/*
 * $Id$  
 * $URL$
 * 
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 * 
 * Distributed under the Modified BSD License.
 * Copyright notice: The copyright for this software and a full listing 
 * of individual contributors are as shown in the packaged copyright.txt 
 * file. 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of the ORGANIZATION nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */
package org.ikasan.spec.configuration;

import java.util.List;

/**
 * 
 * @author Ikasan Development Team
 *
 */
public interface PlatformConfigurationService
{
	/**
	 * Method to get a platform configuration value from the configuration service.
	 *
	 * @param paramName
	 * @return
	 */
	public String getConfigurationValue(String paramName);

	/**
	 * Method to save a platform configuration value to the configuration service.
	 *
	 * @param paramName
	 * @param value
	 */
	public void saveConfigurationValue(String paramName, String value);

	/**
	 * The the username for the account that is used to validate web service calls.
	 * 
	 * @return
	 */
	public String getWebServiceUsername();

	/**
	 * Save the web service username.
	 *
	 * @param username
     */
	public void saveWebServiceUsername(String username);
	
	/**
	  * The the password for the account that is used to validate web service calls.
	 *
	 * @return
	 */
	public String getWebServicePassword();

	/**
	 * Save the web service password.
	 *
	 * @param password
     */
	public void saveWebServicePassword(String password);

	/**
	 * Returns the size of result sets returned for the dashboard.
	 * 
	 * @return
	 */
	public Integer getSearchResultSetSize();

	/**
	 * Save the solr username
	 *
	 * @param username
     */
	public void saveSolrUsername(String username);

	/**
	 * Save the solr password
	 *
	 * @param password
     */
	public void saveSolrPassword(String password);

	/**
	 * Get the solr username
	 *
	 * @return
     */
	public String getSolrUsername();

	/**
	 * Get the solr password
	 *
	 * @return
     */
	public String getSolrPassword();
}
