/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.controller;

import java.util.List;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleService;
import org.ikasan.spec.module.StartupType;
import org.ikasan.trigger.model.TriggerRelationship;
import org.ikasan.wiretap.listener.JobAwareFlowEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/modules"})
public class ModulesController {
    private static final String MODULE_NAME_PARAMETER_NAME = "moduleName";
    private static final String FLOW_NAME_PARAMETER_NAME = "flowName";
    private static final String FLOW_ELEMENT_NAME_PARAMETER_NAME = "flowElementName";
    private static final String TRIGGER_ID_PARAMETER_NAME = "triggerId";
    private static final String STARTUP_TYPE_PARAMETER_NAME = "startupType";
    private static final String STARTUP_COMMENT_PARAMETER_NAME = "startupComment";
    private ModuleService moduleService;
    private JobAwareFlowEventListener jobAwareFlowEventListener;

    @Autowired
    public ModulesController(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    @RequestMapping(value={"list.htm"})
    public String listModules(ModelMap model) {
        model.addAttribute("modules", (Object)this.moduleService.getModules());
        return "modules/modules";
    }

    @RequestMapping(value={"view.htm"})
    public String viewModule(@RequestParam(value="moduleName") String moduleName, ModelMap model) {
        Module module = this.moduleService.getModule(moduleName);
        model.addAttribute("module", (Object)module);
        model.addAttribute("flows", (Object)module.getFlows());
        this.setupNavigationAttributes(moduleName, null, null, model);
        return "modules/viewModule";
    }

    @RequestMapping(value={"viewFlow.htm"})
    public String viewFlow(@RequestParam(value="moduleName") String moduleName, @RequestParam(value="flowName") String flowName, ModelMap model) {
        Module module = this.moduleService.getModule(moduleName);
        Flow flow = (Flow)module.getFlow(flowName);
        model.addAttribute("flowElements", (Object)flow.getFlowElements());
        model.addAttribute("flow", (Object)flow);
        model.addAttribute("startupControl", (Object)this.moduleService.getStartupControl(moduleName, flowName));
        this.setupNavigationAttributes(moduleName, flowName, null, model);
        return "modules/viewFlow";
    }

    @RequestMapping(value={"flowStartupControl.htm"}, method={RequestMethod.POST})
    public String controlInitiator(@RequestParam(value="moduleName") String moduleName, @RequestParam(value="flowName") String flowName, @RequestParam(value="startupType", required=false) String startupType, @RequestParam(value="startupComment", required=false) String startupComment) {
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getName();
        if (startupType != null) {
            if (startupType.equalsIgnoreCase("manual") || startupType.equalsIgnoreCase("automatic") || startupType.equalsIgnoreCase("disabled")) {
                if (startupType.equalsIgnoreCase("disabled") && (startupComment == null || "".equals(startupComment.trim()))) {
                    throw new IllegalArgumentException("must supply comment when disabling Initiator");
                }
                this.moduleService.setStartupType(moduleName, flowName, StartupType.valueOf((String)startupType), startupComment, currentUser);
            } else {
                throw new RuntimeException("Unknown startupType:" + startupType);
            }
        }
        return "redirect:view.htm?moduleName=" + moduleName;
    }

    @RequestMapping(value={"flow.htm"}, method={RequestMethod.POST})
    public String controlFlow(@RequestParam(value="moduleName") String moduleName, @RequestParam(value="flowName") String flowName, @RequestParam(value="action") String action) {
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getName();
        if (action.equalsIgnoreCase("start")) {
            this.moduleService.startFlow(moduleName, flowName, currentUser);
        } else if (action.equalsIgnoreCase("startPause")) {
            this.moduleService.startPauseFlow(moduleName, flowName, currentUser);
        } else if (action.equalsIgnoreCase("pause")) {
            this.moduleService.pauseFlow(moduleName, flowName, currentUser);
        } else if (action.equalsIgnoreCase("resume")) {
            this.moduleService.resumeFlow(moduleName, flowName, currentUser);
        } else if (action.equalsIgnoreCase("stop")) {
            this.moduleService.stopFlow(moduleName, flowName, currentUser);
        } else {
            throw new RuntimeException("Unknown flow action [" + action + "].");
        }
        return "redirect:view.htm?moduleName=" + moduleName;
    }

    @RequestMapping(value={"viewFlowElement.htm"})
    public String viewFlowElement(@RequestParam(value="moduleName") String moduleName, @RequestParam(value="flowName") String flowName, @RequestParam(value="flowElementName") String flowElementName, ModelMap model) {
        Module module = this.moduleService.getModule(moduleName);
        Flow flow = (Flow)module.getFlow(flowName);
        FlowElement<?> flowElement = this.resolveFlowElement(flowElementName, flow);
        List beforeElementTriggers = null;
        List afterElementTriggers = null;
        if (this.jobAwareFlowEventListener != null) {
            beforeElementTriggers = this.jobAwareFlowEventListener.getTriggers(module.getName(), flowName, TriggerRelationship.BEFORE, flowElementName);
            afterElementTriggers = this.jobAwareFlowEventListener.getTriggers(module.getName(), flowName, TriggerRelationship.AFTER, flowElementName);
        }
        model.addAttribute("flow", (Object)flow);
        model.addAttribute("flowElement", flowElement);
        model.addAttribute("beforeElementTriggers", (Object)beforeElementTriggers);
        model.addAttribute("afterElementTriggers", (Object)afterElementTriggers);
        this.setupNavigationAttributes(moduleName, flowName, flowElementName, model);
        return "modules/viewFlowElement";
    }

    private void setupNavigationAttributes(String moduleName, String flowName, String flowElementName, ModelMap model) {
        this.setNotNullAttribute(model, MODULE_NAME_PARAMETER_NAME, moduleName);
        this.setNotNullAttribute(model, FLOW_NAME_PARAMETER_NAME, flowName);
        this.setNotNullAttribute(model, FLOW_ELEMENT_NAME_PARAMETER_NAME, flowElementName);
    }

    private void setNotNullAttribute(ModelMap model, String parameterName, String parameterValue) {
        if (parameterValue != null) {
            model.addAttribute(parameterName, (Object)parameterValue);
        }
    }

    @RequestMapping(value={"deleteTrigger.htm"})
    public String deleteTrigger(@RequestParam(value="moduleName") String moduleName, @RequestParam(value="flowName") String flowName, @RequestParam(value="flowElementName") String flowElementName, @RequestParam(value="triggerId") String triggerId, ModelMap model) throws Exception {
        this.jobAwareFlowEventListener.deleteDynamicTrigger(new Long(triggerId));
        return this.viewFlowElement(moduleName, flowName, flowElementName, model);
    }

    private FlowElement<?> resolveFlowElement(String flowElementName, Flow flow) {
        FlowElement flowElement = null;
        for (FlowElement thisFlowElement : flow.getFlowElements()) {
            if (!thisFlowElement.getComponentName().equals(flowElementName)) continue;
            flowElement = thisFlowElement;
            break;
        }
        return flowElement;
    }

    @Autowired
    public void setJobAwareFlowEventListener(JobAwareFlowEventListener jobAwareFlowEventListener) {
        this.jobAwareFlowEventListener = jobAwareFlowEventListener;
    }
}

