/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SchedulerController {
    private static Logger logger = Logger.getLogger(SchedulerController.class);
    private Scheduler platformScheduler;

    @Autowired
    public SchedulerController(Scheduler platformScheduler) {
        this.platformScheduler = platformScheduler;
        logger.info((Object)("platformScheduler:" + platformScheduler));
    }

    @ModelAttribute(value="platformScheduler")
    public Scheduler getPlatformScheduler() {
        return this.platformScheduler;
    }

    @RequestMapping(value={"/admin/viewScheduler.htm"}, method={RequestMethod.GET})
    public ModelAndView viewScheduler() throws Exception {
        List<Trigger> triggers = this.getTriggers();
        ModelMap myModel = new ModelMap();
        myModel.put((Object)"triggers", triggers);
        return new ModelAndView("admin/viewScheduler", (Map)myModel);
    }

    @RequestMapping(value={"/admin/schedulerStandby.htm"}, method={RequestMethod.POST})
    public String stopScheduler() throws Exception {
        if (!this.platformScheduler.isInStandbyMode()) {
            this.platformScheduler.standby();
        }
        return "redirect:viewScheduler.htm";
    }

    @RequestMapping(value={"/admin/schedulerResume.htm"}, method={RequestMethod.POST})
    public String resumeScheduler() throws Exception {
        if (this.platformScheduler.isInStandbyMode()) {
            this.platformScheduler.start();
        }
        return "redirect:viewScheduler.htm";
    }

    private List<Trigger> getTriggers() throws Exception {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        if (!this.platformScheduler.isShutdown()) {
            List triggerGroupNames = this.platformScheduler.getTriggerGroupNames();
            logger.info((Object)("found triggerGroupNames:" + triggerGroupNames.size()));
            for (String triggerGroupName : triggerGroupNames) {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)triggerGroupName);
                Set keys = this.platformScheduler.getTriggerKeys(groupMatcher);
                logger.info((Object)("found triggerNames:" + keys.size() + ", for triggerGroupName:" + triggerGroupName));
                for (TriggerKey key : keys) {
                    triggers.add(this.platformScheduler.getTrigger(key));
                }
            }
        }
        return triggers;
    }
}

