/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ikasan.spec.search.PagedSearchResult;
import org.ikasan.systemevent.service.SystemEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/systemEvents"})
public class SystemEventLogController {
    private SystemEventService systemEventService;
    private static SimpleDateFormat ddMMyyyyFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static SimpleDateFormat HHmmss;

    @Autowired
    public SystemEventLogController(SystemEventService systemEventService) {
        this.systemEventService = systemEventService;
    }

    @RequestMapping(value={"search.htm"}, method={RequestMethod.GET})
    public String search(HttpServletRequest request, @RequestParam(required=false) Boolean newSearch, @RequestParam(required=false) Integer page, @RequestParam(required=false) String orderBy, @RequestParam(required=false) Boolean orderAsc, @RequestParam(required=false) String subject, @RequestParam(required=false) String action, @RequestParam(required=false) String actor, @RequestParam(required=false) String timestampFromDate, @RequestParam(required=false) String timestampFromTime, @RequestParam(required=false) String timestampToDate, @RequestParam(required=false) String timestampToTime, ModelMap model) {
        Date timestampFrom = this.createDateTime(timestampFromDate, timestampFromTime);
        Date timestampTo = this.createDateTime(timestampToDate, timestampToTime);
        int pageNo = page != null ? page : 0;
        int pageSize = 25;
        String orderByField = orderBy == null ? "timestamp" : orderBy;
        boolean orderAscending = orderAsc != null ? orderAsc : false;
        PagedSearchResult pagedResult = null;
        pagedResult = this.systemEventService.listSystemEvents(pageNo, pageSize, orderByField, orderAscending, subject, action, timestampFrom, timestampTo, actor);
        HashMap<String, String> searchParams = new HashMap<String, String>();
        searchParams.put("subject", subject);
        searchParams.put("action", action);
        searchParams.put("actor", actor);
        searchParams.put("timestampFromDate", timestampFromDate);
        searchParams.put("timestampFromTime", timestampFromTime);
        searchParams.put("timestampToDate", timestampToDate);
        searchParams.put("timestampToTime", timestampToTime);
        model.addAttribute("searchParams", searchParams);
        model.addAttribute("orderBy", (Object)orderBy);
        model.addAttribute("orderAsc", (Object)orderAsc);
        model.addAttribute("page", (Object)pageNo);
        model.addAttribute("results", (Object)pagedResult);
        if (pagedResult != null) {
            model.addAttribute("firstResultIndex", (Object)pagedResult.getFirstResultIndex());
            model.addAttribute("lastPage", (Object)pagedResult.isLastPage());
            model.addAttribute("resultSize", (Object)pagedResult.getResultSize());
            model.addAttribute("size", (Object)pagedResult.getPagedResults().size());
        } else {
            model.addAttribute("resultSize", (Object)0);
        }
        model.addAttribute("searchResultsUrl", (Object)request.getRequestURL());
        return "admin/systemEventLog";
    }

    private Date createDateTime(String dateString, String timeString) {
        if (dateString == null || "".equals(dateString)) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            Date time = HHmmss.parse(timeString);
            GregorianCalendar timeCalendar = new GregorianCalendar();
            timeCalendar.setTime(time);
            calendar.setTime(ddMMyyyyFormat.parse(dateString));
            calendar.set(11, timeCalendar.get(11));
            calendar.set(12, timeCalendar.get(12));
            calendar.set(13, timeCalendar.get(13));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return calendar.getTime();
    }

    @RequestMapping(value={"housekeeping.htm"}, method={RequestMethod.POST})
    public String housekeepnig(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.systemEventService.housekeep();
        return "redirect:search.htm";
    }

    static {
        ddMMyyyyFormat.setLenient(false);
        HHmmss = new SimpleDateFormat("HH:mm:ss");
        HHmmss.setLenient(false);
    }
}

