/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.security.model.Authority;
import org.ikasan.security.model.User;
import org.ikasan.security.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/admin/users"})
@SessionAttributes(value={"user"})
public class UsersController {
    private static final String USERNAME_PARAMETER_NAME = "username";
    private static final String AUTHORITY_PARAMETER_NAME = "authority";
    private UserService userService;
    private Logger logger = Logger.getLogger(UsersController.class);

    @Autowired
    public UsersController(UserService userService) {
        this.userService = userService;
    }

    @RequestMapping(value={"list.htm"})
    public String listUsers(ModelMap model) {
        if (model.get((Object)"user") == null) {
            model.addAttribute("user", (Object)new User(null, null, null, true));
        }
        model.addAttribute("users", (Object)this.userService.getUsers());
        return "admin/users/users";
    }

    @RequestMapping(value={"createUser.htm"}, method={RequestMethod.POST})
    public String createUser(ModelMap model, @ModelAttribute(value="user") User user, BindingResult result) {
        ValidationUtils.rejectIfEmpty((Errors)result, (String)USERNAME_PARAMETER_NAME, (String)"field.required", (String)"Username cannot be empty");
        ValidationUtils.rejectIfEmpty((Errors)result, (String)"password", (String)"field.required", (String)"Password cannot be empty");
        ValidationUtils.rejectIfEmpty((Errors)result, (String)"email", (String)"field.required", (String)"Email Address cannot be empty");
        if (this.userService.userExists(user.getUsername())) {
            result.addError((ObjectError)new FieldError("user", USERNAME_PARAMETER_NAME, "User with this username already exists"));
        }
        if (result.hasErrors()) {
            return this.listUsers(model);
        }
        this.userService.createUser((UserDetails)user);
        this.logger.info((Object)("Created new user, with id:" + user.getId()));
        return this.viewUser(user.getUsername(), model);
    }

    @RequestMapping(value={"view.htm"}, method={RequestMethod.GET})
    public String viewUser(@RequestParam(value="username") String username, ModelMap model) {
        User user = this.userService.loadUserByUsername(username);
        model.addAttribute("user", (Object)user);
        model.addAttribute("nonGrantedAuthorities", this.getNonGrantedAuthrities(user.getAuthorities()));
        return "admin/users/viewUser";
    }

    @RequestMapping(value={"changePassword.htm"}, method={RequestMethod.POST})
    public String changePassword(@ModelAttribute(value="user") User user, @RequestParam(value="confirm_password") String confirmNewPassword, ModelMap model, BindingResult result) {
        try {
            this.userService.changeUsersPassword(user.getUsername(), user.getPassword(), confirmNewPassword);
        }
        catch (IllegalArgumentException e) {
            result.addError((ObjectError)new FieldError("password", "password", e.getMessage()));
        }
        return this.viewUser(user.getUsername(), model);
    }

    @RequestMapping(value={"grantAuthority.htm"}, method={RequestMethod.POST})
    public String grantAuthority(@RequestParam(value="username") String username, @RequestParam(value="authority") String authority, ModelMap model) {
        this.userService.grantAuthority(username, authority);
        return this.viewUser(username, model);
    }

    @RequestMapping(value={"revokeAuthority.htm"}, method={RequestMethod.POST})
    public String revokeAuthority(@RequestParam(value="username") String username, @RequestParam(value="authority") String authority, ModelMap model) {
        this.userService.revokeAuthority(username, authority);
        return this.viewUser(username, model);
    }

    @RequestMapping(value={"delete.htm"}, method={RequestMethod.POST})
    public String deleteUser(@RequestParam(value="username") String username, ModelMap model) {
        this.userService.deleteUser(username);
        return this.listUsers(model);
    }

    @RequestMapping(value={"disable.htm"}, method={RequestMethod.POST})
    public String disableUser(@RequestParam(value="username") String username, ModelMap model) {
        this.userService.disableUser(username);
        return this.viewUser(username, model);
    }

    @RequestMapping(value={"enable.htm"}, method={RequestMethod.POST})
    public String enableUser(@RequestParam(value="username") String username, ModelMap model) {
        this.userService.enableUser(username);
        return this.viewUser(username, model);
    }

    private List<Authority> getNonGrantedAuthrities(Collection<? extends GrantedAuthority> authorities) {
        ArrayList<Authority> nonGrantedAuthorities = new ArrayList<Authority>(this.userService.getAuthorities());
        for (GrantedAuthority grantedAuthority : authorities) {
            nonGrantedAuthorities.remove(grantedAuthority);
        }
        return nonGrantedAuthorities;
    }
}

