/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ikasan.spec.flow.FlowEvent;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleService;
import org.ikasan.spec.search.PagedSearchResult;
import org.ikasan.spec.wiretap.WiretapEvent;
import org.ikasan.spec.wiretap.WiretapService;
import org.ikasan.web.command.WiretapSearchCriteria;
import org.ikasan.web.command.WiretapSearchCriteriaValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/events"})
@SessionAttributes(value={"searchCriteria", "pageNo"})
public class WiretapEventsSearchFormController {
    private Logger logger = Logger.getLogger(WiretapEventsSearchFormController.class);
    private WiretapService<FlowEvent, PagedSearchResult<WiretapEvent>> wiretapService;
    private ModuleService moduleService;
    private WiretapSearchCriteriaValidator validator = new WiretapSearchCriteriaValidator();

    @Autowired
    public WiretapEventsSearchFormController(WiretapService wiretapService, ModuleService moduleService) {
        this.wiretapService = wiretapService;
        this.moduleService = moduleService;
    }

    @ModelAttribute(value="modules")
    public List<Module> getModuleNames() {
        return this.moduleService.getModules();
    }

    @RequestMapping(value={"search.htm"}, method={RequestMethod.GET})
    public String setupForm(HttpServletRequest request, ModelMap model) {
        WiretapSearchCriteria searchCriteria = (WiretapSearchCriteria)request.getSession().getAttribute("searchCriteria");
        if (searchCriteria == null) {
            searchCriteria = new WiretapSearchCriteria();
        }
        model.addAttribute("searchCriteria", (Object)searchCriteria);
        return "events/wiretapEvents";
    }

    @RequestMapping(value={"search.htm"}, method={RequestMethod.POST})
    public String processSubmit(ModelMap modelMap, @ModelAttribute(value="searchCriteria") WiretapSearchCriteria searchCriteria, BindingResult result) {
        this.validator.validate(searchCriteria, (Errors)result);
        if (result.hasErrors()) {
            return "events/wiretapEvents";
        }
        return this.displaySearchResults(modelMap, searchCriteria, 0);
    }

    @RequestMapping(value={"next.htm"})
    public String next(HttpServletRequest request, ModelMap modelMap) {
        WiretapSearchCriteria searchCriteria = (WiretapSearchCriteria)request.getSession().getAttribute("searchCriteria");
        if (searchCriteria == null) {
            return "redirect:/events/search.htm";
        }
        return this.displaySearchResults(modelMap, searchCriteria, this.getSessionPageNo(request) + 1);
    }

    private int getSessionPageNo(HttpServletRequest request) {
        int pageNo = 0;
        Integer sessionPageNo = (Integer)request.getSession().getAttribute("pageNo");
        if (sessionPageNo != null) {
            pageNo = sessionPageNo;
        }
        return pageNo;
    }

    @RequestMapping(value={"searchResults.htm"})
    public String searchResults(HttpServletRequest request, ModelMap modelMap) {
        WiretapSearchCriteria searchCriteria = (WiretapSearchCriteria)request.getSession().getAttribute("searchCriteria");
        if (searchCriteria == null) {
            return "redirect:/events/search.htm";
        }
        return this.displaySearchResults(modelMap, searchCriteria, this.getSessionPageNo(request));
    }

    @RequestMapping(value={"previous.htm"})
    public String previous(HttpServletRequest request, ModelMap modelMap) {
        WiretapSearchCriteria searchCriteria = (WiretapSearchCriteria)request.getSession().getAttribute("searchCriteria");
        if (searchCriteria == null) {
            return "redirect:/events/search.htm";
        }
        return this.displaySearchResults(modelMap, searchCriteria, this.getSessionPageNo(request) - 1);
    }

    @RequestMapping(value={"viewEvent.htm"})
    public ModelAndView viewEvent(@RequestParam(value="eventId") long eventId, ModelMap modelMap) {
        this.logger.info((Object)("inside viewEvent, eventId=[" + eventId + "]"));
        WiretapEvent wiretapEvent = this.wiretapService.getWiretapEvent(new Long(eventId));
        modelMap.addAttribute("wiretapEvent", (Object)wiretapEvent);
        return new ModelAndView("events/viewWiretapEvent", (Map)modelMap);
    }

    @RequestMapping(value={"viewPrettyPayloadContent.htm"})
    public ModelAndView viewPrettyPayloadContent(@RequestParam(value="eventId") long eventId, HttpServletResponse response) {
        this.logger.info((Object)("inside viewPrettyPayloadContent, eventId=[" + eventId + "]"));
        WiretapEvent wiretapEvent = this.wiretapService.getWiretapEvent(new Long(eventId));
        if (wiretapEvent.getEvent() instanceof String) {
            response.setContentType("text/xml");
            try {
                response.getOutputStream().write(((String)wiretapEvent.getEvent()).getBytes());
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not render payload content.", (Throwable)e);
            }
        }
        return null;
    }

    @RequestMapping(value={"housekeeping.htm"}, method={RequestMethod.POST})
    public String housekeepWiretaps() {
        this.wiretapService.housekeep();
        return "redirect:/events/search.htm";
    }

    private String displaySearchResults(ModelMap modelMap, WiretapSearchCriteria searchCriteria, int pageNo) {
        modelMap.addAttribute("pageNo", (Object)pageNo);
        String orderBy = "identifier";
        int pageSize = 20;
        boolean orderAscending = true;
        String moduleFlow = null;
        PagedSearchResult pagedResult = (PagedSearchResult)this.wiretapService.findWiretapEvents(pageNo, pageSize, orderBy, orderAscending, searchCriteria.getModules(), moduleFlow, searchCriteria.getComponentName(), searchCriteria.getEventId(), searchCriteria.getPayloadId(), searchCriteria.getFromDateTime(), searchCriteria.getUntilDateTime(), searchCriteria.getPayloadContent());
        modelMap.addAttribute("searchResults", (Object)pagedResult);
        return "events/wiretapEventResults";
    }
}

