/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.binding.convert.converters.Converter;

public class SpringConverter
implements Converter {
    private Logger logger = Logger.getLogger(SpringConverter.class);
    private String entrySeparator = ",";
    private String fieldSeparator = "=";

    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public Class getSourceClass() {
        return String.class;
    }

    public Class getTargetClass() {
        return Map.class;
    }

    public Object convertSourceToTargetClass(Object source, Class aClass) throws Exception {
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return source;
        }
        if (source instanceof String) {
            String[] mapEntries;
            String sourceStr = (String)source;
            HashMap<String, String> map = new HashMap<String, String>();
            if (sourceStr.startsWith("{")) {
                sourceStr = sourceStr.substring(1);
                if ((sourceStr = sourceStr.replaceAll(", ", ",")).endsWith("}")) {
                    sourceStr = sourceStr.substring(0, sourceStr.length() - 1);
                }
            }
            if ((mapEntries = sourceStr.split(this.entrySeparator)) == null || mapEntries.length == 0) {
                return null;
            }
            for (String mapEntry : mapEntries) {
                String[] fields = mapEntry.split(this.fieldSeparator);
                if (fields == null || fields.length <= 0) continue;
                if (fields.length > 1) {
                    map.put(fields[0], fields[1]);
                    continue;
                }
                map.put(fields[0], null);
            }
            return map;
        }
        this.logger.warn((Object)("class " + source.getClass().getName() + " has no associated converter"));
        return null;
    }
}

