/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.security;

import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class ModuleAdminVoter
implements AccessDecisionVoter {
    public static final String MODULE_ADMIN_ATTRIBUTE = "MODULE_ADMIN";
    private Logger logger = Logger.getLogger(ModuleAdminVoter.class);

    public boolean supports(ConfigAttribute attribute) {
        boolean result = attribute.getAttribute().equals(MODULE_ADMIN_ATTRIBUTE);
        return result;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection config) {
        int result = 0;
        Iterator iter = config.iterator();
        Collection authorities = authentication.getAuthorities();
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (!this.supports(attribute)) continue;
            result = -1;
            ReflectiveMethodInvocation methodInvocation = (ReflectiveMethodInvocation)object;
            String moduleName = (String)methodInvocation.getArguments()[0];
            String moduleAdminRole = "ADMIN_" + moduleName;
            for (GrantedAuthority authority : authorities) {
                if (!moduleAdminRole.equals(authority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }
}

