/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.service;

import org.ikasan.spec.configuration.Configuration;
import org.ikasan.spec.configuration.ConfigurationManagement;
import org.ikasan.spec.configuration.ConfiguredResource;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleService;
import org.ikasan.systemevent.service.SystemEventService;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.webflow.execution.RequestContext;

public class ConfigurationManagementService {
    public static final String CONFIGURATION_INSERT_SYSTEM_EVENT_ACTION = "Configuration created";
    public static final String CONFIGURATION_UPDATE_SYSTEM_EVENT_ACTION = "Configuration updated";
    public static final String CONFIGURATION_DELETE_SYSTEM_EVENT_ACTION = "Configuration deleted";
    private ConfigurationManagement<ConfiguredResource, Configuration> configurationManagement;
    private SystemEventService systemEventService;
    private ModuleService moduleService;

    public ConfigurationManagementService(ConfigurationManagement<ConfiguredResource, Configuration> configurationManagement, SystemEventService systemEventService, ModuleService moduleService) {
        this.configurationManagement = configurationManagement;
        if (configurationManagement == null) {
            throw new IllegalArgumentException("configurationManagement cannot be 'null'");
        }
        this.systemEventService = systemEventService;
        if (systemEventService == null) {
            throw new IllegalArgumentException("systemEventService cannot be 'null'");
        }
        this.moduleService = moduleService;
        if (moduleService == null) {
            throw new IllegalArgumentException("moduleService cannot be 'null'");
        }
    }

    public boolean isConfiguredResource(String moduleName, String flowName, String flowElementName) {
        return this.getFlowComponent(moduleName, flowName, flowElementName) instanceof ConfiguredResource;
    }

    public Configuration findConfiguration(String moduleName, String flowName, String flowElementName, RequestContext context) {
        try {
            ConfiguredResource configuredResource = this.getConfiguredResource(moduleName, flowName, flowElementName);
            return (Configuration)this.configurationManagement.getConfiguration((Object)configuredResource);
        }
        catch (RuntimeException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error().source((Object)"findConfiguration").defaultText(e.getMessage()).build());
            return null;
        }
    }

    public Configuration createConfiguration(String moduleName, String flowName, String flowElementName, RequestContext context) {
        try {
            ConfiguredResource configuredResource = this.getConfiguredResource(moduleName, flowName, flowElementName);
            return (Configuration)this.configurationManagement.createConfiguration((Object)configuredResource);
        }
        catch (RuntimeException e) {
            context.getMessageContext().addMessage(new MessageBuilder().error().source((Object)"createConfiguration").defaultText(e.getMessage()).build());
            return null;
        }
    }

    public void insertConfiguration(Configuration configuration) {
        this.systemEventService.logSystemEvent(configuration.getConfigurationId(), CONFIGURATION_INSERT_SYSTEM_EVENT_ACTION, this.getAuthentication().getName());
        this.configurationManagement.saveConfiguration((Object)configuration);
    }

    public void updateConfiguration(Configuration configuration) {
        this.systemEventService.logSystemEvent(configuration.getConfigurationId(), CONFIGURATION_UPDATE_SYSTEM_EVENT_ACTION, this.getAuthentication().getName());
        this.configurationManagement.saveConfiguration((Object)configuration);
    }

    public void deleteConfiguration(Configuration configuration) {
        this.systemEventService.logSystemEvent(configuration.getConfigurationId(), CONFIGURATION_DELETE_SYSTEM_EVENT_ACTION, this.getAuthentication().getName());
        this.configurationManagement.deleteConfiguration((Object)configuration);
    }

    protected Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private ConfiguredResource getConfiguredResource(String moduleName, String flowName, String flowElementName) {
        Object flowComponent = this.getFlowComponent(moduleName, flowName, flowElementName);
        if (flowComponent instanceof ConfiguredResource) {
            return (ConfiguredResource)flowComponent;
        }
        throw new UnsupportedOperationException("Component must be of type 'ConfiguredResource' to support component configuration");
    }

    private Object getFlowComponent(String moduleName, String flowName, String flowElementName) {
        Module module = this.moduleService.getModule(moduleName);
        Flow flow = (Flow)module.getFlow(flowName);
        FlowElement flowElement = flow.getFlowElement(flowElementName);
        if (flowElement == null) {
            throw new RuntimeException("FlowComponent not found for module [" + moduleName + "] flow [" + flowName + "] flowElementName [" + flowElementName + "]");
        }
        return flowElement.getFlowComponent();
    }
}

