/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.command;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.apache.log4j.Logger;

public class WiretapSearchCriteria
implements Serializable {
    private static final long serialVersionUID = 3595514737829632181L;
    private Logger logger = Logger.getLogger(WiretapSearchCriteria.class);
    private SimpleDateFormat ddMMyyyyFormat = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat HHmmss;
    private Set<String> modules;
    private String componentName;
    private String eventId;
    private String payloadId;
    private String payloadContent;
    private String fromDate;
    private String untilDate;
    private String fromTime;
    private String untilTime;

    public WiretapSearchCriteria() {
        this.ddMMyyyyFormat.setLenient(false);
        this.HHmmss = new SimpleDateFormat("HH:mm:ss");
        this.HHmmss.setLenient(false);
    }

    public static long getSerialVersionUID() {
        return 3595514737829632181L;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getPayloadContent() {
        return this.payloadContent;
    }

    public String getPayloadId() {
        return this.payloadId;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setPayloadContent(String payloadContent) {
        this.payloadContent = payloadContent;
    }

    public void setPayloadId(String payloadId) {
        this.payloadId = payloadId;
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public void setModules(Set<String> modules) {
        this.modules = modules;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(String untilDate) {
        this.untilDate = untilDate;
    }

    public String getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(String fromTime) {
        this.fromTime = fromTime;
    }

    public String getUntilTime() {
        return this.untilTime;
    }

    public void setUntilTime(String untilTime) {
        this.untilTime = untilTime;
    }

    public Date getFromDateTime() {
        Date createDateTime = this.createDateTime(this.fromDate, this.fromTime);
        this.logger.info((Object)("From datetime:" + createDateTime));
        return createDateTime;
    }

    public Date getUntilDateTime() {
        Date createDateTime = this.createDateTime(this.untilDate, this.untilTime);
        this.logger.info((Object)("Until datetime:" + createDateTime));
        return createDateTime;
    }

    private Date createDateTime(String dateString, String timeString) {
        if (dateString == null || "".equals(dateString)) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            Date time = this.HHmmss.parse(timeString);
            GregorianCalendar timeCalendar = new GregorianCalendar();
            timeCalendar.setTime(time);
            calendar.setTime(this.ddMMyyyyFormat.parse(dateString));
            calendar.set(11, timeCalendar.get(11));
            calendar.set(12, timeCalendar.get(12));
            calendar.set(13, timeCalendar.get(13));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return calendar.getTime();
    }
}

