/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.command;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.ikasan.web.command.WiretapSearchCriteria;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class WiretapSearchCriteriaValidator
implements Validator {
    private SimpleDateFormat ddMMyyyyFormat = new SimpleDateFormat("dd/MM/yyyy");
    private SimpleDateFormat HHmmss;

    public WiretapSearchCriteriaValidator() {
        this.ddMMyyyyFormat.setLenient(false);
        this.HHmmss = new SimpleDateFormat("HH:mm:ss");
        this.HHmmss.setLenient(false);
    }

    public boolean supports(Class clazz) {
        return WiretapSearchCriteria.class.equals((Object)clazz);
    }

    public void validate(Object object, Errors errors) {
        Date untilDateTime;
        Date fromDateTime;
        WiretapSearchCriteria wiretapSearchCriteria = (WiretapSearchCriteria)object;
        Set<String> modules = wiretapSearchCriteria.getModules();
        if (modules == null || modules.isEmpty()) {
            errors.reject("modules", "You need to select at least one module");
        }
        this.validateDateAndTime(errors, wiretapSearchCriteria.getFromDate(), "fromDate", wiretapSearchCriteria.getFromTime(), "fromTime");
        this.validateDateAndTime(errors, wiretapSearchCriteria.getUntilDate(), "untilDate", wiretapSearchCriteria.getUntilTime(), "untilTime");
        if (!(errors.hasErrors() || this.isEmpty(wiretapSearchCriteria.getFromDate()) || this.isEmpty(wiretapSearchCriteria.getUntilDate()) || (fromDateTime = wiretapSearchCriteria.getFromDateTime()).compareTo(untilDateTime = wiretapSearchCriteria.getUntilDateTime()) <= 0)) {
            errors.reject("untilDate", "Until cannot be before From");
        }
    }

    private void validateDateAndTime(Errors errors, String dateFieldValue, String dateFieldName, String timeFieldValue, String timeFieldName) {
        if (!this.isEmpty(dateFieldValue) ^ !this.isEmpty(timeFieldValue)) {
            if (this.isEmpty(dateFieldValue)) {
                errors.reject(dateFieldName, dateFieldName + " must be supplied if " + timeFieldName + " has been set");
            } else {
                errors.reject(timeFieldName, timeFieldName + " must be supplied if " + dateFieldName + " has been set");
            }
        }
        if (!this.isEmpty(dateFieldValue)) {
            boolean validDate = true;
            try {
                this.ddMMyyyyFormat.parse(dateFieldValue);
            }
            catch (ParseException e) {
                validDate = false;
            }
            if (dateFieldValue.length() != 10) {
                validDate = false;
            }
            if (!validDate) {
                errors.reject(dateFieldName, dateFieldName + " must be supplied as dd/MM/yyyy");
            }
        }
        if (!this.isEmpty(timeFieldValue)) {
            try {
                this.HHmmss.parse(timeFieldValue);
            }
            catch (ParseException e) {
                errors.reject(timeFieldName, timeFieldName + " must be supplied as HH:mm:ss, eg 00:30:00 for 12:30.00am");
            }
        }
    }

    private boolean isEmpty(String fieldValue) {
        return fieldValue == null || "".equals(fieldValue);
    }
}

