/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.security;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.ikasan.spec.module.Module;
import org.ikasan.web.security.AbstractModuleAfterInvocationProvider;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class AfterInvocationModuleCollectionFilteringProvider
extends AbstractModuleAfterInvocationProvider {
    private static final String AFTER_MODULE_COLLECTION_READ = "AFTER_MODULE_COLLECTION_READ";
    Logger logger = Logger.getLogger(AfterInvocationModuleCollectionFilteringProvider.class);

    public AfterInvocationModuleCollectionFilteringProvider() {
        super(AFTER_MODULE_COLLECTION_READ);
    }

    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        for (ConfigAttribute attr : config) {
            if (!this.supports(attr)) continue;
            if (!(returnedObject instanceof Collection)) {
                throw new AuthorizationServiceException("A Collection was required as the returnedObject, but the returnedObject was [" + returnedObject + "]");
            }
            ArrayList<Module> authorisedModules = new ArrayList<Module>();
            for (Object domainObject : (Collection)returnedObject) {
                Module thisModule;
                if (domainObject == null || !Module.class.isAssignableFrom(domainObject.getClass()) || !this.mayReadModule(authentication, thisModule = (Module)domainObject)) continue;
                authorisedModules.add(thisModule);
            }
            return authorisedModules;
        }
        return returnedObject;
    }

    @Override
    public boolean supports(ConfigAttribute configAttribute) {
        return configAttribute.getAttribute().equalsIgnoreCase(AFTER_MODULE_COLLECTION_READ);
    }
}

