/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.security;

import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.ikasan.spec.module.Module;
import org.ikasan.web.security.AbstractModuleAfterInvocationProvider;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class ModuleAfterInvocationProvider
extends AbstractModuleAfterInvocationProvider {
    private static final String AFTER_MODULE_READ = "AFTER_MODULE_READ";
    private Logger logger = Logger.getLogger(ModuleAfterInvocationProvider.class);

    public ModuleAfterInvocationProvider() {
        super(AFTER_MODULE_READ);
    }

    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        Iterator<ConfigAttribute> iter = config.iterator();
        if (returnedObject == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Return object is null, skipping");
            }
            return null;
        }
        if (!Module.class.isAssignableFrom(returnedObject.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Return object is not a Module, skipping");
            }
            return returnedObject;
        }
        while (iter.hasNext()) {
            ConfigAttribute attr = iter.next();
            if (!this.supports(attr)) continue;
            if (this.mayReadModule(authentication, (Module)returnedObject)) {
                return returnedObject;
            }
            throw new AccessDeniedException("user[" + authentication + "] does not have access to module [" + ((Module)returnedObject).getName() + "]");
        }
        return returnedObject;
    }
}

