/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.web.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ikasan.spec.flow.Flow;
import org.ikasan.spec.flow.FlowElement;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleService;
import org.ikasan.trigger.model.Trigger;
import org.ikasan.trigger.model.TriggerRelationship;
import org.ikasan.trigger.service.FlowEventJob;
import org.ikasan.web.command.TriggerDetails;
import org.ikasan.wiretap.listener.JobAwareFlowEventListener;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.execution.RequestContext;

public class TriggerDetailsService {
    private JobAwareFlowEventListener jobAwareFlowEventListener;
    private ModuleService moduleService;

    public TriggerDetailsService(JobAwareFlowEventListener jobAwareFlowEventListener, ModuleService moduleService) {
        this.jobAwareFlowEventListener = jobAwareFlowEventListener;
        this.moduleService = moduleService;
    }

    public TriggerDetails createTriggerDetails(String moduleName, String flowName, String flowElementName, String relationship) {
        TriggerDetails triggerDetails = new TriggerDetails(moduleName, flowName);
        if (flowElementName != null) {
            triggerDetails.setFlowElementName(flowElementName);
        }
        if (relationship != null) {
            triggerDetails.setRelationship(relationship);
        }
        return triggerDetails;
    }

    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String jobName : this.jobAwareFlowEventListener.getRegisteredJobs().keySet()) {
            result.add(jobName);
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getRelationships() {
        ArrayList<String> result = new ArrayList<String>();
        for (TriggerRelationship relationship : TriggerRelationship.values()) {
            result.add(relationship.getDescription());
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getParameterNames(String jobName) {
        ArrayList<String> result = new ArrayList<String>();
        FlowEventJob flowEventJob = (FlowEventJob)this.jobAwareFlowEventListener.getRegisteredJobs().get(jobName);
        if (flowEventJob != null) {
            result.addAll(flowEventJob.getParameters());
        }
        Collections.sort(result);
        return result;
    }

    public List<String> getFlowElementNames(String moduleName, String flowName) {
        ArrayList<String> result = new ArrayList<String>();
        Module module = this.moduleService.getModule(moduleName);
        Flow flow = (Flow)module.getFlow(flowName);
        List flowElements = flow.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            result.add(flowElement.getComponentName());
        }
        return result;
    }

    public String createTrigger(TriggerDetails triggerDetails, RequestContext context) {
        String jobName = triggerDetails.getJobName();
        FlowEventJob flowEventJob = (FlowEventJob)this.jobAwareFlowEventListener.getRegisteredJobs().get(jobName);
        MessageContext messageContext = context.getMessageContext();
        if (flowEventJob == null) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"jobName").defaultText("Unknown job:" + jobName).build());
        } else {
            Map validationErrors = flowEventJob.validateParameters(triggerDetails.getParams());
            if (validationErrors != null && !validationErrors.isEmpty()) {
                for (String parameterName : validationErrors.keySet()) {
                    messageContext.addMessage(new MessageBuilder().error().source((Object)parameterName).defaultText((String)validationErrors.get(parameterName)).build());
                }
            }
        }
        if (!messageContext.hasErrorMessages()) {
            Trigger trigger = triggerDetails.createTrigger();
            this.jobAwareFlowEventListener.addDynamicTrigger(trigger);
            return "success";
        }
        return "error";
    }
}

