/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.marshaller.xml;

import net.sf.json.JSON;
import net.sf.json.xml.XMLSerializer;
import org.ikasan.marshaller.ConfiguredSerialiser;

public abstract class XmlJsonMarshaller
implements ConfiguredSerialiser<XMLSerializer> {
    protected XMLSerializer xmlSerialiser;
    protected String encoding;

    public XmlJsonMarshaller(XMLSerializer xmlSerialiser) {
        this.xmlSerialiser = xmlSerialiser;
        if (xmlSerialiser == null) {
            throw new IllegalArgumentException("xmlSerialiser cannot be 'null'");
        }
    }

    public String unmarshall(JSON json) {
        if (this.encoding == null) {
            return this.xmlSerialiser.write(json);
        }
        return this.xmlSerialiser.write(json, this.encoding);
    }

    @Override
    public void setSerialiser(XMLSerializer xmlSerialiser) {
        this.xmlSerialiser = xmlSerialiser;
    }

    @Override
    public XMLSerializer getSerialiser() {
        return this.xmlSerialiser;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

