/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.ComparableOperators;
import org.immutables.criteria.expression.Constant;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.IterableOperators;
import org.immutables.criteria.expression.Operator;
import org.immutables.criteria.expression.Operators;
import org.immutables.criteria.expression.OptionalOperators;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.StringOperators;
import org.immutables.criteria.inmemory.PathExtractor;
import org.immutables.criteria.inmemory.ReflectionExtractor;

class ExpressionInterpreter
implements Function<Object, Object> {
    private static final Object UNKNOWN = new Object(){

        public String toString() {
            return "UNKNOWN";
        }
    };
    private final Expression expression;

    private ExpressionInterpreter(Expression expression) {
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    static ExpressionInterpreter of(Expression expression) {
        return new ExpressionInterpreter(expression);
    }

    Predicate<Object> asPredicate() {
        return value -> Boolean.TRUE.equals(this.apply(value));
    }

    @Override
    public Object apply(Object instance) {
        return this.expression.accept((ExpressionVisitor)new LocalVisitor(instance));
    }

    private static class LocalVisitor
    implements ExpressionVisitor<Object> {
        private static final PathExtractor EXTRACTOR = new ReflectionExtractor();
        private final Object instance;

        private LocalVisitor(Object instance) {
            this.instance = instance;
        }

        public Object visit(Call call) {
            Operator op = call.operator();
            List args = call.arguments();
            if (op == Operators.NOT) {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object[])new Object[]{op, args.size()});
                Object value = ((Expression)args.get(0)).accept((ExpressionVisitor)this);
                if (value == UNKNOWN) {
                    return UNKNOWN;
                }
                if (value instanceof Boolean) {
                    return (Boolean)value == false;
                }
                throw new UnsupportedOperationException(String.format("Expected boolean for op %s but got %s", op, value.getClass().getName()));
            }
            if (op == IterableOperators.IS_EMPTY || op == IterableOperators.NOT_EMPTY) {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object[])new Object[]{op, args.size()});
                Object value = ((Expression)args.get(0)).accept((ExpressionVisitor)this);
                if (value == UNKNOWN) {
                    return UNKNOWN;
                }
                Preconditions.checkArgument((boolean)(value instanceof Iterable), (String)"%s not iterable", (Object[])new Object[]{value.getClass().getName()});
                boolean empty = Iterables.isEmpty((Iterable)((Iterable)value));
                return op == IterableOperators.IS_EMPTY == empty;
            }
            if (op == OptionalOperators.IS_ABSENT || op == OptionalOperators.IS_PRESENT) {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object[])new Object[]{op, args.size()});
                Object left = ((Expression)args.get(0)).accept((ExpressionVisitor)this);
                if (left == UNKNOWN) {
                    return op == OptionalOperators.IS_ABSENT;
                }
                return op == OptionalOperators.IS_ABSENT ? Objects.isNull(left) : Objects.nonNull(left);
            }
            if (op == StringOperators.TO_UPPER_CASE || op == StringOperators.TO_LOWER_CASE) {
                Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 but was %s", (Object[])new Object[]{args.size()});
                Object value = ((Expression)args.get(0)).accept((ExpressionVisitor)this);
                if (value == null || value == UNKNOWN) {
                    return UNKNOWN;
                }
                Preconditions.checkArgument((boolean)(value instanceof CharSequence), (String)"Expected %s got %s", (Object[])new Object[]{CharSequence.class.getSimpleName(), value.getClass().getName()});
                return op == StringOperators.TO_UPPER_CASE ? value.toString().toUpperCase() : value.toString().toLowerCase();
            }
            if (op == Operators.AND || op == Operators.OR) {
                Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0, (String)"empty args for %s", (Object[])new Object[]{op});
                boolean shortCircuit = op == Operators.OR;
                boolean prev = !shortCircuit;
                for (Expression exp : args) {
                    Object result = exp.accept((ExpressionVisitor)this);
                    if (result == null || result == UNKNOWN) {
                        return UNKNOWN;
                    }
                    if (prev == shortCircuit || Objects.equals(shortCircuit, result)) {
                        return shortCircuit;
                    }
                    prev = (Boolean)result;
                }
                return prev;
            }
            if (op.arity() == Operator.Arity.BINARY) {
                Preconditions.checkArgument((call.arguments().size() == 2 ? 1 : 0) != 0, (String)"Expected two arguments for %s got %s", (Object[])new Object[]{call, call.arguments().size()});
                Object left = ((Expression)call.arguments().get(0)).accept((ExpressionVisitor)this);
                if (left == UNKNOWN) {
                    return UNKNOWN;
                }
                Object right = ((Expression)call.arguments().get(1)).accept((ExpressionVisitor)this);
                if (right == UNKNOWN) {
                    return UNKNOWN;
                }
                return LocalVisitor.binaryCall(call, left, right);
            }
            throw new UnsupportedOperationException("Don't know how to handle " + op);
        }

        private static Object binaryCall(Call call, Object left, Object right) {
            Preconditions.checkArgument((call.operator().arity() == Operator.Arity.BINARY ? 1 : 0) != 0, (String)"Expected binary call got %s", (Object[])new Object[]{call});
            Operator op = call.operator();
            if (op == Operators.EQUAL || op == Operators.NOT_EQUAL) {
                boolean equals = Objects.equals(left, right);
                return op == Operators.EQUAL == equals;
            }
            if (op == Operators.IN || op == Operators.NOT_IN) {
                Preconditions.checkArgument((boolean)(right instanceof Iterable), (String)"%s is not iterable", (Object[])new Object[]{left.getClass()});
                Iterable rightValue = (Iterable)right;
                Stream<Object> stream = StreamSupport.stream(rightValue.spliterator(), false);
                return op == Operators.IN ? stream.anyMatch(r -> Objects.equals(left, r)) : stream.noneMatch(r -> Objects.equals(left, r));
            }
            if (op == IterableOperators.HAS_SIZE) {
                Preconditions.checkArgument((boolean)(left instanceof Iterable), (String)"%s is not iterable", (Object[])new Object[]{left});
                Preconditions.checkArgument((boolean)(right instanceof Number), (String)"%s is not a number", (Object[])new Object[]{left});
                Iterable iter = (Iterable)left;
                int size = ((Number)right).intValue();
                return Iterables.size((Iterable)iter) == size;
            }
            if (op == IterableOperators.CONTAINS) {
                Preconditions.checkArgument((boolean)(left instanceof Iterable), (String)"%s is not iterable", (Object[])new Object[]{left});
                return Iterables.contains((Iterable)((Iterable)left), (Object)right);
            }
            if (ComparableOperators.isComparable((Operator)call.operator())) {
                Preconditions.checkArgument((boolean)(left instanceof Comparable), (String)"%s is not comparable", (Object[])new Object[]{left});
                Comparable leftComparable = (Comparable)left;
                Preconditions.checkArgument((boolean)(right instanceof Comparable), (String)"%s is not comparable", (Object[])new Object[]{right});
                Comparable rightComparable = (Comparable)right;
                int compare = leftComparable.compareTo(rightComparable);
                if (op == ComparableOperators.GREATER_THAN) {
                    return compare > 0;
                }
                if (op == ComparableOperators.GREATER_THAN_OR_EQUAL) {
                    return compare >= 0;
                }
                if (op == ComparableOperators.LESS_THAN) {
                    return compare < 0;
                }
                if (op == ComparableOperators.LESS_THAN_OR_EQUAL) {
                    return compare <= 0;
                }
            }
            if (op == StringOperators.HAS_LENGTH) {
                Preconditions.checkArgument((boolean)(left instanceof CharSequence), (String)"%s is not CharSequence", (Object[])new Object[]{left});
                Preconditions.checkArgument((boolean)(right instanceof Number), (String)"%s is not Number", (Object[])new Object[]{right});
                int length = ((Number)right).intValue();
                return left.toString().length() == length;
            }
            if (op == StringOperators.MATCHES) {
                Preconditions.checkArgument((boolean)(left instanceof CharSequence), (String)"%s is not string (or CharSequence)", (Object[])new Object[]{left});
                Preconditions.checkArgument((boolean)(right instanceof Pattern), (String)"%s is not regex pattern", (Object[])new Object[]{right});
                return ((Pattern)right).asPredicate().test(left.toString());
            }
            if (op == StringOperators.STARTS_WITH || op == StringOperators.ENDS_WITH || op == StringOperators.CONTAINS) {
                Preconditions.checkArgument((boolean)(left instanceof CharSequence), (String)"%s is not string (or CharSequence)", (Object[])new Object[]{left});
                Preconditions.checkArgument((boolean)(right instanceof CharSequence), (String)"%s is not string (or CharSequence)", (Object[])new Object[]{right});
                if (op == StringOperators.CONTAINS) {
                    return left.toString().contains(right.toString());
                }
                return op == StringOperators.STARTS_WITH ? left.toString().startsWith(right.toString()) : left.toString().endsWith(right.toString());
            }
            throw new UnsupportedOperationException("Unsupported binary call " + call);
        }

        public Object visit(Constant constant) {
            return constant.value();
        }

        public Object visit(Path path) {
            Object extracted = EXTRACTOR.extract(path, this.instance);
            return extracted == null ? UNKNOWN : extracted;
        }
    }
}

