/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.inmemory;

import java.util.Objects;
import java.util.function.Predicate;
import org.immutables.criteria.Criterias;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.inmemory.ExpressionInterpreter;

public final class InMemory {
    public static <T> Predicate<T> toPredicate(Criterion<T> criterion) {
        Objects.requireNonNull(criterion, "criterion");
        Expression expression = (Expression)Criterias.toQuery(criterion).filter().orElseThrow(() -> new IllegalArgumentException("Filter not set"));
        Predicate<Object> predicate = ExpressionInterpreter.of(expression).asPredicate();
        return predicate;
    }

    private InMemory() {
    }
}

