/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.inmemory;

import com.google.common.base.Preconditions;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.BackendException;
import org.immutables.criteria.backend.DefaultResult;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.inmemory.ExpressionInterpreter;
import org.immutables.criteria.inmemory.InMemorySetup;
import org.immutables.criteria.inmemory.PathExtractor;
import org.immutables.criteria.inmemory.ReflectionExtractor;
import org.immutables.criteria.inmemory.TupleExtractor;
import org.reactivestreams.Publisher;

public class InMemoryBackend
implements Backend {
    private final ConcurrentMap<Class<?>, Map<Object, Object>> classToStore;
    private final KeyExtractor.Factory keyExtractorFactory;

    public InMemoryBackend() {
        this(InMemorySetup.of());
    }

    public InMemoryBackend(InMemorySetup setup) {
        Objects.requireNonNull(setup, "setup");
        this.keyExtractorFactory = setup.keyExtractorFactory();
        this.classToStore = new ConcurrentHashMap();
    }

    public Session open(Class<?> entityType) {
        Map store = this.classToStore.computeIfAbsent(entityType, key -> new ConcurrentHashMap());
        return new Session(entityType, this.keyExtractorFactory.create(entityType), store);
    }

    private static class Session
    implements Backend.Session {
        private final Class<?> entityType;
        private final PathExtractor pathExtractor;
        private final KeyExtractor keyExtractor;
        private final Map<Object, Object> store;

        private Session(Class<?> entityType, KeyExtractor extractor, Map<Object, Object> store) {
            this.entityType = entityType;
            this.store = Objects.requireNonNull(store, "store");
            Preconditions.checkArgument((boolean)extractor.metadata().isKeyDefined(), (String)"Key should be defined for %s. Did you use correct KeyExtractor %s ? ", (Object[])new Object[]{entityType, extractor.getClass().getName()});
            this.keyExtractor = extractor;
            this.pathExtractor = new ReflectionExtractor();
        }

        public Class<?> entityType() {
            return this.entityType;
        }

        public Backend.Result execute(Backend.Operation operation) {
            return DefaultResult.of(this.executeInternal(operation));
        }

        private Publisher<?> executeInternal(Backend.Operation operation) {
            if (operation instanceof StandardOperations.Select) {
                return this.query((StandardOperations.Select)operation);
            }
            if (operation instanceof StandardOperations.Insert) {
                return this.insert((StandardOperations.Insert)operation);
            }
            if (operation instanceof StandardOperations.Update) {
                return this.update((StandardOperations.Update)operation);
            }
            if (operation instanceof StandardOperations.Delete) {
                return this.delete((StandardOperations.Delete)operation);
            }
            if (operation instanceof StandardOperations.DeleteByKey) {
                return this.deleteByKey((StandardOperations.DeleteByKey)operation);
            }
            if (operation instanceof StandardOperations.GetByKey) {
                return this.getByKey((StandardOperations.GetByKey)operation);
            }
            return Flowable.error((Throwable)new UnsupportedOperationException(String.format("Operation %s not supported", operation)));
        }

        private Publisher<?> query(StandardOperations.Select select) {
            Query query = select.query();
            if (query.hasAggregations()) {
                throw new UnsupportedOperationException("Aggregations are not yet supported by " + InMemoryBackend.class.getSimpleName());
            }
            Stream<Object> stream = this.store.values().stream();
            if (query.filter().isPresent()) {
                Predicate<Object> predicate = ExpressionInterpreter.of((Expression)query.filter().get()).asPredicate();
                stream = stream.filter(predicate);
            }
            if (!query.collations().isEmpty()) {
                Comparator<Object> comparator = null;
                for (Collation collation : query.collations()) {
                    Function<Object, Comparable> fn = obj -> (Comparable)this.pathExtractor.extract(collation.path(), obj);
                    Comparator<Object> newComparator = Comparator.comparing(fn);
                    if (!collation.direction().isAscending()) {
                        newComparator = newComparator.reversed();
                    }
                    if (comparator != null) {
                        comparator = comparator.thenComparing(newComparator);
                        continue;
                    }
                    comparator = newComparator;
                }
                stream = stream.sorted(comparator);
            }
            if (query.hasProjections()) {
                TupleExtractor extractor = new TupleExtractor(query, this.pathExtractor);
                stream = stream.map(extractor::extract);
            }
            if (query.distinct()) {
                stream = stream.distinct();
            }
            if (query.offset().isPresent()) {
                stream = stream.skip(query.offset().getAsLong());
            }
            if (query.limit().isPresent()) {
                stream = stream.limit(query.limit().getAsLong());
            }
            if (query.count()) {
                return Flowable.just((Object)stream.count());
            }
            return Flowable.fromIterable((Iterable)stream.collect(Collectors.toList()));
        }

        private Publisher<WriteResult> update(StandardOperations.Update op) {
            if (op.values().isEmpty()) {
                return Flowable.just((Object)WriteResult.empty());
            }
            Map<Object, Object> toUpdate = op.values().stream().collect(Collectors.toMap(arg_0 -> ((KeyExtractor)this.keyExtractor).extract(arg_0), v -> v));
            if (op.upsert()) {
                return Flowable.fromCallable(() -> {
                    this.store.putAll(toUpdate);
                    return WriteResult.unknown();
                });
            }
            return Flowable.fromCallable(() -> {
                toUpdate.forEach(this.store::replace);
                return WriteResult.unknown();
            });
        }

        private Publisher<WriteResult> insert(StandardOperations.Insert op) {
            if (op.values().isEmpty()) {
                return Flowable.just((Object)WriteResult.empty());
            }
            Map<Object, Object> toInsert = op.values().stream().collect(Collectors.toMap(arg_0 -> ((KeyExtractor)this.keyExtractor).extract(arg_0), x -> x));
            toInsert.forEach((k, v) -> {
                Object result = this.store.putIfAbsent(k, v);
                if (result != null) {
                    throw new BackendException(String.format("Duplicate key %s for %s", k, this.entityType()));
                }
            });
            return Flowable.just((Object)WriteResult.unknown());
        }

        private Publisher<WriteResult> deleteByKey(StandardOperations.DeleteByKey op) {
            int deleted = 0;
            for (Object key : op.keys()) {
                if (this.store.remove(key) == null) continue;
                ++deleted;
            }
            return Flowable.just((Object)WriteResult.empty().withDeletedCount((long)deleted));
        }

        private Publisher<?> getByKey(StandardOperations.GetByKey op) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object key : op.keys()) {
                Object value = this.store.get(key);
                if (value == null) continue;
                result.add(value);
            }
            return Flowable.fromIterable(result);
        }

        private Publisher<WriteResult> delete(StandardOperations.Delete op) {
            if (!op.query().filter().isPresent()) {
                int deleted = this.store.size();
                this.store.clear();
                return Flowable.just((Object)WriteResult.empty().withDeletedCount((long)deleted));
            }
            Expression filter = (Expression)op.query().filter().orElseThrow(() -> new IllegalArgumentException("no filter"));
            Predicate<Object> predicate = ExpressionInterpreter.of(filter).asPredicate();
            int deleted = 0;
            Iterator<Object> iter = this.store.values().iterator();
            while (iter.hasNext()) {
                if (!predicate.test(iter.next())) continue;
                ++deleted;
                iter.remove();
            }
            return Flowable.just((Object)WriteResult.empty().withDeletedCount((long)deleted));
        }
    }
}

