/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.inmemory;

import java.lang.reflect.Member;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.inmemory.PathExtractor;
import org.immutables.criteria.reflect.MemberExtractor;

class ReflectionExtractor
implements PathExtractor {
    private final MemberExtractor extractor = new UnwrapOptional(new NullSafe(MemberExtractor.ofReflection()));

    ReflectionExtractor() {
    }

    @Override
    @Nullable
    public Object extract(Path path, Object instance) {
        Objects.requireNonNull(path, "path");
        Object result = instance;
        for (Member member : path.members()) {
            result = this.extractor.extract(member, result);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    private static class UnwrapOptional
    implements MemberExtractor {
        private final MemberExtractor delegate;

        private UnwrapOptional(MemberExtractor delegate) {
            this.delegate = delegate;
        }

        public Object extract(Member member, Object instance) {
            Object maybeOptional = this.delegate.extract(member, instance);
            if (maybeOptional instanceof Optional) {
                return ((Optional)maybeOptional).orElse(null);
            }
            if (maybeOptional instanceof com.google.common.base.Optional) {
                return ((com.google.common.base.Optional)maybeOptional).orNull();
            }
            return maybeOptional;
        }
    }

    private static class NullSafe
    implements MemberExtractor {
        private final MemberExtractor delegate;

        private NullSafe(MemberExtractor delegate) {
            this.delegate = delegate;
        }

        public Object extract(Member member, Object instance) {
            return instance != null ? this.delegate.extract(member, instance) : null;
        }
    }
}

