/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.inmemory;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.inmemory.PathExtractor;

class TupleExtractor {
    private final Query query;
    private final PathExtractor pathExtractor;

    TupleExtractor(Query query, PathExtractor pathExtractor) {
        Preconditions.checkArgument((boolean)query.hasProjections(), (Object)"no projections defined");
        this.query = query;
        this.pathExtractor = pathExtractor;
    }

    ProjectedTuple extract(Object instance) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Expression expr : this.query.projections()) {
            Path path = (Path)expr;
            Object value = this.pathExtractor.extract(path, instance);
            value = TupleExtractor.maybeWrapOptional(value, path);
            values.add(value);
        }
        return ProjectedTuple.of((Iterable)this.query.projections(), values);
    }

    private static Object maybeWrapOptional(Object value, Path path) {
        Class klass;
        Type type = path.returnType();
        if (type instanceof ParameterizedType) {
            klass = (Class)((ParameterizedType)type).getRawType();
        } else if (type instanceof Class) {
            klass = (Class)type;
        } else {
            throw new IllegalArgumentException("Unknown type " + type + " for path " + path.toStringPath());
        }
        if (value instanceof OptionalDouble || value instanceof OptionalInt || value instanceof OptionalLong || value instanceof Optional || value instanceof com.google.common.base.Optional) {
            return value;
        }
        if (Optional.class.isAssignableFrom(klass)) {
            return Optional.ofNullable(value);
        }
        if (OptionalDouble.class.isAssignableFrom(klass)) {
            return value == null ? OptionalDouble.empty() : OptionalDouble.of((Double)value);
        }
        if (OptionalLong.class.isAssignableFrom(klass)) {
            return value == null ? OptionalLong.empty() : OptionalLong.of((Long)value);
        }
        if (OptionalInt.class.isAssignableFrom(klass)) {
            return value == null ? OptionalInt.empty() : OptionalInt.of((Integer)value);
        }
        if (com.google.common.base.Optional.class.isAssignableFrom(klass)) {
            return com.google.common.base.Optional.fromNullable((Object)value);
        }
        return value;
    }
}

