/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.func.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.func.fixture.Val;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Val", generator="Immutables")
@Immutable
public final class ImmutableVal
implements Val {
    private final boolean isEmpty;
    private final String name;
    @Nullable
    private final Number nullable;
    private final int age;

    private ImmutableVal(boolean isEmpty, String name, @Nullable Number nullable, int age) {
        this.isEmpty = isEmpty;
        this.name = name;
        this.nullable = nullable;
        this.age = age;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Number nullable() {
        return this.nullable;
    }

    @Override
    public int age() {
        return this.age;
    }

    public final ImmutableVal withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableVal(value, this.name, this.nullable, this.age);
    }

    public final ImmutableVal withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "name");
        return new ImmutableVal(this.isEmpty, newValue, this.nullable, this.age);
    }

    public final ImmutableVal withNullable(@Nullable Number value) {
        if (this.nullable == value) {
            return this;
        }
        return new ImmutableVal(this.isEmpty, this.name, value, this.age);
    }

    public final ImmutableVal withAge(int value) {
        if (this.age == value) {
            return this;
        }
        return new ImmutableVal(this.isEmpty, this.name, this.nullable, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVal && this.equalTo((ImmutableVal)another);
    }

    private boolean equalTo(ImmutableVal another) {
        return this.isEmpty == another.isEmpty && this.name.equals(another.name) && Objects.equals(this.nullable, another.nullable) && this.age == another.age;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isEmpty);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.nullable);
        h += (h << 5) + this.age;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Val").omitNullValues().add("isEmpty", this.isEmpty).add("name", (Object)this.name).add("nullable", (Object)this.nullable).add("age", this.age).toString();
    }

    public static ImmutableVal copyOf(Val instance) {
        if (instance instanceof ImmutableVal) {
            return (ImmutableVal)instance;
        }
        return ImmutableVal.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_AGE = 4L;
        private long initBits = 7L;
        private boolean isEmpty;
        @Nullable
        private String name;
        @Nullable
        private Number nullable;
        private int age;

        private Builder() {
        }

        public final Builder from(Val instance) {
            Objects.requireNonNull(instance, "instance");
            this.isEmpty(instance.isEmpty());
            this.name(instance.getName());
            Number nullableValue = instance.nullable();
            if (nullableValue != null) {
                this.nullable(nullableValue);
            }
            this.age(instance.age());
            return this;
        }

        public final Builder isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder nullable(@Nullable Number nullable) {
            this.nullable = nullable;
            return this;
        }

        public final Builder age(int age) {
            this.age = age;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableVal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVal(this.isEmpty, this.name, this.nullable, this.age);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("age");
            }
            return "Cannot build Val, some of required attributes are not set " + attributes;
        }
    }
}

