/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.func.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.func.fixture.ValGeneric;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ValGeneric", generator="Immutables")
@Immutable
public final class ImmutableValGeneric<T extends Number>
implements ValGeneric<T> {
    private final boolean isEmpty;
    @Nullable
    private final T nullable;

    private ImmutableValGeneric(boolean isEmpty, @Nullable T nullable) {
        this.isEmpty = isEmpty;
        this.nullable = nullable;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    @Nullable
    public T nullable() {
        return this.nullable;
    }

    public final ImmutableValGeneric<T> withIsEmpty(boolean value) {
        if (this.isEmpty == value) {
            return this;
        }
        return new ImmutableValGeneric<T>(value, this.nullable);
    }

    public final ImmutableValGeneric<T> withNullable(@Nullable T value) {
        if (this.nullable == value) {
            return this;
        }
        return new ImmutableValGeneric<T>(this.isEmpty, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValGeneric && this.equalTo((ImmutableValGeneric)another);
    }

    private boolean equalTo(ImmutableValGeneric<?> another) {
        return this.isEmpty == another.isEmpty && Objects.equals(this.nullable, another.nullable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isEmpty);
        h += (h << 5) + Objects.hashCode(this.nullable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValGeneric").omitNullValues().add("isEmpty", this.isEmpty).add("nullable", this.nullable).toString();
    }

    public static <T extends Number> ImmutableValGeneric<T> copyOf(ValGeneric<T> instance) {
        if (instance instanceof ImmutableValGeneric) {
            return (ImmutableValGeneric)instance;
        }
        return ImmutableValGeneric.builder().from(instance).build();
    }

    public static <T extends Number> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableValGeneric(boolean x0, Number x1, 1 x2) {
        this(x0, x1);
    }

    @NotThreadSafe
    public static final class Builder<T extends Number> {
        private static final long INIT_BIT_IS_EMPTY = 1L;
        private long initBits = 1L;
        private boolean isEmpty;
        @Nullable
        private T nullable;

        private Builder() {
        }

        public final Builder<T> from(ValGeneric<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.isEmpty(instance.isEmpty());
            T nullableValue = instance.nullable();
            if (nullableValue != null) {
                this.nullable(nullableValue);
            }
            return this;
        }

        public final Builder<T> isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> nullable(@Nullable T nullable) {
            this.nullable = nullable;
            return this;
        }

        public ImmutableValGeneric<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValGeneric(this.isEmpty, (Number)this.nullable, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isEmpty");
            }
            return "Cannot build ValGeneric, some of required attributes are not set " + attributes;
        }
    }
}

