package org.immutables.generator.processor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generator.processor.Trees;

/**
 * {@code ImmutableTrees} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Trees}.
 * @see ImmutableTrees.Identifier
 * @see ImmutableTrees.TypeIdentifier
 * @see ImmutableTrees.TypeDeclaration
 * @see ImmutableTrees.ResolvedType
 * @see ImmutableTrees.BoundAccessExpression
 * @see ImmutableTrees.InvokableDeclaration
 * @see ImmutableTrees.ValueDeclaration
 * @see ImmutableTrees.Parameter
 * @see ImmutableTrees.Block
 * @see ImmutableTrees.Comment
 * @see ImmutableTrees.ConditionalBlock
 * @see ImmutableTrees.IfStatement
 * @see ImmutableTrees.ForStatement
 * @see ImmutableTrees.ForIterationAccessExpression
 * @see ImmutableTrees.LetStatement
 * @see ImmutableTrees.InvokeStatement
 * @see ImmutableTrees.LetEnd
 * @see ImmutableTrees.ForEnd
 * @see ImmutableTrees.IfEnd
 * @see ImmutableTrees.InvokeEnd
 * @see ImmutableTrees.InvokeString
 * @see ImmutableTrees.Invoke
 * @see ImmutableTrees.Let
 * @see ImmutableTrees.Unit
 * @see ImmutableTrees.Template
 * @see ImmutableTrees.AccessExpression
 * @see ImmutableTrees.ApplyExpression
 * @see ImmutableTrees.AssignGenerator
 * @see ImmutableTrees.IterationGenerator
 * @see ImmutableTrees.TransformGenerator
 * @see ImmutableTrees.For
 * @see ImmutableTrees.If
 * @see ImmutableTrees.ElseIf
 * @see ImmutableTrees.Else
 * @see ImmutableTrees.TemplateEnd
 * @see ImmutableTrees.StringLiteral
 * @see ImmutableTrees.Newline
 * @see ImmutableTrees.TextFragment
 * @see ImmutableTrees.TextBlock
 * @see ImmutableTrees.TextLine
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Trees"})
public final class ImmutableTrees {
  private ImmutableTrees() {}

  /**
   * Immutable implementation of {@link Trees.Identifier}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Identifier"})
  @Immutable
  public static final class Identifier
      extends Trees.Identifier {

    /**
     * Constructs new immutable instance of Trees.Identifier.
     * @param value value for {@code value}
     * @return immutable Trees.Identifier instance
     */
    public static Identifier of(String value) {
      return checkPreconditions(new Identifier(value));
    }

    private static Identifier checkPreconditions(Identifier instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Identifier. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Identifier copyOf(Trees.Identifier instance) {
      if (instance instanceof Identifier) {
        return (Identifier) instance;
      }
      return of(instance.value());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Identifier copyOf(Identifier instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final String value;

    private Identifier(
        String value) {
      this.value = Preconditions.checkNotNull(value);
    }

    private Identifier(
        Identifier copiedInstance, 
        String value) {
      this.value = value;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Identifier#value()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for value, non-null
     * @return modified copy of the {@code this} object
     */
    public final Identifier withValue(String value) {
      if (this.value == value) {
        return this;
      }
      String newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Identifier(
          this, 
          newValue));
    }
    @Override
    public String value() {
      return value;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Identifier && equalTo((Identifier) another));
    }

    private boolean equalTo(Identifier another) {
      return value.equals(another.value);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + value.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }
  }

  /**
   * Immutable implementation of {@link Trees.TypeIdentifier}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TypeIdentifier"})
  @Immutable
  public static final class TypeIdentifier
      extends Trees.TypeIdentifier {

    /**
     * Constructs new immutable instance of Trees.TypeIdentifier.
     * @param value value for {@code value}
     * @return immutable Trees.TypeIdentifier instance
     */
    public static TypeIdentifier of(String value) {
      return checkPreconditions(new TypeIdentifier(value));
    }

    private static TypeIdentifier checkPreconditions(TypeIdentifier instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TypeIdentifier. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TypeIdentifier copyOf(Trees.TypeIdentifier instance) {
      if (instance instanceof TypeIdentifier) {
        return (TypeIdentifier) instance;
      }
      return of(instance.value());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TypeIdentifier copyOf(TypeIdentifier instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final String value;

    private TypeIdentifier(
        String value) {
      this.value = Preconditions.checkNotNull(value);
    }

    private TypeIdentifier(
        TypeIdentifier copiedInstance, 
        String value) {
      this.value = value;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TypeIdentifier#value()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for value, non-null
     * @return modified copy of the {@code this} object
     */
    public final TypeIdentifier withValue(String value) {
      if (this.value == value) {
        return this;
      }
      String newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TypeIdentifier(
          this, 
          newValue));
    }
    @Override
    public String value() {
      return value;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TypeIdentifier && equalTo((TypeIdentifier) another));
    }

    private boolean equalTo(TypeIdentifier another) {
      return value.equals(another.value);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + value.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }
  }

  /**
   * Immutable implementation of {@link Trees.TypeDeclaration}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TypeDeclaration"})
  @Immutable
  public static final class TypeDeclaration
      extends Trees.TypeDeclaration {

    private static TypeDeclaration checkPreconditions(TypeDeclaration instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TypeDeclaration. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TypeDeclaration copyOf(Trees.TypeDeclaration instance) {
      if (instance instanceof TypeDeclaration) {
        return (TypeDeclaration) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .type(instance.type())
          .kind(instance.kind())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TypeDeclaration copyOf(TypeDeclaration instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.TypeIdentifier type;
    private final Trees.TypeDeclaration.Kind kind;

    private TypeDeclaration(Builder builder) {
      this.type = builder.type;
      this.kind = builder.kind != null
          ? builder.kind
          : Preconditions.checkNotNull(super.kind());
    }

    private TypeDeclaration(
        TypeDeclaration copiedInstance, 
        Trees.TypeIdentifier type, 
        Trees.TypeDeclaration.Kind kind) {
      this.type = type;
      this.kind = kind;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TypeDeclaration#type()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for type, non-null
     * @return modified copy of the {@code this} object
     */
    public final TypeDeclaration withType(Trees.TypeIdentifier value) {
      if (this.type == value) {
        return this;
      }
      Trees.TypeIdentifier newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TypeDeclaration(
          this, 
          newValue, 
          this.kind));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TypeDeclaration#kind()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for kind, non-null
     * @return modified copy of the {@code this} object
     */
    public final TypeDeclaration withKind(Trees.TypeDeclaration.Kind value) {
      if (this.kind == value) {
        return this;
      }
      Trees.TypeDeclaration.Kind newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TypeDeclaration(
          this, 
          this.type, 
          newValue));
    }
    @Override
    public Trees.TypeIdentifier type() {
      return type;
    }
    @Override
    public Trees.TypeDeclaration.Kind kind() {
      return kind;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TypeDeclaration && equalTo((TypeDeclaration) another));
    }

    private boolean equalTo(TypeDeclaration another) {
      return type.equals(another.type)
          && kind.equals(another.kind);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + type.hashCode();
      h = h * 17 + kind.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TypeDeclaration")
          .add("type", type)
          .add("kind", kind)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.TypeDeclaration}.
     * @return new Trees.TypeDeclaration builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.TypeDeclaration}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_TYPE = 0x1L;

      private boolean typeIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_TYPE) != 0;
      }
      @Nullable
      private Trees.TypeIdentifier type;
      @Nullable
      private Trees.TypeDeclaration.Kind kind;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("TypeDeclaration.Builder")
            .omitNullValues()
            .add("type", type)
            .add("kind", kind)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.TypeDeclaration#type()}.
       * @param type value for type, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Trees.TypeIdentifier type) {
        this.type = Preconditions.checkNotNull(type);
        initializedBitset0 |= INITIALIZED_BIT_TYPE;
        return this;
      }

      /**
       * Initializes value for {@link Trees.TypeDeclaration#kind()}.
       * <p><em>If not set, this attribute will have {@link Trees.TypeDeclaration#kind() default value}.</em>
       * @param kind value for kind, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder kind(Trees.TypeDeclaration.Kind kind) {
        this.kind = Preconditions.checkNotNull(kind);
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.TypeDeclaration, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!typeIsSet() ? "type" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.TypeDeclaration}.
       * @return immutable instance of Trees.TypeDeclaration
       */
      public TypeDeclaration build() {
        checkRequiredAttributes();
        return checkPreconditions(new TypeDeclaration(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ResolvedType}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ResolvedType"})
  @Immutable
  public static final class ResolvedType
      extends Trees.ResolvedType {

    /**
     * Constructs new immutable instance of Trees.ResolvedType.
     * @param type value for {@code type}
     * @return immutable Trees.ResolvedType instance
     */
    public static ResolvedType of(Object type) {
      return checkPreconditions(new ResolvedType(type));
    }

    private static ResolvedType checkPreconditions(ResolvedType instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ResolvedType. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ResolvedType copyOf(Trees.ResolvedType instance) {
      if (instance instanceof ResolvedType) {
        return (ResolvedType) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .type(instance.type())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ResolvedType copyOf(ResolvedType instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Object type;

    private ResolvedType(
        Object type) {
      this.type = Preconditions.checkNotNull(type);
    }

    private ResolvedType(Builder builder) {
      this.type = builder.type;
    }

    private ResolvedType(
        ResolvedType copiedInstance, 
        Object type) {
      this.type = type;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.ResolvedType#type()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for type, non-null
     * @return modified copy of the {@code this} object
     */
    public final ResolvedType withType(Object value) {
      if (this.type == value) {
        return this;
      }
      Object newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new ResolvedType(
          this, 
          newValue));
    }
    @Override
    public Object type() {
      return type;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ResolvedType && equalTo((ResolvedType) another));
    }

    private boolean equalTo(ResolvedType another) {
      return type.equals(another.type);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + type.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    /**
     * Creates builder for {@link Trees.ResolvedType}.
     * @return new Trees.ResolvedType builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ResolvedType}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_TYPE = 0x1L;

      private boolean typeIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_TYPE) != 0;
      }
      @Nullable
      private Object type;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ResolvedType.Builder")
            .omitNullValues()
            .add("type", type)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.ResolvedType#type()}.
       * @param type value for type, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Object type) {
        this.type = Preconditions.checkNotNull(type);
        initializedBitset0 |= INITIALIZED_BIT_TYPE;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.ResolvedType, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!typeIsSet() ? "type" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.ResolvedType}.
       * @return immutable instance of Trees.ResolvedType
       */
      public ResolvedType build() {
        checkRequiredAttributes();
        return checkPreconditions(new ResolvedType(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.BoundAccessExpression}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.BoundAccessExpression"})
  @Immutable
  public static final class BoundAccessExpression
      extends Trees.BoundAccessExpression {

    private static BoundAccessExpression checkPreconditions(BoundAccessExpression instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.BoundAccessExpression. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static BoundAccessExpression copyOf(Trees.BoundAccessExpression instance) {
      if (instance instanceof BoundAccessExpression) {
        return (BoundAccessExpression) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllAccessor(instance.accessor())
          .addAllPath(instance.path())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static BoundAccessExpression copyOf(BoundAccessExpression instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Object> accessor;
    private final ImmutableList<Trees.Identifier> path;

    private BoundAccessExpression(Builder builder) {
      this.accessor = builder.accessorBuilder.build();
      this.path = builder.pathBuilder.build();
    }

    private BoundAccessExpression(
        BoundAccessExpression copiedInstance, 
        ImmutableList<Object> accessor, 
        ImmutableList<Trees.Identifier> path) {
      this.accessor = accessor;
      this.path = path;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.BoundAccessExpression#accessor()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final BoundAccessExpression withAccessor(Object... elements) {
      ImmutableList<Object> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new BoundAccessExpression(
          this, 
          newValue, 
          this.path));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.BoundAccessExpression#accessor()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of accessor elements to set
     * @return modified copy of {@code this} object
     */
    public final BoundAccessExpression withAccessor(Iterable<? extends Object> elements) {
      if (this.accessor == elements) {
        return this;
      }
      ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new BoundAccessExpression(
          this, 
          newValue, 
          this.path));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.BoundAccessExpression#path()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final BoundAccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new BoundAccessExpression(
          this, 
          this.accessor, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.BoundAccessExpression#path()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of path elements to set
     * @return modified copy of {@code this} object
     */
    public final BoundAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) {
        return this;
      }
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new BoundAccessExpression(
          this, 
          this.accessor, 
          newValue));
    }
    @Override
    public ImmutableList<Object> accessor() {
      return accessor;
    }
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof BoundAccessExpression && equalTo((BoundAccessExpression) another));
    }

    private boolean equalTo(BoundAccessExpression another) {
      return accessor.equals(another.accessor)
          && path.equals(another.path);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + accessor.hashCode();
      h = h * 17 + path.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    /**
     * Creates builder for {@link Trees.BoundAccessExpression}.
     * @return new Trees.BoundAccessExpression builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.BoundAccessExpression}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Object> accessorBuilder =
          ImmutableList.builder();
      private ImmutableList.Builder<Trees.Identifier> pathBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("BoundAccessExpression.Builder")
            .omitNullValues()
            .add("accessor", accessorBuilder.build())
            .add("path", pathBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.BoundAccessExpression#accessor()} list.
       * @param element single accessor element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAccessor(Object element) {
        accessorBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#accessor()} list.
       * @param elements array of accessor elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAccessor(Object... elements) {
        accessorBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.BoundAccessExpression#accessor()} list.
       * @param elements iterable of accessor elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllAccessor(Iterable<? extends Object> elements) {
        accessorBuilder.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.BoundAccessExpression#path()} list.
       * @param element single path element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addPath(Trees.Identifier element) {
        pathBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#path()} list.
       * @param elements array of path elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addPath(Trees.Identifier... elements) {
        pathBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.BoundAccessExpression#path()} list.
       * @param elements iterable of path elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
        pathBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.BoundAccessExpression}.
       * @return immutable instance of Trees.BoundAccessExpression
       */
      public BoundAccessExpression build() {
        return checkPreconditions(new BoundAccessExpression(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokableDeclaration}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.InvokableDeclaration"})
  @Immutable
  public static final class InvokableDeclaration
      implements Trees.InvokableDeclaration {

    private static InvokableDeclaration checkPreconditions(InvokableDeclaration instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.InvokableDeclaration. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static InvokableDeclaration copyOf(Trees.InvokableDeclaration instance) {
      if (instance instanceof InvokableDeclaration) {
        return (InvokableDeclaration) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParameters(instance.parameters())
          .name(instance.name())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static InvokableDeclaration copyOf(InvokableDeclaration instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.Parameter> parameters;
    private final Trees.Identifier name;

    private InvokableDeclaration(Builder builder) {
      this.parameters = builder.parametersBuilder.build();
      this.name = builder.name;
    }

    private InvokableDeclaration(
        InvokableDeclaration copiedInstance, 
        ImmutableList<Trees.Parameter> parameters, 
        Trees.Identifier name) {
      this.parameters = parameters;
      this.name = name;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokableDeclaration#parameters()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokableDeclaration withParameters(Trees.Parameter... elements) {
      ImmutableList<Trees.Parameter> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new InvokableDeclaration(
          this, 
          newValue, 
          this.name));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokableDeclaration#parameters()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parameters elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokableDeclaration withParameters(Iterable<? extends Trees.Parameter> elements) {
      if (this.parameters == elements) {
        return this;
      }
      ImmutableList<Trees.Parameter> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new InvokableDeclaration(
          this, 
          newValue, 
          this.name));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.InvokableDeclaration#name()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for name, non-null
     * @return modified copy of the {@code this} object
     */
    public final InvokableDeclaration withName(Trees.Identifier value) {
      if (this.name == value) {
        return this;
      }
      Trees.Identifier newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new InvokableDeclaration(
          this, 
          this.parameters, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.Parameter> parameters() {
      return parameters;
    }
    @Override
    public Trees.Identifier name() {
      return name;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof InvokableDeclaration && equalTo((InvokableDeclaration) another));
    }

    private boolean equalTo(InvokableDeclaration another) {
      return parameters.equals(another.parameters)
          && name.equals(another.name);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parameters.hashCode();
      h = h * 17 + name.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokableDeclaration")
          .add("parameters", parameters)
          .add("name", name)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.InvokableDeclaration}.
     * @return new Trees.InvokableDeclaration builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.InvokableDeclaration}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_NAME = 0x1L;

      private boolean nameIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_NAME) != 0;
      }
      private ImmutableList.Builder<Trees.Parameter> parametersBuilder =
          ImmutableList.builder();
      @Nullable
      private Trees.Identifier name;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("InvokableDeclaration.Builder")
            .omitNullValues()
            .add("parameters", parametersBuilder.build())
            .add("name", name)
            .toString();
      }

      /**
       * Adds one element to {@link Trees.InvokableDeclaration#parameters()} list.
       * @param element single parameters element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParameters(Trees.Parameter element) {
        parametersBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokableDeclaration#parameters()} list.
       * @param elements array of parameters elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParameters(Trees.Parameter... elements) {
        parametersBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.InvokableDeclaration#parameters()} list.
       * @param elements iterable of parameters elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParameters(Iterable<? extends Trees.Parameter> elements) {
        parametersBuilder.addAll(elements);
        return this;
      }

      /**
       * Initializes value for {@link Trees.InvokableDeclaration#name()}.
       * @param name value for name, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name);
        initializedBitset0 |= INITIALIZED_BIT_NAME;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.InvokableDeclaration, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!nameIsSet() ? "name" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.InvokableDeclaration}.
       * @return immutable instance of Trees.InvokableDeclaration
       */
      public InvokableDeclaration build() {
        checkRequiredAttributes();
        return checkPreconditions(new InvokableDeclaration(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ValueDeclaration}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ValueDeclaration"})
  @Immutable
  public static final class ValueDeclaration
      implements Trees.ValueDeclaration {

    private static ValueDeclaration checkPreconditions(ValueDeclaration instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ValueDeclaration. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ValueDeclaration copyOf(Trees.ValueDeclaration instance) {
      if (instance instanceof ValueDeclaration) {
        return (ValueDeclaration) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .type(instance.type())
          .containedType(instance.containedType())
          .name(instance.name())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ValueDeclaration copyOf(ValueDeclaration instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Optional<Trees.TypeReference> type;
    private final Optional<Trees.TypeReference> containedType;
    private final Trees.Identifier name;

    private ValueDeclaration(Builder builder) {
      this.type = builder.type;
      this.containedType = builder.containedType;
      this.name = builder.name;
    }

    private ValueDeclaration(
        ValueDeclaration copiedInstance, 
        Optional<Trees.TypeReference> type, 
        Optional<Trees.TypeReference> containedType, 
        Trees.Identifier name) {
      this.type = type;
      this.containedType = containedType;
      this.name = name;
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.ValueDeclaration#type()}.
     * @param value value for type, non-null
     * @return modified copy of {@code this} object
     */
    public final ValueDeclaration withType(Trees.TypeReference value) {
      Optional<Trees.TypeReference> newValue = Optional.of(value);
      return checkPreconditions(new ValueDeclaration(
          this, 
          newValue, 
          this.containedType, 
          this.name));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.ValueDeclaration#type()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for type, non-null
     * @return modified copy of {@code this} object
     */
    public final ValueDeclaration withType(Optional<Trees.TypeReference> optional) {
      if (this.type == optional) {
        return this;
      }
      Optional<Trees.TypeReference> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new ValueDeclaration(
          this, 
          newValue, 
          this.containedType, 
          this.name));
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.ValueDeclaration#containedType()}.
     * @param value value for containedType, non-null
     * @return modified copy of {@code this} object
     */
    public final ValueDeclaration withContainedType(Trees.TypeReference value) {
      Optional<Trees.TypeReference> newValue = Optional.of(value);
      return checkPreconditions(new ValueDeclaration(
          this, 
          this.type, 
          newValue, 
          this.name));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.ValueDeclaration#containedType()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for containedType, non-null
     * @return modified copy of {@code this} object
     */
    public final ValueDeclaration withContainedType(Optional<Trees.TypeReference> optional) {
      if (this.containedType == optional) {
        return this;
      }
      Optional<Trees.TypeReference> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new ValueDeclaration(
          this, 
          this.type, 
          newValue, 
          this.name));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.ValueDeclaration#name()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for name, non-null
     * @return modified copy of the {@code this} object
     */
    public final ValueDeclaration withName(Trees.Identifier value) {
      if (this.name == value) {
        return this;
      }
      Trees.Identifier newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new ValueDeclaration(
          this, 
          this.type, 
          this.containedType, 
          newValue));
    }
    @Override
    public Optional<Trees.TypeReference> type() {
      return type;
    }
    @Override
    public Optional<Trees.TypeReference> containedType() {
      return containedType;
    }
    @Override
    public Trees.Identifier name() {
      return name;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ValueDeclaration && equalTo((ValueDeclaration) another));
    }

    private boolean equalTo(ValueDeclaration another) {
      return type.equals(another.type)
          && containedType.equals(another.containedType)
          && name.equals(another.name);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + type.hashCode();
      h = h * 17 + containedType.hashCode();
      h = h * 17 + name.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ValueDeclaration")
          .add("type", type.orNull())
          .add("containedType", containedType.orNull())
          .add("name", name)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.ValueDeclaration}.
     * @return new Trees.ValueDeclaration builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ValueDeclaration}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_NAME = 0x1L;

      private boolean nameIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_NAME) != 0;
      }
      private Optional<Trees.TypeReference> type = Optional.absent();
      private Optional<Trees.TypeReference> containedType = Optional.absent();
      @Nullable
      private Trees.Identifier name;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ValueDeclaration.Builder")
            .omitNullValues()
            .add("type", type.orNull())
            .add("containedType", containedType.orNull())
            .add("name", name)
            .toString();
      }

      /**
       * Initializes present value for optional {@link Trees.ValueDeclaration#type()}.
       * @param type value for type, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Trees.TypeReference type) {
        this.type(Optional.of(type));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.ValueDeclaration#type()}.
       * @param type value for type, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Optional<Trees.TypeReference> type) {
        this.type = Preconditions.checkNotNull(type);
        return this;
      }

      /**
       * Initializes present value for optional {@link Trees.ValueDeclaration#containedType()}.
       * @param containedType value for containedType, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder containedType(Trees.TypeReference containedType) {
        this.containedType(Optional.of(containedType));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.ValueDeclaration#containedType()}.
       * @param containedType value for containedType, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder containedType(Optional<Trees.TypeReference> containedType) {
        this.containedType = Preconditions.checkNotNull(containedType);
        return this;
      }

      /**
       * Initializes value for {@link Trees.ValueDeclaration#name()}.
       * @param name value for name, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name);
        initializedBitset0 |= INITIALIZED_BIT_NAME;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.ValueDeclaration, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!nameIsSet() ? "name" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.ValueDeclaration}.
       * @return immutable instance of Trees.ValueDeclaration
       */
      public ValueDeclaration build() {
        checkRequiredAttributes();
        return checkPreconditions(new ValueDeclaration(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Parameter}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Parameter"})
  @Immutable
  public static final class Parameter
      implements Trees.Parameter {

    private static Parameter checkPreconditions(Parameter instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Parameter. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Parameter copyOf(Trees.Parameter instance) {
      if (instance instanceof Parameter) {
        return (Parameter) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .name(instance.name())
          .type(instance.type())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Parameter copyOf(Parameter instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Identifier name;
    private final Trees.TypeReference type;

    private Parameter(Builder builder) {
      this.name = builder.name;
      this.type = builder.type;
    }

    private Parameter(
        Parameter copiedInstance, 
        Trees.Identifier name, 
        Trees.TypeReference type) {
      this.name = name;
      this.type = type;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Parameter#name()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for name, non-null
     * @return modified copy of the {@code this} object
     */
    public final Parameter withName(Trees.Identifier value) {
      if (this.name == value) {
        return this;
      }
      Trees.Identifier newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Parameter(
          this, 
          newValue, 
          this.type));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Parameter#type()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for type, non-null
     * @return modified copy of the {@code this} object
     */
    public final Parameter withType(Trees.TypeReference value) {
      if (this.type == value) {
        return this;
      }
      Trees.TypeReference newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Parameter(
          this, 
          this.name, 
          newValue));
    }
    @Override
    public Trees.Identifier name() {
      return name;
    }
    @Override
    public Trees.TypeReference type() {
      return type;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Parameter && equalTo((Parameter) another));
    }

    private boolean equalTo(Parameter another) {
      return name.equals(another.name)
          && type.equals(another.type);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + name.hashCode();
      h = h * 17 + type.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Parameter")
          .add("name", name)
          .add("type", type)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Parameter}.
     * @return new Trees.Parameter builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Parameter}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x3;
      private static final long INITIALIZED_BIT_NAME = 0x1L;

      private boolean nameIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_NAME) != 0;
      }
      private static final long INITIALIZED_BIT_TYPE = 0x2L;

      private boolean typeIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_TYPE) != 0;
      }
      @Nullable
      private Trees.Identifier name;
      @Nullable
      private Trees.TypeReference type;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Parameter.Builder")
            .omitNullValues()
            .add("name", name)
            .add("type", type)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.Parameter#name()}.
       * @param name value for name, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name);
        initializedBitset0 |= INITIALIZED_BIT_NAME;
        return this;
      }

      /**
       * Initializes value for {@link Trees.Parameter#type()}.
       * @param type value for type, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Trees.TypeReference type) {
        this.type = Preconditions.checkNotNull(type);
        initializedBitset0 |= INITIALIZED_BIT_TYPE;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.Parameter, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!nameIsSet() ? "name" : null)
                  .addValue(!typeIsSet() ? "type" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.Parameter}.
       * @return immutable instance of Trees.Parameter
       */
      public Parameter build() {
        checkRequiredAttributes();
        return checkPreconditions(new Parameter(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Block}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Block"})
  @Immutable
  public static final class Block
      implements Trees.Block {

    private static Block checkPreconditions(Block instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Block. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Block copyOf(Trees.Block instance) {
      if (instance instanceof Block) {
        return (Block) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Block copyOf(Block instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.TemplatePart> parts;

    private Block(Builder builder) {
      this.parts = builder.partsBuilder.build();
    }

    private Block(
        Block copiedInstance, 
        ImmutableList<Trees.TemplatePart> parts) {
      this.parts = parts;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Block#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final Block withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new Block(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Block#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final Block withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new Block(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Block && equalTo((Block) another));
    }

    private boolean equalTo(Block another) {
      return parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Block")
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Block}.
     * @return new Trees.Block builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Block}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Block.Builder")
            .omitNullValues()
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.Block#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.Block#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.Block#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.Block}.
       * @return immutable instance of Trees.Block
       */
      public Block build() {
        return checkPreconditions(new Block(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Comment}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Comment"})
  @Immutable
  public static final class Comment
      implements Trees.Comment {

    private static Comment checkPreconditions(Comment instance) {
      return instance;
    }

    private static final Comment INSTANCE = checkPreconditions(new Comment());

    /**
     * Returns default immutable singleton value of Comment
     * @return immutable instance of Trees.Comment
     */
    public static Comment of() {
      return INSTANCE;
    }

    private Comment() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Comment && equalTo((Comment) another));
    }

    private boolean equalTo(Comment another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.Comment".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Comment")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.ConditionalBlock}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ConditionalBlock"})
  @Immutable
  public static final class ConditionalBlock
      implements Trees.ConditionalBlock {

    private static ConditionalBlock checkPreconditions(ConditionalBlock instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ConditionalBlock. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ConditionalBlock copyOf(Trees.ConditionalBlock instance) {
      if (instance instanceof ConditionalBlock) {
        return (ConditionalBlock) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .condition(instance.condition())
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ConditionalBlock copyOf(ConditionalBlock instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Expression condition;
    private final ImmutableList<Trees.TemplatePart> parts;

    private ConditionalBlock(Builder builder) {
      this.condition = builder.condition;
      this.parts = builder.partsBuilder.build();
    }

    private ConditionalBlock(
        ConditionalBlock copiedInstance, 
        Trees.Expression condition, 
        ImmutableList<Trees.TemplatePart> parts) {
      this.condition = condition;
      this.parts = parts;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.ConditionalBlock#condition()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for condition, non-null
     * @return modified copy of the {@code this} object
     */
    public final ConditionalBlock withCondition(Trees.Expression value) {
      if (this.condition == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new ConditionalBlock(
          this, 
          newValue, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ConditionalBlock#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final ConditionalBlock withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new ConditionalBlock(
          this, 
          this.condition, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ConditionalBlock#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final ConditionalBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new ConditionalBlock(
          this, 
          this.condition, 
          newValue));
    }
    @Override
    public Trees.Expression condition() {
      return condition;
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ConditionalBlock && equalTo((ConditionalBlock) another));
    }

    private boolean equalTo(ConditionalBlock another) {
      return condition.equals(another.condition)
          && parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + condition.hashCode();
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ConditionalBlock")
          .add("condition", condition)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.ConditionalBlock}.
     * @return new Trees.ConditionalBlock builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ConditionalBlock}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_CONDITION = 0x1L;

      private boolean conditionIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_CONDITION) != 0;
      }
      @Nullable
      private Trees.Expression condition;
      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ConditionalBlock.Builder")
            .omitNullValues()
            .add("condition", condition)
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Initializes value for {@link Trees.ConditionalBlock#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition);
        initializedBitset0 |= INITIALIZED_BIT_CONDITION;
        return this;
      }

      /**
       * Adds one element to {@link Trees.ConditionalBlock#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ConditionalBlock#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.ConditionalBlock#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.ConditionalBlock, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!conditionIsSet() ? "condition" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.ConditionalBlock}.
       * @return immutable instance of Trees.ConditionalBlock
       */
      public ConditionalBlock build() {
        checkRequiredAttributes();
        return checkPreconditions(new ConditionalBlock(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.IfStatement}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.IfStatement"})
  @Immutable
  public static final class IfStatement
      implements Trees.IfStatement {

    private static IfStatement checkPreconditions(IfStatement instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.IfStatement. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static IfStatement copyOf(Trees.IfStatement instance) {
      if (instance instanceof IfStatement) {
        return (IfStatement) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .then(instance.then())
          .addAllOtherwiseIf(instance.otherwiseIf())
          .otherwise(instance.otherwise())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static IfStatement copyOf(IfStatement instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.ConditionalBlock then;
    private final ImmutableList<Trees.ConditionalBlock> otherwiseIf;
    private final Optional<Trees.Block> otherwise;

    private IfStatement(Builder builder) {
      this.then = builder.then;
      this.otherwiseIf = builder.otherwiseIfBuilder.build();
      this.otherwise = builder.otherwise;
    }

    private IfStatement(
        IfStatement copiedInstance, 
        Trees.ConditionalBlock then, 
        ImmutableList<Trees.ConditionalBlock> otherwiseIf, 
        Optional<Trees.Block> otherwise) {
      this.then = then;
      this.otherwiseIf = otherwiseIf;
      this.otherwise = otherwise;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.IfStatement#then()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for then, non-null
     * @return modified copy of the {@code this} object
     */
    public final IfStatement withThen(Trees.ConditionalBlock value) {
      if (this.then == value) {
        return this;
      }
      Trees.ConditionalBlock newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new IfStatement(
          this, 
          newValue, 
          this.otherwiseIf, 
          this.otherwise));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.IfStatement#otherwiseIf()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final IfStatement withOtherwiseIf(Trees.ConditionalBlock... elements) {
      ImmutableList<Trees.ConditionalBlock> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new IfStatement(
          this, 
          this.then, 
          newValue, 
          this.otherwise));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.IfStatement#otherwiseIf()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of otherwiseIf elements to set
     * @return modified copy of {@code this} object
     */
    public final IfStatement withOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
      if (this.otherwiseIf == elements) {
        return this;
      }
      ImmutableList<Trees.ConditionalBlock> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new IfStatement(
          this, 
          this.then, 
          newValue, 
          this.otherwise));
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.IfStatement#otherwise()}.
     * @param value value for otherwise, non-null
     * @return modified copy of {@code this} object
     */
    public final IfStatement withOtherwise(Trees.Block value) {
      Optional<Trees.Block> newValue = Optional.of(value);
      return checkPreconditions(new IfStatement(
          this, 
          this.then, 
          this.otherwiseIf, 
          newValue));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.IfStatement#otherwise()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for otherwise, non-null
     * @return modified copy of {@code this} object
     */
    public final IfStatement withOtherwise(Optional<Trees.Block> optional) {
      if (this.otherwise == optional) {
        return this;
      }
      Optional<Trees.Block> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new IfStatement(
          this, 
          this.then, 
          this.otherwiseIf, 
          newValue));
    }
    @Override
    public Trees.ConditionalBlock then() {
      return then;
    }
    @Override
    public ImmutableList<Trees.ConditionalBlock> otherwiseIf() {
      return otherwiseIf;
    }
    @Override
    public Optional<Trees.Block> otherwise() {
      return otherwise;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof IfStatement && equalTo((IfStatement) another));
    }

    private boolean equalTo(IfStatement another) {
      return then.equals(another.then)
          && otherwiseIf.equals(another.otherwiseIf)
          && otherwise.equals(another.otherwise);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + then.hashCode();
      h = h * 17 + otherwiseIf.hashCode();
      h = h * 17 + otherwise.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IfStatement")
          .add("then", then)
          .add("otherwiseIf", otherwiseIf)
          .add("otherwise", otherwise.orNull())
          .toString();
    }

    /**
     * Creates builder for {@link Trees.IfStatement}.
     * @return new Trees.IfStatement builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.IfStatement}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_THEN = 0x1L;

      private boolean thenIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_THEN) != 0;
      }
      @Nullable
      private Trees.ConditionalBlock then;
      private ImmutableList.Builder<Trees.ConditionalBlock> otherwiseIfBuilder =
          ImmutableList.builder();
      private Optional<Trees.Block> otherwise = Optional.absent();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("IfStatement.Builder")
            .omitNullValues()
            .add("then", then)
            .add("otherwiseIf", otherwiseIfBuilder.build())
            .add("otherwise", otherwise.orNull())
            .toString();
      }

      /**
       * Initializes value for {@link Trees.IfStatement#then()}.
       * @param then value for then, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder then(Trees.ConditionalBlock then) {
        this.then = Preconditions.checkNotNull(then);
        initializedBitset0 |= INITIALIZED_BIT_THEN;
        return this;
      }

      /**
       * Adds one element to {@link Trees.IfStatement#otherwiseIf()} list.
       * @param element single otherwiseIf element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addOtherwiseIf(Trees.ConditionalBlock element) {
        otherwiseIfBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.IfStatement#otherwiseIf()} list.
       * @param elements array of otherwiseIf elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addOtherwiseIf(Trees.ConditionalBlock... elements) {
        otherwiseIfBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.IfStatement#otherwiseIf()} list.
       * @param elements iterable of otherwiseIf elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
        otherwiseIfBuilder.addAll(elements);
        return this;
      }

      /**
       * Initializes present value for optional {@link Trees.IfStatement#otherwise()}.
       * @param otherwise value for otherwise, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder otherwise(Trees.Block otherwise) {
        this.otherwise(Optional.of(otherwise));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.IfStatement#otherwise()}.
       * @param otherwise value for otherwise, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder otherwise(Optional<Trees.Block> otherwise) {
        this.otherwise = Preconditions.checkNotNull(otherwise);
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.IfStatement, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!thenIsSet() ? "then" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.IfStatement}.
       * @return immutable instance of Trees.IfStatement
       */
      public IfStatement build() {
        checkRequiredAttributes();
        return checkPreconditions(new IfStatement(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForStatement}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ForStatement"})
  @Immutable
  public static final class ForStatement
      implements Trees.ForStatement {

    private static ForStatement checkPreconditions(ForStatement instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ForStatement. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ForStatement copyOf(Trees.ForStatement instance) {
      if (instance instanceof ForStatement) {
        return (ForStatement) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllDeclaration(instance.declaration())
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ForStatement copyOf(ForStatement instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.GeneratorDeclaration> declaration;
    private final ImmutableList<Trees.TemplatePart> parts;

    private ForStatement(Builder builder) {
      this.declaration = builder.declarationBuilder.build();
      this.parts = builder.partsBuilder.build();
    }

    private ForStatement(
        ForStatement copiedInstance, 
        ImmutableList<Trees.GeneratorDeclaration> declaration, 
        ImmutableList<Trees.TemplatePart> parts) {
      this.declaration = declaration;
      this.parts = parts;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForStatement#declaration()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final ForStatement withDeclaration(Trees.GeneratorDeclaration... elements) {
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new ForStatement(
          this, 
          newValue, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForStatement#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of declaration elements to set
     * @return modified copy of {@code this} object
     */
    public final ForStatement withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
      if (this.declaration == elements) {
        return this;
      }
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new ForStatement(
          this, 
          newValue, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForStatement#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final ForStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new ForStatement(
          this, 
          this.declaration, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForStatement#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final ForStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new ForStatement(
          this, 
          this.declaration, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.GeneratorDeclaration> declaration() {
      return declaration;
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ForStatement && equalTo((ForStatement) another));
    }

    private boolean equalTo(ForStatement another) {
      return declaration.equals(another.declaration)
          && parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + declaration.hashCode();
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ForStatement")
          .add("declaration", declaration)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.ForStatement}.
     * @return new Trees.ForStatement builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ForStatement}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.GeneratorDeclaration> declarationBuilder =
          ImmutableList.builder();
      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ForStatement.Builder")
            .omitNullValues()
            .add("declaration", declarationBuilder.build())
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.ForStatement#declaration()} list.
       * @param element single declaration element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
        declarationBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ForStatement#declaration()} list.
       * @param elements array of declaration elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration... elements) {
        declarationBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.ForStatement#declaration()} list.
       * @param elements iterable of declaration elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        declarationBuilder.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.ForStatement#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ForStatement#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.ForStatement#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.ForStatement}.
       * @return immutable instance of Trees.ForStatement
       */
      public ForStatement build() {
        return checkPreconditions(new ForStatement(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForIterationAccessExpression}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ForIterationAccessExpression"})
  @Immutable
  public static final class ForIterationAccessExpression
      implements Trees.ForIterationAccessExpression {

    /**
     * Constructs new immutable instance of Trees.ForIterationAccessExpression.
     * @param access value for {@code access}
     * @return immutable Trees.ForIterationAccessExpression instance
     */
    public static ForIterationAccessExpression of(Trees.AccessExpression access) {
      return checkPreconditions(new ForIterationAccessExpression(access));
    }

    private static ForIterationAccessExpression checkPreconditions(ForIterationAccessExpression instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ForIterationAccessExpression. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ForIterationAccessExpression copyOf(Trees.ForIterationAccessExpression instance) {
      if (instance instanceof ForIterationAccessExpression) {
        return (ForIterationAccessExpression) instance;
      }
      return of(instance.access())
          .withPath(instance.path());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ForIterationAccessExpression copyOf(ForIterationAccessExpression instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.AccessExpression access;
    private final ImmutableList<Trees.Identifier> path;

    private ForIterationAccessExpression(
        Trees.AccessExpression access) {
      this.access = Preconditions.checkNotNull(access);
      this.path = ImmutableList.of();
    }

    private ForIterationAccessExpression(
        ForIterationAccessExpression copiedInstance, 
        Trees.AccessExpression access, 
        ImmutableList<Trees.Identifier> path) {
      this.access = access;
      this.path = path;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.ForIterationAccessExpression#access()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for access, non-null
     * @return modified copy of the {@code this} object
     */
    public final ForIterationAccessExpression withAccess(Trees.AccessExpression value) {
      if (this.access == value) {
        return this;
      }
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new ForIterationAccessExpression(
          this, 
          newValue, 
          this.path));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForIterationAccessExpression#path()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final ForIterationAccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new ForIterationAccessExpression(
          this, 
          this.access, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ForIterationAccessExpression#path()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of path elements to set
     * @return modified copy of {@code this} object
     */
    public final ForIterationAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) {
        return this;
      }
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new ForIterationAccessExpression(
          this, 
          this.access, 
          newValue));
    }
    @Override
    public Trees.AccessExpression access() {
      return access;
    }
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ForIterationAccessExpression && equalTo((ForIterationAccessExpression) another));
    }

    private boolean equalTo(ForIterationAccessExpression another) {
      return access.equals(another.access)
          && path.equals(another.path);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + access.hashCode();
      h = h * 17 + path.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ForIterationAccessExpression")
          .add("access", access)
          .add("path", path)
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.LetStatement}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.LetStatement"})
  @Immutable
  public static final class LetStatement
      implements Trees.LetStatement {

    private static LetStatement checkPreconditions(LetStatement instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.LetStatement. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static LetStatement copyOf(Trees.LetStatement instance) {
      if (instance instanceof LetStatement) {
        return (LetStatement) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParts(instance.parts())
          .declaration(instance.declaration())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static LetStatement copyOf(LetStatement instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.TemplatePart> parts;
    private final Trees.InvokableDeclaration declaration;

    private LetStatement(Builder builder) {
      this.parts = builder.partsBuilder.build();
      this.declaration = builder.declaration;
    }

    private LetStatement(
        LetStatement copiedInstance, 
        ImmutableList<Trees.TemplatePart> parts, 
        Trees.InvokableDeclaration declaration) {
      this.parts = parts;
      this.declaration = declaration;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.LetStatement#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final LetStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new LetStatement(
          this, 
          newValue, 
          this.declaration));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.LetStatement#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final LetStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new LetStatement(
          this, 
          newValue, 
          this.declaration));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.LetStatement#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final LetStatement withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new LetStatement(
          this, 
          this.parts, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof LetStatement && equalTo((LetStatement) another));
    }

    private boolean equalTo(LetStatement another) {
      return parts.equals(another.parts)
          && declaration.equals(another.declaration);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parts.hashCode();
      h = h * 17 + declaration.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("LetStatement")
          .add("parts", parts)
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.LetStatement}.
     * @return new Trees.LetStatement builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.LetStatement}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_DECLARATION = 0x1L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();
      @Nullable
      private Trees.InvokableDeclaration declaration;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("LetStatement.Builder")
            .omitNullValues()
            .add("parts", partsBuilder.build())
            .add("declaration", declaration)
            .toString();
      }

      /**
       * Adds one element to {@link Trees.LetStatement#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.LetStatement#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.LetStatement#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Initializes value for {@link Trees.LetStatement#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.LetStatement, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.LetStatement}.
       * @return immutable instance of Trees.LetStatement
       */
      public LetStatement build() {
        checkRequiredAttributes();
        return checkPreconditions(new LetStatement(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeStatement}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.InvokeStatement"})
  @Immutable
  public static final class InvokeStatement
      implements Trees.InvokeStatement {

    private static InvokeStatement checkPreconditions(InvokeStatement instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.InvokeStatement. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static InvokeStatement copyOf(Trees.InvokeStatement instance) {
      if (instance instanceof InvokeStatement) {
        return (InvokeStatement) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .access(instance.access())
          .addAllParams(instance.params())
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static InvokeStatement copyOf(InvokeStatement instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Expression access;
    private final ImmutableList<Trees.Expression> params;
    private final ImmutableList<Trees.TemplatePart> parts;

    private InvokeStatement(Builder builder) {
      this.access = builder.access;
      this.params = builder.paramsBuilder.build();
      this.parts = builder.partsBuilder.build();
    }

    private InvokeStatement(
        InvokeStatement copiedInstance, 
        Trees.Expression access, 
        ImmutableList<Trees.Expression> params, 
        ImmutableList<Trees.TemplatePart> parts) {
      this.access = access;
      this.params = params;
      this.parts = parts;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.InvokeStatement#access()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for access, non-null
     * @return modified copy of the {@code this} object
     */
    public final InvokeStatement withAccess(Trees.Expression value) {
      if (this.access == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new InvokeStatement(
          this, 
          newValue, 
          this.params, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokeStatement#params()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokeStatement withParams(Trees.Expression... elements) {
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new InvokeStatement(
          this, 
          this.access, 
          newValue, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokeStatement#params()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of params elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokeStatement withParams(Iterable<? extends Trees.Expression> elements) {
      if (this.params == elements) {
        return this;
      }
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new InvokeStatement(
          this, 
          this.access, 
          newValue, 
          this.parts));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokeStatement#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokeStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new InvokeStatement(
          this, 
          this.access, 
          this.params, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.InvokeStatement#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final InvokeStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new InvokeStatement(
          this, 
          this.access, 
          this.params, 
          newValue));
    }
    @Override
    public Trees.Expression access() {
      return access;
    }
    @Override
    public ImmutableList<Trees.Expression> params() {
      return params;
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof InvokeStatement && equalTo((InvokeStatement) another));
    }

    private boolean equalTo(InvokeStatement another) {
      return access.equals(another.access)
          && params.equals(another.params)
          && parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + access.hashCode();
      h = h * 17 + params.hashCode();
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeStatement")
          .add("access", access)
          .add("params", params)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.InvokeStatement}.
     * @return new Trees.InvokeStatement builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.InvokeStatement}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_ACCESS = 0x1L;

      private boolean accessIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_ACCESS) != 0;
      }
      @Nullable
      private Trees.Expression access;
      private ImmutableList.Builder<Trees.Expression> paramsBuilder =
          ImmutableList.builder();
      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("InvokeStatement.Builder")
            .omitNullValues()
            .add("access", access)
            .add("params", paramsBuilder.build())
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Initializes value for {@link Trees.InvokeStatement#access()}.
       * @param access value for access, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder access(Trees.Expression access) {
        this.access = Preconditions.checkNotNull(access);
        initializedBitset0 |= INITIALIZED_BIT_ACCESS;
        return this;
      }

      /**
       * Adds one element to {@link Trees.InvokeStatement#params()} list.
       * @param element single params element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParams(Trees.Expression element) {
        paramsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#params()} list.
       * @param elements array of params elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParams(Trees.Expression... elements) {
        paramsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.InvokeStatement#params()} list.
       * @param elements iterable of params elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
        paramsBuilder.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.InvokeStatement#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.InvokeStatement#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.InvokeStatement, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!accessIsSet() ? "access" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.InvokeStatement}.
       * @return immutable instance of Trees.InvokeStatement
       */
      public InvokeStatement build() {
        checkRequiredAttributes();
        return checkPreconditions(new InvokeStatement(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.LetEnd}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.LetEnd"})
  @Immutable
  public static final class LetEnd
      implements Trees.LetEnd {

    private static LetEnd checkPreconditions(LetEnd instance) {
      return instance;
    }

    private static final LetEnd INSTANCE = checkPreconditions(new LetEnd());

    /**
     * Returns default immutable singleton value of LetEnd
     * @return immutable instance of Trees.LetEnd
     */
    public static LetEnd of() {
      return INSTANCE;
    }

    private LetEnd() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof LetEnd && equalTo((LetEnd) another));
    }

    private boolean equalTo(LetEnd another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.LetEnd".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("LetEnd")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForEnd}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ForEnd"})
  @Immutable
  public static final class ForEnd
      implements Trees.ForEnd {

    private static ForEnd checkPreconditions(ForEnd instance) {
      return instance;
    }

    private static final ForEnd INSTANCE = checkPreconditions(new ForEnd());

    /**
     * Returns default immutable singleton value of ForEnd
     * @return immutable instance of Trees.ForEnd
     */
    public static ForEnd of() {
      return INSTANCE;
    }

    private ForEnd() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ForEnd && equalTo((ForEnd) another));
    }

    private boolean equalTo(ForEnd another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.ForEnd".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ForEnd")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.IfEnd}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.IfEnd"})
  @Immutable
  public static final class IfEnd
      implements Trees.IfEnd {

    private static IfEnd checkPreconditions(IfEnd instance) {
      return instance;
    }

    private static final IfEnd INSTANCE = checkPreconditions(new IfEnd());

    /**
     * Returns default immutable singleton value of IfEnd
     * @return immutable instance of Trees.IfEnd
     */
    public static IfEnd of() {
      return INSTANCE;
    }

    private IfEnd() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof IfEnd && equalTo((IfEnd) another));
    }

    private boolean equalTo(IfEnd another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.IfEnd".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IfEnd")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeEnd}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.InvokeEnd"})
  @Immutable
  public static final class InvokeEnd
      implements Trees.InvokeEnd {

    /**
     * Constructs new immutable instance of Trees.InvokeEnd.
     * @param access value for {@code access}
     * @return immutable Trees.InvokeEnd instance
     */
    public static InvokeEnd of(Trees.AccessExpression access) {
      return checkPreconditions(new InvokeEnd(access));
    }

    private static InvokeEnd checkPreconditions(InvokeEnd instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.InvokeEnd. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static InvokeEnd copyOf(Trees.InvokeEnd instance) {
      if (instance instanceof InvokeEnd) {
        return (InvokeEnd) instance;
      }
      return of(instance.access());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static InvokeEnd copyOf(InvokeEnd instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.AccessExpression access;

    private InvokeEnd(
        Trees.AccessExpression access) {
      this.access = Preconditions.checkNotNull(access);
    }

    private InvokeEnd(
        InvokeEnd copiedInstance, 
        Trees.AccessExpression access) {
      this.access = access;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.InvokeEnd#access()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for access, non-null
     * @return modified copy of the {@code this} object
     */
    public final InvokeEnd withAccess(Trees.AccessExpression value) {
      if (this.access == value) {
        return this;
      }
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new InvokeEnd(
          this, 
          newValue));
    }
    @Override
    public Trees.AccessExpression access() {
      return access;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof InvokeEnd && equalTo((InvokeEnd) another));
    }

    private boolean equalTo(InvokeEnd another) {
      return access.equals(another.access);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + access.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeEnd")
          .add("access", access)
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeString}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.InvokeString"})
  @Immutable
  public static final class InvokeString
      implements Trees.InvokeString {

    /**
     * Constructs new immutable instance of Trees.InvokeString.
     * @param literal value for {@code literal}
     * @return immutable Trees.InvokeString instance
     */
    public static InvokeString of(Trees.StringLiteral literal) {
      return checkPreconditions(new InvokeString(literal));
    }

    private static InvokeString checkPreconditions(InvokeString instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.InvokeString. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static InvokeString copyOf(Trees.InvokeString instance) {
      if (instance instanceof InvokeString) {
        return (InvokeString) instance;
      }
      return of(instance.literal());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static InvokeString copyOf(InvokeString instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.StringLiteral literal;

    private InvokeString(
        Trees.StringLiteral literal) {
      this.literal = Preconditions.checkNotNull(literal);
    }

    private InvokeString(
        InvokeString copiedInstance, 
        Trees.StringLiteral literal) {
      this.literal = literal;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.InvokeString#literal()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for literal, non-null
     * @return modified copy of the {@code this} object
     */
    public final InvokeString withLiteral(Trees.StringLiteral value) {
      if (this.literal == value) {
        return this;
      }
      Trees.StringLiteral newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new InvokeString(
          this, 
          newValue));
    }
    @Override
    public Trees.StringLiteral literal() {
      return literal;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof InvokeString && equalTo((InvokeString) another));
    }

    private boolean equalTo(InvokeString another) {
      return literal.equals(another.literal);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + literal.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeString")
          .add("literal", literal)
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.Invoke}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Invoke"})
  @Immutable
  public static final class Invoke
      implements Trees.Invoke {

    private static Invoke checkPreconditions(Invoke instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Invoke. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Invoke copyOf(Trees.Invoke instance) {
      if (instance instanceof Invoke) {
        return (Invoke) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .access(instance.access())
          .invoke(instance.invoke())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Invoke copyOf(Invoke instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.AccessExpression access;
    private final Optional<Trees.ApplyExpression> invoke;

    private Invoke(Builder builder) {
      this.access = builder.access;
      this.invoke = builder.invoke;
    }

    private Invoke(
        Invoke copiedInstance, 
        Trees.AccessExpression access, 
        Optional<Trees.ApplyExpression> invoke) {
      this.access = access;
      this.invoke = invoke;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Invoke#access()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for access, non-null
     * @return modified copy of the {@code this} object
     */
    public final Invoke withAccess(Trees.AccessExpression value) {
      if (this.access == value) {
        return this;
      }
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Invoke(
          this, 
          newValue, 
          this.invoke));
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.Invoke#invoke()}.
     * @param value value for invoke, non-null
     * @return modified copy of {@code this} object
     */
    public final Invoke withInvoke(Trees.ApplyExpression value) {
      Optional<Trees.ApplyExpression> newValue = Optional.of(value);
      return checkPreconditions(new Invoke(
          this, 
          this.access, 
          newValue));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.Invoke#invoke()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for invoke, non-null
     * @return modified copy of {@code this} object
     */
    public final Invoke withInvoke(Optional<Trees.ApplyExpression> optional) {
      if (this.invoke == optional) {
        return this;
      }
      Optional<Trees.ApplyExpression> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new Invoke(
          this, 
          this.access, 
          newValue));
    }
    @Override
    public Trees.AccessExpression access() {
      return access;
    }
    @Override
    public Optional<Trees.ApplyExpression> invoke() {
      return invoke;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Invoke && equalTo((Invoke) another));
    }

    private boolean equalTo(Invoke another) {
      return access.equals(another.access)
          && invoke.equals(another.invoke);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + access.hashCode();
      h = h * 17 + invoke.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Invoke")
          .add("access", access)
          .add("invoke", invoke.orNull())
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Invoke}.
     * @return new Trees.Invoke builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Invoke}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_ACCESS = 0x1L;

      private boolean accessIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_ACCESS) != 0;
      }
      @Nullable
      private Trees.AccessExpression access;
      private Optional<Trees.ApplyExpression> invoke = Optional.absent();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Invoke.Builder")
            .omitNullValues()
            .add("access", access)
            .add("invoke", invoke.orNull())
            .toString();
      }

      /**
       * Initializes value for {@link Trees.Invoke#access()}.
       * @param access value for access, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder access(Trees.AccessExpression access) {
        this.access = Preconditions.checkNotNull(access);
        initializedBitset0 |= INITIALIZED_BIT_ACCESS;
        return this;
      }

      /**
       * Initializes present value for optional {@link Trees.Invoke#invoke()}.
       * @param invoke value for invoke, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder invoke(Trees.ApplyExpression invoke) {
        this.invoke(Optional.of(invoke));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.Invoke#invoke()}.
       * @param invoke value for invoke, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder invoke(Optional<Trees.ApplyExpression> invoke) {
        this.invoke = Preconditions.checkNotNull(invoke);
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.Invoke, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!accessIsSet() ? "access" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.Invoke}.
       * @return immutable instance of Trees.Invoke
       */
      public Invoke build() {
        checkRequiredAttributes();
        return checkPreconditions(new Invoke(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Let}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Let"})
  @Immutable
  public static final class Let
      implements Trees.Let {

    private static Let checkPreconditions(Let instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Let. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Let copyOf(Trees.Let instance) {
      if (instance instanceof Let) {
        return (Let) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .declaration(instance.declaration())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Let copyOf(Let instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.InvokableDeclaration declaration;

    private Let(Builder builder) {
      this.declaration = builder.declaration;
    }

    private Let(
        Let copiedInstance, 
        Trees.InvokableDeclaration declaration) {
      this.declaration = declaration;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Let#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final Let withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Let(
          this, 
          newValue));
    }
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Let && equalTo((Let) another));
    }

    private boolean equalTo(Let another) {
      return declaration.equals(another.declaration);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + declaration.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Let")
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Let}.
     * @return new Trees.Let builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Let}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_DECLARATION = 0x1L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      @Nullable
      private Trees.InvokableDeclaration declaration;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Let.Builder")
            .omitNullValues()
            .add("declaration", declaration)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.Let#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.Let, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.Let}.
       * @return immutable instance of Trees.Let
       */
      public Let build() {
        checkRequiredAttributes();
        return checkPreconditions(new Let(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Unit}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Unit"})
  @Immutable
  public static final class Unit
      implements Trees.Unit {

    private static Unit checkPreconditions(Unit instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Unit. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Unit copyOf(Trees.Unit instance) {
      if (instance instanceof Unit) {
        return (Unit) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Unit copyOf(Unit instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.UnitPart> parts;

    private Unit(Builder builder) {
      this.parts = builder.partsBuilder.build();
    }

    private Unit(
        Unit copiedInstance, 
        ImmutableList<Trees.UnitPart> parts) {
      this.parts = parts;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Unit#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final Unit withParts(Trees.UnitPart... elements) {
      ImmutableList<Trees.UnitPart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new Unit(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Unit#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final Unit withParts(Iterable<? extends Trees.UnitPart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.UnitPart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new Unit(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.UnitPart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Unit && equalTo((Unit) another));
    }

    private boolean equalTo(Unit another) {
      return parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Unit")
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Unit}.
     * @return new Trees.Unit builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Unit}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.UnitPart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Unit.Builder")
            .omitNullValues()
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.Unit#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.UnitPart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.Unit#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.UnitPart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.Unit#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.UnitPart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.Unit}.
       * @return immutable instance of Trees.Unit
       */
      public Unit build() {
        return checkPreconditions(new Unit(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Template}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Template"})
  @Immutable
  public static final class Template
      implements Trees.Template {

    private static Template checkPreconditions(Template instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.Template. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static Template copyOf(Trees.Template instance) {
      if (instance instanceof Template) {
        return (Template) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParts(instance.parts())
          .declaration(instance.declaration())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static Template copyOf(Template instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.TemplatePart> parts;
    private final Trees.InvokableDeclaration declaration;

    private Template(Builder builder) {
      this.parts = builder.partsBuilder.build();
      this.declaration = builder.declaration;
    }

    private Template(
        Template copiedInstance, 
        ImmutableList<Trees.TemplatePart> parts, 
        Trees.InvokableDeclaration declaration) {
      this.parts = parts;
      this.declaration = declaration;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Template#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final Template withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new Template(
          this, 
          newValue, 
          this.declaration));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.Template#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final Template withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new Template(
          this, 
          newValue, 
          this.declaration));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.Template#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final Template withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new Template(
          this, 
          this.parts, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Template && equalTo((Template) another));
    }

    private boolean equalTo(Template another) {
      return parts.equals(another.parts)
          && declaration.equals(another.declaration);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parts.hashCode();
      h = h * 17 + declaration.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Template")
          .add("parts", parts)
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.Template}.
     * @return new Trees.Template builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.Template}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_DECLARATION = 0x1L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      private ImmutableList.Builder<Trees.TemplatePart> partsBuilder =
          ImmutableList.builder();
      @Nullable
      private Trees.InvokableDeclaration declaration;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("Template.Builder")
            .omitNullValues()
            .add("parts", partsBuilder.build())
            .add("declaration", declaration)
            .toString();
      }

      /**
       * Adds one element to {@link Trees.Template#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.Template#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.Template#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Initializes value for {@link Trees.Template#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.Template, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.Template}.
       * @return immutable instance of Trees.Template
       */
      public Template build() {
        checkRequiredAttributes();
        return checkPreconditions(new Template(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.AccessExpression}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.AccessExpression"})
  @Immutable
  public static final class AccessExpression
      implements Trees.AccessExpression {

    private static AccessExpression checkPreconditions(AccessExpression instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.AccessExpression. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static AccessExpression copyOf(Trees.AccessExpression instance) {
      if (instance instanceof AccessExpression) {
        return (AccessExpression) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllPath(instance.path())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static AccessExpression copyOf(AccessExpression instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.Identifier> path;

    private AccessExpression(Builder builder) {
      this.path = builder.pathBuilder.build();
    }

    private AccessExpression(
        AccessExpression copiedInstance, 
        ImmutableList<Trees.Identifier> path) {
      this.path = path;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.AccessExpression#path()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final AccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new AccessExpression(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.AccessExpression#path()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of path elements to set
     * @return modified copy of {@code this} object
     */
    public final AccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) {
        return this;
      }
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new AccessExpression(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof AccessExpression && equalTo((AccessExpression) another));
    }

    private boolean equalTo(AccessExpression another) {
      return path.equals(another.path);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + path.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("AccessExpression")
          .add("path", path)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.AccessExpression}.
     * @return new Trees.AccessExpression builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.AccessExpression}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.Identifier> pathBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("AccessExpression.Builder")
            .omitNullValues()
            .add("path", pathBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.AccessExpression#path()} list.
       * @param element single path element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addPath(Trees.Identifier element) {
        pathBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.AccessExpression#path()} list.
       * @param elements array of path elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addPath(Trees.Identifier... elements) {
        pathBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.AccessExpression#path()} list.
       * @param elements iterable of path elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
        pathBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.AccessExpression}.
       * @return immutable instance of Trees.AccessExpression
       */
      public AccessExpression build() {
        return checkPreconditions(new AccessExpression(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ApplyExpression}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ApplyExpression"})
  @Immutable
  public static final class ApplyExpression
      implements Trees.ApplyExpression {

    private static ApplyExpression checkPreconditions(ApplyExpression instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ApplyExpression. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ApplyExpression copyOf(Trees.ApplyExpression instance) {
      if (instance instanceof ApplyExpression) {
        return (ApplyExpression) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParams(instance.params())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ApplyExpression copyOf(ApplyExpression instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.Expression> params;

    private ApplyExpression(Builder builder) {
      this.params = builder.paramsBuilder.build();
    }

    private ApplyExpression(
        ApplyExpression copiedInstance, 
        ImmutableList<Trees.Expression> params) {
      this.params = params;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ApplyExpression#params()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final ApplyExpression withParams(Trees.Expression... elements) {
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new ApplyExpression(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.ApplyExpression#params()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of params elements to set
     * @return modified copy of {@code this} object
     */
    public final ApplyExpression withParams(Iterable<? extends Trees.Expression> elements) {
      if (this.params == elements) {
        return this;
      }
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new ApplyExpression(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.Expression> params() {
      return params;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ApplyExpression && equalTo((ApplyExpression) another));
    }

    private boolean equalTo(ApplyExpression another) {
      return params.equals(another.params);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + params.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ApplyExpression")
          .add("params", params)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.ApplyExpression}.
     * @return new Trees.ApplyExpression builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ApplyExpression}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.Expression> paramsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ApplyExpression.Builder")
            .omitNullValues()
            .add("params", paramsBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.ApplyExpression#params()} list.
       * @param element single params element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParams(Trees.Expression element) {
        paramsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ApplyExpression#params()} list.
       * @param elements array of params elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParams(Trees.Expression... elements) {
        paramsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.ApplyExpression#params()} list.
       * @param elements iterable of params elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
        paramsBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.ApplyExpression}.
       * @return immutable instance of Trees.ApplyExpression
       */
      public ApplyExpression build() {
        return checkPreconditions(new ApplyExpression(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.AssignGenerator}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.AssignGenerator"})
  @Immutable
  public static final class AssignGenerator
      implements Trees.AssignGenerator {

    private static AssignGenerator checkPreconditions(AssignGenerator instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.AssignGenerator. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static AssignGenerator copyOf(Trees.AssignGenerator instance) {
      if (instance instanceof AssignGenerator) {
        return (AssignGenerator) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static AssignGenerator copyOf(AssignGenerator instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private AssignGenerator(Builder builder) {
      this.declaration = builder.declaration;
      this.from = builder.from;
    }

    private AssignGenerator(
        AssignGenerator copiedInstance, 
        Trees.ValueDeclaration declaration, 
        Trees.Expression from) {
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.AssignGenerator#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final AssignGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new AssignGenerator(
          this, 
          newValue, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.AssignGenerator#from()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for from, non-null
     * @return modified copy of the {@code this} object
     */
    public final AssignGenerator withFrom(Trees.Expression value) {
      if (this.from == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new AssignGenerator(
          this, 
          this.declaration, 
          newValue));
    }
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }
    @Override
    public Trees.Expression from() {
      return from;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof AssignGenerator && equalTo((AssignGenerator) another));
    }

    private boolean equalTo(AssignGenerator another) {
      return declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + declaration.hashCode();
      h = h * 17 + from.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("AssignGenerator")
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.AssignGenerator}.
     * @return new Trees.AssignGenerator builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.AssignGenerator}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x3;
      private static final long INITIALIZED_BIT_DECLARATION = 0x1L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      private static final long INITIALIZED_BIT_FROM = 0x2L;

      private boolean fromIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_FROM) != 0;
      }
      @Nullable
      private Trees.ValueDeclaration declaration;
      @Nullable
      private Trees.Expression from;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("AssignGenerator.Builder")
            .omitNullValues()
            .add("declaration", declaration)
            .add("from", from)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.AssignGenerator#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes value for {@link Trees.AssignGenerator#from()}.
       * @param from value for from, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from);
        initializedBitset0 |= INITIALIZED_BIT_FROM;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.AssignGenerator, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .addValue(!fromIsSet() ? "from" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.AssignGenerator}.
       * @return immutable instance of Trees.AssignGenerator
       */
      public AssignGenerator build() {
        checkRequiredAttributes();
        return checkPreconditions(new AssignGenerator(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.IterationGenerator}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.IterationGenerator"})
  @Immutable
  public static final class IterationGenerator
      implements Trees.IterationGenerator {

    private static IterationGenerator checkPreconditions(IterationGenerator instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.IterationGenerator. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static IterationGenerator copyOf(Trees.IterationGenerator instance) {
      if (instance instanceof IterationGenerator) {
        return (IterationGenerator) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .condition(instance.condition())
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static IterationGenerator copyOf(IterationGenerator instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Optional<Trees.Expression> condition;
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private IterationGenerator(Builder builder) {
      this.condition = builder.condition;
      this.declaration = builder.declaration;
      this.from = builder.from;
    }

    private IterationGenerator(
        IterationGenerator copiedInstance, 
        Optional<Trees.Expression> condition, 
        Trees.ValueDeclaration declaration, 
        Trees.Expression from) {
      this.condition = condition;
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.IterationGenerator#condition()}.
     * @param value value for condition, non-null
     * @return modified copy of {@code this} object
     */
    public final IterationGenerator withCondition(Trees.Expression value) {
      Optional<Trees.Expression> newValue = Optional.of(value);
      return checkPreconditions(new IterationGenerator(
          this, 
          newValue, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.IterationGenerator#condition()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for condition, non-null
     * @return modified copy of {@code this} object
     */
    public final IterationGenerator withCondition(Optional<Trees.Expression> optional) {
      if (this.condition == optional) {
        return this;
      }
      Optional<Trees.Expression> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new IterationGenerator(
          this, 
          newValue, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.IterationGenerator#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final IterationGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new IterationGenerator(
          this, 
          this.condition, 
          newValue, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.IterationGenerator#from()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for from, non-null
     * @return modified copy of the {@code this} object
     */
    public final IterationGenerator withFrom(Trees.Expression value) {
      if (this.from == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new IterationGenerator(
          this, 
          this.condition, 
          this.declaration, 
          newValue));
    }
    @Override
    public Optional<Trees.Expression> condition() {
      return condition;
    }
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }
    @Override
    public Trees.Expression from() {
      return from;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof IterationGenerator && equalTo((IterationGenerator) another));
    }

    private boolean equalTo(IterationGenerator another) {
      return condition.equals(another.condition)
          && declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + condition.hashCode();
      h = h * 17 + declaration.hashCode();
      h = h * 17 + from.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IterationGenerator")
          .add("condition", condition.orNull())
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.IterationGenerator}.
     * @return new Trees.IterationGenerator builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.IterationGenerator}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x3;
      private static final long INITIALIZED_BIT_DECLARATION = 0x1L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      private static final long INITIALIZED_BIT_FROM = 0x2L;

      private boolean fromIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_FROM) != 0;
      }
      private Optional<Trees.Expression> condition = Optional.absent();
      @Nullable
      private Trees.ValueDeclaration declaration;
      @Nullable
      private Trees.Expression from;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("IterationGenerator.Builder")
            .omitNullValues()
            .add("condition", condition.orNull())
            .add("declaration", declaration)
            .add("from", from)
            .toString();
      }

      /**
       * Initializes present value for optional {@link Trees.IterationGenerator#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition(Optional.of(condition));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.IterationGenerator#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Optional<Trees.Expression> condition) {
        this.condition = Preconditions.checkNotNull(condition);
        return this;
      }

      /**
       * Initializes value for {@link Trees.IterationGenerator#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes value for {@link Trees.IterationGenerator#from()}.
       * @param from value for from, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from);
        initializedBitset0 |= INITIALIZED_BIT_FROM;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.IterationGenerator, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .addValue(!fromIsSet() ? "from" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.IterationGenerator}.
       * @return immutable instance of Trees.IterationGenerator
       */
      public IterationGenerator build() {
        checkRequiredAttributes();
        return checkPreconditions(new IterationGenerator(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TransformGenerator}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TransformGenerator"})
  @Immutable
  public static final class TransformGenerator
      implements Trees.TransformGenerator {

    private static TransformGenerator checkPreconditions(TransformGenerator instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TransformGenerator. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TransformGenerator copyOf(Trees.TransformGenerator instance) {
      if (instance instanceof TransformGenerator) {
        return (TransformGenerator) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .transform(instance.transform())
          .varDeclaration(instance.varDeclaration())
          .condition(instance.condition())
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TransformGenerator copyOf(TransformGenerator instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Expression transform;
    private final Trees.ValueDeclaration varDeclaration;
    private final Optional<Trees.Expression> condition;
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private TransformGenerator(Builder builder) {
      this.transform = builder.transform;
      this.varDeclaration = builder.varDeclaration;
      this.condition = builder.condition;
      this.declaration = builder.declaration;
      this.from = builder.from;
    }

    private TransformGenerator(
        TransformGenerator copiedInstance, 
        Trees.Expression transform, 
        Trees.ValueDeclaration varDeclaration, 
        Optional<Trees.Expression> condition, 
        Trees.ValueDeclaration declaration, 
        Trees.Expression from) {
      this.transform = transform;
      this.varDeclaration = varDeclaration;
      this.condition = condition;
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TransformGenerator#transform()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for transform, non-null
     * @return modified copy of the {@code this} object
     */
    public final TransformGenerator withTransform(Trees.Expression value) {
      if (this.transform == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TransformGenerator(
          this, 
          newValue, 
          this.varDeclaration, 
          this.condition, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TransformGenerator#varDeclaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for varDeclaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final TransformGenerator withVarDeclaration(Trees.ValueDeclaration value) {
      if (this.varDeclaration == value) {
        return this;
      }
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TransformGenerator(
          this, 
          this.transform, 
          newValue, 
          this.condition, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting present value for optional {@link Trees.TransformGenerator#condition()}.
     * @param value value for condition, non-null
     * @return modified copy of {@code this} object
     */
    public final TransformGenerator withCondition(Trees.Expression value) {
      Optional<Trees.Expression> newValue = Optional.of(value);
      return checkPreconditions(new TransformGenerator(
          this, 
          this.transform, 
          this.varDeclaration, 
          newValue, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting optional value for {@link Trees.TransformGenerator#condition()}.
     * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional value for condition, non-null
     * @return modified copy of {@code this} object
     */
    public final TransformGenerator withCondition(Optional<Trees.Expression> optional) {
      if (this.condition == optional) {
        return this;
      }
      Optional<Trees.Expression> newValue = Preconditions.checkNotNull(optional);
      return checkPreconditions(new TransformGenerator(
          this, 
          this.transform, 
          this.varDeclaration, 
          newValue, 
          this.declaration, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TransformGenerator#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for declaration, non-null
     * @return modified copy of the {@code this} object
     */
    public final TransformGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) {
        return this;
      }
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TransformGenerator(
          this, 
          this.transform, 
          this.varDeclaration, 
          this.condition, 
          newValue, 
          this.from));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TransformGenerator#from()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for from, non-null
     * @return modified copy of the {@code this} object
     */
    public final TransformGenerator withFrom(Trees.Expression value) {
      if (this.from == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TransformGenerator(
          this, 
          this.transform, 
          this.varDeclaration, 
          this.condition, 
          this.declaration, 
          newValue));
    }
    @Override
    public Trees.Expression transform() {
      return transform;
    }
    @Override
    public Trees.ValueDeclaration varDeclaration() {
      return varDeclaration;
    }
    @Override
    public Optional<Trees.Expression> condition() {
      return condition;
    }
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }
    @Override
    public Trees.Expression from() {
      return from;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TransformGenerator && equalTo((TransformGenerator) another));
    }

    private boolean equalTo(TransformGenerator another) {
      return transform.equals(another.transform)
          && varDeclaration.equals(another.varDeclaration)
          && condition.equals(another.condition)
          && declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + transform.hashCode();
      h = h * 17 + varDeclaration.hashCode();
      h = h * 17 + condition.hashCode();
      h = h * 17 + declaration.hashCode();
      h = h * 17 + from.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TransformGenerator")
          .add("transform", transform)
          .add("varDeclaration", varDeclaration)
          .add("condition", condition.orNull())
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.TransformGenerator}.
     * @return new Trees.TransformGenerator builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.TransformGenerator}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0xf;
      private static final long INITIALIZED_BIT_TRANSFORM = 0x1L;

      private boolean transformIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_TRANSFORM) != 0;
      }
      private static final long INITIALIZED_BIT_VAR_DECLARATION = 0x2L;

      private boolean varDeclarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_VAR_DECLARATION) != 0;
      }
      private static final long INITIALIZED_BIT_DECLARATION = 0x4L;

      private boolean declarationIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_DECLARATION) != 0;
      }
      private static final long INITIALIZED_BIT_FROM = 0x8L;

      private boolean fromIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_FROM) != 0;
      }
      @Nullable
      private Trees.Expression transform;
      @Nullable
      private Trees.ValueDeclaration varDeclaration;
      private Optional<Trees.Expression> condition = Optional.absent();
      @Nullable
      private Trees.ValueDeclaration declaration;
      @Nullable
      private Trees.Expression from;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("TransformGenerator.Builder")
            .omitNullValues()
            .add("transform", transform)
            .add("varDeclaration", varDeclaration)
            .add("condition", condition.orNull())
            .add("declaration", declaration)
            .add("from", from)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.TransformGenerator#transform()}.
       * @param transform value for transform, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder transform(Trees.Expression transform) {
        this.transform = Preconditions.checkNotNull(transform);
        initializedBitset0 |= INITIALIZED_BIT_TRANSFORM;
        return this;
      }

      /**
       * Initializes value for {@link Trees.TransformGenerator#varDeclaration()}.
       * @param varDeclaration value for varDeclaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder varDeclaration(Trees.ValueDeclaration varDeclaration) {
        this.varDeclaration = Preconditions.checkNotNull(varDeclaration);
        initializedBitset0 |= INITIALIZED_BIT_VAR_DECLARATION;
        return this;
      }

      /**
       * Initializes present value for optional {@link Trees.TransformGenerator#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition(Optional.of(condition));
        return this;
      }

      /**
       * Initializes optional value for {@link Trees.TransformGenerator#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Optional<Trees.Expression> condition) {
        this.condition = Preconditions.checkNotNull(condition);
        return this;
      }

      /**
       * Initializes value for {@link Trees.TransformGenerator#declaration()}.
       * @param declaration value for declaration, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration);
        initializedBitset0 |= INITIALIZED_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes value for {@link Trees.TransformGenerator#from()}.
       * @param from value for from, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from);
        initializedBitset0 |= INITIALIZED_BIT_FROM;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.TransformGenerator, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!transformIsSet() ? "transform" : null)
                  .addValue(!varDeclarationIsSet() ? "varDeclaration" : null)
                  .addValue(!declarationIsSet() ? "declaration" : null)
                  .addValue(!fromIsSet() ? "from" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.TransformGenerator}.
       * @return immutable instance of Trees.TransformGenerator
       */
      public TransformGenerator build() {
        checkRequiredAttributes();
        return checkPreconditions(new TransformGenerator(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.For}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.For"})
  @Immutable
  public static final class For
      implements Trees.For {

    private static For checkPreconditions(For instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.For. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static For copyOf(Trees.For instance) {
      if (instance instanceof For) {
        return (For) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllDeclaration(instance.declaration())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static For copyOf(For instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.GeneratorDeclaration> declaration;

    private For(Builder builder) {
      this.declaration = builder.declarationBuilder.build();
    }

    private For(
        For copiedInstance, 
        ImmutableList<Trees.GeneratorDeclaration> declaration) {
      this.declaration = declaration;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.For#declaration()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final For withDeclaration(Trees.GeneratorDeclaration... elements) {
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new For(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.For#declaration()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of declaration elements to set
     * @return modified copy of {@code this} object
     */
    public final For withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
      if (this.declaration == elements) {
        return this;
      }
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new For(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.GeneratorDeclaration> declaration() {
      return declaration;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof For && equalTo((For) another));
    }

    private boolean equalTo(For another) {
      return declaration.equals(another.declaration);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + declaration.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("For")
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.For}.
     * @return new Trees.For builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.For}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.GeneratorDeclaration> declarationBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("For.Builder")
            .omitNullValues()
            .add("declaration", declarationBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.For#declaration()} list.
       * @param element single declaration element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
        declarationBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.For#declaration()} list.
       * @param elements array of declaration elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration... elements) {
        declarationBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.For#declaration()} list.
       * @param elements iterable of declaration elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        declarationBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.For}.
       * @return immutable instance of Trees.For
       */
      public For build() {
        return checkPreconditions(new For(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.If}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.If"})
  @Immutable
  public static final class If
      implements Trees.If {

    private static If checkPreconditions(If instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.If. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static If copyOf(Trees.If instance) {
      if (instance instanceof If) {
        return (If) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .condition(instance.condition())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static If copyOf(If instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Expression condition;

    private If(Builder builder) {
      this.condition = builder.condition;
    }

    private If(
        If copiedInstance, 
        Trees.Expression condition) {
      this.condition = condition;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.If#condition()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for condition, non-null
     * @return modified copy of the {@code this} object
     */
    public final If withCondition(Trees.Expression value) {
      if (this.condition == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new If(
          this, 
          newValue));
    }
    @Override
    public Trees.Expression condition() {
      return condition;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof If && equalTo((If) another));
    }

    private boolean equalTo(If another) {
      return condition.equals(another.condition);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + condition.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("If")
          .add("condition", condition)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.If}.
     * @return new Trees.If builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.If}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_CONDITION = 0x1L;

      private boolean conditionIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_CONDITION) != 0;
      }
      @Nullable
      private Trees.Expression condition;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("If.Builder")
            .omitNullValues()
            .add("condition", condition)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.If#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition);
        initializedBitset0 |= INITIALIZED_BIT_CONDITION;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.If, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!conditionIsSet() ? "condition" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.If}.
       * @return immutable instance of Trees.If
       */
      public If build() {
        checkRequiredAttributes();
        return checkPreconditions(new If(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ElseIf}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.ElseIf"})
  @Immutable
  public static final class ElseIf
      implements Trees.ElseIf {

    private static ElseIf checkPreconditions(ElseIf instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.ElseIf. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static ElseIf copyOf(Trees.ElseIf instance) {
      if (instance instanceof ElseIf) {
        return (ElseIf) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .condition(instance.condition())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static ElseIf copyOf(ElseIf instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.Expression condition;

    private ElseIf(Builder builder) {
      this.condition = builder.condition;
    }

    private ElseIf(
        ElseIf copiedInstance, 
        Trees.Expression condition) {
      this.condition = condition;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.ElseIf#condition()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for condition, non-null
     * @return modified copy of the {@code this} object
     */
    public final ElseIf withCondition(Trees.Expression value) {
      if (this.condition == value) {
        return this;
      }
      Trees.Expression newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new ElseIf(
          this, 
          newValue));
    }
    @Override
    public Trees.Expression condition() {
      return condition;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof ElseIf && equalTo((ElseIf) another));
    }

    private boolean equalTo(ElseIf another) {
      return condition.equals(another.condition);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + condition.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ElseIf")
          .add("condition", condition)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.ElseIf}.
     * @return new Trees.ElseIf builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.ElseIf}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_CONDITION = 0x1L;

      private boolean conditionIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_CONDITION) != 0;
      }
      @Nullable
      private Trees.Expression condition;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("ElseIf.Builder")
            .omitNullValues()
            .add("condition", condition)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.ElseIf#condition()}.
       * @param condition value for condition, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition);
        initializedBitset0 |= INITIALIZED_BIT_CONDITION;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.ElseIf, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!conditionIsSet() ? "condition" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.ElseIf}.
       * @return immutable instance of Trees.ElseIf
       */
      public ElseIf build() {
        checkRequiredAttributes();
        return checkPreconditions(new ElseIf(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Else}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Else"})
  @Immutable
  public static final class Else
      implements Trees.Else {

    private static Else checkPreconditions(Else instance) {
      return instance;
    }

    private static final Else INSTANCE = checkPreconditions(new Else());

    /**
     * Returns default immutable singleton value of Else
     * @return immutable instance of Trees.Else
     */
    public static Else of() {
      return INSTANCE;
    }

    private Else() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Else && equalTo((Else) another));
    }

    private boolean equalTo(Else another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.Else".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Else")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.TemplateEnd}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TemplateEnd"})
  @Immutable
  public static final class TemplateEnd
      implements Trees.TemplateEnd {

    private static TemplateEnd checkPreconditions(TemplateEnd instance) {
      return instance;
    }

    private static final TemplateEnd INSTANCE = checkPreconditions(new TemplateEnd());

    /**
     * Returns default immutable singleton value of TemplateEnd
     * @return immutable instance of Trees.TemplateEnd
     */
    public static TemplateEnd of() {
      return INSTANCE;
    }

    private TemplateEnd() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TemplateEnd && equalTo((TemplateEnd) another));
    }

    private boolean equalTo(TemplateEnd another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.TemplateEnd".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TemplateEnd")
          .toString();
    }
  }

  /**
   * Immutable implementation of {@link Trees.StringLiteral}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.StringLiteral"})
  @Immutable
  public static final class StringLiteral
      extends Trees.StringLiteral {

    /**
     * Constructs new immutable instance of Trees.StringLiteral.
     * @param value value for {@code value}
     * @return immutable Trees.StringLiteral instance
     */
    public static StringLiteral of(String value) {
      return checkPreconditions(new StringLiteral(value));
    }

    private static StringLiteral checkPreconditions(StringLiteral instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.StringLiteral. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static StringLiteral copyOf(Trees.StringLiteral instance) {
      if (instance instanceof StringLiteral) {
        return (StringLiteral) instance;
      }
      return of(instance.value());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static StringLiteral copyOf(StringLiteral instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final String value;

    private StringLiteral(
        String value) {
      this.value = Preconditions.checkNotNull(value);
    }

    private StringLiteral(
        StringLiteral copiedInstance, 
        String value) {
      this.value = value;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.StringLiteral#value()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for value, non-null
     * @return modified copy of the {@code this} object
     */
    public final StringLiteral withValue(String value) {
      if (this.value == value) {
        return this;
      }
      String newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new StringLiteral(
          this, 
          newValue));
    }
    @Override
    public String value() {
      return value;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof StringLiteral && equalTo((StringLiteral) another));
    }

    private boolean equalTo(StringLiteral another) {
      return value.equals(another.value);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + value.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }
  }

  /**
   * Immutable implementation of {@link Trees.Newline}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.Newline"})
  @Immutable
  public static final class Newline
      extends Trees.Newline {

    private static Newline checkPreconditions(Newline instance) {
      return instance;
    }

    private static final Newline INSTANCE = checkPreconditions(new Newline());

    /**
     * Returns default immutable singleton value of Newline
     * @return immutable instance of Trees.Newline
     */
    public static Newline of() {
      return INSTANCE;
    }

    private Newline() {
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof Newline && equalTo((Newline) another));
    }

    private boolean equalTo(Newline another) {
      return true;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + "Trees.Newline".hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextFragment}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TextFragment"})
  @Immutable
  public static final class TextFragment
      extends Trees.TextFragment {

    /**
     * Constructs new immutable instance of Trees.TextFragment.
     * @param value value for {@code value}
     * @return immutable Trees.TextFragment instance
     */
    public static TextFragment of(String value) {
      return checkPreconditions(new TextFragment(value));
    }

    private static TextFragment checkPreconditions(TextFragment instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TextFragment. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TextFragment copyOf(Trees.TextFragment instance) {
      if (instance instanceof TextFragment) {
        return (TextFragment) instance;
      }
      return of(instance.value());
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TextFragment copyOf(TextFragment instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final String value;

    private TextFragment(
        String value) {
      this.value = Preconditions.checkNotNull(value);
    }

    private TextFragment(
        TextFragment copiedInstance, 
        String value) {
      this.value = value;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TextFragment#value()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for value, non-null
     * @return modified copy of the {@code this} object
     */
    public final TextFragment withValue(String value) {
      if (this.value == value) {
        return this;
      }
      String newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TextFragment(
          this, 
          newValue));
    }
    @Override
    public String value() {
      return value;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TextFragment && equalTo((TextFragment) another));
    }

    private boolean equalTo(TextFragment another) {
      return value.equals(another.value);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + value.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextBlock}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TextBlock"})
  @Immutable
  public static final class TextBlock
      implements Trees.TextBlock {

    private static TextBlock checkPreconditions(TextBlock instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TextBlock. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TextBlock copyOf(Trees.TextBlock instance) {
      if (instance instanceof TextBlock) {
        return (TextBlock) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .addAllParts(instance.parts())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TextBlock copyOf(TextBlock instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final ImmutableList<Trees.TextPart> parts;

    private TextBlock(Builder builder) {
      this.parts = builder.partsBuilder.build();
    }

    private TextBlock(
        TextBlock copiedInstance, 
        ImmutableList<Trees.TextPart> parts) {
      this.parts = parts;
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.TextBlock#parts()}.
     * @param elements elements to set
     * @return modified copy of {@code this} object
     */
    public final TextBlock withParts(Trees.TextPart... elements) {
      ImmutableList<Trees.TextPart> newValue = ImmutableList.copyOf(    Arrays.asList(elements));
      return checkPreconditions(new TextBlock(
          this, 
          newValue));
    }

    /**
     * Copy current immutable object with elements that replace content of {@link Trees.TextBlock#parts()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements iterable of parts elements to set
     * @return modified copy of {@code this} object
     */
    public final TextBlock withParts(Iterable<? extends Trees.TextPart> elements) {
      if (this.parts == elements) {
        return this;
      }
      ImmutableList<Trees.TextPart> newValue = ImmutableList.copyOf(elements);
      return checkPreconditions(new TextBlock(
          this, 
          newValue));
    }
    @Override
    public ImmutableList<Trees.TextPart> parts() {
      return parts;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TextBlock && equalTo((TextBlock) another));
    }

    private boolean equalTo(TextBlock another) {
      return parts.equals(another.parts);
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + parts.hashCode();
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TextBlock")
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.TextBlock}.
     * @return new Trees.TextBlock builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.TextBlock}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private ImmutableList.Builder<Trees.TextPart> partsBuilder =
          ImmutableList.builder();

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("TextBlock.Builder")
            .omitNullValues()
            .add("parts", partsBuilder.build())
            .toString();
      }

      /**
       * Adds one element to {@link Trees.TextBlock#parts()} list.
       * @param element single parts element
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TextPart element) {
        partsBuilder.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.TextBlock#parts()} list.
       * @param elements array of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addParts(Trees.TextPart... elements) {
        partsBuilder.addAll(ImmutableList.copyOf(    Arrays.asList(elements)));
        return this;
      }
      /**
       * Adds elements to {@link Trees.TextBlock#parts()} list.
       * @param elements iterable of parts elements
       * @return {@code this} builder for chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TextPart> elements) {
        partsBuilder.addAll(elements);
        return this;
      }

      /**
       * Builds new {@link Trees.TextBlock}.
       * @return immutable instance of Trees.TextBlock
       */
      public TextBlock build() {
        return checkPreconditions(new TextBlock(this));
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextLine}.
   * <p>
   * Use static factory methods to create instances: {@code of()} or
   * {@code builder()}.
   */
  @SuppressWarnings("all")
  @ParametersAreNonnullByDefault
  @Generated({"Immutables.generator", "Trees.TextLine"})
  @Immutable
  public static final class TextLine
      extends Trees.TextLine {

    private static TextLine checkPreconditions(TextLine instance) {
      return instance;
    }

    /**
     * Creates immutable copy of Trees.TextLine. Uses accessors to get values to initialize new immutable instance.
     * If instance is already immutable, it returns it unchanged.
     */
    public static TextLine copyOf(Trees.TextLine instance) {
      if (instance instanceof TextLine) {
        return (TextLine) instance;
      }
      Preconditions.checkNotNull(instance);
      return builder()
          .fragment(instance.fragment())
          .newline(instance.newline())
          .build();
    }

    /**
     * @deprecated Already an immutable object, no need to create immutable copy
     */
    @Deprecated
    public static TextLine copyOf(TextLine instance) {
      return Preconditions.checkNotNull(instance);
    }
    private final Trees.TextFragment fragment;
    private final boolean newline;

    private TextLine(Builder builder) {
      this.fragment = builder.fragment;
      this.newline = builder.newlineIsSet()
          ? builder.newline
          : super.newline();
    }

    private TextLine(
        TextLine copiedInstance, 
        Trees.TextFragment fragment, 
        boolean newline) {
      this.fragment = fragment;
      this.newline = newline;
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TextLine#fragment()}.
     * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for fragment, non-null
     * @return modified copy of the {@code this} object
     */
    public final TextLine withFragment(Trees.TextFragment value) {
      if (this.fragment == value) {
        return this;
      }
      Trees.TextFragment newValue = Preconditions.checkNotNull(value);
      return checkPreconditions(new TextLine(
          this, 
          newValue, 
          this.newline));
    }

    /**
     * Copy current immutable object by setting value for {@link Trees.TextLine#newline()}.
     * Value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value value for newline, non-null
     * @return modified copy of the {@code this} object
     */
    public final TextLine withNewline(boolean value) {
      if (this.newline == value) {
        return this;
      }
      boolean newValue = value;
      return checkPreconditions(new TextLine(
          this, 
          this.fragment, 
          newValue));
    }
    @Override
    public Trees.TextFragment fragment() {
      return fragment;
    }
    @Override
    public boolean newline() {
      return newline;
    }

    @Override
    public boolean equals(Object another) {
      return this == another
          || (another instanceof TextLine && equalTo((TextLine) another));
    }

    private boolean equalTo(TextLine another) {
      return fragment.equals(another.fragment)
          && newline == another.newline;
    }

    private int computeHashCode() {
      int h = 31;
      h = h * 17 + fragment.hashCode();
      h = h * 17 + Booleans.hashCode(newline);
      return h;
    }

    @Override
    public int hashCode() {
      return computeHashCode();
    }

    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TextLine")
          .add("fragment", fragment)
          .add("newline", newline)
          .toString();
    }

    /**
     * Creates builder for {@link Trees.TextLine}.
     * @return new Trees.TextLine builder
     */
    public static Builder builder() {
      return new Builder();
    }

    /**
     * Builds instances of {@link Trees.TextLine}.
     * Builder is not thread safe and generally should not be stored in fields and collections, 
     * but used immediately to create instances.
     */
    @NotThreadSafe
    public static final class Builder {
      private Builder() {
      }

      private long nondefaultBitset0;
      private static final long NONDEFAULT_BIT_NEWLINE = 0x1L;

      private boolean newlineIsSet() {
        return (nondefaultBitset0 & NONDEFAULT_BIT_NEWLINE) != 0;
      }
      private long initializedBitset0;
      private static final long INITIALIZED_BITSET_ALL_0 = 0x1;
      private static final long INITIALIZED_BIT_FRAGMENT = 0x1L;

      private boolean fragmentIsSet() {
        return (initializedBitset0 & INITIALIZED_BIT_FRAGMENT) != 0;
      }
      @Nullable
      private Trees.TextFragment fragment;
      private boolean newline;

      @Override
      public String toString() {
        return MoreObjects.toStringHelper("TextLine.Builder")
            .omitNullValues()
            .add("fragment", fragment)
            .add("newline", newlineIsSet() ? newline : null)
            .toString();
      }

      /**
       * Initializes value for {@link Trees.TextLine#fragment()}.
       * @param fragment value for fragment, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder fragment(Trees.TextFragment fragment) {
        this.fragment = Preconditions.checkNotNull(fragment);
        initializedBitset0 |= INITIALIZED_BIT_FRAGMENT;
        return this;
      }

      /**
       * Initializes value for {@link Trees.TextLine#newline()}.
       * <p><em>If not set, this attribute will have {@link Trees.TextLine#newline() default value}.</em>
       * @param newline value for newline, non-null
       * @return {@code this} builder for chained invocation
       */
      public final Builder newline(boolean newline) {
        this.newline = newline;
        nondefaultBitset0 |= NONDEFAULT_BIT_NEWLINE;
        return this;
      }

      private void checkRequiredAttributes() {
        if (initializedBitset0 != INITIALIZED_BITSET_ALL_0) {
          throw new IllegalStateException(
              MoreObjects.toStringHelper("Cannot build Trees.TextLine, some of required attributes are not set ")
                  .omitNullValues()
                  .addValue(!fragmentIsSet() ? "fragment" : null)
                  .toString());
        }
      }

      /**
       * Builds new {@link Trees.TextLine}.
       * @return immutable instance of Trees.TextLine
       */
      public TextLine build() {
        checkRequiredAttributes();
        return checkPreconditions(new TextLine(this));
      }
    }
  }
}
