package org.immutables.generator.processor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;

@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Transformers.generator", "Trees"})
public abstract class TreesTransformer<C> {
  protected TreesTransformer() {
  }

  public ImmutableTrees.Identifier transform(C context, ImmutableTrees.Identifier value) {
    return value
        .withValue(transformIdentifierValue(context, value, value.value()));
  }

  protected String transformIdentifierValue(C context, ImmutableTrees.Identifier value, String element) {
    return element;
  }

  public ImmutableTrees.TypeIdentifier transform(C context, ImmutableTrees.TypeIdentifier value) {
    return value
        .withValue(transformTypeIdentifierValue(context, value, value.value()));
  }

  protected String transformTypeIdentifierValue(C context, ImmutableTrees.TypeIdentifier value, String element) {
    return element;
  }

  public ImmutableTrees.TypeDeclaration transform(C context, ImmutableTrees.TypeDeclaration value) {
    return value
        .withType(transformTypeDeclarationType(context, value, value.type()))
        .withKind(transformTypeDeclarationKind(context, value, value.kind()));
  }

  protected Trees.TypeIdentifier transformTypeDeclarationType(C context, ImmutableTrees.TypeDeclaration value, Trees.TypeIdentifier element) {
    if (element instanceof ImmutableTrees.TypeIdentifier) {
      return transformTypeIdentifier(context, (ImmutableTrees.TypeIdentifier) element);
    }
    return element;
  }

  protected Trees.TypeDeclaration.Kind transformTypeDeclarationKind(C context, ImmutableTrees.TypeDeclaration value, Trees.TypeDeclaration.Kind element) {
    return element;
  }

  public ImmutableTrees.ResolvedType transform(C context, ImmutableTrees.ResolvedType value) {
    return value
        .withType(transformResolvedTypeType(context, value, value.type()));
  }

  protected Object transformResolvedTypeType(C context, ImmutableTrees.ResolvedType value, Object element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformObject(context, (ImmutableTrees.Identifier) element);
    }
    if (element instanceof ImmutableTrees.TypeIdentifier) {
      return transformObject(context, (ImmutableTrees.TypeIdentifier) element);
    }
    if (element instanceof ImmutableTrees.TypeDeclaration) {
      return transformObject(context, (ImmutableTrees.TypeDeclaration) element);
    }
    if (element instanceof ImmutableTrees.ResolvedType) {
      return transformObject(context, (ImmutableTrees.ResolvedType) element);
    }
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformObject(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformObject(context, (ImmutableTrees.StringLiteral) element);
    }
    if (element instanceof ImmutableTrees.Newline) {
      return transformObject(context, (ImmutableTrees.Newline) element);
    }
    if (element instanceof ImmutableTrees.TextFragment) {
      return transformObject(context, (ImmutableTrees.TextFragment) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformObject(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  public ImmutableTrees.BoundAccessExpression transform(C context, ImmutableTrees.BoundAccessExpression value) {
    return value
        .withAccessor(transformBoundAccessExpressionListAccessor(context, value, value.accessor()))
        .withPath(transformBoundAccessExpressionListPath(context, value, value.path()));
  }

  protected Iterable<Object> transformBoundAccessExpressionListAccessor(C context, ImmutableTrees.BoundAccessExpression value, List<Object> collection) {
    List<Object> list = Lists.newArrayList();
    for (Object element : collection) {
      list.add(transformBoundAccessExpressionAccessor(context, value, element));
    }
    return list;
  }

  protected Object transformBoundAccessExpressionAccessor(C context, ImmutableTrees.BoundAccessExpression value, Object element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformObject(context, (ImmutableTrees.Identifier) element);
    }
    if (element instanceof ImmutableTrees.TypeIdentifier) {
      return transformObject(context, (ImmutableTrees.TypeIdentifier) element);
    }
    if (element instanceof ImmutableTrees.TypeDeclaration) {
      return transformObject(context, (ImmutableTrees.TypeDeclaration) element);
    }
    if (element instanceof ImmutableTrees.ResolvedType) {
      return transformObject(context, (ImmutableTrees.ResolvedType) element);
    }
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformObject(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformObject(context, (ImmutableTrees.StringLiteral) element);
    }
    if (element instanceof ImmutableTrees.Newline) {
      return transformObject(context, (ImmutableTrees.Newline) element);
    }
    if (element instanceof ImmutableTrees.TextFragment) {
      return transformObject(context, (ImmutableTrees.TextFragment) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformObject(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  protected Iterable<Trees.Identifier> transformBoundAccessExpressionListPath(C context, ImmutableTrees.BoundAccessExpression value, List<Trees.Identifier> collection) {
    List<Trees.Identifier> list = Lists.newArrayList();
    for (Trees.Identifier element : collection) {
      list.add(transformBoundAccessExpressionPath(context, value, element));
    }
    return list;
  }

  protected Trees.Identifier transformBoundAccessExpressionPath(C context, ImmutableTrees.BoundAccessExpression value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  public ImmutableTrees.InvokableDeclaration transform(C context, ImmutableTrees.InvokableDeclaration value) {
    return value
        .withParameters(transformInvokableDeclarationListParameters(context, value, value.parameters()))
        .withName(transformInvokableDeclarationName(context, value, value.name()));
  }

  protected Iterable<Trees.Parameter> transformInvokableDeclarationListParameters(C context, ImmutableTrees.InvokableDeclaration value, List<Trees.Parameter> collection) {
    List<Trees.Parameter> list = Lists.newArrayList();
    for (Trees.Parameter element : collection) {
      list.add(transformInvokableDeclarationParameters(context, value, element));
    }
    return list;
  }

  protected Trees.Parameter transformInvokableDeclarationParameters(C context, ImmutableTrees.InvokableDeclaration value, Trees.Parameter element) {
    if (element instanceof ImmutableTrees.Parameter) {
      return transformParameter(context, (ImmutableTrees.Parameter) element);
    }
    return element;
  }

  protected Trees.Identifier transformInvokableDeclarationName(C context, ImmutableTrees.InvokableDeclaration value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  public ImmutableTrees.ValueDeclaration transform(C context, ImmutableTrees.ValueDeclaration value) {
    return value
        .withType(transformValueDeclarationOptionalType(context, value, value.type()))
        .withContainedType(transformValueDeclarationOptionalContainedType(context, value, value.containedType()))
        .withName(transformValueDeclarationName(context, value, value.name()));
  }

  protected Optional<Trees.TypeReference> transformValueDeclarationOptionalType(C context, ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformValueDeclarationType(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.TypeReference transformValueDeclarationType(C context, ImmutableTrees.ValueDeclaration value, Trees.TypeReference element) {
    if (element instanceof ImmutableTrees.TypeDeclaration) {
      return transformTypeReference(context, (ImmutableTrees.TypeDeclaration) element);
    }
    if (element instanceof ImmutableTrees.ResolvedType) {
      return transformTypeReference(context, (ImmutableTrees.ResolvedType) element);
    }
    return element;
  }

  protected Optional<Trees.TypeReference> transformValueDeclarationOptionalContainedType(C context, ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformValueDeclarationContainedType(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.TypeReference transformValueDeclarationContainedType(C context, ImmutableTrees.ValueDeclaration value, Trees.TypeReference element) {
    if (element instanceof ImmutableTrees.TypeDeclaration) {
      return transformTypeReference(context, (ImmutableTrees.TypeDeclaration) element);
    }
    if (element instanceof ImmutableTrees.ResolvedType) {
      return transformTypeReference(context, (ImmutableTrees.ResolvedType) element);
    }
    return element;
  }

  protected Trees.Identifier transformValueDeclarationName(C context, ImmutableTrees.ValueDeclaration value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  public ImmutableTrees.Parameter transform(C context, ImmutableTrees.Parameter value) {
    return value
        .withName(transformParameterName(context, value, value.name()))
        .withType(transformParameterType(context, value, value.type()));
  }

  protected Trees.Identifier transformParameterName(C context, ImmutableTrees.Parameter value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  protected Trees.TypeReference transformParameterType(C context, ImmutableTrees.Parameter value, Trees.TypeReference element) {
    if (element instanceof ImmutableTrees.TypeDeclaration) {
      return transformTypeReference(context, (ImmutableTrees.TypeDeclaration) element);
    }
    if (element instanceof ImmutableTrees.ResolvedType) {
      return transformTypeReference(context, (ImmutableTrees.ResolvedType) element);
    }
    return element;
  }

  public ImmutableTrees.Block transform(C context, ImmutableTrees.Block value) {
    return value
        .withParts(transformBlockListParts(context, value, value.parts()));
  }

  protected Iterable<Trees.TemplatePart> transformBlockListParts(C context, ImmutableTrees.Block value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformBlockParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformBlockParts(C context, ImmutableTrees.Block value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  public ImmutableTrees.Comment transform(C context, ImmutableTrees.Comment value) {
    return value;
  }

  public ImmutableTrees.ConditionalBlock transform(C context, ImmutableTrees.ConditionalBlock value) {
    return value
        .withCondition(transformConditionalBlockCondition(context, value, value.condition()))
        .withParts(transformConditionalBlockListParts(context, value, value.parts()));
  }

  protected Trees.Expression transformConditionalBlockCondition(C context, ImmutableTrees.ConditionalBlock value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Iterable<Trees.TemplatePart> transformConditionalBlockListParts(C context, ImmutableTrees.ConditionalBlock value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformConditionalBlockParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformConditionalBlockParts(C context, ImmutableTrees.ConditionalBlock value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  public ImmutableTrees.IfStatement transform(C context, ImmutableTrees.IfStatement value) {
    return value
        .withThen(transformIfStatementThen(context, value, value.then()))
        .withOtherwiseIf(transformIfStatementListOtherwiseIf(context, value, value.otherwiseIf()))
        .withOtherwise(transformIfStatementOptionalOtherwise(context, value, value.otherwise()));
  }

  protected Trees.ConditionalBlock transformIfStatementThen(C context, ImmutableTrees.IfStatement value, Trees.ConditionalBlock element) {
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformConditionalBlock(context, (ImmutableTrees.ConditionalBlock) element);
    }
    return element;
  }

  protected Iterable<Trees.ConditionalBlock> transformIfStatementListOtherwiseIf(C context, ImmutableTrees.IfStatement value, List<Trees.ConditionalBlock> collection) {
    List<Trees.ConditionalBlock> list = Lists.newArrayList();
    for (Trees.ConditionalBlock element : collection) {
      list.add(transformIfStatementOtherwiseIf(context, value, element));
    }
    return list;
  }

  protected Trees.ConditionalBlock transformIfStatementOtherwiseIf(C context, ImmutableTrees.IfStatement value, Trees.ConditionalBlock element) {
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformConditionalBlock(context, (ImmutableTrees.ConditionalBlock) element);
    }
    return element;
  }

  protected Optional<Trees.Block> transformIfStatementOptionalOtherwise(C context, ImmutableTrees.IfStatement value, Optional<Trees.Block> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformIfStatementOtherwise(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.Block transformIfStatementOtherwise(C context, ImmutableTrees.IfStatement value, Trees.Block element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformBlock(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformBlock(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformBlock(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformBlock(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformBlock(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformBlock(context, (ImmutableTrees.Template) element);
    }
    return element;
  }

  public ImmutableTrees.ForStatement transform(C context, ImmutableTrees.ForStatement value) {
    return value
        .withDeclaration(transformForStatementListDeclaration(context, value, value.declaration()))
        .withParts(transformForStatementListParts(context, value, value.parts()));
  }

  protected Iterable<Trees.GeneratorDeclaration> transformForStatementListDeclaration(C context, ImmutableTrees.ForStatement value, List<Trees.GeneratorDeclaration> collection) {
    List<Trees.GeneratorDeclaration> list = Lists.newArrayList();
    for (Trees.GeneratorDeclaration element : collection) {
      list.add(transformForStatementDeclaration(context, value, element));
    }
    return list;
  }

  protected Trees.GeneratorDeclaration transformForStatementDeclaration(C context, ImmutableTrees.ForStatement value, Trees.GeneratorDeclaration element) {
    if (element instanceof ImmutableTrees.AssignGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.AssignGenerator) element);
    }
    if (element instanceof ImmutableTrees.IterationGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.IterationGenerator) element);
    }
    if (element instanceof ImmutableTrees.TransformGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.TransformGenerator) element);
    }
    return element;
  }

  protected Iterable<Trees.TemplatePart> transformForStatementListParts(C context, ImmutableTrees.ForStatement value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformForStatementParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformForStatementParts(C context, ImmutableTrees.ForStatement value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  public ImmutableTrees.ForIterationAccessExpression transform(C context, ImmutableTrees.ForIterationAccessExpression value) {
    return value
        .withAccess(transformForIterationAccessExpressionAccess(context, value, value.access()))
        .withPath(transformForIterationAccessExpressionListPath(context, value, value.path()));
  }

  protected Trees.AccessExpression transformForIterationAccessExpressionAccess(C context, ImmutableTrees.ForIterationAccessExpression value, Trees.AccessExpression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    return element;
  }

  protected Iterable<Trees.Identifier> transformForIterationAccessExpressionListPath(C context, ImmutableTrees.ForIterationAccessExpression value, List<Trees.Identifier> collection) {
    List<Trees.Identifier> list = Lists.newArrayList();
    for (Trees.Identifier element : collection) {
      list.add(transformForIterationAccessExpressionPath(context, value, element));
    }
    return list;
  }

  protected Trees.Identifier transformForIterationAccessExpressionPath(C context, ImmutableTrees.ForIterationAccessExpression value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  public ImmutableTrees.LetStatement transform(C context, ImmutableTrees.LetStatement value) {
    return value
        .withParts(transformLetStatementListParts(context, value, value.parts()))
        .withDeclaration(transformLetStatementDeclaration(context, value, value.declaration()));
  }

  protected Iterable<Trees.TemplatePart> transformLetStatementListParts(C context, ImmutableTrees.LetStatement value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformLetStatementParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformLetStatementParts(C context, ImmutableTrees.LetStatement value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  protected Trees.InvokableDeclaration transformLetStatementDeclaration(C context, ImmutableTrees.LetStatement value, Trees.InvokableDeclaration element) {
    if (element instanceof ImmutableTrees.InvokableDeclaration) {
      return transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration) element);
    }
    return element;
  }

  public ImmutableTrees.InvokeStatement transform(C context, ImmutableTrees.InvokeStatement value) {
    return value
        .withAccess(transformInvokeStatementAccess(context, value, value.access()))
        .withParams(transformInvokeStatementListParams(context, value, value.params()))
        .withParts(transformInvokeStatementListParts(context, value, value.parts()));
  }

  protected Trees.Expression transformInvokeStatementAccess(C context, ImmutableTrees.InvokeStatement value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Iterable<Trees.Expression> transformInvokeStatementListParams(C context, ImmutableTrees.InvokeStatement value, List<Trees.Expression> collection) {
    List<Trees.Expression> list = Lists.newArrayList();
    for (Trees.Expression element : collection) {
      list.add(transformInvokeStatementParams(context, value, element));
    }
    return list;
  }

  protected Trees.Expression transformInvokeStatementParams(C context, ImmutableTrees.InvokeStatement value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Iterable<Trees.TemplatePart> transformInvokeStatementListParts(C context, ImmutableTrees.InvokeStatement value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformInvokeStatementParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformInvokeStatementParts(C context, ImmutableTrees.InvokeStatement value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  public ImmutableTrees.LetEnd transform(C context, ImmutableTrees.LetEnd value) {
    return value;
  }

  public ImmutableTrees.ForEnd transform(C context, ImmutableTrees.ForEnd value) {
    return value;
  }

  public ImmutableTrees.IfEnd transform(C context, ImmutableTrees.IfEnd value) {
    return value;
  }

  public ImmutableTrees.InvokeEnd transform(C context, ImmutableTrees.InvokeEnd value) {
    return value
        .withAccess(transformInvokeEndAccess(context, value, value.access()));
  }

  protected Trees.AccessExpression transformInvokeEndAccess(C context, ImmutableTrees.InvokeEnd value, Trees.AccessExpression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    return element;
  }

  public ImmutableTrees.InvokeString transform(C context, ImmutableTrees.InvokeString value) {
    return value
        .withLiteral(transformInvokeStringLiteral(context, value, value.literal()));
  }

  protected Trees.StringLiteral transformInvokeStringLiteral(C context, ImmutableTrees.InvokeString value, Trees.StringLiteral element) {
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformStringLiteral(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.Invoke transform(C context, ImmutableTrees.Invoke value) {
    return value
        .withAccess(transformInvokeAccess(context, value, value.access()))
        .withInvoke(transformInvokeOptionalInvoke(context, value, value.invoke()));
  }

  protected Trees.AccessExpression transformInvokeAccess(C context, ImmutableTrees.Invoke value, Trees.AccessExpression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformAccessExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    return element;
  }

  protected Optional<Trees.ApplyExpression> transformInvokeOptionalInvoke(C context, ImmutableTrees.Invoke value, Optional<Trees.ApplyExpression> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformInvokeInvoke(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.ApplyExpression transformInvokeInvoke(C context, ImmutableTrees.Invoke value, Trees.ApplyExpression element) {
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformApplyExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    return element;
  }

  public ImmutableTrees.Let transform(C context, ImmutableTrees.Let value) {
    return value
        .withDeclaration(transformLetDeclaration(context, value, value.declaration()));
  }

  protected Trees.InvokableDeclaration transformLetDeclaration(C context, ImmutableTrees.Let value, Trees.InvokableDeclaration element) {
    if (element instanceof ImmutableTrees.InvokableDeclaration) {
      return transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration) element);
    }
    return element;
  }

  public ImmutableTrees.Unit transform(C context, ImmutableTrees.Unit value) {
    return value
        .withParts(transformUnitListParts(context, value, value.parts()));
  }

  protected Iterable<Trees.UnitPart> transformUnitListParts(C context, ImmutableTrees.Unit value, List<Trees.UnitPart> collection) {
    List<Trees.UnitPart> list = Lists.newArrayList();
    for (Trees.UnitPart element : collection) {
      list.add(transformUnitParts(context, value, element));
    }
    return list;
  }

  protected Trees.UnitPart transformUnitParts(C context, ImmutableTrees.Unit value, Trees.UnitPart element) {
    if (element instanceof ImmutableTrees.Comment) {
      return transformUnitPart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformUnitPart(context, (ImmutableTrees.Template) element);
    }
    return element;
  }

  public ImmutableTrees.Template transform(C context, ImmutableTrees.Template value) {
    return value
        .withParts(transformTemplateListParts(context, value, value.parts()))
        .withDeclaration(transformTemplateDeclaration(context, value, value.declaration()));
  }

  protected Iterable<Trees.TemplatePart> transformTemplateListParts(C context, ImmutableTrees.Template value, List<Trees.TemplatePart> collection) {
    List<Trees.TemplatePart> list = Lists.newArrayList();
    for (Trees.TemplatePart element : collection) {
      list.add(transformTemplateParts(context, value, element));
    }
    return list;
  }

  protected Trees.TemplatePart transformTemplateParts(C context, ImmutableTrees.Template value, Trees.TemplatePart element) {
    if (element instanceof ImmutableTrees.Block) {
      return transformTemplatePart(context, (ImmutableTrees.Block) element);
    }
    if (element instanceof ImmutableTrees.Comment) {
      return transformTemplatePart(context, (ImmutableTrees.Comment) element);
    }
    if (element instanceof ImmutableTrees.ConditionalBlock) {
      return transformTemplatePart(context, (ImmutableTrees.ConditionalBlock) element);
    }
    if (element instanceof ImmutableTrees.IfStatement) {
      return transformTemplatePart(context, (ImmutableTrees.IfStatement) element);
    }
    if (element instanceof ImmutableTrees.ForStatement) {
      return transformTemplatePart(context, (ImmutableTrees.ForStatement) element);
    }
    if (element instanceof ImmutableTrees.LetStatement) {
      return transformTemplatePart(context, (ImmutableTrees.LetStatement) element);
    }
    if (element instanceof ImmutableTrees.InvokeStatement) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeStatement) element);
    }
    if (element instanceof ImmutableTrees.LetEnd) {
      return transformTemplatePart(context, (ImmutableTrees.LetEnd) element);
    }
    if (element instanceof ImmutableTrees.ForEnd) {
      return transformTemplatePart(context, (ImmutableTrees.ForEnd) element);
    }
    if (element instanceof ImmutableTrees.IfEnd) {
      return transformTemplatePart(context, (ImmutableTrees.IfEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeEnd) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeEnd) element);
    }
    if (element instanceof ImmutableTrees.InvokeString) {
      return transformTemplatePart(context, (ImmutableTrees.InvokeString) element);
    }
    if (element instanceof ImmutableTrees.Invoke) {
      return transformTemplatePart(context, (ImmutableTrees.Invoke) element);
    }
    if (element instanceof ImmutableTrees.Let) {
      return transformTemplatePart(context, (ImmutableTrees.Let) element);
    }
    if (element instanceof ImmutableTrees.Template) {
      return transformTemplatePart(context, (ImmutableTrees.Template) element);
    }
    if (element instanceof ImmutableTrees.For) {
      return transformTemplatePart(context, (ImmutableTrees.For) element);
    }
    if (element instanceof ImmutableTrees.If) {
      return transformTemplatePart(context, (ImmutableTrees.If) element);
    }
    if (element instanceof ImmutableTrees.ElseIf) {
      return transformTemplatePart(context, (ImmutableTrees.ElseIf) element);
    }
    if (element instanceof ImmutableTrees.Else) {
      return transformTemplatePart(context, (ImmutableTrees.Else) element);
    }
    if (element instanceof ImmutableTrees.TemplateEnd) {
      return transformTemplatePart(context, (ImmutableTrees.TemplateEnd) element);
    }
    if (element instanceof ImmutableTrees.TextBlock) {
      return transformTemplatePart(context, (ImmutableTrees.TextBlock) element);
    }
    if (element instanceof ImmutableTrees.TextLine) {
      return transformTemplatePart(context, (ImmutableTrees.TextLine) element);
    }
    return element;
  }

  protected Trees.InvokableDeclaration transformTemplateDeclaration(C context, ImmutableTrees.Template value, Trees.InvokableDeclaration element) {
    if (element instanceof ImmutableTrees.InvokableDeclaration) {
      return transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration) element);
    }
    return element;
  }

  public ImmutableTrees.AccessExpression transform(C context, ImmutableTrees.AccessExpression value) {
    return value
        .withPath(transformAccessExpressionListPath(context, value, value.path()));
  }

  protected Iterable<Trees.Identifier> transformAccessExpressionListPath(C context, ImmutableTrees.AccessExpression value, List<Trees.Identifier> collection) {
    List<Trees.Identifier> list = Lists.newArrayList();
    for (Trees.Identifier element : collection) {
      list.add(transformAccessExpressionPath(context, value, element));
    }
    return list;
  }

  protected Trees.Identifier transformAccessExpressionPath(C context, ImmutableTrees.AccessExpression value, Trees.Identifier element) {
    if (element instanceof ImmutableTrees.Identifier) {
      return transformIdentifier(context, (ImmutableTrees.Identifier) element);
    }
    return element;
  }

  public ImmutableTrees.ApplyExpression transform(C context, ImmutableTrees.ApplyExpression value) {
    return value
        .withParams(transformApplyExpressionListParams(context, value, value.params()));
  }

  protected Iterable<Trees.Expression> transformApplyExpressionListParams(C context, ImmutableTrees.ApplyExpression value, List<Trees.Expression> collection) {
    List<Trees.Expression> list = Lists.newArrayList();
    for (Trees.Expression element : collection) {
      list.add(transformApplyExpressionParams(context, value, element));
    }
    return list;
  }

  protected Trees.Expression transformApplyExpressionParams(C context, ImmutableTrees.ApplyExpression value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.AssignGenerator transform(C context, ImmutableTrees.AssignGenerator value) {
    return value
        .withDeclaration(transformAssignGeneratorDeclaration(context, value, value.declaration()))
        .withFrom(transformAssignGeneratorFrom(context, value, value.from()));
  }

  protected Trees.ValueDeclaration transformAssignGeneratorDeclaration(C context, ImmutableTrees.AssignGenerator value, Trees.ValueDeclaration element) {
    if (element instanceof ImmutableTrees.ValueDeclaration) {
      return transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration) element);
    }
    return element;
  }

  protected Trees.Expression transformAssignGeneratorFrom(C context, ImmutableTrees.AssignGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.IterationGenerator transform(C context, ImmutableTrees.IterationGenerator value) {
    return value
        .withCondition(transformIterationGeneratorOptionalCondition(context, value, value.condition()))
        .withDeclaration(transformIterationGeneratorDeclaration(context, value, value.declaration()))
        .withFrom(transformIterationGeneratorFrom(context, value, value.from()));
  }

  protected Optional<Trees.Expression> transformIterationGeneratorOptionalCondition(C context, ImmutableTrees.IterationGenerator value, Optional<Trees.Expression> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformIterationGeneratorCondition(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.Expression transformIterationGeneratorCondition(C context, ImmutableTrees.IterationGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Trees.ValueDeclaration transformIterationGeneratorDeclaration(C context, ImmutableTrees.IterationGenerator value, Trees.ValueDeclaration element) {
    if (element instanceof ImmutableTrees.ValueDeclaration) {
      return transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration) element);
    }
    return element;
  }

  protected Trees.Expression transformIterationGeneratorFrom(C context, ImmutableTrees.IterationGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.TransformGenerator transform(C context, ImmutableTrees.TransformGenerator value) {
    return value
        .withTransform(transformTransformGeneratorTransform(context, value, value.transform()))
        .withVarDeclaration(transformTransformGeneratorVarDeclaration(context, value, value.varDeclaration()))
        .withCondition(transformTransformGeneratorOptionalCondition(context, value, value.condition()))
        .withDeclaration(transformTransformGeneratorDeclaration(context, value, value.declaration()))
        .withFrom(transformTransformGeneratorFrom(context, value, value.from()));
  }

  protected Trees.Expression transformTransformGeneratorTransform(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Trees.ValueDeclaration transformTransformGeneratorVarDeclaration(C context, ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration element) {
    if (element instanceof ImmutableTrees.ValueDeclaration) {
      return transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration) element);
    }
    return element;
  }

  protected Optional<Trees.Expression> transformTransformGeneratorOptionalCondition(C context, ImmutableTrees.TransformGenerator value, Optional<Trees.Expression> optional) {
    if (optional.isPresent()) {
      return Optional.of(transformTransformGeneratorCondition(context, value, optional.get()));
    }
    return Optional.absent();
  }

  protected Trees.Expression transformTransformGeneratorCondition(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  protected Trees.ValueDeclaration transformTransformGeneratorDeclaration(C context, ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration element) {
    if (element instanceof ImmutableTrees.ValueDeclaration) {
      return transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration) element);
    }
    return element;
  }

  protected Trees.Expression transformTransformGeneratorFrom(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.For transform(C context, ImmutableTrees.For value) {
    return value
        .withDeclaration(transformForListDeclaration(context, value, value.declaration()));
  }

  protected Iterable<Trees.GeneratorDeclaration> transformForListDeclaration(C context, ImmutableTrees.For value, List<Trees.GeneratorDeclaration> collection) {
    List<Trees.GeneratorDeclaration> list = Lists.newArrayList();
    for (Trees.GeneratorDeclaration element : collection) {
      list.add(transformForDeclaration(context, value, element));
    }
    return list;
  }

  protected Trees.GeneratorDeclaration transformForDeclaration(C context, ImmutableTrees.For value, Trees.GeneratorDeclaration element) {
    if (element instanceof ImmutableTrees.AssignGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.AssignGenerator) element);
    }
    if (element instanceof ImmutableTrees.IterationGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.IterationGenerator) element);
    }
    if (element instanceof ImmutableTrees.TransformGenerator) {
      return transformGeneratorDeclaration(context, (ImmutableTrees.TransformGenerator) element);
    }
    return element;
  }

  public ImmutableTrees.If transform(C context, ImmutableTrees.If value) {
    return value
        .withCondition(transformIfCondition(context, value, value.condition()));
  }

  protected Trees.Expression transformIfCondition(C context, ImmutableTrees.If value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.ElseIf transform(C context, ImmutableTrees.ElseIf value) {
    return value
        .withCondition(transformElseIfCondition(context, value, value.condition()));
  }

  protected Trees.Expression transformElseIfCondition(C context, ImmutableTrees.ElseIf value, Trees.Expression element) {
    if (element instanceof ImmutableTrees.BoundAccessExpression) {
      return transformExpression(context, (ImmutableTrees.BoundAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
      return transformExpression(context, (ImmutableTrees.ForIterationAccessExpression) element);
    }
    if (element instanceof ImmutableTrees.AccessExpression) {
      return transformExpression(context, (ImmutableTrees.AccessExpression) element);
    }
    if (element instanceof ImmutableTrees.ApplyExpression) {
      return transformExpression(context, (ImmutableTrees.ApplyExpression) element);
    }
    if (element instanceof ImmutableTrees.StringLiteral) {
      return transformExpression(context, (ImmutableTrees.StringLiteral) element);
    }
    return element;
  }

  public ImmutableTrees.Else transform(C context, ImmutableTrees.Else value) {
    return value;
  }

  public ImmutableTrees.TemplateEnd transform(C context, ImmutableTrees.TemplateEnd value) {
    return value;
  }

  public ImmutableTrees.StringLiteral transform(C context, ImmutableTrees.StringLiteral value) {
    return value
        .withValue(transformStringLiteralValue(context, value, value.value()));
  }

  protected String transformStringLiteralValue(C context, ImmutableTrees.StringLiteral value, String element) {
    return element;
  }

  public ImmutableTrees.Newline transform(C context, ImmutableTrees.Newline value) {
    return value;
  }

  public ImmutableTrees.TextFragment transform(C context, ImmutableTrees.TextFragment value) {
    return value
        .withValue(transformTextFragmentValue(context, value, value.value()));
  }

  protected String transformTextFragmentValue(C context, ImmutableTrees.TextFragment value, String element) {
    return element;
  }

  public ImmutableTrees.TextBlock transform(C context, ImmutableTrees.TextBlock value) {
    return value
        .withParts(transformTextBlockListParts(context, value, value.parts()));
  }

  protected Iterable<Trees.TextPart> transformTextBlockListParts(C context, ImmutableTrees.TextBlock value, List<Trees.TextPart> collection) {
    List<Trees.TextPart> list = Lists.newArrayList();
    for (Trees.TextPart element : collection) {
      list.add(transformTextBlockParts(context, value, element));
    }
    return list;
  }

  protected Trees.TextPart transformTextBlockParts(C context, ImmutableTrees.TextBlock value, Trees.TextPart element) {
    if (element instanceof ImmutableTrees.Newline) {
      return transformTextPart(context, (ImmutableTrees.Newline) element);
    }
    if (element instanceof ImmutableTrees.TextFragment) {
      return transformTextPart(context, (ImmutableTrees.TextFragment) element);
    }
    return element;
  }

  public ImmutableTrees.TextLine transform(C context, ImmutableTrees.TextLine value) {
    return value
        .withFragment(transformTextLineFragment(context, value, value.fragment()))
        .withNewline(transformTextLineNewline(context, value, value.newline()));
  }

  protected Trees.TextFragment transformTextLineFragment(C context, ImmutableTrees.TextLine value, Trees.TextFragment element) {
    if (element instanceof ImmutableTrees.TextFragment) {
      return transformTextFragment(context, (ImmutableTrees.TextFragment) element);
    }
    return element;
  }

  protected boolean transformTextLineNewline(C context, ImmutableTrees.TextLine value, boolean element) {
    return element;
  }

  protected Trees.InvokeEnd transformInvokeEnd(C context, ImmutableTrees.InvokeEnd value) {
    return transform(context, value);
  }

  protected Trees.TextBlock transformTextBlock(C context, ImmutableTrees.TextBlock value) {
    return transform(context, value);
  }

  protected Trees.ApplyExpression transformApplyExpression(C context, ImmutableTrees.ApplyExpression value) {
    return transform(context, value);
  }

  protected Trees.TemplateEnd transformTemplateEnd(C context, ImmutableTrees.TemplateEnd value) {
    return transform(context, value);
  }

  protected Trees.TransformGenerator transformTransformGenerator(C context, ImmutableTrees.TransformGenerator value) {
    return transform(context, value);
  }

  protected Trees.ConditionalBlock transformConditionalBlock(C context, ImmutableTrees.ConditionalBlock value) {
    return transform(context, value);
  }

  protected Trees.IfEnd transformIfEnd(C context, ImmutableTrees.IfEnd value) {
    return transform(context, value);
  }

  protected Trees.Template transformTemplate(C context, ImmutableTrees.Template value) {
    return transform(context, value);
  }

  protected Trees.ForIterationAccessExpression transformForIterationAccessExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
    return transform(context, value);
  }

  protected Trees.AssignGenerator transformAssignGenerator(C context, ImmutableTrees.AssignGenerator value) {
    return transform(context, value);
  }

  protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.IterationGenerator value) {
    return transformIterationGenerator(context, value);
  }

  protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.TransformGenerator value) {
    return transformTransformGenerator(context, value);
  }

  protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.AssignGenerator value) {
    return transformAssignGenerator(context, value);
  }

  protected Trees.ForStatement transformForStatement(C context, ImmutableTrees.ForStatement value) {
    return transform(context, value);
  }

  protected Trees.ValueDeclaration transformValueDeclaration(C context, ImmutableTrees.ValueDeclaration value) {
    return transform(context, value);
  }

  protected Trees.TypeReference transformTypeReference(C context, ImmutableTrees.TypeDeclaration value) {
    return transformTypeDeclaration(context, value);
  }

  protected Trees.TypeReference transformTypeReference(C context, ImmutableTrees.ResolvedType value) {
    return transformResolvedType(context, value);
  }

  protected Trees.InvokeStatement transformInvokeStatement(C context, ImmutableTrees.InvokeStatement value) {
    return transform(context, value);
  }

  protected Trees.ResolvedType transformResolvedType(C context, ImmutableTrees.ResolvedType value) {
    return transform(context, value);
  }

  protected Trees.Newline transformNewline(C context, ImmutableTrees.Newline value) {
    return transform(context, value);
  }

  protected Trees.Let transformLet(C context, ImmutableTrees.Let value) {
    return transform(context, value);
  }

  protected Trees.TextLine transformTextLine(C context, ImmutableTrees.TextLine value) {
    return transform(context, value);
  }

  protected Trees.UnitPart transformUnitPart(C context, ImmutableTrees.Comment value) {
    return transformComment(context, value);
  }

  protected Trees.UnitPart transformUnitPart(C context, ImmutableTrees.Template value) {
    return transformTemplate(context, value);
  }

  protected Trees.InvokableDeclaration transformInvokableDeclaration(C context, ImmutableTrees.InvokableDeclaration value) {
    return transform(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.InvokeStatement value) {
    return transformInvokeStatement(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.ConditionalBlock value) {
    return transformConditionalBlock(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.ForStatement value) {
    return transformForStatement(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.Template value) {
    return transformTemplate(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.LetStatement value) {
    return transformLetStatement(context, value);
  }

  protected Trees.Block transformBlock(C context, ImmutableTrees.Block value) {
    return transform(context, value);
  }

  protected Trees.LetStatement transformLetStatement(C context, ImmutableTrees.LetStatement value) {
    return transform(context, value);
  }

  protected Trees.ForEnd transformForEnd(C context, ImmutableTrees.ForEnd value) {
    return transform(context, value);
  }

  protected Trees.TypeIdentifier transformTypeIdentifier(C context, ImmutableTrees.TypeIdentifier value) {
    return transform(context, value);
  }

  protected Trees.StringLiteral transformStringLiteral(C context, ImmutableTrees.StringLiteral value) {
    return transform(context, value);
  }

  protected Trees.Else transformElse(C context, ImmutableTrees.Else value) {
    return transform(context, value);
  }

  protected Trees.TextPart transformTextPart(C context, ImmutableTrees.TextFragment value) {
    return transformTextFragment(context, value);
  }

  protected Trees.TextPart transformTextPart(C context, ImmutableTrees.Newline value) {
    return transformNewline(context, value);
  }

  protected Trees.Identifier transformIdentifier(C context, ImmutableTrees.Identifier value) {
    return transform(context, value);
  }

  protected Trees.LetEnd transformLetEnd(C context, ImmutableTrees.LetEnd value) {
    return transform(context, value);
  }

  protected Trees.TypeDeclaration transformTypeDeclaration(C context, ImmutableTrees.TypeDeclaration value) {
    return transform(context, value);
  }

  protected Trees.Expression transformExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
    return transformForIterationAccessExpression(context, value);
  }

  protected Trees.Expression transformExpression(C context, ImmutableTrees.BoundAccessExpression value) {
    return transformBoundAccessExpression(context, value);
  }

  protected Trees.Expression transformExpression(C context, ImmutableTrees.AccessExpression value) {
    return transformAccessExpression(context, value);
  }

  protected Trees.Expression transformExpression(C context, ImmutableTrees.ApplyExpression value) {
    return transformApplyExpression(context, value);
  }

  protected Trees.Expression transformExpression(C context, ImmutableTrees.StringLiteral value) {
    return transformStringLiteral(context, value);
  }

  protected Trees.IterationGenerator transformIterationGenerator(C context, ImmutableTrees.IterationGenerator value) {
    return transform(context, value);
  }

  protected Trees.If transformIf(C context, ImmutableTrees.If value) {
    return transform(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ConditionalBlock value) {
    return transformConditionalBlock(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeEnd value) {
    return transformInvokeEnd(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.If value) {
    return transformIf(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Comment value) {
    return transformComment(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.LetEnd value) {
    return transformLetEnd(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TemplateEnd value) {
    return transformTemplateEnd(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ForEnd value) {
    return transformForEnd(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Template value) {
    return transformTemplate(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TextBlock value) {
    return transformTextBlock(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeStatement value) {
    return transformInvokeStatement(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Invoke value) {
    return transformInvoke(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.IfStatement value) {
    return transformIfStatement(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Let value) {
    return transformLet(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.For value) {
    return transformFor(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ElseIf value) {
    return transformElseIf(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Else value) {
    return transformElse(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ForStatement value) {
    return transformForStatement(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.LetStatement value) {
    return transformLetStatement(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeString value) {
    return transformInvokeString(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TextLine value) {
    return transformTextLine(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.IfEnd value) {
    return transformIfEnd(context, value);
  }

  protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Block value) {
    return transformBlock(context, value);
  }

  protected Trees.InvokeString transformInvokeString(C context, ImmutableTrees.InvokeString value) {
    return transform(context, value);
  }

  protected Trees.ElseIf transformElseIf(C context, ImmutableTrees.ElseIf value) {
    return transform(context, value);
  }

  protected Trees.TextFragment transformTextFragment(C context, ImmutableTrees.TextFragment value) {
    return transform(context, value);
  }

  protected Trees.Invoke transformInvoke(C context, ImmutableTrees.Invoke value) {
    return transform(context, value);
  }

  protected Trees.Parameter transformParameter(C context, ImmutableTrees.Parameter value) {
    return transform(context, value);
  }

  protected Trees.Comment transformComment(C context, ImmutableTrees.Comment value) {
    return transform(context, value);
  }

  protected Trees.IfStatement transformIfStatement(C context, ImmutableTrees.IfStatement value) {
    return transform(context, value);
  }

  protected Trees.BoundAccessExpression transformBoundAccessExpression(C context, ImmutableTrees.BoundAccessExpression value) {
    return transform(context, value);
  }

  protected Trees.For transformFor(C context, ImmutableTrees.For value) {
    return transform(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.BoundAccessExpression value) {
    return transformBoundAccessExpression(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.TextFragment value) {
    return transformTextFragment(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.StringLiteral value) {
    return transformStringLiteral(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.Newline value) {
    return transformNewline(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.Identifier value) {
    return transformIdentifier(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.TextLine value) {
    return transformTextLine(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.TypeIdentifier value) {
    return transformTypeIdentifier(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.TypeDeclaration value) {
    return transformTypeDeclaration(context, value);
  }

  protected Object transformObject(C context, ImmutableTrees.ResolvedType value) {
    return transformResolvedType(context, value);
  }

  protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.BoundAccessExpression value) {
    return transformBoundAccessExpression(context, value);
  }

  protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
    return transformForIterationAccessExpression(context, value);
  }

  protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.AccessExpression value) {
    return transform(context, value);
  }
}
