/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.immutables.generator.Templates;
import org.immutables.generator.processor.GeneratedTypes;
import org.immutables.generator.processor.Implicits;
import org.immutables.generator.processor.Introspection;

public final class Accessors
extends Introspection {
    private static final String OPTIONAL_TYPE_SIMPLE_NAME = Optional.class.getSimpleName();
    public final TypeMirror iterableTypeErasure;
    public final TypeElement iterableElement;
    public final TypeMirror invokableType;
    public final TypeMirror iterationType;
    public final TypeMirror objectType;
    private final Cache<String, ImmutableMap<String, Accessor>> accessorsDefined = new Cache<String, ImmutableMap<String, Accessor>>(){

        @Override
        public ImmutableMap<String, Accessor> load(String key) throws Exception {
            return Accessors.this.extractFrom(Accessors.this.elements.getTypeElement(key));
        }
    };

    Accessors(ProcessingEnvironment environment) {
        super(environment);
        this.iterableElement = this.elements.getTypeElement(Iterable.class.getName());
        this.iterableTypeErasure = this.types.erasure(this.iterableElement.asType());
        this.invokableType = this.elements.getTypeElement(Templates.Invokable.class.getCanonicalName()).asType();
        this.iterationType = this.elements.getTypeElement(Templates.Iteration.class.getCanonicalName()).asType();
        this.objectType = this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
    }

    public TypeMirror wrapIterable(TypeMirror typeMirror) {
        return this.types.getDeclaredType(this.iterableElement, typeMirror);
    }

    ImmutableMap<String, Accessor> definedBy(TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            return this.accessorsDefined.get(this.toName(type));
        }
        return ImmutableMap.of();
    }

    private ImmutableMap<String, Accessor> extractFrom(@Nullable TypeElement type) {
        if (type == null) {
            return ImmutableMap.of();
        }
        HashMap accesors = Maps.newHashMap();
        this.collectAccessors(type, accesors);
        Optional<TypeElement> implementationSubclass = this.getImplementationSubclass(type);
        if (implementationSubclass.isPresent()) {
            this.collectAccessors((TypeElement)implementationSubclass.get(), accesors);
        }
        return ImmutableMap.builder().putAll((Map)accesors).build();
    }

    private Optional<TypeElement> getImplementationSubclass(TypeElement type) {
        return Optional.fromNullable((Object)this.elements.getTypeElement(GeneratedTypes.getQualifiedName(this.elements, type)));
    }

    private void collectAccessors(TypeElement type, Map<String, Accessor> accesors) {
        List<? extends Element> members = this.elements.getAllMembers(type);
        this.collectMethodAccesors(accesors, members);
        this.collectFieldAccessors(accesors, members);
    }

    private void collectFieldAccessors(Map<String, Accessor> accesors, List<? extends Element> allMembers) {
        for (VariableElement value : ElementFilter.fieldsIn(allMembers)) {
            if (!this.isAccessible(value)) continue;
            Accessor accessor = new Accessor(value);
            accesors.put(accessor.name, accessor);
        }
    }

    private void collectMethodAccesors(Map<String, Accessor> accesors, List<? extends Element> allMembers) {
        for (ExecutableElement method : ElementFilter.methodsIn(allMembers)) {
            if (!this.isAccessible(method) || !this.isSimpleAccessor(method)) continue;
            Accessor accessor = new Accessor(method);
            accesors.put(accessor.name, accessor);
        }
    }

    private boolean isAccessible(Element element) {
        return !element.getModifiers().contains((Object)Modifier.STATIC) && !element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private boolean isSimpleAccessor(ExecutableElement method) {
        return method.getParameters().isEmpty() && method.getThrownTypes().isEmpty() && method.getTypeParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID;
    }

    public LocalAccess local(String value, TypeMirror requiredVar) {
        return new LocalAccess(value, requiredVar);
    }

    public Binder binder(Implicits.ImplicitResolver implicits) {
        return new Binder(implicits);
    }

    @NotThreadSafe
    private static abstract class Cache<K, V> {
        private final Map<K, V> map = Maps.newHashMap();

        private Cache() {
        }

        protected abstract V load(K var1) throws Exception;

        final V get(K key) {
            V value = this.map.get(key);
            if (value == null) {
                try {
                    value = this.load(key);
                }
                catch (Exception ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
                this.map.put(key, value);
            }
            return value;
        }
    }

    public static class UnresolvedAccessorException
    extends RuntimeException {
        public final TypeMirror targetType;
        public final String attribute;
        public final ImmutableList<Accessor> alternatives;

        public UnresolvedAccessorException(TypeMirror targetType, String attribute, ImmutableList<Accessor> alternatives) {
            this.targetType = targetType;
            this.attribute = attribute;
            this.alternatives = alternatives;
        }

        @Override
        public String getMessage() {
            return "Unresolvable: " + this.targetType + "." + this.attribute + "\n\tAlternatives: " + this.alternatives;
        }
    }

    public final class Binder {
        private final Implicits.ImplicitResolver implicits;

        Binder(Implicits.ImplicitResolver implicits) {
            this.implicits = implicits;
        }

        public BoundAccessor bind(TypeMirror targetType, String attribute) {
            BoundAccessor accessor = this.resolveAccessorWithBeanAccessor(targetType, attribute);
            if (accessor != null) {
                return accessor;
            }
            throw new UnresolvedAccessorException(targetType, attribute, this.collectAlternatives(targetType));
        }

        @Nullable
        private BoundAccessor resolveAccessorWithBeanAccessor(TypeMirror targetType, String attribute) {
            BoundAccessor accessor = this.resolveAccessor(targetType, attribute);
            if (accessor != null) {
                return accessor;
            }
            String capitalizedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, attribute);
            accessor = this.resolveAccessor(targetType, "get" + capitalizedName);
            if (accessor != null) {
                return accessor;
            }
            accessor = this.resolveAccessor(targetType, "is" + capitalizedName);
            if (accessor != null) {
                return accessor;
            }
            accessor = this.resolveAccessor(targetType, "$$" + attribute);
            if (accessor != null) {
                return accessor;
            }
            return accessor;
        }

        @Nullable
        private BoundAccessor resolveAccessor(TypeMirror targetType, String attribute) {
            Accessor accessor = (Accessor)Accessors.this.definedBy(targetType).get((Object)attribute);
            if (accessor != null) {
                return accessor.bind(targetType);
            }
            for (TypeMirror implicit : this.implicits.resolveFor(targetType)) {
                accessor = (Accessor)Accessors.this.definedBy(implicit).get((Object)attribute);
                if (accessor == null) continue;
                return accessor.bind(implicit);
            }
            return null;
        }

        public BoundAccess bindLocalOrThis(TypeMirror type, String name, Map<String, TypeMirror> locals) {
            TypeMirror typeMirror = locals.get(name);
            if (typeMirror != null) {
                return new LocalAccess(name, typeMirror);
            }
            return this.bind(type, name);
        }

        private ImmutableList<Accessor> collectAlternatives(TypeMirror targetType) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)Accessors.this.definedBy(targetType).values());
            for (TypeMirror implicit : this.implicits.resolveFor(targetType)) {
                builder.addAll((Iterable)Accessors.this.definedBy(implicit).values());
            }
            return builder.build();
        }
    }

    public final class BoundAccessor
    extends BoundAccess {
        public final Accessor accessor;
        public final TypeMirror target;

        BoundAccessor(Accessor accessor, TypeMirror target, TypeMirror type) {
            super(type, accessor.name, accessor.callable);
            this.target = target;
            this.accessor = accessor;
        }

        public String toString() {
            return this.accessor + ": " + this.type;
        }
    }

    public final class LocalAccess
    extends BoundAccess {
        LocalAccess(String name, TypeMirror type) {
            super(type, name, false);
        }

        public String toString() {
            return "" + this.name + ": " + this.type;
        }
    }

    public abstract class BoundAccess {
        public final TypeMirror type;
        @Nullable
        public final TypeMirror containedType;
        public final String name;
        public final boolean invokable;
        public final boolean callable;
        public final boolean boxed;

        protected BoundAccess(TypeMirror type, String name, boolean callable) {
            this.name = name;
            this.callable = callable;
            this.type = this.boxed(type);
            this.boxed = this.type != type;
            this.containedType = this.boxed(this.inferContainedType(type));
            this.invokable = Accessors.this.types.isAssignable(type, Accessors.this.invokableType);
        }

        private TypeMirror boxed(TypeMirror type) {
            if (type == null) {
                return type;
            }
            Class boxedClass = null;
            switch (type.getKind()) {
                case BOOLEAN: {
                    boxedClass = Boolean.class;
                    break;
                }
                case SHORT: {
                    boxedClass = Short.class;
                    break;
                }
                case INT: {
                    boxedClass = Integer.class;
                    break;
                }
                case LONG: {
                    boxedClass = Long.class;
                    break;
                }
                case FLOAT: {
                    boxedClass = Float.class;
                    break;
                }
                case DOUBLE: {
                    boxedClass = Double.class;
                    break;
                }
                case CHAR: {
                    boxedClass = Character.class;
                    break;
                }
                case BYTE: {
                    boxedClass = Byte.class;
                    break;
                }
                case VOID: {
                    boxedClass = Void.class;
                    break;
                }
            }
            return boxedClass == null ? type : Accessors.this.elements.getTypeElement(boxedClass.getName()).asType();
        }

        public boolean isContainer() {
            return this.containedType != null;
        }

        @Nullable
        private TypeMirror inferContainedType(TypeMirror type) {
            DeclaredType declaredType;
            if (type.getKind() == TypeKind.DECLARED && (this.isIterableType(declaredType = (DeclaredType)type) || this.isOptionalType(declaredType))) {
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                return typeArguments.size() == 1 ? this.upperBound(typeArguments.get(0)) : Accessors.this.objectType;
            }
            if (type instanceof ArrayType) {
                return this.upperBound(((ArrayType)type).getComponentType());
            }
            return null;
        }

        private TypeMirror upperBound(TypeMirror type) {
            switch (type.getKind()) {
                case WILDCARD: {
                    return (TypeMirror)MoreObjects.firstNonNull((Object)((WildcardType)type).getExtendsBound(), (Object)Accessors.this.objectType);
                }
                case TYPEVAR: {
                    return ((TypeVariable)type).getUpperBound();
                }
            }
            return type;
        }

        private boolean isIterableType(TypeMirror type) {
            return Accessors.this.types.isSubtype(Accessors.this.types.erasure(type), Accessors.this.iterableTypeErasure);
        }

        private boolean isOptionalType(DeclaredType parametrizedType) {
            return parametrizedType.asElement().getSimpleName().contentEquals(OPTIONAL_TYPE_SIMPLE_NAME) && parametrizedType.getTypeArguments().size() == 1;
        }
    }

    public final class Accessor {
        public final Element element;
        public final String name;
        public final boolean callable;

        Accessor(Element element) {
            this.element = element;
            this.name = element.getSimpleName().toString();
            this.callable = element.getKind() == ElementKind.METHOD;
        }

        final BoundAccessor bind(TypeMirror target) {
            TypeMirror type = Accessors.this.types.asMemberOf((DeclaredType)target, this.element);
            if (type instanceof ExecutableType) {
                type = ((ExecutableType)type).getReturnType();
            }
            return new BoundAccessor(this, target, type);
        }

        public String toString() {
            return this.element.getEnclosingElement().getSimpleName() + "." + this.name + "" + (this.callable ? "()" : "");
        }
    }
}

