/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

public final class Balancing {
    private static final TreesTransformer<Void> TRANSFORMER = new TreesTransformer<Void>(){

        @Override
        public ImmutableTrees.Template transform(Void context, ImmutableTrees.Template template) {
            return new TemplateScope(template).balance();
        }
    };

    private Balancing() {
    }

    public static ImmutableTrees.Unit balance(ImmutableTrees.Unit unit) {
        return TRANSFORMER.transform((Void)null, unit);
    }

    private static class IfScope
    extends BlockScope {
        private final ImmutableTrees.If directive;
        private final ImmutableTrees.IfStatement.Builder builder;
        @Nullable
        private ImmutableTrees.ElseIf currentElseIf;
        @Nullable
        private ImmutableTrees.Else currentElse;

        IfScope(Scope parent, ImmutableTrees.If directive) {
            super(parent, ImmutableTrees.IfEnd.of(), true, false);
            this.directive = directive;
            this.builder = ImmutableTrees.IfStatement.builder();
        }

        @Override
        void add(Trees.TemplatePart part) {
            if (part instanceof ImmutableTrees.ElseIf || part instanceof ImmutableTrees.Else) {
                if (this.currentElse != null) {
                    throw new MisplacedDirective(this, (Trees.Directive)part);
                }
                this.flushBlock();
                if (part instanceof ImmutableTrees.ElseIf) {
                    this.currentElseIf = (ImmutableTrees.ElseIf)part;
                } else if (part instanceof ImmutableTrees.Else) {
                    this.currentElse = (ImmutableTrees.Else)part;
                }
            } else {
                super.add(part);
            }
        }

        @Override
        boolean incorrect(Trees.TemplatePart part) {
            return false;
        }

        private void flushBlock() {
            if (this.currentElse != null) {
                this.builder.otherwise(ImmutableTrees.Block.builder().addAllParts(this.parts).build());
            } else if (this.currentElseIf != null) {
                this.builder.addOtherwiseIf((Trees.ConditionalBlock)ImmutableTrees.ConditionalBlock.builder().condition(this.currentElseIf.condition()).addAllParts(this.parts).build());
            } else {
                this.builder.then(ImmutableTrees.ConditionalBlock.builder().condition(this.directive.condition()).addAllParts(this.parts).build());
            }
            this.parts.clear();
        }

        @Override
        ImmutableTrees.IfStatement createPart() {
            this.flushBlock();
            return this.builder.build();
        }
    }

    private static class InvokeScope
    extends BlockScope {
        private final ImmutableTrees.Invoke directive;

        InvokeScope(Scope parent, ImmutableTrees.Invoke directive) {
            super(parent, ImmutableTrees.InvokeEnd.of(directive.access()), false, false);
            this.directive = directive;
        }

        @Override
        ImmutableTrees.InvokeStatement createPart() {
            return ImmutableTrees.InvokeStatement.builder().access(this.directive.access()).addAllParams((Iterable<? extends Trees.Expression>)(this.directive.invoke().isPresent() ? ((Trees.ApplyExpression)this.directive.invoke().get()).params() : ImmutableList.of())).addAllParts(this.parts).build();
        }
    }

    private static class LetScope
    extends BlockScope {
        private final ImmutableTrees.Let directive;

        LetScope(Scope parent, ImmutableTrees.Let directive) {
            super(parent, ImmutableTrees.LetEnd.of(), true, false);
            this.directive = directive;
        }

        @Override
        ImmutableTrees.LetStatement createPart() {
            return ImmutableTrees.LetStatement.builder().declaration(this.directive.declaration()).addAllParts(this.parts).build();
        }
    }

    private static class ForScope
    extends BlockScope {
        private final ImmutableTrees.For directive;

        ForScope(Scope parent, ImmutableTrees.For directive) {
            super(parent, ImmutableTrees.ForEnd.of(), true, false);
            this.directive = directive;
        }

        @Override
        ImmutableTrees.ForStatement createPart() {
            return ImmutableTrees.ForStatement.builder().addAllDeclaration((Iterable<? extends Trees.GeneratorDeclaration>)this.directive.declaration()).addAllParts(this.parts).build();
        }
    }

    private static abstract class BlockScope
    extends Scope {
        private final Trees.DirectiveEnd expectedEnd;
        private final boolean requiresEnd;
        private final boolean sharesEnd;
        final Scope parent;

        BlockScope(Scope parent, Trees.DirectiveEnd expectedEnd, boolean requiresEnd, boolean sharesEnd) {
            this.parent = parent;
            this.expectedEnd = expectedEnd;
            this.requiresEnd = requiresEnd;
            this.sharesEnd = sharesEnd;
        }

        abstract Trees.TemplatePart createPart();

        @Override
        boolean incorrect(Trees.TemplatePart part) {
            return part instanceof Trees.Otherwise;
        }

        @Override
        Scope correct(Trees.TemplatePart part) {
            return this.splat(part);
        }

        @Override
        final Scope end(Trees.DirectiveEnd directiveEnd) {
            if (this.expectedEnd.equals(directiveEnd)) {
                Scope scope = this.parent.pass(this.createPart());
                return this.sharesEnd ? scope.end(directiveEnd) : scope;
            }
            if (!this.requiresEnd) {
                return this.splat(directiveEnd);
            }
            throw new MisplacedDirective(this, directiveEnd);
        }

        private Scope splat(Trees.TemplatePart part) {
            List parts = this.parts;
            this.parts = Lists.newArrayList();
            return this.parent.pass(this.createPart()).passAll(parts).pass(part);
        }
    }

    private static final class MisplacedDirective
    extends RuntimeException {
        private final Trees.Directive directive;
        private final Scope scope;

        MisplacedDirective(Scope scope, Trees.Directive directive) {
            this.scope = scope;
            this.directive = directive;
        }

        @Override
        public String getMessage() {
            return "Misplaced directive: " + this.directive + " in " + this.scope;
        }
    }

    private static final class TemplateScope
    extends BlockScope {
        private final ImmutableTrees.Template template;

        TemplateScope(ImmutableTrees.Template template) {
            super(new UnitScope(), ImmutableTrees.TemplateEnd.of(), true, false);
            this.template = template;
        }

        ImmutableTrees.Template balance() {
            Scope scope = this.passAll((Iterable<Trees.TemplatePart>)this.template.parts()).pass(ImmutableTrees.TemplateEnd.of());
            if (scope != this.parent) {
                throw new MisplacedDirective(this, ImmutableTrees.TemplateEnd.of());
            }
            return this.createPart();
        }

        @Override
        void add(Trees.TemplatePart part) {
            if (!(part instanceof ImmutableTrees.TemplateEnd)) {
                super.add(part);
            }
        }

        @Override
        ImmutableTrees.Template createPart() {
            return this.template.withParts(this.parts);
        }
    }

    private static final class UnitScope
    extends Scope {
        private UnitScope() {
        }

        @Override
        Scope end(Trees.DirectiveEnd directiveEnd) {
            return this;
        }

        @Override
        boolean incorrect(Trees.TemplatePart part) {
            return part == null;
        }

        @Override
        Scope correct(Trees.TemplatePart part) {
            return this;
        }
    }

    private static abstract class Scope {
        List<Trees.TemplatePart> parts = Lists.newArrayList();

        private Scope() {
        }

        final Scope pass(Trees.TemplatePart part) {
            if (part instanceof Trees.DirectiveStart) {
                return this.nextOrAdd((Trees.DirectiveStart)part);
            }
            if (part instanceof Trees.DirectiveEnd) {
                return this.end((Trees.DirectiveEnd)part);
            }
            if (this.incorrect(part)) {
                return this.correct(part);
            }
            this.add(part);
            return this;
        }

        Scope nextOrAdd(Trees.DirectiveStart part) {
            Scope next = this.next(part);
            if (next == this) {
                this.add(part);
            }
            return next;
        }

        Scope correct(Trees.TemplatePart part) {
            return this;
        }

        boolean incorrect(Trees.TemplatePart part) {
            return false;
        }

        void add(Trees.TemplatePart part) {
            this.parts.add(part);
        }

        abstract Scope end(Trees.DirectiveEnd var1);

        final Scope passAll(Iterable<Trees.TemplatePart> parts) {
            Scope scope = this;
            for (Trees.TemplatePart part : parts) {
                scope = scope.pass(part);
            }
            return scope;
        }

        final Scope next(Trees.DirectiveStart directive) {
            if (directive instanceof ImmutableTrees.If) {
                return new IfScope(this, (ImmutableTrees.If)directive);
            }
            if (directive instanceof ImmutableTrees.For) {
                return new ForScope(this, (ImmutableTrees.For)directive);
            }
            if (directive instanceof ImmutableTrees.Let) {
                return new LetScope(this, (ImmutableTrees.Let)directive);
            }
            if (directive instanceof ImmutableTrees.Invoke) {
                return new InvokeScope(this, (ImmutableTrees.Invoke)directive);
            }
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue(this.parts).toString();
        }
    }
}

