/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.immutables.generator.Implicit;
import org.immutables.generator.processor.Introspection;

public class Implicits
extends Introspection {
    private final TypeMirror implicitTypeErasure;

    Implicits(ProcessingEnvironment environment) {
        super(environment);
        this.implicitTypeErasure = this.types.erasure(this.elements.getTypeElement(Implicit.class.getName()).asType());
    }

    public ImplicitResolver resolverFrom(final Iterable<? extends TypeMirror> imports) {
        return new ImplicitResolver(){
            ListMultimap<TypeMirror, TypeMirror> mappings;
            {
                this.mappings = Implicits.this.buildImplicitMappingFrom(imports);
            }

            @Override
            public List<TypeMirror> resolveFor(TypeMirror typeMirror) {
                return this.mappings.get((Object)typeMirror);
            }
        };
    }

    private ImmutableListMultimap<TypeMirror, TypeMirror> buildImplicitMappingFrom(Iterable<? extends TypeMirror> imports) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (TypeMirror typeMirror : imports) {
            if (!this.types.isSubtype(this.checkDeclaredType(typeMirror), this.implicitTypeErasure)) continue;
            for (TypeMirror typeMirror2 : this.types.directSupertypes(typeMirror)) {
                if (!this.types.isSubtype(typeMirror2, this.implicitTypeErasure)) continue;
                TypeMirror targetType = this.getTargetTypeArgument(typeMirror2);
                builder.put((Object)targetType, (Object)typeMirror);
            }
        }
        return builder.build();
    }

    private TypeMirror getTargetTypeArgument(TypeMirror facetTypeSupertype) {
        TypeMirror typeArgument = (TypeMirror)Iterables.getOnlyElement(this.checkDeclaredType(facetTypeSupertype).getTypeArguments());
        if (typeArgument instanceof TypeVariable) {
            return ((TypeVariable)typeArgument).getUpperBound();
        }
        return typeArgument;
    }

    private DeclaredType checkDeclaredType(TypeMirror type) {
        Preconditions.checkState((type.getKind() == TypeKind.DECLARED ? 1 : 0) != 0, (String)"'%s' should have been a declared type", (Object[])new Object[]{type});
        return (DeclaredType)type;
    }

    public static interface ImplicitResolver {
        public List<TypeMirror> resolveFor(TypeMirror var1);
    }
}

