/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

public final class Spacing {
    private static final TreesTransformer<Void> TRANSFORMER = new TreesTransformer<Void>(){

        @Override
        protected Iterable<Trees.TemplatePart> transformTemplateListParts(Void context, ImmutableTrees.Template value, final List<Trees.TemplatePart> parts) {
            final ArrayList results = Lists.newArrayList();
            class Normalizer {
                @Nullable
                ImmutableTrees.TextFragment fragment;

                Normalizer() {
                }

                void collect() {
                    for (Trees.TemplatePart part : parts) {
                        if (part instanceof ImmutableTrees.TextBlock) {
                            ImmutableTrees.TextBlock block = (ImmutableTrees.TextBlock)part;
                            for (Trees.TextPart text : block.parts()) {
                                if (text instanceof ImmutableTrees.TextFragment) {
                                    this.flushFragment();
                                    this.fragment = (ImmutableTrees.TextFragment)text;
                                }
                                if (!(text instanceof ImmutableTrees.Newline)) continue;
                                this.flushNewline();
                            }
                            continue;
                        }
                        this.flushFragment();
                        results.add(part);
                    }
                    this.flushFragment();
                }

                void flushFragment() {
                    if (this.fragment != null && !this.fragment.value().isEmpty()) {
                        results.add(ImmutableTrees.TextLine.builder().fragment(this.fragment).build());
                    }
                    this.fragment = null;
                }

                void flushNewline() {
                    results.add(ImmutableTrees.TextLine.builder().fragment(this.fragment != null ? this.fragment : ImmutableTrees.TextFragment.of("")).newline(true).build());
                    this.fragment = null;
                }
            }
            new Normalizer().collect();
            return results;
        }
    };

    private Spacing() {
    }

    public static ImmutableTrees.Unit normalize(ImmutableTrees.Unit unit) {
        return TRANSFORMER.transform((Void)null, unit);
    }
}

