/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;

@ParametersAreNonnullByDefault
public abstract class TreesTransformer<C> {
    protected TreesTransformer() {
    }

    public ImmutableTrees.Identifier transform(C context, ImmutableTrees.Identifier value) {
        return value.withValue(this.transformIdentifierValue(context, value, value.value()));
    }

    protected String transformIdentifierValue(C context, ImmutableTrees.Identifier value, String element) {
        return element;
    }

    public ImmutableTrees.TypeIdentifier transform(C context, ImmutableTrees.TypeIdentifier value) {
        return value.withValue(this.transformTypeIdentifierValue(context, value, value.value()));
    }

    protected String transformTypeIdentifierValue(C context, ImmutableTrees.TypeIdentifier value, String element) {
        return element;
    }

    public ImmutableTrees.TypeDeclaration transform(C context, ImmutableTrees.TypeDeclaration value) {
        return value.withType(this.transformTypeDeclarationType(context, value, value.type())).withKind(this.transformTypeDeclarationKind(context, value, value.kind()));
    }

    protected Trees.TypeIdentifier transformTypeDeclarationType(C context, ImmutableTrees.TypeDeclaration value, Trees.TypeIdentifier element) {
        if (element instanceof ImmutableTrees.TypeIdentifier) {
            return this.transformTypeIdentifier(context, (ImmutableTrees.TypeIdentifier)element);
        }
        return element;
    }

    protected Trees.TypeDeclaration.Kind transformTypeDeclarationKind(C context, ImmutableTrees.TypeDeclaration value, Trees.TypeDeclaration.Kind element) {
        return element;
    }

    public ImmutableTrees.ResolvedType transform(C context, ImmutableTrees.ResolvedType value) {
        return value.withType(this.transformResolvedTypeType(context, value, value.type()));
    }

    protected Object transformResolvedTypeType(C context, ImmutableTrees.ResolvedType value, Object element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformObject(context, (ImmutableTrees.Identifier)element);
        }
        if (element instanceof ImmutableTrees.TypeIdentifier) {
            return this.transformObject(context, (ImmutableTrees.TypeIdentifier)element);
        }
        if (element instanceof ImmutableTrees.TypeDeclaration) {
            return this.transformObject(context, (ImmutableTrees.TypeDeclaration)element);
        }
        if (element instanceof ImmutableTrees.ResolvedType) {
            return this.transformObject(context, (ImmutableTrees.ResolvedType)element);
        }
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformObject(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformObject(context, (ImmutableTrees.StringLiteral)element);
        }
        if (element instanceof ImmutableTrees.Newline) {
            return this.transformObject(context, (ImmutableTrees.Newline)element);
        }
        if (element instanceof ImmutableTrees.TextFragment) {
            return this.transformObject(context, (ImmutableTrees.TextFragment)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformObject(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    public ImmutableTrees.BoundAccessExpression transform(C context, ImmutableTrees.BoundAccessExpression value) {
        return value.withAccessor(this.transformBoundAccessExpressionListAccessor(context, value, (List<Object>)value.accessor())).withPath(this.transformBoundAccessExpressionListPath(context, value, (List<Trees.Identifier>)value.path()));
    }

    protected Iterable<Object> transformBoundAccessExpressionListAccessor(C context, ImmutableTrees.BoundAccessExpression value, List<Object> collection) {
        ArrayList list = Lists.newArrayList();
        for (Object element : collection) {
            list.add(this.transformBoundAccessExpressionAccessor(context, value, element));
        }
        return list;
    }

    protected Object transformBoundAccessExpressionAccessor(C context, ImmutableTrees.BoundAccessExpression value, Object element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformObject(context, (ImmutableTrees.Identifier)element);
        }
        if (element instanceof ImmutableTrees.TypeIdentifier) {
            return this.transformObject(context, (ImmutableTrees.TypeIdentifier)element);
        }
        if (element instanceof ImmutableTrees.TypeDeclaration) {
            return this.transformObject(context, (ImmutableTrees.TypeDeclaration)element);
        }
        if (element instanceof ImmutableTrees.ResolvedType) {
            return this.transformObject(context, (ImmutableTrees.ResolvedType)element);
        }
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformObject(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformObject(context, (ImmutableTrees.StringLiteral)element);
        }
        if (element instanceof ImmutableTrees.Newline) {
            return this.transformObject(context, (ImmutableTrees.Newline)element);
        }
        if (element instanceof ImmutableTrees.TextFragment) {
            return this.transformObject(context, (ImmutableTrees.TextFragment)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformObject(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    protected Iterable<Trees.Identifier> transformBoundAccessExpressionListPath(C context, ImmutableTrees.BoundAccessExpression value, List<Trees.Identifier> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Identifier element : collection) {
            list.add(this.transformBoundAccessExpressionPath(context, value, element));
        }
        return list;
    }

    protected Trees.Identifier transformBoundAccessExpressionPath(C context, ImmutableTrees.BoundAccessExpression value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    public ImmutableTrees.InvokableDeclaration transform(C context, ImmutableTrees.InvokableDeclaration value) {
        return value.withParameters(this.transformInvokableDeclarationListParameters(context, value, (List<Trees.Parameter>)value.parameters())).withName(this.transformInvokableDeclarationName(context, value, value.name()));
    }

    protected Iterable<Trees.Parameter> transformInvokableDeclarationListParameters(C context, ImmutableTrees.InvokableDeclaration value, List<Trees.Parameter> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Parameter element : collection) {
            list.add(this.transformInvokableDeclarationParameters(context, value, element));
        }
        return list;
    }

    protected Trees.Parameter transformInvokableDeclarationParameters(C context, ImmutableTrees.InvokableDeclaration value, Trees.Parameter element) {
        if (element instanceof ImmutableTrees.Parameter) {
            return this.transformParameter(context, (ImmutableTrees.Parameter)element);
        }
        return element;
    }

    protected Trees.Identifier transformInvokableDeclarationName(C context, ImmutableTrees.InvokableDeclaration value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    public ImmutableTrees.ValueDeclaration transform(C context, ImmutableTrees.ValueDeclaration value) {
        return value.withType(this.transformValueDeclarationOptionalType(context, value, value.type())).withContainedType(this.transformValueDeclarationOptionalContainedType(context, value, value.containedType())).withName(this.transformValueDeclarationName(context, value, value.name()));
    }

    protected Optional<Trees.TypeReference> transformValueDeclarationOptionalType(C context, ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformValueDeclarationType(context, value, (Trees.TypeReference)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.TypeReference transformValueDeclarationType(C context, ImmutableTrees.ValueDeclaration value, Trees.TypeReference element) {
        if (element instanceof ImmutableTrees.TypeDeclaration) {
            return this.transformTypeReference(context, (ImmutableTrees.TypeDeclaration)element);
        }
        if (element instanceof ImmutableTrees.ResolvedType) {
            return this.transformTypeReference(context, (ImmutableTrees.ResolvedType)element);
        }
        return element;
    }

    protected Optional<Trees.TypeReference> transformValueDeclarationOptionalContainedType(C context, ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformValueDeclarationContainedType(context, value, (Trees.TypeReference)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.TypeReference transformValueDeclarationContainedType(C context, ImmutableTrees.ValueDeclaration value, Trees.TypeReference element) {
        if (element instanceof ImmutableTrees.TypeDeclaration) {
            return this.transformTypeReference(context, (ImmutableTrees.TypeDeclaration)element);
        }
        if (element instanceof ImmutableTrees.ResolvedType) {
            return this.transformTypeReference(context, (ImmutableTrees.ResolvedType)element);
        }
        return element;
    }

    protected Trees.Identifier transformValueDeclarationName(C context, ImmutableTrees.ValueDeclaration value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    public ImmutableTrees.Parameter transform(C context, ImmutableTrees.Parameter value) {
        return value.withName(this.transformParameterName(context, value, value.name())).withType(this.transformParameterType(context, value, value.type()));
    }

    protected Trees.Identifier transformParameterName(C context, ImmutableTrees.Parameter value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    protected Trees.TypeReference transformParameterType(C context, ImmutableTrees.Parameter value, Trees.TypeReference element) {
        if (element instanceof ImmutableTrees.TypeDeclaration) {
            return this.transformTypeReference(context, (ImmutableTrees.TypeDeclaration)element);
        }
        if (element instanceof ImmutableTrees.ResolvedType) {
            return this.transformTypeReference(context, (ImmutableTrees.ResolvedType)element);
        }
        return element;
    }

    public ImmutableTrees.Block transform(C context, ImmutableTrees.Block value) {
        return value.withParts(this.transformBlockListParts(context, value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Iterable<Trees.TemplatePart> transformBlockListParts(C context, ImmutableTrees.Block value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformBlockParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformBlockParts(C context, ImmutableTrees.Block value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    public ImmutableTrees.Comment transform(C context, ImmutableTrees.Comment value) {
        return value;
    }

    public ImmutableTrees.ConditionalBlock transform(C context, ImmutableTrees.ConditionalBlock value) {
        return value.withCondition(this.transformConditionalBlockCondition(context, value, value.condition())).withParts(this.transformConditionalBlockListParts(context, value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Trees.Expression transformConditionalBlockCondition(C context, ImmutableTrees.ConditionalBlock value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Iterable<Trees.TemplatePart> transformConditionalBlockListParts(C context, ImmutableTrees.ConditionalBlock value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformConditionalBlockParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformConditionalBlockParts(C context, ImmutableTrees.ConditionalBlock value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    public ImmutableTrees.IfStatement transform(C context, ImmutableTrees.IfStatement value) {
        return value.withThen(this.transformIfStatementThen(context, value, value.then())).withOtherwiseIf(this.transformIfStatementListOtherwiseIf(context, value, (List<Trees.ConditionalBlock>)value.otherwiseIf())).withOtherwise(this.transformIfStatementOptionalOtherwise(context, value, value.otherwise()));
    }

    protected Trees.ConditionalBlock transformIfStatementThen(C context, ImmutableTrees.IfStatement value, Trees.ConditionalBlock element) {
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformConditionalBlock(context, (ImmutableTrees.ConditionalBlock)element);
        }
        return element;
    }

    protected Iterable<Trees.ConditionalBlock> transformIfStatementListOtherwiseIf(C context, ImmutableTrees.IfStatement value, List<Trees.ConditionalBlock> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.ConditionalBlock element : collection) {
            list.add(this.transformIfStatementOtherwiseIf(context, value, element));
        }
        return list;
    }

    protected Trees.ConditionalBlock transformIfStatementOtherwiseIf(C context, ImmutableTrees.IfStatement value, Trees.ConditionalBlock element) {
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformConditionalBlock(context, (ImmutableTrees.ConditionalBlock)element);
        }
        return element;
    }

    protected Optional<Trees.Block> transformIfStatementOptionalOtherwise(C context, ImmutableTrees.IfStatement value, Optional<Trees.Block> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformIfStatementOtherwise(context, value, (Trees.Block)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.Block transformIfStatementOtherwise(C context, ImmutableTrees.IfStatement value, Trees.Block element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformBlock(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformBlock(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformBlock(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformBlock(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformBlock(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformBlock(context, (ImmutableTrees.Template)element);
        }
        return element;
    }

    public ImmutableTrees.ForStatement transform(C context, ImmutableTrees.ForStatement value) {
        return value.withDeclaration(this.transformForStatementListDeclaration(context, value, (List<Trees.GeneratorDeclaration>)value.declaration())).withParts(this.transformForStatementListParts(context, value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Iterable<Trees.GeneratorDeclaration> transformForStatementListDeclaration(C context, ImmutableTrees.ForStatement value, List<Trees.GeneratorDeclaration> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.GeneratorDeclaration element : collection) {
            list.add(this.transformForStatementDeclaration(context, value, element));
        }
        return list;
    }

    protected Trees.GeneratorDeclaration transformForStatementDeclaration(C context, ImmutableTrees.ForStatement value, Trees.GeneratorDeclaration element) {
        if (element instanceof ImmutableTrees.AssignGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.AssignGenerator)element);
        }
        if (element instanceof ImmutableTrees.IterationGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.IterationGenerator)element);
        }
        if (element instanceof ImmutableTrees.TransformGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.TransformGenerator)element);
        }
        return element;
    }

    protected Iterable<Trees.TemplatePart> transformForStatementListParts(C context, ImmutableTrees.ForStatement value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformForStatementParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformForStatementParts(C context, ImmutableTrees.ForStatement value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    public ImmutableTrees.ForIterationAccessExpression transform(C context, ImmutableTrees.ForIterationAccessExpression value) {
        return value.withAccess(this.transformForIterationAccessExpressionAccess(context, value, value.access())).withPath(this.transformForIterationAccessExpressionListPath(context, value, (List<Trees.Identifier>)value.path()));
    }

    protected Trees.AccessExpression transformForIterationAccessExpressionAccess(C context, ImmutableTrees.ForIterationAccessExpression value, Trees.AccessExpression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        return element;
    }

    protected Iterable<Trees.Identifier> transformForIterationAccessExpressionListPath(C context, ImmutableTrees.ForIterationAccessExpression value, List<Trees.Identifier> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Identifier element : collection) {
            list.add(this.transformForIterationAccessExpressionPath(context, value, element));
        }
        return list;
    }

    protected Trees.Identifier transformForIterationAccessExpressionPath(C context, ImmutableTrees.ForIterationAccessExpression value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    public ImmutableTrees.LetStatement transform(C context, ImmutableTrees.LetStatement value) {
        return value.withParts(this.transformLetStatementListParts(context, value, (List<Trees.TemplatePart>)value.parts())).withDeclaration(this.transformLetStatementDeclaration(context, value, value.declaration()));
    }

    protected Iterable<Trees.TemplatePart> transformLetStatementListParts(C context, ImmutableTrees.LetStatement value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformLetStatementParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformLetStatementParts(C context, ImmutableTrees.LetStatement value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    protected Trees.InvokableDeclaration transformLetStatementDeclaration(C context, ImmutableTrees.LetStatement value, Trees.InvokableDeclaration element) {
        if (element instanceof ImmutableTrees.InvokableDeclaration) {
            return this.transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration)element);
        }
        return element;
    }

    public ImmutableTrees.InvokeStatement transform(C context, ImmutableTrees.InvokeStatement value) {
        return value.withAccess(this.transformInvokeStatementAccess(context, value, value.access())).withParams(this.transformInvokeStatementListParams(context, value, (List<Trees.Expression>)value.params())).withParts(this.transformInvokeStatementListParts(context, value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Trees.Expression transformInvokeStatementAccess(C context, ImmutableTrees.InvokeStatement value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Iterable<Trees.Expression> transformInvokeStatementListParams(C context, ImmutableTrees.InvokeStatement value, List<Trees.Expression> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Expression element : collection) {
            list.add(this.transformInvokeStatementParams(context, value, element));
        }
        return list;
    }

    protected Trees.Expression transformInvokeStatementParams(C context, ImmutableTrees.InvokeStatement value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Iterable<Trees.TemplatePart> transformInvokeStatementListParts(C context, ImmutableTrees.InvokeStatement value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformInvokeStatementParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformInvokeStatementParts(C context, ImmutableTrees.InvokeStatement value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    public ImmutableTrees.LetEnd transform(C context, ImmutableTrees.LetEnd value) {
        return value;
    }

    public ImmutableTrees.ForEnd transform(C context, ImmutableTrees.ForEnd value) {
        return value;
    }

    public ImmutableTrees.IfEnd transform(C context, ImmutableTrees.IfEnd value) {
        return value;
    }

    public ImmutableTrees.InvokeEnd transform(C context, ImmutableTrees.InvokeEnd value) {
        return value.withAccess(this.transformInvokeEndAccess(context, value, value.access()));
    }

    protected Trees.AccessExpression transformInvokeEndAccess(C context, ImmutableTrees.InvokeEnd value, Trees.AccessExpression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        return element;
    }

    public ImmutableTrees.InvokeString transform(C context, ImmutableTrees.InvokeString value) {
        return value.withLiteral(this.transformInvokeStringLiteral(context, value, value.literal()));
    }

    protected Trees.StringLiteral transformInvokeStringLiteral(C context, ImmutableTrees.InvokeString value, Trees.StringLiteral element) {
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformStringLiteral(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.Invoke transform(C context, ImmutableTrees.Invoke value) {
        return value.withAccess(this.transformInvokeAccess(context, value, value.access())).withInvoke(this.transformInvokeOptionalInvoke(context, value, value.invoke()));
    }

    protected Trees.AccessExpression transformInvokeAccess(C context, ImmutableTrees.Invoke value, Trees.AccessExpression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformAccessExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        return element;
    }

    protected Optional<Trees.ApplyExpression> transformInvokeOptionalInvoke(C context, ImmutableTrees.Invoke value, Optional<Trees.ApplyExpression> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformInvokeInvoke(context, value, (Trees.ApplyExpression)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.ApplyExpression transformInvokeInvoke(C context, ImmutableTrees.Invoke value, Trees.ApplyExpression element) {
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformApplyExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        return element;
    }

    public ImmutableTrees.Let transform(C context, ImmutableTrees.Let value) {
        return value.withDeclaration(this.transformLetDeclaration(context, value, value.declaration()));
    }

    protected Trees.InvokableDeclaration transformLetDeclaration(C context, ImmutableTrees.Let value, Trees.InvokableDeclaration element) {
        if (element instanceof ImmutableTrees.InvokableDeclaration) {
            return this.transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration)element);
        }
        return element;
    }

    public ImmutableTrees.Unit transform(C context, ImmutableTrees.Unit value) {
        return value.withParts(this.transformUnitListParts(context, value, (List<Trees.UnitPart>)value.parts()));
    }

    protected Iterable<Trees.UnitPart> transformUnitListParts(C context, ImmutableTrees.Unit value, List<Trees.UnitPart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.UnitPart element : collection) {
            list.add(this.transformUnitParts(context, value, element));
        }
        return list;
    }

    protected Trees.UnitPart transformUnitParts(C context, ImmutableTrees.Unit value, Trees.UnitPart element) {
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformUnitPart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformUnitPart(context, (ImmutableTrees.Template)element);
        }
        return element;
    }

    public ImmutableTrees.Template transform(C context, ImmutableTrees.Template value) {
        return value.withParts(this.transformTemplateListParts(context, value, (List<Trees.TemplatePart>)value.parts())).withDeclaration(this.transformTemplateDeclaration(context, value, value.declaration()));
    }

    protected Iterable<Trees.TemplatePart> transformTemplateListParts(C context, ImmutableTrees.Template value, List<Trees.TemplatePart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TemplatePart element : collection) {
            list.add(this.transformTemplateParts(context, value, element));
        }
        return list;
    }

    protected Trees.TemplatePart transformTemplateParts(C context, ImmutableTrees.Template value, Trees.TemplatePart element) {
        if (element instanceof ImmutableTrees.Block) {
            return this.transformTemplatePart(context, (ImmutableTrees.Block)element);
        }
        if (element instanceof ImmutableTrees.Comment) {
            return this.transformTemplatePart(context, (ImmutableTrees.Comment)element);
        }
        if (element instanceof ImmutableTrees.ConditionalBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.ConditionalBlock)element);
        }
        if (element instanceof ImmutableTrees.IfStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfStatement)element);
        }
        if (element instanceof ImmutableTrees.ForStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForStatement)element);
        }
        if (element instanceof ImmutableTrees.LetStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetStatement)element);
        }
        if (element instanceof ImmutableTrees.InvokeStatement) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeStatement)element);
        }
        if (element instanceof ImmutableTrees.LetEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.LetEnd)element);
        }
        if (element instanceof ImmutableTrees.ForEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.ForEnd)element);
        }
        if (element instanceof ImmutableTrees.IfEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.IfEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeEnd)element);
        }
        if (element instanceof ImmutableTrees.InvokeString) {
            return this.transformTemplatePart(context, (ImmutableTrees.InvokeString)element);
        }
        if (element instanceof ImmutableTrees.Invoke) {
            return this.transformTemplatePart(context, (ImmutableTrees.Invoke)element);
        }
        if (element instanceof ImmutableTrees.Let) {
            return this.transformTemplatePart(context, (ImmutableTrees.Let)element);
        }
        if (element instanceof ImmutableTrees.Template) {
            return this.transformTemplatePart(context, (ImmutableTrees.Template)element);
        }
        if (element instanceof ImmutableTrees.For) {
            return this.transformTemplatePart(context, (ImmutableTrees.For)element);
        }
        if (element instanceof ImmutableTrees.If) {
            return this.transformTemplatePart(context, (ImmutableTrees.If)element);
        }
        if (element instanceof ImmutableTrees.ElseIf) {
            return this.transformTemplatePart(context, (ImmutableTrees.ElseIf)element);
        }
        if (element instanceof ImmutableTrees.Else) {
            return this.transformTemplatePart(context, (ImmutableTrees.Else)element);
        }
        if (element instanceof ImmutableTrees.TemplateEnd) {
            return this.transformTemplatePart(context, (ImmutableTrees.TemplateEnd)element);
        }
        if (element instanceof ImmutableTrees.TextBlock) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextBlock)element);
        }
        if (element instanceof ImmutableTrees.TextLine) {
            return this.transformTemplatePart(context, (ImmutableTrees.TextLine)element);
        }
        return element;
    }

    protected Trees.InvokableDeclaration transformTemplateDeclaration(C context, ImmutableTrees.Template value, Trees.InvokableDeclaration element) {
        if (element instanceof ImmutableTrees.InvokableDeclaration) {
            return this.transformInvokableDeclaration(context, (ImmutableTrees.InvokableDeclaration)element);
        }
        return element;
    }

    public ImmutableTrees.AccessExpression transform(C context, ImmutableTrees.AccessExpression value) {
        return value.withPath(this.transformAccessExpressionListPath(context, value, (List<Trees.Identifier>)value.path()));
    }

    protected Iterable<Trees.Identifier> transformAccessExpressionListPath(C context, ImmutableTrees.AccessExpression value, List<Trees.Identifier> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Identifier element : collection) {
            list.add(this.transformAccessExpressionPath(context, value, element));
        }
        return list;
    }

    protected Trees.Identifier transformAccessExpressionPath(C context, ImmutableTrees.AccessExpression value, Trees.Identifier element) {
        if (element instanceof ImmutableTrees.Identifier) {
            return this.transformIdentifier(context, (ImmutableTrees.Identifier)element);
        }
        return element;
    }

    public ImmutableTrees.ApplyExpression transform(C context, ImmutableTrees.ApplyExpression value) {
        return value.withParams(this.transformApplyExpressionListParams(context, value, (List<Trees.Expression>)value.params()));
    }

    protected Iterable<Trees.Expression> transformApplyExpressionListParams(C context, ImmutableTrees.ApplyExpression value, List<Trees.Expression> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.Expression element : collection) {
            list.add(this.transformApplyExpressionParams(context, value, element));
        }
        return list;
    }

    protected Trees.Expression transformApplyExpressionParams(C context, ImmutableTrees.ApplyExpression value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.AssignGenerator transform(C context, ImmutableTrees.AssignGenerator value) {
        return value.withDeclaration(this.transformAssignGeneratorDeclaration(context, value, value.declaration())).withFrom(this.transformAssignGeneratorFrom(context, value, value.from()));
    }

    protected Trees.ValueDeclaration transformAssignGeneratorDeclaration(C context, ImmutableTrees.AssignGenerator value, Trees.ValueDeclaration element) {
        if (element instanceof ImmutableTrees.ValueDeclaration) {
            return this.transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration)element);
        }
        return element;
    }

    protected Trees.Expression transformAssignGeneratorFrom(C context, ImmutableTrees.AssignGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.IterationGenerator transform(C context, ImmutableTrees.IterationGenerator value) {
        return value.withCondition(this.transformIterationGeneratorOptionalCondition(context, value, value.condition())).withDeclaration(this.transformIterationGeneratorDeclaration(context, value, value.declaration())).withFrom(this.transformIterationGeneratorFrom(context, value, value.from()));
    }

    protected Optional<Trees.Expression> transformIterationGeneratorOptionalCondition(C context, ImmutableTrees.IterationGenerator value, Optional<Trees.Expression> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformIterationGeneratorCondition(context, value, (Trees.Expression)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.Expression transformIterationGeneratorCondition(C context, ImmutableTrees.IterationGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Trees.ValueDeclaration transformIterationGeneratorDeclaration(C context, ImmutableTrees.IterationGenerator value, Trees.ValueDeclaration element) {
        if (element instanceof ImmutableTrees.ValueDeclaration) {
            return this.transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration)element);
        }
        return element;
    }

    protected Trees.Expression transformIterationGeneratorFrom(C context, ImmutableTrees.IterationGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.TransformGenerator transform(C context, ImmutableTrees.TransformGenerator value) {
        return value.withTransform(this.transformTransformGeneratorTransform(context, value, value.transform())).withVarDeclaration(this.transformTransformGeneratorVarDeclaration(context, value, value.varDeclaration())).withCondition(this.transformTransformGeneratorOptionalCondition(context, value, value.condition())).withDeclaration(this.transformTransformGeneratorDeclaration(context, value, value.declaration())).withFrom(this.transformTransformGeneratorFrom(context, value, value.from()));
    }

    protected Trees.Expression transformTransformGeneratorTransform(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Trees.ValueDeclaration transformTransformGeneratorVarDeclaration(C context, ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration element) {
        if (element instanceof ImmutableTrees.ValueDeclaration) {
            return this.transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration)element);
        }
        return element;
    }

    protected Optional<Trees.Expression> transformTransformGeneratorOptionalCondition(C context, ImmutableTrees.TransformGenerator value, Optional<Trees.Expression> optional) {
        if (optional.isPresent()) {
            return Optional.of((Object)this.transformTransformGeneratorCondition(context, value, (Trees.Expression)optional.get()));
        }
        return Optional.absent();
    }

    protected Trees.Expression transformTransformGeneratorCondition(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    protected Trees.ValueDeclaration transformTransformGeneratorDeclaration(C context, ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration element) {
        if (element instanceof ImmutableTrees.ValueDeclaration) {
            return this.transformValueDeclaration(context, (ImmutableTrees.ValueDeclaration)element);
        }
        return element;
    }

    protected Trees.Expression transformTransformGeneratorFrom(C context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.For transform(C context, ImmutableTrees.For value) {
        return value.withDeclaration(this.transformForListDeclaration(context, value, (List<Trees.GeneratorDeclaration>)value.declaration()));
    }

    protected Iterable<Trees.GeneratorDeclaration> transformForListDeclaration(C context, ImmutableTrees.For value, List<Trees.GeneratorDeclaration> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.GeneratorDeclaration element : collection) {
            list.add(this.transformForDeclaration(context, value, element));
        }
        return list;
    }

    protected Trees.GeneratorDeclaration transformForDeclaration(C context, ImmutableTrees.For value, Trees.GeneratorDeclaration element) {
        if (element instanceof ImmutableTrees.AssignGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.AssignGenerator)element);
        }
        if (element instanceof ImmutableTrees.IterationGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.IterationGenerator)element);
        }
        if (element instanceof ImmutableTrees.TransformGenerator) {
            return this.transformGeneratorDeclaration(context, (ImmutableTrees.TransformGenerator)element);
        }
        return element;
    }

    public ImmutableTrees.If transform(C context, ImmutableTrees.If value) {
        return value.withCondition(this.transformIfCondition(context, value, value.condition()));
    }

    protected Trees.Expression transformIfCondition(C context, ImmutableTrees.If value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.ElseIf transform(C context, ImmutableTrees.ElseIf value) {
        return value.withCondition(this.transformElseIfCondition(context, value, value.condition()));
    }

    protected Trees.Expression transformElseIfCondition(C context, ImmutableTrees.ElseIf value, Trees.Expression element) {
        if (element instanceof ImmutableTrees.BoundAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.BoundAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.ForIterationAccessExpression)element);
        }
        if (element instanceof ImmutableTrees.AccessExpression) {
            return this.transformExpression(context, (ImmutableTrees.AccessExpression)element);
        }
        if (element instanceof ImmutableTrees.ApplyExpression) {
            return this.transformExpression(context, (ImmutableTrees.ApplyExpression)element);
        }
        if (element instanceof ImmutableTrees.StringLiteral) {
            return this.transformExpression(context, (ImmutableTrees.StringLiteral)element);
        }
        return element;
    }

    public ImmutableTrees.Else transform(C context, ImmutableTrees.Else value) {
        return value;
    }

    public ImmutableTrees.TemplateEnd transform(C context, ImmutableTrees.TemplateEnd value) {
        return value;
    }

    public ImmutableTrees.StringLiteral transform(C context, ImmutableTrees.StringLiteral value) {
        return value.withValue(this.transformStringLiteralValue(context, value, value.value()));
    }

    protected String transformStringLiteralValue(C context, ImmutableTrees.StringLiteral value, String element) {
        return element;
    }

    public ImmutableTrees.Newline transform(C context, ImmutableTrees.Newline value) {
        return value;
    }

    public ImmutableTrees.TextFragment transform(C context, ImmutableTrees.TextFragment value) {
        return value.withValue(this.transformTextFragmentValue(context, value, value.value()));
    }

    protected String transformTextFragmentValue(C context, ImmutableTrees.TextFragment value, String element) {
        return element;
    }

    public ImmutableTrees.TextBlock transform(C context, ImmutableTrees.TextBlock value) {
        return value.withParts(this.transformTextBlockListParts(context, value, (List<Trees.TextPart>)value.parts()));
    }

    protected Iterable<Trees.TextPart> transformTextBlockListParts(C context, ImmutableTrees.TextBlock value, List<Trees.TextPart> collection) {
        ArrayList list = Lists.newArrayList();
        for (Trees.TextPart element : collection) {
            list.add(this.transformTextBlockParts(context, value, element));
        }
        return list;
    }

    protected Trees.TextPart transformTextBlockParts(C context, ImmutableTrees.TextBlock value, Trees.TextPart element) {
        if (element instanceof ImmutableTrees.Newline) {
            return this.transformTextPart(context, (ImmutableTrees.Newline)element);
        }
        if (element instanceof ImmutableTrees.TextFragment) {
            return this.transformTextPart(context, (ImmutableTrees.TextFragment)element);
        }
        return element;
    }

    public ImmutableTrees.TextLine transform(C context, ImmutableTrees.TextLine value) {
        return value.withFragment(this.transformTextLineFragment(context, value, value.fragment())).withNewline(this.transformTextLineNewline(context, value, value.newline()));
    }

    protected Trees.TextFragment transformTextLineFragment(C context, ImmutableTrees.TextLine value, Trees.TextFragment element) {
        if (element instanceof ImmutableTrees.TextFragment) {
            return this.transformTextFragment(context, (ImmutableTrees.TextFragment)element);
        }
        return element;
    }

    protected boolean transformTextLineNewline(C context, ImmutableTrees.TextLine value, boolean element) {
        return element;
    }

    protected Trees.InvokeEnd transformInvokeEnd(C context, ImmutableTrees.InvokeEnd value) {
        return this.transform(context, value);
    }

    protected Trees.TextBlock transformTextBlock(C context, ImmutableTrees.TextBlock value) {
        return this.transform(context, value);
    }

    protected Trees.ApplyExpression transformApplyExpression(C context, ImmutableTrees.ApplyExpression value) {
        return this.transform(context, value);
    }

    protected Trees.TemplateEnd transformTemplateEnd(C context, ImmutableTrees.TemplateEnd value) {
        return this.transform(context, value);
    }

    protected Trees.TransformGenerator transformTransformGenerator(C context, ImmutableTrees.TransformGenerator value) {
        return this.transform(context, value);
    }

    protected Trees.ConditionalBlock transformConditionalBlock(C context, ImmutableTrees.ConditionalBlock value) {
        return this.transform(context, value);
    }

    protected Trees.IfEnd transformIfEnd(C context, ImmutableTrees.IfEnd value) {
        return this.transform(context, value);
    }

    protected Trees.Template transformTemplate(C context, ImmutableTrees.Template value) {
        return this.transform(context, value);
    }

    protected Trees.ForIterationAccessExpression transformForIterationAccessExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
        return this.transform(context, value);
    }

    protected Trees.AssignGenerator transformAssignGenerator(C context, ImmutableTrees.AssignGenerator value) {
        return this.transform(context, value);
    }

    protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.IterationGenerator value) {
        return this.transformIterationGenerator(context, value);
    }

    protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.TransformGenerator value) {
        return this.transformTransformGenerator(context, value);
    }

    protected Trees.GeneratorDeclaration transformGeneratorDeclaration(C context, ImmutableTrees.AssignGenerator value) {
        return this.transformAssignGenerator(context, value);
    }

    protected Trees.ForStatement transformForStatement(C context, ImmutableTrees.ForStatement value) {
        return this.transform(context, value);
    }

    protected Trees.ValueDeclaration transformValueDeclaration(C context, ImmutableTrees.ValueDeclaration value) {
        return this.transform(context, value);
    }

    protected Trees.TypeReference transformTypeReference(C context, ImmutableTrees.TypeDeclaration value) {
        return this.transformTypeDeclaration(context, value);
    }

    protected Trees.TypeReference transformTypeReference(C context, ImmutableTrees.ResolvedType value) {
        return this.transformResolvedType(context, value);
    }

    protected Trees.InvokeStatement transformInvokeStatement(C context, ImmutableTrees.InvokeStatement value) {
        return this.transform(context, value);
    }

    protected Trees.ResolvedType transformResolvedType(C context, ImmutableTrees.ResolvedType value) {
        return this.transform(context, value);
    }

    protected Trees.Newline transformNewline(C context, ImmutableTrees.Newline value) {
        return this.transform(context, value);
    }

    protected Trees.Let transformLet(C context, ImmutableTrees.Let value) {
        return this.transform(context, value);
    }

    protected Trees.TextLine transformTextLine(C context, ImmutableTrees.TextLine value) {
        return this.transform(context, value);
    }

    protected Trees.UnitPart transformUnitPart(C context, ImmutableTrees.Comment value) {
        return this.transformComment(context, value);
    }

    protected Trees.UnitPart transformUnitPart(C context, ImmutableTrees.Template value) {
        return this.transformTemplate(context, value);
    }

    protected Trees.InvokableDeclaration transformInvokableDeclaration(C context, ImmutableTrees.InvokableDeclaration value) {
        return this.transform(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.InvokeStatement value) {
        return this.transformInvokeStatement(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.ConditionalBlock value) {
        return this.transformConditionalBlock(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.ForStatement value) {
        return this.transformForStatement(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.Template value) {
        return this.transformTemplate(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.LetStatement value) {
        return this.transformLetStatement(context, value);
    }

    protected Trees.Block transformBlock(C context, ImmutableTrees.Block value) {
        return this.transform(context, value);
    }

    protected Trees.LetStatement transformLetStatement(C context, ImmutableTrees.LetStatement value) {
        return this.transform(context, value);
    }

    protected Trees.ForEnd transformForEnd(C context, ImmutableTrees.ForEnd value) {
        return this.transform(context, value);
    }

    protected Trees.TypeIdentifier transformTypeIdentifier(C context, ImmutableTrees.TypeIdentifier value) {
        return this.transform(context, value);
    }

    protected Trees.StringLiteral transformStringLiteral(C context, ImmutableTrees.StringLiteral value) {
        return this.transform(context, value);
    }

    protected Trees.Else transformElse(C context, ImmutableTrees.Else value) {
        return this.transform(context, value);
    }

    protected Trees.TextPart transformTextPart(C context, ImmutableTrees.TextFragment value) {
        return this.transformTextFragment(context, value);
    }

    protected Trees.TextPart transformTextPart(C context, ImmutableTrees.Newline value) {
        return this.transformNewline(context, value);
    }

    protected Trees.Identifier transformIdentifier(C context, ImmutableTrees.Identifier value) {
        return this.transform(context, value);
    }

    protected Trees.LetEnd transformLetEnd(C context, ImmutableTrees.LetEnd value) {
        return this.transform(context, value);
    }

    protected Trees.TypeDeclaration transformTypeDeclaration(C context, ImmutableTrees.TypeDeclaration value) {
        return this.transform(context, value);
    }

    protected Trees.Expression transformExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
        return this.transformForIterationAccessExpression(context, value);
    }

    protected Trees.Expression transformExpression(C context, ImmutableTrees.BoundAccessExpression value) {
        return this.transformBoundAccessExpression(context, value);
    }

    protected Trees.Expression transformExpression(C context, ImmutableTrees.AccessExpression value) {
        return this.transformAccessExpression(context, value);
    }

    protected Trees.Expression transformExpression(C context, ImmutableTrees.ApplyExpression value) {
        return this.transformApplyExpression(context, value);
    }

    protected Trees.Expression transformExpression(C context, ImmutableTrees.StringLiteral value) {
        return this.transformStringLiteral(context, value);
    }

    protected Trees.IterationGenerator transformIterationGenerator(C context, ImmutableTrees.IterationGenerator value) {
        return this.transform(context, value);
    }

    protected Trees.If transformIf(C context, ImmutableTrees.If value) {
        return this.transform(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ConditionalBlock value) {
        return this.transformConditionalBlock(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeEnd value) {
        return this.transformInvokeEnd(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.If value) {
        return this.transformIf(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Comment value) {
        return this.transformComment(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.LetEnd value) {
        return this.transformLetEnd(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TemplateEnd value) {
        return this.transformTemplateEnd(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ForEnd value) {
        return this.transformForEnd(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Template value) {
        return this.transformTemplate(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TextBlock value) {
        return this.transformTextBlock(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeStatement value) {
        return this.transformInvokeStatement(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Invoke value) {
        return this.transformInvoke(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.IfStatement value) {
        return this.transformIfStatement(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Let value) {
        return this.transformLet(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.For value) {
        return this.transformFor(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ElseIf value) {
        return this.transformElseIf(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Else value) {
        return this.transformElse(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.ForStatement value) {
        return this.transformForStatement(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.LetStatement value) {
        return this.transformLetStatement(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.InvokeString value) {
        return this.transformInvokeString(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.TextLine value) {
        return this.transformTextLine(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.IfEnd value) {
        return this.transformIfEnd(context, value);
    }

    protected Trees.TemplatePart transformTemplatePart(C context, ImmutableTrees.Block value) {
        return this.transformBlock(context, value);
    }

    protected Trees.InvokeString transformInvokeString(C context, ImmutableTrees.InvokeString value) {
        return this.transform(context, value);
    }

    protected Trees.ElseIf transformElseIf(C context, ImmutableTrees.ElseIf value) {
        return this.transform(context, value);
    }

    protected Trees.TextFragment transformTextFragment(C context, ImmutableTrees.TextFragment value) {
        return this.transform(context, value);
    }

    protected Trees.Invoke transformInvoke(C context, ImmutableTrees.Invoke value) {
        return this.transform(context, value);
    }

    protected Trees.Parameter transformParameter(C context, ImmutableTrees.Parameter value) {
        return this.transform(context, value);
    }

    protected Trees.Comment transformComment(C context, ImmutableTrees.Comment value) {
        return this.transform(context, value);
    }

    protected Trees.IfStatement transformIfStatement(C context, ImmutableTrees.IfStatement value) {
        return this.transform(context, value);
    }

    protected Trees.BoundAccessExpression transformBoundAccessExpression(C context, ImmutableTrees.BoundAccessExpression value) {
        return this.transform(context, value);
    }

    protected Trees.For transformFor(C context, ImmutableTrees.For value) {
        return this.transform(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.BoundAccessExpression value) {
        return this.transformBoundAccessExpression(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.TextFragment value) {
        return this.transformTextFragment(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.StringLiteral value) {
        return this.transformStringLiteral(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.Newline value) {
        return this.transformNewline(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.Identifier value) {
        return this.transformIdentifier(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.TextLine value) {
        return this.transformTextLine(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.TypeIdentifier value) {
        return this.transformTypeIdentifier(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.TypeDeclaration value) {
        return this.transformTypeDeclaration(context, value);
    }

    protected Object transformObject(C context, ImmutableTrees.ResolvedType value) {
        return this.transformResolvedType(context, value);
    }

    protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.BoundAccessExpression value) {
        return this.transformBoundAccessExpression(context, value);
    }

    protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.ForIterationAccessExpression value) {
        return this.transformForIterationAccessExpression(context, value);
    }

    protected Trees.AccessExpression transformAccessExpression(C context, ImmutableTrees.AccessExpression value) {
        return this.transform(context, value);
    }
}

