/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.immutables.generator.processor.Accessors;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.SwissArmyKnife;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

public final class TypeResolver {
    static final String ITERATION_ACCESS_VARIABLE = "for";
    private final SwissArmyKnife knife;

    public TypeResolver(SwissArmyKnife knife) {
        this.knife = knife;
    }

    public ImmutableTrees.Unit resolve(ImmutableTrees.Unit unit) {
        return new Transformer().transform(new Scope(), new ForIterationAccessTransformer().transform((Void)null, unit));
    }

    public static ImmutableList<Accessors.BoundAccess> asBoundAccess(Iterable<?> iterable) {
        for (Object object : iterable) {
            Preconditions.checkArgument((boolean)(object instanceof Accessors.BoundAccess));
        }
        return FluentIterable.from(iterable).filter(Accessors.BoundAccess.class).toList();
    }

    private static final class Transformer
    extends TreesTransformer<Scope> {
        private Transformer() {
        }

        @Override
        public ImmutableTrees.Unit transform(Scope scope, ImmutableTrees.Unit unit) {
            for (ImmutableTrees.Template template : Iterables.filter(unit.parts(), ImmutableTrees.Template.class)) {
                scope.declareInvokable(template.declaration().name());
            }
            return super.transform(scope, unit);
        }

        @Override
        public ImmutableTrees.AssignGenerator transform(Scope scope, ImmutableTrees.AssignGenerator value) {
            ImmutableTrees.AssignGenerator generator = super.transform(scope, value);
            return generator.withDeclaration(scope.inferType(generator.declaration(), generator.from(), InferencePurpose.ASSIGN));
        }

        @Override
        protected Trees.TemplatePart transformTemplatePart(Scope scope, ImmutableTrees.LetStatement statement) {
            scope.declareInvokable(statement.declaration().name());
            return super.transformTemplatePart(scope, statement);
        }

        @Override
        public ImmutableTrees.IterationGenerator transform(Scope scope, ImmutableTrees.IterationGenerator value) {
            ImmutableTrees.IterationGenerator generator = super.transform(scope, value);
            return generator.withDeclaration(scope.inferType(generator.declaration(), generator.from(), InferencePurpose.ITERATE)).withCondition(this.transformIterationGeneratorConditionAfterDeclaration(scope, generator, generator.condition()));
        }

        @Override
        public ImmutableTrees.TransformGenerator transform(Scope scope, ImmutableTrees.TransformGenerator value) {
            ImmutableTrees.TransformGenerator generator = super.transform(scope, value);
            generator = generator.withVarDeclaration(scope.inferType(generator.varDeclaration(), generator.from(), InferencePurpose.ITERATE)).withCondition(this.transformTransformGeneratorConditionAfterDeclaration(scope, generator, generator.condition())).withTransform(this.transformTransformGeneratorTransformAfterDeclaration(scope, generator, generator.transform()));
            return generator.withDeclaration(scope.inferType(generator.declaration(), generator.transform(), InferencePurpose.COLLECT));
        }

        private Optional<Trees.Expression> transformIterationGeneratorConditionAfterDeclaration(Scope scope, ImmutableTrees.IterationGenerator generator, Optional<Trees.Expression> condition) {
            if (condition.isPresent()) {
                return Optional.of((Object)super.transformIterationGeneratorCondition(scope, generator, (Trees.Expression)condition.get()));
            }
            return Optional.absent();
        }

        private Optional<Trees.Expression> transformTransformGeneratorConditionAfterDeclaration(Scope scope, ImmutableTrees.TransformGenerator generator, Optional<Trees.Expression> condition) {
            if (condition.isPresent()) {
                return Optional.of((Object)super.transformTransformGeneratorCondition(scope, generator, (Trees.Expression)condition.get()));
            }
            return Optional.absent();
        }

        private Trees.Expression transformTransformGeneratorTransformAfterDeclaration(Scope scope, ImmutableTrees.TransformGenerator generator, Trees.Expression condition) {
            return super.transformTransformGeneratorTransform(scope, generator, condition);
        }

        @Override
        protected Trees.Expression transformIterationGeneratorCondition(Scope scope, ImmutableTrees.IterationGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        protected Trees.Expression transformTransformGeneratorCondition(Scope context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        protected Trees.Expression transformTransformGeneratorTransform(Scope context, ImmutableTrees.TransformGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        public ImmutableTrees.Parameter transform(Scope scope, ImmutableTrees.Parameter parameter) {
            return parameter.withType(scope.declare((Trees.TypeDeclaration)parameter.type(), parameter.name()));
        }

        @Override
        public ImmutableTrees.Template transform(Scope scope, ImmutableTrees.Template template) {
            scope = scope.nest();
            return template.withDeclaration(this.transformTemplateDeclaration(scope, template, template.declaration())).withParts(this.transformTemplateListParts(scope, template, (List<Trees.TemplatePart>)template.parts()));
        }

        @Override
        public ImmutableTrees.LetStatement transform(Scope scope, ImmutableTrees.LetStatement statement) {
            scope = scope.nest();
            return statement.withDeclaration(this.transformLetStatementDeclaration(scope, statement, statement.declaration())).withParts(this.transformLetStatementListParts(scope, statement, (List<Trees.TemplatePart>)statement.parts()));
        }

        @Override
        public ImmutableTrees.ForStatement transform(Scope scope, ImmutableTrees.ForStatement statement) {
            scope = scope.nest();
            scope.declareForIterationAccess(ImmutableTrees.Identifier.of(TypeResolver.ITERATION_ACCESS_VARIABLE));
            return statement.withDeclaration(this.transformForStatementListDeclaration(scope, statement, (List<Trees.GeneratorDeclaration>)statement.declaration())).withParts(this.transformForStatementListParts(scope, statement, (List<Trees.TemplatePart>)statement.parts()));
        }

        @Override
        protected Iterable<Trees.TemplatePart> transformForStatementListParts(Scope context, ImmutableTrees.ForStatement value, List<Trees.TemplatePart> collection) {
            return super.transformForStatementListParts(context, value, collection);
        }

        @Override
        protected Trees.AccessExpression transformAccessExpression(Scope scope, ImmutableTrees.AccessExpression value) {
            return scope.resolveAccess(value);
        }

        @Override
        protected Trees.Expression transformExpression(Scope scope, ImmutableTrees.ApplyExpression value) {
            return this.simplifyExpression(super.transformExpression(scope, value));
        }

        private Trees.Expression simplifyExpression(Trees.Expression expression) {
            ImmutableList<Trees.Expression> params;
            if (expression instanceof ImmutableTrees.ApplyExpression && (params = ((ImmutableTrees.ApplyExpression)expression).params()).size() == 1) {
                return (Trees.Expression)params.get(0);
            }
            return expression;
        }
    }

    private static final class ForIterationAccessTransformer
    extends TreesTransformer<Void> {
        private ForIterationAccessTransformer() {
        }

        @Override
        protected Trees.Expression transformExpression(Void context, ImmutableTrees.ForIterationAccessExpression expression) {
            return ImmutableTrees.AccessExpression.builder().addPath((Trees.Identifier)ImmutableTrees.Identifier.of(TypeResolver.ITERATION_ACCESS_VARIABLE)).addAllPath(expression.access().path()).build();
        }
    }

    private class Scope {
        final Map<String, TypeMirror> locals = Maps.newLinkedHashMap();

        private Scope() {
        }

        Scope nest() {
            Scope nested = new Scope();
            nested.locals.putAll(this.locals);
            return nested;
        }

        Trees.TypeReference declare(Trees.TypeDeclaration type, Trees.Identifier name) {
            if (this.isDeclared(name)) {
                throw new TypingException(String.format("Redeclaration of local %s", name));
            }
            return this.declare(this.resolve(type), name);
        }

        Trees.TypeReference declareInvokable(Trees.Identifier name) {
            return this.declare(((TypeResolver)TypeResolver.this).knife.accessors.invokableType, name);
        }

        Trees.TypeReference declareForIterationAccess(Trees.Identifier name) {
            return this.declare(((TypeResolver)TypeResolver.this).knife.accessors.iterationType, name);
        }

        boolean isDeclared(Trees.Identifier name) {
            return this.locals.containsKey(name.value());
        }

        Trees.TypeReference declare(TypeMirror type, Trees.Identifier name) {
            this.locals.put(name.value(), type);
            return ImmutableTrees.ResolvedType.of(type);
        }

        TypeMirror resolve(Trees.TypeDeclaration type) {
            TypeMirror resolved = (TypeMirror)((TypeResolver)TypeResolver.this).knife.imports.get((Object)type.type().value());
            if (resolved == null) {
                throw new TypingException(String.format("Could not resolve %s simple type", type));
            }
            if (type.kind() == Trees.TypeDeclaration.Kind.ITERABLE) {
                resolved = this.makeIterableTypeOf(resolved);
            }
            return resolved;
        }

        DeclaredType makeIterableTypeOf(TypeMirror resolved) {
            return ((TypeResolver)TypeResolver.this).knife.types.getDeclaredType(((TypeResolver)TypeResolver.this).knife.accessors.iterableElement, resolved);
        }

        ImmutableTrees.BoundAccessExpression resolveAccess(Trees.AccessExpression expression) {
            if (expression instanceof ImmutableTrees.BoundAccessExpression) {
                return (ImmutableTrees.BoundAccessExpression)expression;
            }
            ImmutableTrees.BoundAccessExpression.Builder builder = ImmutableTrees.BoundAccessExpression.builder().addAllPath(expression.path());
            Accessors.BoundAccess accessor = null;
            for (Trees.Identifier identifier : expression.path()) {
                accessor = this.bindAccess(accessor, identifier.value());
                builder.addAccessor((Object)accessor);
            }
            return builder.build();
        }

        Accessors.BoundAccess bindAccess(@Nullable Accessors.BoundAccess previous, String name) {
            return previous != null ? ((TypeResolver)TypeResolver.this).knife.binder.bind(previous.type, name) : ((TypeResolver)TypeResolver.this).knife.binder.bindLocalOrThis(((TypeResolver)TypeResolver.this).knife.type.asType(), name, this.locals);
        }

        Trees.ValueDeclaration inferType(Trees.ValueDeclaration declaration, Trees.Expression expression, InferencePurpose inferenceKind) {
            if (expression instanceof ImmutableTrees.BoundAccessExpression) {
                ImmutableTrees.BoundAccessExpression scopeBoundAccess = (ImmutableTrees.BoundAccessExpression)expression;
                Accessors.BoundAccess lastAccess = (Accessors.BoundAccess)Iterables.getLast(TypeResolver.asBoundAccess(scopeBoundAccess.accessor()));
                if (inferenceKind == InferencePurpose.ITERATE && !lastAccess.isContainer()) {
                    throw new TypingException(String.format("Not iterable type '%s'%n\tin expression '%s'", lastAccess.type, scopeBoundAccess.path()));
                }
                if (declaration.type().isPresent()) {
                    return declaration.withType(this.resolveDeclared((Trees.TypeReference)declaration.type().get(), declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(this.resolveType((Trees.TypeReference)declaration.type().get(), false)));
                }
                if (inferenceKind == InferencePurpose.ITERATE) {
                    TypeMirror resolved = lastAccess.containedType;
                    return declaration.withType(this.declare(resolved, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(resolved));
                }
                if (inferenceKind == InferencePurpose.COLLECT) {
                    TypeMirror resolved = ((TypeResolver)TypeResolver.this).knife.accessors.wrapIterable(lastAccess.type);
                    return declaration.withType(this.declare(resolved, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(lastAccess.type));
                }
                return declaration.withType(this.declare(lastAccess.type, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(lastAccess.type));
            }
            if (declaration.type().isPresent()) {
                return declaration.withType(this.resolveDeclared((Trees.TypeReference)declaration.type().get(), declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(this.resolveType((Trees.TypeReference)declaration.type().get(), false)));
            }
            throw new TypingException(String.format("Value should be typed %s%n\texpression '%s'", declaration.name(), expression));
        }

        private Trees.TypeReference resolveDeclared(Trees.TypeReference typeReference, Trees.Identifier name) {
            return this.declare(this.resolveType(typeReference, true), name);
        }

        private TypeMirror resolveType(Trees.TypeReference typeReference, boolean wrapIterable) {
            Preconditions.checkState((boolean)(typeReference instanceof ImmutableTrees.TypeDeclaration));
            ImmutableTrees.TypeDeclaration typeDeclaration = (ImmutableTrees.TypeDeclaration)typeReference;
            Trees.TypeIdentifier type = typeDeclaration.type();
            TypeMirror resolved = (TypeMirror)((TypeResolver)TypeResolver.this).knife.imports.get((Object)type.value());
            if (resolved == null) {
                throw new TypingException(String.format("Could not resolve declared type '%s'", typeDeclaration));
            }
            if (wrapIterable && typeDeclaration.kind() == Trees.TypeDeclaration.Kind.ITERABLE) {
                resolved = ((TypeResolver)TypeResolver.this).knife.accessors.wrapIterable(resolved);
            }
            return resolved;
        }
    }

    private static enum InferencePurpose {
        ASSIGN,
        ITERATE,
        COLLECT;

    }

    public static class TypingException
    extends RuntimeException {
        TypingException(String message) {
            super(message);
        }
    }
}

