/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generator.processor.Trees;

@ParametersAreNonnullByDefault
public final class ImmutableTrees {
    private ImmutableTrees() {
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TextLine
    extends Trees.TextLine {
        private final Trees.TextFragment fragment;
        private final boolean newline;

        private static TextLine checkPreconditions(TextLine instance) {
            return instance;
        }

        public static TextLine copyOf(Trees.TextLine instance) {
            if (instance instanceof TextLine) {
                return (TextLine)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return TextLine.builder().fragment(instance.fragment()).newline(instance.newline()).build();
        }

        @Deprecated
        public static TextLine copyOf(TextLine instance) {
            return (TextLine)Preconditions.checkNotNull((Object)instance);
        }

        private TextLine(Builder builder) {
            this.fragment = builder.fragment;
            this.newline = builder.newlineIsSet() ? builder.newline : super.newline();
        }

        private TextLine(TextLine copiedInstance, Trees.TextFragment fragment, boolean newline) {
            this.fragment = fragment;
            this.newline = newline;
        }

        public final TextLine withFragment(Trees.TextFragment value) {
            if (this.fragment == value) {
                return this;
            }
            Trees.TextFragment newValue = (Trees.TextFragment)Preconditions.checkNotNull((Object)value);
            return TextLine.checkPreconditions(new TextLine(this, newValue, this.newline));
        }

        public final TextLine withNewline(boolean value) {
            if (this.newline == value) {
                return this;
            }
            boolean newValue = value;
            return TextLine.checkPreconditions(new TextLine(this, this.fragment, newValue));
        }

        @Override
        public Trees.TextFragment fragment() {
            return this.fragment;
        }

        @Override
        public boolean newline() {
            return this.newline;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TextLine && this.equalTo((TextLine)another);
        }

        private boolean equalTo(TextLine another) {
            return this.fragment.equals(another.fragment) && this.newline == another.newline;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.fragment.hashCode();
            h = h * 17 + Booleans.hashCode((boolean)this.newline);
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long nondefaultBitset0;
            private static final long NONDEFAULT_BIT_NEWLINE = 1L;
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_FRAGMENT = 1L;
            @Nullable
            private Trees.TextFragment fragment;
            private boolean newline;

            private Builder() {
            }

            private boolean newlineIsSet() {
                return (this.nondefaultBitset0 & 1L) != 0L;
            }

            private boolean fragmentIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"TextLine.Builder").omitNullValues().add("fragment", (Object)this.fragment).add("newline", this.newlineIsSet() ? Boolean.valueOf(this.newline) : null).toString();
            }

            public final Builder fragment(Trees.TextFragment fragment) {
                this.fragment = (Trees.TextFragment)Preconditions.checkNotNull((Object)fragment);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder newline(boolean newline) {
                this.newline = newline;
                this.nondefaultBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.TextLine, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.fragmentIsSet() ? "fragment" : null)).toString());
                }
            }

            public TextLine build() {
                this.checkRequiredAttributes();
                return TextLine.checkPreconditions(new TextLine(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TextBlock
    implements Trees.TextBlock {
        private final ImmutableList<Trees.TextPart> parts;

        private static TextBlock checkPreconditions(TextBlock instance) {
            return instance;
        }

        public static TextBlock copyOf(Trees.TextBlock instance) {
            if (instance instanceof TextBlock) {
                return (TextBlock)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return TextBlock.builder().addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static TextBlock copyOf(TextBlock instance) {
            return (TextBlock)Preconditions.checkNotNull((Object)instance);
        }

        private TextBlock(Builder builder) {
            this.parts = builder.partsBuilder.build();
        }

        private TextBlock(TextBlock copiedInstance, ImmutableList<Trees.TextPart> parts) {
            this.parts = parts;
        }

        public final TextBlock withParts(Trees.TextPart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return TextBlock.checkPreconditions(new TextBlock(this, (ImmutableList<Trees.TextPart>)newValue));
        }

        public final TextBlock withParts(Iterable<? extends Trees.TextPart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return TextBlock.checkPreconditions(new TextBlock(this, (ImmutableList<Trees.TextPart>)newValue));
        }

        public ImmutableList<Trees.TextPart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TextBlock && this.equalTo((TextBlock)another);
        }

        private boolean equalTo(TextBlock another) {
            return this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TextBlock").add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.TextPart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"TextBlock.Builder").omitNullValues().add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder addParts(Trees.TextPart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TextPart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TextPart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public TextBlock build() {
                return TextBlock.checkPreconditions(new TextBlock(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TextFragment
    extends Trees.TextFragment {
        private final String value;

        public static TextFragment of(String value) {
            return TextFragment.checkPreconditions(new TextFragment(value));
        }

        private static TextFragment checkPreconditions(TextFragment instance) {
            return instance;
        }

        public static TextFragment copyOf(Trees.TextFragment instance) {
            if (instance instanceof TextFragment) {
                return (TextFragment)instance;
            }
            return TextFragment.of(instance.value());
        }

        @Deprecated
        public static TextFragment copyOf(TextFragment instance) {
            return (TextFragment)Preconditions.checkNotNull((Object)instance);
        }

        private TextFragment(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        private TextFragment(TextFragment copiedInstance, String value) {
            this.value = value;
        }

        public final TextFragment withValue(String value) {
            if (this.value == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return TextFragment.checkPreconditions(new TextFragment(this, newValue));
        }

        @Override
        public String value() {
            return this.value;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TextFragment && this.equalTo((TextFragment)another);
        }

        private boolean equalTo(TextFragment another) {
            return this.value.equals(another.value);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.value.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Newline
    extends Trees.Newline {
        private static final Newline INSTANCE = Newline.checkPreconditions(new Newline());

        private static Newline checkPreconditions(Newline instance) {
            return instance;
        }

        public static Newline of() {
            return INSTANCE;
        }

        private Newline() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Newline && this.equalTo((Newline)another);
        }

        private boolean equalTo(Newline another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.Newline".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class StringLiteral
    extends Trees.StringLiteral {
        private final String value;

        public static StringLiteral of(String value) {
            return StringLiteral.checkPreconditions(new StringLiteral(value));
        }

        private static StringLiteral checkPreconditions(StringLiteral instance) {
            return instance;
        }

        public static StringLiteral copyOf(Trees.StringLiteral instance) {
            if (instance instanceof StringLiteral) {
                return (StringLiteral)instance;
            }
            return StringLiteral.of(instance.value());
        }

        @Deprecated
        public static StringLiteral copyOf(StringLiteral instance) {
            return (StringLiteral)Preconditions.checkNotNull((Object)instance);
        }

        private StringLiteral(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        private StringLiteral(StringLiteral copiedInstance, String value) {
            this.value = value;
        }

        public final StringLiteral withValue(String value) {
            if (this.value == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return StringLiteral.checkPreconditions(new StringLiteral(this, newValue));
        }

        @Override
        public String value() {
            return this.value;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof StringLiteral && this.equalTo((StringLiteral)another);
        }

        private boolean equalTo(StringLiteral another) {
            return this.value.equals(another.value);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.value.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TemplateEnd
    implements Trees.TemplateEnd {
        private static final TemplateEnd INSTANCE = TemplateEnd.checkPreconditions(new TemplateEnd());

        private static TemplateEnd checkPreconditions(TemplateEnd instance) {
            return instance;
        }

        public static TemplateEnd of() {
            return INSTANCE;
        }

        private TemplateEnd() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TemplateEnd && this.equalTo((TemplateEnd)another);
        }

        private boolean equalTo(TemplateEnd another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.TemplateEnd".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TemplateEnd").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Else
    implements Trees.Else {
        private static final Else INSTANCE = Else.checkPreconditions(new Else());

        private static Else checkPreconditions(Else instance) {
            return instance;
        }

        public static Else of() {
            return INSTANCE;
        }

        private Else() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Else && this.equalTo((Else)another);
        }

        private boolean equalTo(Else another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.Else".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Else").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ElseIf
    implements Trees.ElseIf {
        private final Trees.Expression condition;

        private static ElseIf checkPreconditions(ElseIf instance) {
            return instance;
        }

        public static ElseIf copyOf(Trees.ElseIf instance) {
            if (instance instanceof ElseIf) {
                return (ElseIf)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ElseIf.builder().condition(instance.condition()).build();
        }

        @Deprecated
        public static ElseIf copyOf(ElseIf instance) {
            return (ElseIf)Preconditions.checkNotNull((Object)instance);
        }

        private ElseIf(Builder builder) {
            this.condition = builder.condition;
        }

        private ElseIf(ElseIf copiedInstance, Trees.Expression condition) {
            this.condition = condition;
        }

        public final ElseIf withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return ElseIf.checkPreconditions(new ElseIf(this, newValue));
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ElseIf && this.equalTo((ElseIf)another);
        }

        private boolean equalTo(ElseIf another) {
            return this.condition.equals(another.condition);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.condition.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ElseIf").add("condition", (Object)this.condition).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_CONDITION = 1L;
            @Nullable
            private Trees.Expression condition;

            private Builder() {
            }

            private boolean conditionIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ElseIf.Builder").omitNullValues().add("condition", (Object)this.condition).toString();
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.ElseIf, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.conditionIsSet() ? "condition" : null)).toString());
                }
            }

            public ElseIf build() {
                this.checkRequiredAttributes();
                return ElseIf.checkPreconditions(new ElseIf(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class If
    implements Trees.If {
        private final Trees.Expression condition;

        private static If checkPreconditions(If instance) {
            return instance;
        }

        public static If copyOf(Trees.If instance) {
            if (instance instanceof If) {
                return (If)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return If.builder().condition(instance.condition()).build();
        }

        @Deprecated
        public static If copyOf(If instance) {
            return (If)Preconditions.checkNotNull((Object)instance);
        }

        private If(Builder builder) {
            this.condition = builder.condition;
        }

        private If(If copiedInstance, Trees.Expression condition) {
            this.condition = condition;
        }

        public final If withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return If.checkPreconditions(new If(this, newValue));
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof If && this.equalTo((If)another);
        }

        private boolean equalTo(If another) {
            return this.condition.equals(another.condition);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.condition.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"If").add("condition", (Object)this.condition).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_CONDITION = 1L;
            @Nullable
            private Trees.Expression condition;

            private Builder() {
            }

            private boolean conditionIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"If.Builder").omitNullValues().add("condition", (Object)this.condition).toString();
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.If, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.conditionIsSet() ? "condition" : null)).toString());
                }
            }

            public If build() {
                this.checkRequiredAttributes();
                return If.checkPreconditions(new If(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class For
    implements Trees.For {
        private final ImmutableList<Trees.GeneratorDeclaration> declaration;

        private static For checkPreconditions(For instance) {
            return instance;
        }

        public static For copyOf(Trees.For instance) {
            if (instance instanceof For) {
                return (For)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return For.builder().addAllDeclaration(instance.declaration()).build();
        }

        @Deprecated
        public static For copyOf(For instance) {
            return (For)Preconditions.checkNotNull((Object)instance);
        }

        private For(Builder builder) {
            this.declaration = builder.declarationBuilder.build();
        }

        private For(For copiedInstance, ImmutableList<Trees.GeneratorDeclaration> declaration) {
            this.declaration = declaration;
        }

        public final For withDeclaration(Trees.GeneratorDeclaration ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return For.checkPreconditions(new For(this, (ImmutableList<Trees.GeneratorDeclaration>)newValue));
        }

        public final For withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
            if (this.declaration == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return For.checkPreconditions(new For(this, (ImmutableList<Trees.GeneratorDeclaration>)newValue));
        }

        public ImmutableList<Trees.GeneratorDeclaration> declaration() {
            return this.declaration;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof For && this.equalTo((For)another);
        }

        private boolean equalTo(For another) {
            return this.declaration.equals(another.declaration);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.declaration.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"For").add("declaration", this.declaration).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.GeneratorDeclaration> declarationBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"For.Builder").omitNullValues().add("declaration", (Object)this.declarationBuilder.build()).toString();
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
                this.declarationBuilder.add((Object)element);
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration ... elements) {
                this.declarationBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declarationBuilder.addAll(elements);
                return this;
            }

            public For build() {
                return For.checkPreconditions(new For(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TransformGenerator
    implements Trees.TransformGenerator {
        private final Trees.Expression transform;
        private final Trees.ValueDeclaration varDeclaration;
        private final Optional<Trees.Expression> condition;
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private static TransformGenerator checkPreconditions(TransformGenerator instance) {
            return instance;
        }

        public static TransformGenerator copyOf(Trees.TransformGenerator instance) {
            if (instance instanceof TransformGenerator) {
                return (TransformGenerator)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return TransformGenerator.builder().transform(instance.transform()).varDeclaration(instance.varDeclaration()).condition(instance.condition()).declaration(instance.declaration()).from(instance.from()).build();
        }

        @Deprecated
        public static TransformGenerator copyOf(TransformGenerator instance) {
            return (TransformGenerator)Preconditions.checkNotNull((Object)instance);
        }

        private TransformGenerator(Builder builder) {
            this.transform = builder.transform;
            this.varDeclaration = builder.varDeclaration;
            this.condition = builder.condition;
            this.declaration = builder.declaration;
            this.from = builder.from;
        }

        private TransformGenerator(TransformGenerator copiedInstance, Trees.Expression transform, Trees.ValueDeclaration varDeclaration, Optional<Trees.Expression> condition, Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.transform = transform;
            this.varDeclaration = varDeclaration;
            this.condition = condition;
            this.declaration = declaration;
            this.from = from;
        }

        public final TransformGenerator withTransform(Trees.Expression value) {
            if (this.transform == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, newValue, this.varDeclaration, this.condition, this.declaration, this.from));
        }

        public final TransformGenerator withVarDeclaration(Trees.ValueDeclaration value) {
            if (this.varDeclaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, this.transform, newValue, this.condition, this.declaration, this.from));
        }

        public final TransformGenerator withCondition(Trees.Expression value) {
            Optional newValue = Optional.of((Object)value);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, this.transform, this.varDeclaration, (Optional<Trees.Expression>)newValue, this.declaration, this.from));
        }

        public final TransformGenerator withCondition(Optional<Trees.Expression> optional) {
            if (this.condition == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, this.transform, this.varDeclaration, (Optional<Trees.Expression>)newValue, this.declaration, this.from));
        }

        public final TransformGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, this.transform, this.varDeclaration, this.condition, newValue, this.from));
        }

        public final TransformGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return TransformGenerator.checkPreconditions(new TransformGenerator(this, this.transform, this.varDeclaration, this.condition, this.declaration, newValue));
        }

        @Override
        public Trees.Expression transform() {
            return this.transform;
        }

        @Override
        public Trees.ValueDeclaration varDeclaration() {
            return this.varDeclaration;
        }

        @Override
        public Optional<Trees.Expression> condition() {
            return this.condition;
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TransformGenerator && this.equalTo((TransformGenerator)another);
        }

        private boolean equalTo(TransformGenerator another) {
            return this.transform.equals(another.transform) && this.varDeclaration.equals(another.varDeclaration) && this.condition.equals(another.condition) && this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.transform.hashCode();
            h = h * 17 + this.varDeclaration.hashCode();
            h = h * 17 + this.condition.hashCode();
            h = h * 17 + this.declaration.hashCode();
            h = h * 17 + this.from.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TransformGenerator").add("transform", (Object)this.transform).add("varDeclaration", (Object)this.varDeclaration).add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 15L;
            private static final long INITIALIZED_BIT_TRANSFORM = 1L;
            private static final long INITIALIZED_BIT_VAR_DECLARATION = 2L;
            private static final long INITIALIZED_BIT_DECLARATION = 4L;
            private static final long INITIALIZED_BIT_FROM = 8L;
            @Nullable
            private Trees.Expression transform;
            @Nullable
            private Trees.ValueDeclaration varDeclaration;
            private Optional<Trees.Expression> condition = Optional.absent();
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            private boolean transformIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            private boolean varDeclarationIsSet() {
                return (this.initializedBitset0 & 2L) != 0L;
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 4L) != 0L;
            }

            private boolean fromIsSet() {
                return (this.initializedBitset0 & 8L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"TransformGenerator.Builder").omitNullValues().add("transform", (Object)this.transform).add("varDeclaration", (Object)this.varDeclaration).add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
            }

            public final Builder transform(Trees.Expression transform) {
                this.transform = (Trees.Expression)Preconditions.checkNotNull((Object)transform);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder varDeclaration(Trees.ValueDeclaration varDeclaration) {
                this.varDeclaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)varDeclaration);
                this.initializedBitset0 |= 2L;
                return this;
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition((Optional<Trees.Expression>)Optional.of((Object)condition));
                return this;
            }

            public final Builder condition(Optional<Trees.Expression> condition) {
                this.condition = (Optional)Preconditions.checkNotNull(condition);
                return this;
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 4L;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from);
                this.initializedBitset0 |= 8L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 15L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.TransformGenerator, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.transformIsSet() ? "transform" : null)).addValue((Object)(!this.varDeclarationIsSet() ? "varDeclaration" : null)).addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).addValue((Object)(!this.fromIsSet() ? "from" : null)).toString());
                }
            }

            public TransformGenerator build() {
                this.checkRequiredAttributes();
                return TransformGenerator.checkPreconditions(new TransformGenerator(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class IterationGenerator
    implements Trees.IterationGenerator {
        private final Optional<Trees.Expression> condition;
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private static IterationGenerator checkPreconditions(IterationGenerator instance) {
            return instance;
        }

        public static IterationGenerator copyOf(Trees.IterationGenerator instance) {
            if (instance instanceof IterationGenerator) {
                return (IterationGenerator)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return IterationGenerator.builder().condition(instance.condition()).declaration(instance.declaration()).from(instance.from()).build();
        }

        @Deprecated
        public static IterationGenerator copyOf(IterationGenerator instance) {
            return (IterationGenerator)Preconditions.checkNotNull((Object)instance);
        }

        private IterationGenerator(Builder builder) {
            this.condition = builder.condition;
            this.declaration = builder.declaration;
            this.from = builder.from;
        }

        private IterationGenerator(IterationGenerator copiedInstance, Optional<Trees.Expression> condition, Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.condition = condition;
            this.declaration = declaration;
            this.from = from;
        }

        public final IterationGenerator withCondition(Trees.Expression value) {
            Optional newValue = Optional.of((Object)value);
            return IterationGenerator.checkPreconditions(new IterationGenerator(this, (Optional<Trees.Expression>)newValue, this.declaration, this.from));
        }

        public final IterationGenerator withCondition(Optional<Trees.Expression> optional) {
            if (this.condition == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return IterationGenerator.checkPreconditions(new IterationGenerator(this, (Optional<Trees.Expression>)newValue, this.declaration, this.from));
        }

        public final IterationGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value);
            return IterationGenerator.checkPreconditions(new IterationGenerator(this, this.condition, newValue, this.from));
        }

        public final IterationGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return IterationGenerator.checkPreconditions(new IterationGenerator(this, this.condition, this.declaration, newValue));
        }

        @Override
        public Optional<Trees.Expression> condition() {
            return this.condition;
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof IterationGenerator && this.equalTo((IterationGenerator)another);
        }

        private boolean equalTo(IterationGenerator another) {
            return this.condition.equals(another.condition) && this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.condition.hashCode();
            h = h * 17 + this.declaration.hashCode();
            h = h * 17 + this.from.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IterationGenerator").add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 3L;
            private static final long INITIALIZED_BIT_DECLARATION = 1L;
            private static final long INITIALIZED_BIT_FROM = 2L;
            private Optional<Trees.Expression> condition = Optional.absent();
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            private boolean fromIsSet() {
                return (this.initializedBitset0 & 2L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"IterationGenerator.Builder").omitNullValues().add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition((Optional<Trees.Expression>)Optional.of((Object)condition));
                return this;
            }

            public final Builder condition(Optional<Trees.Expression> condition) {
                this.condition = (Optional)Preconditions.checkNotNull(condition);
                return this;
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from);
                this.initializedBitset0 |= 2L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 3L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.IterationGenerator, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).addValue((Object)(!this.fromIsSet() ? "from" : null)).toString());
                }
            }

            public IterationGenerator build() {
                this.checkRequiredAttributes();
                return IterationGenerator.checkPreconditions(new IterationGenerator(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class AssignGenerator
    implements Trees.AssignGenerator {
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private static AssignGenerator checkPreconditions(AssignGenerator instance) {
            return instance;
        }

        public static AssignGenerator copyOf(Trees.AssignGenerator instance) {
            if (instance instanceof AssignGenerator) {
                return (AssignGenerator)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return AssignGenerator.builder().declaration(instance.declaration()).from(instance.from()).build();
        }

        @Deprecated
        public static AssignGenerator copyOf(AssignGenerator instance) {
            return (AssignGenerator)Preconditions.checkNotNull((Object)instance);
        }

        private AssignGenerator(Builder builder) {
            this.declaration = builder.declaration;
            this.from = builder.from;
        }

        private AssignGenerator(AssignGenerator copiedInstance, Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.declaration = declaration;
            this.from = from;
        }

        public final AssignGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value);
            return AssignGenerator.checkPreconditions(new AssignGenerator(this, newValue, this.from));
        }

        public final AssignGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return AssignGenerator.checkPreconditions(new AssignGenerator(this, this.declaration, newValue));
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof AssignGenerator && this.equalTo((AssignGenerator)another);
        }

        private boolean equalTo(AssignGenerator another) {
            return this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.declaration.hashCode();
            h = h * 17 + this.from.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AssignGenerator").add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 3L;
            private static final long INITIALIZED_BIT_DECLARATION = 1L;
            private static final long INITIALIZED_BIT_FROM = 2L;
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            private boolean fromIsSet() {
                return (this.initializedBitset0 & 2L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"AssignGenerator.Builder").omitNullValues().add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from);
                this.initializedBitset0 |= 2L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 3L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.AssignGenerator, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).addValue((Object)(!this.fromIsSet() ? "from" : null)).toString());
                }
            }

            public AssignGenerator build() {
                this.checkRequiredAttributes();
                return AssignGenerator.checkPreconditions(new AssignGenerator(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ApplyExpression
    implements Trees.ApplyExpression {
        private final ImmutableList<Trees.Expression> params;

        private static ApplyExpression checkPreconditions(ApplyExpression instance) {
            return instance;
        }

        public static ApplyExpression copyOf(Trees.ApplyExpression instance) {
            if (instance instanceof ApplyExpression) {
                return (ApplyExpression)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ApplyExpression.builder().addAllParams(instance.params()).build();
        }

        @Deprecated
        public static ApplyExpression copyOf(ApplyExpression instance) {
            return (ApplyExpression)Preconditions.checkNotNull((Object)instance);
        }

        private ApplyExpression(Builder builder) {
            this.params = builder.paramsBuilder.build();
        }

        private ApplyExpression(ApplyExpression copiedInstance, ImmutableList<Trees.Expression> params) {
            this.params = params;
        }

        public final ApplyExpression withParams(Trees.Expression ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return ApplyExpression.checkPreconditions(new ApplyExpression(this, (ImmutableList<Trees.Expression>)newValue));
        }

        public final ApplyExpression withParams(Iterable<? extends Trees.Expression> elements) {
            if (this.params == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return ApplyExpression.checkPreconditions(new ApplyExpression(this, (ImmutableList<Trees.Expression>)newValue));
        }

        public ImmutableList<Trees.Expression> params() {
            return this.params;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ApplyExpression && this.equalTo((ApplyExpression)another);
        }

        private boolean equalTo(ApplyExpression another) {
            return this.params.equals(another.params);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.params.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ApplyExpression").add("params", this.params).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.Expression> paramsBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ApplyExpression.Builder").omitNullValues().add("params", (Object)this.paramsBuilder.build()).toString();
            }

            public final Builder addParams(Trees.Expression element) {
                this.paramsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParams(Trees.Expression ... elements) {
                this.paramsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
                this.paramsBuilder.addAll(elements);
                return this;
            }

            public ApplyExpression build() {
                return ApplyExpression.checkPreconditions(new ApplyExpression(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class AccessExpression
    implements Trees.AccessExpression {
        private final ImmutableList<Trees.Identifier> path;

        private static AccessExpression checkPreconditions(AccessExpression instance) {
            return instance;
        }

        public static AccessExpression copyOf(Trees.AccessExpression instance) {
            if (instance instanceof AccessExpression) {
                return (AccessExpression)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return AccessExpression.builder().addAllPath(instance.path()).build();
        }

        @Deprecated
        public static AccessExpression copyOf(AccessExpression instance) {
            return (AccessExpression)Preconditions.checkNotNull((Object)instance);
        }

        private AccessExpression(Builder builder) {
            this.path = builder.pathBuilder.build();
        }

        private AccessExpression(AccessExpression copiedInstance, ImmutableList<Trees.Identifier> path) {
            this.path = path;
        }

        public final AccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return AccessExpression.checkPreconditions(new AccessExpression(this, (ImmutableList<Trees.Identifier>)newValue));
        }

        public final AccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return AccessExpression.checkPreconditions(new AccessExpression(this, (ImmutableList<Trees.Identifier>)newValue));
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof AccessExpression && this.equalTo((AccessExpression)another);
        }

        private boolean equalTo(AccessExpression another) {
            return this.path.equals(another.path);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.path.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AccessExpression").add("path", this.path).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.Identifier> pathBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"AccessExpression.Builder").omitNullValues().add("path", (Object)this.pathBuilder.build()).toString();
            }

            public final Builder addPath(Trees.Identifier element) {
                this.pathBuilder.add((Object)element);
                return this;
            }

            public final Builder addPath(Trees.Identifier ... elements) {
                this.pathBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
                this.pathBuilder.addAll(elements);
                return this;
            }

            public AccessExpression build() {
                return AccessExpression.checkPreconditions(new AccessExpression(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Template
    extends Trees.Template {
        private final boolean isPublic;
        private final ImmutableList<Trees.TemplatePart> parts;
        private final Trees.InvokableDeclaration declaration;

        private static Template checkPreconditions(Template instance) {
            return instance;
        }

        public static Template copyOf(Trees.Template instance) {
            if (instance instanceof Template) {
                return (Template)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Template.builder().isPublic(instance.isPublic()).addAllParts(instance.parts()).declaration(instance.declaration()).build();
        }

        @Deprecated
        public static Template copyOf(Template instance) {
            return (Template)Preconditions.checkNotNull((Object)instance);
        }

        private Template(Builder builder) {
            this.parts = builder.partsBuilder.build();
            this.declaration = builder.declaration;
            this.isPublic = builder.isPublicIsSet() ? builder.isPublic : super.isPublic();
        }

        private Template(Template copiedInstance, boolean isPublic, ImmutableList<Trees.TemplatePart> parts, Trees.InvokableDeclaration declaration) {
            this.isPublic = isPublic;
            this.parts = parts;
            this.declaration = declaration;
        }

        public final Template withIsPublic(boolean value) {
            if (this.isPublic == value) {
                return this;
            }
            boolean newValue = value;
            return Template.checkPreconditions(new Template(this, newValue, this.parts, this.declaration));
        }

        public final Template withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return Template.checkPreconditions(new Template(this, this.isPublic, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration));
        }

        public final Template withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return Template.checkPreconditions(new Template(this, this.isPublic, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration));
        }

        public final Template withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value);
            return Template.checkPreconditions(new Template(this, this.isPublic, this.parts, newValue));
        }

        @Override
        public boolean isPublic() {
            return this.isPublic;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Template && this.equalTo((Template)another);
        }

        private boolean equalTo(Template another) {
            return this.isPublic == another.isPublic && this.parts.equals(another.parts) && this.declaration.equals(another.declaration);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + Booleans.hashCode((boolean)this.isPublic);
            h = h * 17 + this.parts.hashCode();
            h = h * 17 + this.declaration.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Template").add("isPublic", this.isPublic).add("parts", this.parts).add("declaration", (Object)this.declaration).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long nondefaultBitset0;
            private static final long NONDEFAULT_BIT_IS_PUBLIC = 1L;
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_DECLARATION = 1L;
            private boolean isPublic;
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            private boolean isPublicIsSet() {
                return (this.nondefaultBitset0 & 1L) != 0L;
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Template.Builder").omitNullValues().add("isPublic", this.isPublicIsSet() ? Boolean.valueOf(this.isPublic) : null).add("parts", (Object)this.partsBuilder.build()).add("declaration", (Object)this.declaration).toString();
            }

            public final Builder isPublic(boolean isPublic) {
                this.isPublic = isPublic;
                this.nondefaultBitset0 |= 1L;
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.Template, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).toString());
                }
            }

            public Template build() {
                this.checkRequiredAttributes();
                return Template.checkPreconditions(new Template(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Unit
    implements Trees.Unit {
        private final ImmutableList<Trees.UnitPart> parts;

        private static Unit checkPreconditions(Unit instance) {
            return instance;
        }

        public static Unit copyOf(Trees.Unit instance) {
            if (instance instanceof Unit) {
                return (Unit)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Unit.builder().addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static Unit copyOf(Unit instance) {
            return (Unit)Preconditions.checkNotNull((Object)instance);
        }

        private Unit(Builder builder) {
            this.parts = builder.partsBuilder.build();
        }

        private Unit(Unit copiedInstance, ImmutableList<Trees.UnitPart> parts) {
            this.parts = parts;
        }

        public final Unit withParts(Trees.UnitPart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return Unit.checkPreconditions(new Unit(this, (ImmutableList<Trees.UnitPart>)newValue));
        }

        public final Unit withParts(Iterable<? extends Trees.UnitPart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return Unit.checkPreconditions(new Unit(this, (ImmutableList<Trees.UnitPart>)newValue));
        }

        public ImmutableList<Trees.UnitPart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Unit && this.equalTo((Unit)another);
        }

        private boolean equalTo(Unit another) {
            return this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Unit").add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.UnitPart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Unit.Builder").omitNullValues().add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder addParts(Trees.UnitPart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.UnitPart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.UnitPart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public Unit build() {
                return Unit.checkPreconditions(new Unit(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Let
    implements Trees.Let {
        private final Trees.InvokableDeclaration declaration;

        private static Let checkPreconditions(Let instance) {
            return instance;
        }

        public static Let copyOf(Trees.Let instance) {
            if (instance instanceof Let) {
                return (Let)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Let.builder().declaration(instance.declaration()).build();
        }

        @Deprecated
        public static Let copyOf(Let instance) {
            return (Let)Preconditions.checkNotNull((Object)instance);
        }

        private Let(Builder builder) {
            this.declaration = builder.declaration;
        }

        private Let(Let copiedInstance, Trees.InvokableDeclaration declaration) {
            this.declaration = declaration;
        }

        public final Let withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value);
            return Let.checkPreconditions(new Let(this, newValue));
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Let && this.equalTo((Let)another);
        }

        private boolean equalTo(Let another) {
            return this.declaration.equals(another.declaration);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.declaration.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Let").add("declaration", (Object)this.declaration).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_DECLARATION = 1L;
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Let.Builder").omitNullValues().add("declaration", (Object)this.declaration).toString();
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.Let, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).toString());
                }
            }

            public Let build() {
                this.checkRequiredAttributes();
                return Let.checkPreconditions(new Let(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Invoke
    implements Trees.Invoke {
        private final Trees.AccessExpression access;
        private final Optional<Trees.ApplyExpression> invoke;

        private static Invoke checkPreconditions(Invoke instance) {
            return instance;
        }

        public static Invoke copyOf(Trees.Invoke instance) {
            if (instance instanceof Invoke) {
                return (Invoke)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Invoke.builder().access(instance.access()).invoke(instance.invoke()).build();
        }

        @Deprecated
        public static Invoke copyOf(Invoke instance) {
            return (Invoke)Preconditions.checkNotNull((Object)instance);
        }

        private Invoke(Builder builder) {
            this.access = builder.access;
            this.invoke = builder.invoke;
        }

        private Invoke(Invoke copiedInstance, Trees.AccessExpression access, Optional<Trees.ApplyExpression> invoke) {
            this.access = access;
            this.invoke = invoke;
        }

        public final Invoke withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value);
            return Invoke.checkPreconditions(new Invoke(this, newValue, this.invoke));
        }

        public final Invoke withInvoke(Trees.ApplyExpression value) {
            Optional newValue = Optional.of((Object)value);
            return Invoke.checkPreconditions(new Invoke(this, this.access, (Optional<Trees.ApplyExpression>)newValue));
        }

        public final Invoke withInvoke(Optional<Trees.ApplyExpression> optional) {
            if (this.invoke == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return Invoke.checkPreconditions(new Invoke(this, this.access, (Optional<Trees.ApplyExpression>)newValue));
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        @Override
        public Optional<Trees.ApplyExpression> invoke() {
            return this.invoke;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Invoke && this.equalTo((Invoke)another);
        }

        private boolean equalTo(Invoke another) {
            return this.access.equals(another.access) && this.invoke.equals(another.invoke);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.access.hashCode();
            h = h * 17 + this.invoke.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Invoke").add("access", (Object)this.access).add("invoke", this.invoke.orNull()).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_ACCESS = 1L;
            @Nullable
            private Trees.AccessExpression access;
            private Optional<Trees.ApplyExpression> invoke = Optional.absent();

            private Builder() {
            }

            private boolean accessIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Invoke.Builder").omitNullValues().add("access", (Object)this.access).add("invoke", this.invoke.orNull()).toString();
            }

            public final Builder access(Trees.AccessExpression access) {
                this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder invoke(Trees.ApplyExpression invoke) {
                this.invoke((Optional<Trees.ApplyExpression>)Optional.of((Object)invoke));
                return this;
            }

            public final Builder invoke(Optional<Trees.ApplyExpression> invoke) {
                this.invoke = (Optional)Preconditions.checkNotNull(invoke);
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.Invoke, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.accessIsSet() ? "access" : null)).toString());
                }
            }

            public Invoke build() {
                this.checkRequiredAttributes();
                return Invoke.checkPreconditions(new Invoke(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class InvokeString
    implements Trees.InvokeString {
        private final Trees.StringLiteral literal;

        public static InvokeString of(Trees.StringLiteral literal) {
            return InvokeString.checkPreconditions(new InvokeString(literal));
        }

        private static InvokeString checkPreconditions(InvokeString instance) {
            return instance;
        }

        public static InvokeString copyOf(Trees.InvokeString instance) {
            if (instance instanceof InvokeString) {
                return (InvokeString)instance;
            }
            return InvokeString.of(instance.literal());
        }

        @Deprecated
        public static InvokeString copyOf(InvokeString instance) {
            return (InvokeString)Preconditions.checkNotNull((Object)instance);
        }

        private InvokeString(Trees.StringLiteral literal) {
            this.literal = (Trees.StringLiteral)Preconditions.checkNotNull((Object)literal);
        }

        private InvokeString(InvokeString copiedInstance, Trees.StringLiteral literal) {
            this.literal = literal;
        }

        public final InvokeString withLiteral(Trees.StringLiteral value) {
            if (this.literal == value) {
                return this;
            }
            Trees.StringLiteral newValue = (Trees.StringLiteral)Preconditions.checkNotNull((Object)value);
            return InvokeString.checkPreconditions(new InvokeString(this, newValue));
        }

        @Override
        public Trees.StringLiteral literal() {
            return this.literal;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof InvokeString && this.equalTo((InvokeString)another);
        }

        private boolean equalTo(InvokeString another) {
            return this.literal.equals(another.literal);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.literal.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeString").add("literal", (Object)this.literal).toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class InvokeEnd
    implements Trees.InvokeEnd {
        private final Trees.AccessExpression access;

        public static InvokeEnd of(Trees.AccessExpression access) {
            return InvokeEnd.checkPreconditions(new InvokeEnd(access));
        }

        private static InvokeEnd checkPreconditions(InvokeEnd instance) {
            return instance;
        }

        public static InvokeEnd copyOf(Trees.InvokeEnd instance) {
            if (instance instanceof InvokeEnd) {
                return (InvokeEnd)instance;
            }
            return InvokeEnd.of(instance.access());
        }

        @Deprecated
        public static InvokeEnd copyOf(InvokeEnd instance) {
            return (InvokeEnd)Preconditions.checkNotNull((Object)instance);
        }

        private InvokeEnd(Trees.AccessExpression access) {
            this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access);
        }

        private InvokeEnd(InvokeEnd copiedInstance, Trees.AccessExpression access) {
            this.access = access;
        }

        public final InvokeEnd withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value);
            return InvokeEnd.checkPreconditions(new InvokeEnd(this, newValue));
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof InvokeEnd && this.equalTo((InvokeEnd)another);
        }

        private boolean equalTo(InvokeEnd another) {
            return this.access.equals(another.access);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.access.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeEnd").add("access", (Object)this.access).toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class IfEnd
    implements Trees.IfEnd {
        private static final IfEnd INSTANCE = IfEnd.checkPreconditions(new IfEnd());

        private static IfEnd checkPreconditions(IfEnd instance) {
            return instance;
        }

        public static IfEnd of() {
            return INSTANCE;
        }

        private IfEnd() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof IfEnd && this.equalTo((IfEnd)another);
        }

        private boolean equalTo(IfEnd another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.IfEnd".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IfEnd").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ForEnd
    implements Trees.ForEnd {
        private static final ForEnd INSTANCE = ForEnd.checkPreconditions(new ForEnd());

        private static ForEnd checkPreconditions(ForEnd instance) {
            return instance;
        }

        public static ForEnd of() {
            return INSTANCE;
        }

        private ForEnd() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ForEnd && this.equalTo((ForEnd)another);
        }

        private boolean equalTo(ForEnd another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.ForEnd".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ForEnd").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class LetEnd
    implements Trees.LetEnd {
        private static final LetEnd INSTANCE = LetEnd.checkPreconditions(new LetEnd());

        private static LetEnd checkPreconditions(LetEnd instance) {
            return instance;
        }

        public static LetEnd of() {
            return INSTANCE;
        }

        private LetEnd() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof LetEnd && this.equalTo((LetEnd)another);
        }

        private boolean equalTo(LetEnd another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.LetEnd".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"LetEnd").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class InvokeStatement
    implements Trees.InvokeStatement {
        private final Trees.Expression access;
        private final ImmutableList<Trees.Expression> params;
        private final ImmutableList<Trees.TemplatePart> parts;

        private static InvokeStatement checkPreconditions(InvokeStatement instance) {
            return instance;
        }

        public static InvokeStatement copyOf(Trees.InvokeStatement instance) {
            if (instance instanceof InvokeStatement) {
                return (InvokeStatement)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return InvokeStatement.builder().access(instance.access()).addAllParams(instance.params()).addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static InvokeStatement copyOf(InvokeStatement instance) {
            return (InvokeStatement)Preconditions.checkNotNull((Object)instance);
        }

        private InvokeStatement(Builder builder) {
            this.access = builder.access;
            this.params = builder.paramsBuilder.build();
            this.parts = builder.partsBuilder.build();
        }

        private InvokeStatement(InvokeStatement copiedInstance, Trees.Expression access, ImmutableList<Trees.Expression> params, ImmutableList<Trees.TemplatePart> parts) {
            this.access = access;
            this.params = params;
            this.parts = parts;
        }

        public final InvokeStatement withAccess(Trees.Expression value) {
            if (this.access == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return InvokeStatement.checkPreconditions(new InvokeStatement(this, newValue, this.params, this.parts));
        }

        public final InvokeStatement withParams(Trees.Expression ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return InvokeStatement.checkPreconditions(new InvokeStatement(this, this.access, (ImmutableList<Trees.Expression>)newValue, this.parts));
        }

        public final InvokeStatement withParams(Iterable<? extends Trees.Expression> elements) {
            if (this.params == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return InvokeStatement.checkPreconditions(new InvokeStatement(this, this.access, (ImmutableList<Trees.Expression>)newValue, this.parts));
        }

        public final InvokeStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return InvokeStatement.checkPreconditions(new InvokeStatement(this, this.access, this.params, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        public final InvokeStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return InvokeStatement.checkPreconditions(new InvokeStatement(this, this.access, this.params, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        @Override
        public Trees.Expression access() {
            return this.access;
        }

        public ImmutableList<Trees.Expression> params() {
            return this.params;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof InvokeStatement && this.equalTo((InvokeStatement)another);
        }

        private boolean equalTo(InvokeStatement another) {
            return this.access.equals(another.access) && this.params.equals(another.params) && this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.access.hashCode();
            h = h * 17 + this.params.hashCode();
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeStatement").add("access", (Object)this.access).add("params", this.params).add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_ACCESS = 1L;
            @Nullable
            private Trees.Expression access;
            private ImmutableList.Builder<Trees.Expression> paramsBuilder = ImmutableList.builder();
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            private boolean accessIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"InvokeStatement.Builder").omitNullValues().add("access", (Object)this.access).add("params", (Object)this.paramsBuilder.build()).add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder access(Trees.Expression access) {
                this.access = (Trees.Expression)Preconditions.checkNotNull((Object)access);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder addParams(Trees.Expression element) {
                this.paramsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParams(Trees.Expression ... elements) {
                this.paramsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
                this.paramsBuilder.addAll(elements);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.InvokeStatement, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.accessIsSet() ? "access" : null)).toString());
                }
            }

            public InvokeStatement build() {
                this.checkRequiredAttributes();
                return InvokeStatement.checkPreconditions(new InvokeStatement(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class LetStatement
    implements Trees.LetStatement {
        private final ImmutableList<Trees.TemplatePart> parts;
        private final Trees.InvokableDeclaration declaration;

        private static LetStatement checkPreconditions(LetStatement instance) {
            return instance;
        }

        public static LetStatement copyOf(Trees.LetStatement instance) {
            if (instance instanceof LetStatement) {
                return (LetStatement)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return LetStatement.builder().addAllParts(instance.parts()).declaration(instance.declaration()).build();
        }

        @Deprecated
        public static LetStatement copyOf(LetStatement instance) {
            return (LetStatement)Preconditions.checkNotNull((Object)instance);
        }

        private LetStatement(Builder builder) {
            this.parts = builder.partsBuilder.build();
            this.declaration = builder.declaration;
        }

        private LetStatement(LetStatement copiedInstance, ImmutableList<Trees.TemplatePart> parts, Trees.InvokableDeclaration declaration) {
            this.parts = parts;
            this.declaration = declaration;
        }

        public final LetStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return LetStatement.checkPreconditions(new LetStatement(this, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration));
        }

        public final LetStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return LetStatement.checkPreconditions(new LetStatement(this, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration));
        }

        public final LetStatement withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value);
            return LetStatement.checkPreconditions(new LetStatement(this, this.parts, newValue));
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof LetStatement && this.equalTo((LetStatement)another);
        }

        private boolean equalTo(LetStatement another) {
            return this.parts.equals(another.parts) && this.declaration.equals(another.declaration);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.parts.hashCode();
            h = h * 17 + this.declaration.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"LetStatement").add("parts", this.parts).add("declaration", (Object)this.declaration).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_DECLARATION = 1L;
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            private boolean declarationIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"LetStatement.Builder").omitNullValues().add("parts", (Object)this.partsBuilder.build()).add("declaration", (Object)this.declaration).toString();
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.LetStatement, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.declarationIsSet() ? "declaration" : null)).toString());
                }
            }

            public LetStatement build() {
                this.checkRequiredAttributes();
                return LetStatement.checkPreconditions(new LetStatement(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ForIterationAccessExpression
    implements Trees.ForIterationAccessExpression {
        private final Trees.AccessExpression access;
        private final ImmutableList<Trees.Identifier> path;

        public static ForIterationAccessExpression of(Trees.AccessExpression access) {
            return ForIterationAccessExpression.checkPreconditions(new ForIterationAccessExpression(access));
        }

        private static ForIterationAccessExpression checkPreconditions(ForIterationAccessExpression instance) {
            return instance;
        }

        public static ForIterationAccessExpression copyOf(Trees.ForIterationAccessExpression instance) {
            if (instance instanceof ForIterationAccessExpression) {
                return (ForIterationAccessExpression)instance;
            }
            return ForIterationAccessExpression.of(instance.access()).withPath(instance.path());
        }

        @Deprecated
        public static ForIterationAccessExpression copyOf(ForIterationAccessExpression instance) {
            return (ForIterationAccessExpression)Preconditions.checkNotNull((Object)instance);
        }

        private ForIterationAccessExpression(Trees.AccessExpression access) {
            this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access);
            this.path = ImmutableList.of();
        }

        private ForIterationAccessExpression(ForIterationAccessExpression copiedInstance, Trees.AccessExpression access, ImmutableList<Trees.Identifier> path) {
            this.access = access;
            this.path = path;
        }

        public final ForIterationAccessExpression withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value);
            return ForIterationAccessExpression.checkPreconditions(new ForIterationAccessExpression(this, newValue, this.path));
        }

        public final ForIterationAccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return ForIterationAccessExpression.checkPreconditions(new ForIterationAccessExpression(this, this.access, (ImmutableList<Trees.Identifier>)newValue));
        }

        public final ForIterationAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return ForIterationAccessExpression.checkPreconditions(new ForIterationAccessExpression(this, this.access, (ImmutableList<Trees.Identifier>)newValue));
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ForIterationAccessExpression && this.equalTo((ForIterationAccessExpression)another);
        }

        private boolean equalTo(ForIterationAccessExpression another) {
            return this.access.equals(another.access) && this.path.equals(another.path);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.access.hashCode();
            h = h * 17 + this.path.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ForIterationAccessExpression").add("access", (Object)this.access).add("path", this.path).toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ForStatement
    extends Trees.ForStatement {
        private final boolean useForAccess;
        private final boolean useDelimit;
        private final ImmutableList<Trees.GeneratorDeclaration> declaration;
        private final ImmutableList<Trees.TemplatePart> parts;

        private static ForStatement checkPreconditions(ForStatement instance) {
            return instance;
        }

        public static ForStatement copyOf(Trees.ForStatement instance) {
            if (instance instanceof ForStatement) {
                return (ForStatement)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ForStatement.builder().useForAccess(instance.useForAccess()).useDelimit(instance.useDelimit()).addAllDeclaration(instance.declaration()).addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static ForStatement copyOf(ForStatement instance) {
            return (ForStatement)Preconditions.checkNotNull((Object)instance);
        }

        private ForStatement(Builder builder) {
            this.declaration = builder.declarationBuilder.build();
            this.parts = builder.partsBuilder.build();
            this.useForAccess = builder.useForAccessIsSet() ? builder.useForAccess : super.useForAccess();
            this.useDelimit = builder.useDelimitIsSet() ? builder.useDelimit : super.useDelimit();
        }

        private ForStatement(ForStatement copiedInstance, boolean useForAccess, boolean useDelimit, ImmutableList<Trees.GeneratorDeclaration> declaration, ImmutableList<Trees.TemplatePart> parts) {
            this.useForAccess = useForAccess;
            this.useDelimit = useDelimit;
            this.declaration = declaration;
            this.parts = parts;
        }

        public final ForStatement withUseForAccess(boolean value) {
            if (this.useForAccess == value) {
                return this;
            }
            boolean newValue = value;
            return ForStatement.checkPreconditions(new ForStatement(this, newValue, this.useDelimit, this.declaration, this.parts));
        }

        public final ForStatement withUseDelimit(boolean value) {
            if (this.useDelimit == value) {
                return this;
            }
            boolean newValue = value;
            return ForStatement.checkPreconditions(new ForStatement(this, this.useForAccess, newValue, this.declaration, this.parts));
        }

        public final ForStatement withDeclaration(Trees.GeneratorDeclaration ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return ForStatement.checkPreconditions(new ForStatement(this, this.useForAccess, this.useDelimit, (ImmutableList<Trees.GeneratorDeclaration>)newValue, this.parts));
        }

        public final ForStatement withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
            if (this.declaration == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return ForStatement.checkPreconditions(new ForStatement(this, this.useForAccess, this.useDelimit, (ImmutableList<Trees.GeneratorDeclaration>)newValue, this.parts));
        }

        public final ForStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return ForStatement.checkPreconditions(new ForStatement(this, this.useForAccess, this.useDelimit, this.declaration, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        public final ForStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return ForStatement.checkPreconditions(new ForStatement(this, this.useForAccess, this.useDelimit, this.declaration, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        @Override
        public boolean useForAccess() {
            return this.useForAccess;
        }

        @Override
        public boolean useDelimit() {
            return this.useDelimit;
        }

        public ImmutableList<Trees.GeneratorDeclaration> declaration() {
            return this.declaration;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ForStatement && this.equalTo((ForStatement)another);
        }

        private boolean equalTo(ForStatement another) {
            return this.useForAccess == another.useForAccess && this.useDelimit == another.useDelimit && this.declaration.equals(another.declaration) && this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + Booleans.hashCode((boolean)this.useForAccess);
            h = h * 17 + Booleans.hashCode((boolean)this.useDelimit);
            h = h * 17 + this.declaration.hashCode();
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ForStatement").add("useForAccess", this.useForAccess).add("useDelimit", this.useDelimit).add("declaration", this.declaration).add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long nondefaultBitset0;
            private static final long NONDEFAULT_BIT_USE_FOR_ACCESS = 1L;
            private static final long NONDEFAULT_BIT_USE_DELIMIT = 2L;
            private boolean useForAccess;
            private boolean useDelimit;
            private ImmutableList.Builder<Trees.GeneratorDeclaration> declarationBuilder = ImmutableList.builder();
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            private boolean useForAccessIsSet() {
                return (this.nondefaultBitset0 & 1L) != 0L;
            }

            private boolean useDelimitIsSet() {
                return (this.nondefaultBitset0 & 2L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ForStatement.Builder").omitNullValues().add("useForAccess", this.useForAccessIsSet() ? Boolean.valueOf(this.useForAccess) : null).add("useDelimit", this.useDelimitIsSet() ? Boolean.valueOf(this.useDelimit) : null).add("declaration", (Object)this.declarationBuilder.build()).add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder useForAccess(boolean useForAccess) {
                this.useForAccess = useForAccess;
                this.nondefaultBitset0 |= 1L;
                return this;
            }

            public final Builder useDelimit(boolean useDelimit) {
                this.useDelimit = useDelimit;
                this.nondefaultBitset0 |= 2L;
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
                this.declarationBuilder.add((Object)element);
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration ... elements) {
                this.declarationBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declarationBuilder.addAll(elements);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public ForStatement build() {
                return ForStatement.checkPreconditions(new ForStatement(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class IfStatement
    implements Trees.IfStatement {
        private final Trees.ConditionalBlock then;
        private final ImmutableList<Trees.ConditionalBlock> otherwiseIf;
        private final Optional<Trees.Block> otherwise;

        private static IfStatement checkPreconditions(IfStatement instance) {
            return instance;
        }

        public static IfStatement copyOf(Trees.IfStatement instance) {
            if (instance instanceof IfStatement) {
                return (IfStatement)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return IfStatement.builder().then(instance.then()).addAllOtherwiseIf(instance.otherwiseIf()).otherwise(instance.otherwise()).build();
        }

        @Deprecated
        public static IfStatement copyOf(IfStatement instance) {
            return (IfStatement)Preconditions.checkNotNull((Object)instance);
        }

        private IfStatement(Builder builder) {
            this.then = builder.then;
            this.otherwiseIf = builder.otherwiseIfBuilder.build();
            this.otherwise = builder.otherwise;
        }

        private IfStatement(IfStatement copiedInstance, Trees.ConditionalBlock then, ImmutableList<Trees.ConditionalBlock> otherwiseIf, Optional<Trees.Block> otherwise) {
            this.then = then;
            this.otherwiseIf = otherwiseIf;
            this.otherwise = otherwise;
        }

        public final IfStatement withThen(Trees.ConditionalBlock value) {
            if (this.then == value) {
                return this;
            }
            Trees.ConditionalBlock newValue = (Trees.ConditionalBlock)Preconditions.checkNotNull((Object)value);
            return IfStatement.checkPreconditions(new IfStatement(this, newValue, this.otherwiseIf, this.otherwise));
        }

        public final IfStatement withOtherwiseIf(Trees.ConditionalBlock ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return IfStatement.checkPreconditions(new IfStatement(this, this.then, (ImmutableList<Trees.ConditionalBlock>)newValue, this.otherwise));
        }

        public final IfStatement withOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
            if (this.otherwiseIf == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return IfStatement.checkPreconditions(new IfStatement(this, this.then, (ImmutableList<Trees.ConditionalBlock>)newValue, this.otherwise));
        }

        public final IfStatement withOtherwise(Trees.Block value) {
            Optional newValue = Optional.of((Object)value);
            return IfStatement.checkPreconditions(new IfStatement(this, this.then, this.otherwiseIf, (Optional<Trees.Block>)newValue));
        }

        public final IfStatement withOtherwise(Optional<Trees.Block> optional) {
            if (this.otherwise == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return IfStatement.checkPreconditions(new IfStatement(this, this.then, this.otherwiseIf, (Optional<Trees.Block>)newValue));
        }

        @Override
        public Trees.ConditionalBlock then() {
            return this.then;
        }

        public ImmutableList<Trees.ConditionalBlock> otherwiseIf() {
            return this.otherwiseIf;
        }

        @Override
        public Optional<Trees.Block> otherwise() {
            return this.otherwise;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof IfStatement && this.equalTo((IfStatement)another);
        }

        private boolean equalTo(IfStatement another) {
            return this.then.equals(another.then) && this.otherwiseIf.equals(another.otherwiseIf) && this.otherwise.equals(another.otherwise);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.then.hashCode();
            h = h * 17 + this.otherwiseIf.hashCode();
            h = h * 17 + this.otherwise.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IfStatement").add("then", (Object)this.then).add("otherwiseIf", this.otherwiseIf).add("otherwise", this.otherwise.orNull()).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_THEN = 1L;
            @Nullable
            private Trees.ConditionalBlock then;
            private ImmutableList.Builder<Trees.ConditionalBlock> otherwiseIfBuilder = ImmutableList.builder();
            private Optional<Trees.Block> otherwise = Optional.absent();

            private Builder() {
            }

            private boolean thenIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"IfStatement.Builder").omitNullValues().add("then", (Object)this.then).add("otherwiseIf", (Object)this.otherwiseIfBuilder.build()).add("otherwise", this.otherwise.orNull()).toString();
            }

            public final Builder then(Trees.ConditionalBlock then) {
                this.then = (Trees.ConditionalBlock)Preconditions.checkNotNull((Object)then);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder addOtherwiseIf(Trees.ConditionalBlock element) {
                this.otherwiseIfBuilder.add((Object)element);
                return this;
            }

            public final Builder addOtherwiseIf(Trees.ConditionalBlock ... elements) {
                this.otherwiseIfBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
                this.otherwiseIfBuilder.addAll(elements);
                return this;
            }

            public final Builder otherwise(Trees.Block otherwise) {
                this.otherwise((Optional<Trees.Block>)Optional.of((Object)otherwise));
                return this;
            }

            public final Builder otherwise(Optional<Trees.Block> otherwise) {
                this.otherwise = (Optional)Preconditions.checkNotNull(otherwise);
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.IfStatement, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.thenIsSet() ? "then" : null)).toString());
                }
            }

            public IfStatement build() {
                this.checkRequiredAttributes();
                return IfStatement.checkPreconditions(new IfStatement(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ConditionalBlock
    implements Trees.ConditionalBlock {
        private final Trees.Expression condition;
        private final ImmutableList<Trees.TemplatePart> parts;

        private static ConditionalBlock checkPreconditions(ConditionalBlock instance) {
            return instance;
        }

        public static ConditionalBlock copyOf(Trees.ConditionalBlock instance) {
            if (instance instanceof ConditionalBlock) {
                return (ConditionalBlock)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ConditionalBlock.builder().condition(instance.condition()).addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static ConditionalBlock copyOf(ConditionalBlock instance) {
            return (ConditionalBlock)Preconditions.checkNotNull((Object)instance);
        }

        private ConditionalBlock(Builder builder) {
            this.condition = builder.condition;
            this.parts = builder.partsBuilder.build();
        }

        private ConditionalBlock(ConditionalBlock copiedInstance, Trees.Expression condition, ImmutableList<Trees.TemplatePart> parts) {
            this.condition = condition;
            this.parts = parts;
        }

        public final ConditionalBlock withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value);
            return ConditionalBlock.checkPreconditions(new ConditionalBlock(this, newValue, this.parts));
        }

        public final ConditionalBlock withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return ConditionalBlock.checkPreconditions(new ConditionalBlock(this, this.condition, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        public final ConditionalBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return ConditionalBlock.checkPreconditions(new ConditionalBlock(this, this.condition, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ConditionalBlock && this.equalTo((ConditionalBlock)another);
        }

        private boolean equalTo(ConditionalBlock another) {
            return this.condition.equals(another.condition) && this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.condition.hashCode();
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ConditionalBlock").add("condition", (Object)this.condition).add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_CONDITION = 1L;
            @Nullable
            private Trees.Expression condition;
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            private boolean conditionIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ConditionalBlock.Builder").omitNullValues().add("condition", (Object)this.condition).add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.ConditionalBlock, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.conditionIsSet() ? "condition" : null)).toString());
                }
            }

            public ConditionalBlock build() {
                this.checkRequiredAttributes();
                return ConditionalBlock.checkPreconditions(new ConditionalBlock(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Comment
    implements Trees.Comment {
        private static final Comment INSTANCE = Comment.checkPreconditions(new Comment());

        private static Comment checkPreconditions(Comment instance) {
            return instance;
        }

        public static Comment of() {
            return INSTANCE;
        }

        private Comment() {
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Comment && this.equalTo((Comment)another);
        }

        private boolean equalTo(Comment another) {
            return true;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + "Trees.Comment".hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Comment").toString();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Block
    implements Trees.Block {
        private final ImmutableList<Trees.TemplatePart> parts;

        private static Block checkPreconditions(Block instance) {
            return instance;
        }

        public static Block copyOf(Trees.Block instance) {
            if (instance instanceof Block) {
                return (Block)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Block.builder().addAllParts(instance.parts()).build();
        }

        @Deprecated
        public static Block copyOf(Block instance) {
            return (Block)Preconditions.checkNotNull((Object)instance);
        }

        private Block(Builder builder) {
            this.parts = builder.partsBuilder.build();
        }

        private Block(Block copiedInstance, ImmutableList<Trees.TemplatePart> parts) {
            this.parts = parts;
        }

        public final Block withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return Block.checkPreconditions(new Block(this, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        public final Block withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return Block.checkPreconditions(new Block(this, (ImmutableList<Trees.TemplatePart>)newValue));
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Block && this.equalTo((Block)another);
        }

        private boolean equalTo(Block another) {
            return this.parts.equals(another.parts);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.parts.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Block").add("parts", this.parts).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.TemplatePart> partsBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Block.Builder").omitNullValues().add("parts", (Object)this.partsBuilder.build()).toString();
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.partsBuilder.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.partsBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.partsBuilder.addAll(elements);
                return this;
            }

            public Block build() {
                return Block.checkPreconditions(new Block(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Parameter
    implements Trees.Parameter {
        private final Trees.Identifier name;
        private final Trees.TypeReference type;

        private static Parameter checkPreconditions(Parameter instance) {
            return instance;
        }

        public static Parameter copyOf(Trees.Parameter instance) {
            if (instance instanceof Parameter) {
                return (Parameter)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Parameter.builder().name(instance.name()).type(instance.type()).build();
        }

        @Deprecated
        public static Parameter copyOf(Parameter instance) {
            return (Parameter)Preconditions.checkNotNull((Object)instance);
        }

        private Parameter(Builder builder) {
            this.name = builder.name;
            this.type = builder.type;
        }

        private Parameter(Parameter copiedInstance, Trees.Identifier name, Trees.TypeReference type) {
            this.name = name;
            this.type = type;
        }

        public final Parameter withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value);
            return Parameter.checkPreconditions(new Parameter(this, newValue, this.type));
        }

        public final Parameter withType(Trees.TypeReference value) {
            if (this.type == value) {
                return this;
            }
            Trees.TypeReference newValue = (Trees.TypeReference)Preconditions.checkNotNull((Object)value);
            return Parameter.checkPreconditions(new Parameter(this, this.name, newValue));
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        @Override
        public Trees.TypeReference type() {
            return this.type;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Parameter && this.equalTo((Parameter)another);
        }

        private boolean equalTo(Parameter another) {
            return this.name.equals(another.name) && this.type.equals(another.type);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            h = h * 17 + this.type.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Parameter").add("name", (Object)this.name).add("type", (Object)this.type).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 3L;
            private static final long INITIALIZED_BIT_NAME = 1L;
            private static final long INITIALIZED_BIT_TYPE = 2L;
            @Nullable
            private Trees.Identifier name;
            @Nullable
            private Trees.TypeReference type;

            private Builder() {
            }

            private boolean nameIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            private boolean typeIsSet() {
                return (this.initializedBitset0 & 2L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"Parameter.Builder").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).toString();
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder type(Trees.TypeReference type) {
                this.type = (Trees.TypeReference)Preconditions.checkNotNull((Object)type);
                this.initializedBitset0 |= 2L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 3L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.Parameter, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.nameIsSet() ? "name" : null)).addValue((Object)(!this.typeIsSet() ? "type" : null)).toString());
                }
            }

            public Parameter build() {
                this.checkRequiredAttributes();
                return Parameter.checkPreconditions(new Parameter(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ValueDeclaration
    implements Trees.ValueDeclaration {
        private final Optional<Trees.TypeReference> type;
        private final Optional<Trees.TypeReference> containedType;
        private final Trees.Identifier name;

        private static ValueDeclaration checkPreconditions(ValueDeclaration instance) {
            return instance;
        }

        public static ValueDeclaration copyOf(Trees.ValueDeclaration instance) {
            if (instance instanceof ValueDeclaration) {
                return (ValueDeclaration)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ValueDeclaration.builder().type(instance.type()).containedType(instance.containedType()).name(instance.name()).build();
        }

        @Deprecated
        public static ValueDeclaration copyOf(ValueDeclaration instance) {
            return (ValueDeclaration)Preconditions.checkNotNull((Object)instance);
        }

        private ValueDeclaration(Builder builder) {
            this.type = builder.type;
            this.containedType = builder.containedType;
            this.name = builder.name;
        }

        private ValueDeclaration(ValueDeclaration copiedInstance, Optional<Trees.TypeReference> type, Optional<Trees.TypeReference> containedType, Trees.Identifier name) {
            this.type = type;
            this.containedType = containedType;
            this.name = name;
        }

        @Override
        public final ValueDeclaration withType(Trees.TypeReference value) {
            Optional newValue = Optional.of((Object)value);
            return ValueDeclaration.checkPreconditions(new ValueDeclaration(this, (Optional<Trees.TypeReference>)newValue, this.containedType, this.name));
        }

        public final ValueDeclaration withType(Optional<Trees.TypeReference> optional) {
            if (this.type == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return ValueDeclaration.checkPreconditions(new ValueDeclaration(this, (Optional<Trees.TypeReference>)newValue, this.containedType, this.name));
        }

        @Override
        public final ValueDeclaration withContainedType(Trees.TypeReference value) {
            Optional newValue = Optional.of((Object)value);
            return ValueDeclaration.checkPreconditions(new ValueDeclaration(this, this.type, (Optional<Trees.TypeReference>)newValue, this.name));
        }

        public final ValueDeclaration withContainedType(Optional<Trees.TypeReference> optional) {
            if (this.containedType == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return ValueDeclaration.checkPreconditions(new ValueDeclaration(this, this.type, (Optional<Trees.TypeReference>)newValue, this.name));
        }

        public final ValueDeclaration withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value);
            return ValueDeclaration.checkPreconditions(new ValueDeclaration(this, this.type, this.containedType, newValue));
        }

        @Override
        public Optional<Trees.TypeReference> type() {
            return this.type;
        }

        @Override
        public Optional<Trees.TypeReference> containedType() {
            return this.containedType;
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ValueDeclaration && this.equalTo((ValueDeclaration)another);
        }

        private boolean equalTo(ValueDeclaration another) {
            return this.type.equals(another.type) && this.containedType.equals(another.containedType) && this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.type.hashCode();
            h = h * 17 + this.containedType.hashCode();
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ValueDeclaration").add("type", this.type.orNull()).add("containedType", this.containedType.orNull()).add("name", (Object)this.name).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_NAME = 1L;
            private Optional<Trees.TypeReference> type = Optional.absent();
            private Optional<Trees.TypeReference> containedType = Optional.absent();
            @Nullable
            private Trees.Identifier name;

            private Builder() {
            }

            private boolean nameIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ValueDeclaration.Builder").omitNullValues().add("type", this.type.orNull()).add("containedType", this.containedType.orNull()).add("name", (Object)this.name).toString();
            }

            public final Builder type(Trees.TypeReference type) {
                this.type((Optional<Trees.TypeReference>)Optional.of((Object)type));
                return this;
            }

            public final Builder type(Optional<Trees.TypeReference> type) {
                this.type = (Optional)Preconditions.checkNotNull(type);
                return this;
            }

            public final Builder containedType(Trees.TypeReference containedType) {
                this.containedType((Optional<Trees.TypeReference>)Optional.of((Object)containedType));
                return this;
            }

            public final Builder containedType(Optional<Trees.TypeReference> containedType) {
                this.containedType = (Optional)Preconditions.checkNotNull(containedType);
                return this;
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.ValueDeclaration, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.nameIsSet() ? "name" : null)).toString());
                }
            }

            public ValueDeclaration build() {
                this.checkRequiredAttributes();
                return ValueDeclaration.checkPreconditions(new ValueDeclaration(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class InvokableDeclaration
    implements Trees.InvokableDeclaration {
        private final ImmutableList<Trees.Parameter> parameters;
        private final Trees.Identifier name;

        private static InvokableDeclaration checkPreconditions(InvokableDeclaration instance) {
            return instance;
        }

        public static InvokableDeclaration copyOf(Trees.InvokableDeclaration instance) {
            if (instance instanceof InvokableDeclaration) {
                return (InvokableDeclaration)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return InvokableDeclaration.builder().addAllParameters(instance.parameters()).name(instance.name()).build();
        }

        @Deprecated
        public static InvokableDeclaration copyOf(InvokableDeclaration instance) {
            return (InvokableDeclaration)Preconditions.checkNotNull((Object)instance);
        }

        private InvokableDeclaration(Builder builder) {
            this.parameters = builder.parametersBuilder.build();
            this.name = builder.name;
        }

        private InvokableDeclaration(InvokableDeclaration copiedInstance, ImmutableList<Trees.Parameter> parameters, Trees.Identifier name) {
            this.parameters = parameters;
            this.name = name;
        }

        public final InvokableDeclaration withParameters(Trees.Parameter ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return InvokableDeclaration.checkPreconditions(new InvokableDeclaration(this, (ImmutableList<Trees.Parameter>)newValue, this.name));
        }

        public final InvokableDeclaration withParameters(Iterable<? extends Trees.Parameter> elements) {
            if (this.parameters == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return InvokableDeclaration.checkPreconditions(new InvokableDeclaration(this, (ImmutableList<Trees.Parameter>)newValue, this.name));
        }

        public final InvokableDeclaration withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value);
            return InvokableDeclaration.checkPreconditions(new InvokableDeclaration(this, this.parameters, newValue));
        }

        public ImmutableList<Trees.Parameter> parameters() {
            return this.parameters;
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof InvokableDeclaration && this.equalTo((InvokableDeclaration)another);
        }

        private boolean equalTo(InvokableDeclaration another) {
            return this.parameters.equals(another.parameters) && this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.parameters.hashCode();
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokableDeclaration").add("parameters", this.parameters).add("name", (Object)this.name).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_NAME = 1L;
            private ImmutableList.Builder<Trees.Parameter> parametersBuilder = ImmutableList.builder();
            @Nullable
            private Trees.Identifier name;

            private Builder() {
            }

            private boolean nameIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"InvokableDeclaration.Builder").omitNullValues().add("parameters", (Object)this.parametersBuilder.build()).add("name", (Object)this.name).toString();
            }

            public final Builder addParameters(Trees.Parameter element) {
                this.parametersBuilder.add((Object)element);
                return this;
            }

            public final Builder addParameters(Trees.Parameter ... elements) {
                this.parametersBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllParameters(Iterable<? extends Trees.Parameter> elements) {
                this.parametersBuilder.addAll(elements);
                return this;
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.InvokableDeclaration, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.nameIsSet() ? "name" : null)).toString());
                }
            }

            public InvokableDeclaration build() {
                this.checkRequiredAttributes();
                return InvokableDeclaration.checkPreconditions(new InvokableDeclaration(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class BoundAccessExpression
    extends Trees.BoundAccessExpression {
        private final ImmutableList<Object> accessor;
        private final ImmutableList<Trees.Identifier> path;

        private static BoundAccessExpression checkPreconditions(BoundAccessExpression instance) {
            return instance;
        }

        public static BoundAccessExpression copyOf(Trees.BoundAccessExpression instance) {
            if (instance instanceof BoundAccessExpression) {
                return (BoundAccessExpression)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return BoundAccessExpression.builder().addAllAccessor(instance.accessor()).addAllPath(instance.path()).build();
        }

        @Deprecated
        public static BoundAccessExpression copyOf(BoundAccessExpression instance) {
            return (BoundAccessExpression)Preconditions.checkNotNull((Object)instance);
        }

        private BoundAccessExpression(Builder builder) {
            this.accessor = builder.accessorBuilder.build();
            this.path = builder.pathBuilder.build();
        }

        private BoundAccessExpression(BoundAccessExpression copiedInstance, ImmutableList<Object> accessor, ImmutableList<Trees.Identifier> path) {
            this.accessor = accessor;
            this.path = path;
        }

        public final BoundAccessExpression withAccessor(Object ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return BoundAccessExpression.checkPreconditions(new BoundAccessExpression(this, (ImmutableList<Object>)newValue, this.path));
        }

        public final BoundAccessExpression withAccessor(Iterable<? extends Object> elements) {
            if (this.accessor == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return BoundAccessExpression.checkPreconditions(new BoundAccessExpression(this, (ImmutableList<Object>)newValue, this.path));
        }

        public final BoundAccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
            return BoundAccessExpression.checkPreconditions(new BoundAccessExpression(this, this.accessor, (ImmutableList<Trees.Identifier>)newValue));
        }

        public final BoundAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return BoundAccessExpression.checkPreconditions(new BoundAccessExpression(this, this.accessor, (ImmutableList<Trees.Identifier>)newValue));
        }

        public ImmutableList<Object> accessor() {
            return this.accessor;
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof BoundAccessExpression && this.equalTo((BoundAccessExpression)another);
        }

        private boolean equalTo(BoundAccessExpression another) {
            return this.accessor.equals(another.accessor) && this.path.equals(another.path);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.accessor.hashCode();
            h = h * 17 + this.path.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Object> accessorBuilder = ImmutableList.builder();
            private ImmutableList.Builder<Trees.Identifier> pathBuilder = ImmutableList.builder();

            private Builder() {
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"BoundAccessExpression.Builder").omitNullValues().add("accessor", (Object)this.accessorBuilder.build()).add("path", (Object)this.pathBuilder.build()).toString();
            }

            public final Builder addAccessor(Object element) {
                this.accessorBuilder.add(element);
                return this;
            }

            public final Builder addAccessor(Object ... elements) {
                this.accessorBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllAccessor(Iterable<? extends Object> elements) {
                this.accessorBuilder.addAll(elements);
                return this;
            }

            public final Builder addPath(Trees.Identifier element) {
                this.pathBuilder.add((Object)element);
                return this;
            }

            public final Builder addPath(Trees.Identifier ... elements) {
                this.pathBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
                return this;
            }

            public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
                this.pathBuilder.addAll(elements);
                return this;
            }

            public BoundAccessExpression build() {
                return BoundAccessExpression.checkPreconditions(new BoundAccessExpression(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class ResolvedType
    extends Trees.ResolvedType {
        private final Object type;

        public static ResolvedType of(Object type) {
            return ResolvedType.checkPreconditions(new ResolvedType(type));
        }

        private static ResolvedType checkPreconditions(ResolvedType instance) {
            return instance;
        }

        public static ResolvedType copyOf(Trees.ResolvedType instance) {
            if (instance instanceof ResolvedType) {
                return (ResolvedType)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return ResolvedType.builder().type(instance.type()).build();
        }

        @Deprecated
        public static ResolvedType copyOf(ResolvedType instance) {
            return (ResolvedType)Preconditions.checkNotNull((Object)instance);
        }

        private ResolvedType(Object type) {
            this.type = Preconditions.checkNotNull((Object)type);
        }

        private ResolvedType(Builder builder) {
            this.type = builder.type;
        }

        private ResolvedType(ResolvedType copiedInstance, Object type) {
            this.type = type;
        }

        public final ResolvedType withType(Object value) {
            if (this.type == value) {
                return this;
            }
            Object newValue = Preconditions.checkNotNull((Object)value);
            return ResolvedType.checkPreconditions(new ResolvedType(this, newValue));
        }

        @Override
        public Object type() {
            return this.type;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof ResolvedType && this.equalTo((ResolvedType)another);
        }

        private boolean equalTo(ResolvedType another) {
            return this.type.equals(another.type);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.type.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_TYPE = 1L;
            @Nullable
            private Object type;

            private Builder() {
            }

            private boolean typeIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ResolvedType.Builder").omitNullValues().add("type", this.type).toString();
            }

            public final Builder type(Object type) {
                this.type = Preconditions.checkNotNull((Object)type);
                this.initializedBitset0 |= 1L;
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.ResolvedType, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.typeIsSet() ? "type" : null)).toString());
                }
            }

            public ResolvedType build() {
                this.checkRequiredAttributes();
                return ResolvedType.checkPreconditions(new ResolvedType(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TypeDeclaration
    extends Trees.TypeDeclaration {
        private final Trees.TypeIdentifier type;
        private final Trees.TypeDeclaration.Kind kind;

        private static TypeDeclaration checkPreconditions(TypeDeclaration instance) {
            return instance;
        }

        public static TypeDeclaration copyOf(Trees.TypeDeclaration instance) {
            if (instance instanceof TypeDeclaration) {
                return (TypeDeclaration)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return TypeDeclaration.builder().type(instance.type()).kind(instance.kind()).build();
        }

        @Deprecated
        public static TypeDeclaration copyOf(TypeDeclaration instance) {
            return (TypeDeclaration)Preconditions.checkNotNull((Object)instance);
        }

        private TypeDeclaration(Builder builder) {
            this.type = builder.type;
            this.kind = builder.kind != null ? builder.kind : (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)super.kind())));
        }

        private TypeDeclaration(TypeDeclaration copiedInstance, Trees.TypeIdentifier type, Trees.TypeDeclaration.Kind kind) {
            this.type = type;
            this.kind = kind;
        }

        public final TypeDeclaration withType(Trees.TypeIdentifier value) {
            if (this.type == value) {
                return this;
            }
            Trees.TypeIdentifier newValue = (Trees.TypeIdentifier)Preconditions.checkNotNull((Object)value);
            return TypeDeclaration.checkPreconditions(new TypeDeclaration(this, newValue, this.kind));
        }

        public final TypeDeclaration withKind(Trees.TypeDeclaration.Kind value) {
            if (this.kind == value) {
                return this;
            }
            Trees.TypeDeclaration.Kind newValue = (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)value)));
            return TypeDeclaration.checkPreconditions(new TypeDeclaration(this, this.type, newValue));
        }

        @Override
        public Trees.TypeIdentifier type() {
            return this.type;
        }

        @Override
        public Trees.TypeDeclaration.Kind kind() {
            return this.kind;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TypeDeclaration && this.equalTo((TypeDeclaration)another);
        }

        private boolean equalTo(TypeDeclaration another) {
            return this.type.equals(another.type) && this.kind.equals((Object)another.kind);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.type.hashCode();
            h = h * 17 + this.kind.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TypeDeclaration").add("type", (Object)this.type).add("kind", (Object)this.kind).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private long initializedBitset0;
            private static final long INITIALIZED_BITSET_ALL_0 = 1L;
            private static final long INITIALIZED_BIT_TYPE = 1L;
            @Nullable
            private Trees.TypeIdentifier type;
            @Nullable
            private Trees.TypeDeclaration.Kind kind;

            private Builder() {
            }

            private boolean typeIsSet() {
                return (this.initializedBitset0 & 1L) != 0L;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"TypeDeclaration.Builder").omitNullValues().add("type", (Object)this.type).add("kind", (Object)this.kind).toString();
            }

            public final Builder type(Trees.TypeIdentifier type) {
                this.type = (Trees.TypeIdentifier)Preconditions.checkNotNull((Object)type);
                this.initializedBitset0 |= 1L;
                return this;
            }

            public final Builder kind(Trees.TypeDeclaration.Kind kind) {
                this.kind = (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
                return this;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset0 != 1L) {
                    throw new IllegalStateException(MoreObjects.toStringHelper((String)"Cannot build Trees.TypeDeclaration, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.typeIsSet() ? "type" : null)).toString());
                }
            }

            public TypeDeclaration build() {
                this.checkRequiredAttributes();
                return TypeDeclaration.checkPreconditions(new TypeDeclaration(this));
            }
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class TypeIdentifier
    extends Trees.TypeIdentifier {
        private final String value;

        public static TypeIdentifier of(String value) {
            return TypeIdentifier.checkPreconditions(new TypeIdentifier(value));
        }

        private static TypeIdentifier checkPreconditions(TypeIdentifier instance) {
            return instance;
        }

        public static TypeIdentifier copyOf(Trees.TypeIdentifier instance) {
            if (instance instanceof TypeIdentifier) {
                return (TypeIdentifier)instance;
            }
            return TypeIdentifier.of(instance.value());
        }

        @Deprecated
        public static TypeIdentifier copyOf(TypeIdentifier instance) {
            return (TypeIdentifier)Preconditions.checkNotNull((Object)instance);
        }

        private TypeIdentifier(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        private TypeIdentifier(TypeIdentifier copiedInstance, String value) {
            this.value = value;
        }

        public final TypeIdentifier withValue(String value) {
            if (this.value == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return TypeIdentifier.checkPreconditions(new TypeIdentifier(this, newValue));
        }

        @Override
        public String value() {
            return this.value;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof TypeIdentifier && this.equalTo((TypeIdentifier)another);
        }

        private boolean equalTo(TypeIdentifier another) {
            return this.value.equals(another.value);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.value.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static final class Identifier
    extends Trees.Identifier {
        private final String value;

        public static Identifier of(String value) {
            return Identifier.checkPreconditions(new Identifier(value));
        }

        private static Identifier checkPreconditions(Identifier instance) {
            return instance;
        }

        public static Identifier copyOf(Trees.Identifier instance) {
            if (instance instanceof Identifier) {
                return (Identifier)instance;
            }
            return Identifier.of(instance.value());
        }

        @Deprecated
        public static Identifier copyOf(Identifier instance) {
            return (Identifier)Preconditions.checkNotNull((Object)instance);
        }

        private Identifier(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        private Identifier(Identifier copiedInstance, String value) {
            this.value = value;
        }

        public final Identifier withValue(String value) {
            if (this.value == value) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value);
            return Identifier.checkPreconditions(new Identifier(this, newValue));
        }

        @Override
        public String value() {
            return this.value;
        }

        public boolean equals(Object another) {
            return this == another || another instanceof Identifier && this.equalTo((Identifier)another);
        }

        private boolean equalTo(Identifier another) {
            return this.value.equals(another.value);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.value.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }
    }
}

