/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import org.immutables.generator.processor.Extractions;
import org.immutables.generator.processor.ParboiledTrees;
import org.immutables.generator.processor.Trees;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.ExplicitActionsOnly;
import org.parboiled.annotations.MemoMismatches;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;

@ExplicitActionsOnly
public class Parser
extends BaseParser<Object> {
    Rule COMMENT = this.Literal("--");
    Rule ASSIGN = this.Literal("=");
    Rule DOT = this.Literal(".");
    Rule COMMA = this.Literal(",");
    Rule ELLIPSIS = this.Literal("...");
    Rule IN = this.Literal("in");
    Rule FOR = this.Literal("for");
    Rule LET = this.Literal("let");
    Rule IF = this.Literal("if");
    Rule ELSE = this.Literal("else");
    Rule TEMPLATE = this.Literal("template");
    Rule PUBLIC = this.Literal("public");
    private static final String KEYWORD_IN = "in";
    private static final String KEYWORD_FOR = "for";
    private static final String KEYWORD_LET = "let";
    private static final String KEYWORD_IF = "if";
    private static final String KEYWORD_ELSE = "else";
    private static final String KEYWORD_TEMPLATE = "template";
    private static final String KEYWORD_PUBLIC = "public";

    public Rule Unit() {
        return this.Sequence(ParboiledTrees.Unit.builder(), this.Spacing(), new Object[]{this.OneOrMore(this.Sequence(this.FirstOf(this.OpeningDirective(this.Comment()), this.TemplateDirective(), new Object[0]), ParboiledTrees.Unit.addParts(), new Object[]{this.Spacing()})), EOI, ParboiledTrees.Unit.build()});
    }

    Rule Comment() {
        return this.Sequence(this.COMMENT, this.Optional(this.TextBlock(), Extractions.popped(), new Object[0]), new Object[]{ParboiledTrees.Comment.of()});
    }

    Rule TextBlock() {
        return this.Sequence(ParboiledTrees.TextBlock.builder(), this.TextFragment(), new Object[]{ParboiledTrees.TextBlock.addParts(ParboiledTrees.TextFragment.of()), this.ZeroOrMore(this.Sequence(this.Newline(), ParboiledTrees.TextBlock.addParts(ParboiledTrees.Newline.of()), new Object[]{this.TextFragment(), ParboiledTrees.TextBlock.addParts(ParboiledTrees.TextFragment.of())})), ParboiledTrees.TextBlock.build()});
    }

    Rule TemplateDirective() {
        return this.Sequence(ParboiledTrees.Template.builder(), this.TemplateStart(), new Object[]{this.TemplateBody(), this.TemplateEnd(), ParboiledTrees.Template.build()});
    }

    Rule TemplateStart() {
        return this.OpeningDirective(this.Template());
    }

    Rule TemplateEnd() {
        return this.ClosingDirective(this.TEMPLATE);
    }

    Rule TemplateBody() {
        return this.Sequence(this.TextBlock(), ParboiledTrees.Template.addParts(), new Object[]{this.ZeroOrMore(this.Sequence(this.Directive(), ParboiledTrees.Template.addParts(), new Object[]{this.TextBlock(), ParboiledTrees.Template.addParts()}))});
    }

    Rule DirectiveStart() {
        return this.OpeningDirective(this.FirstOf(this.Comment(), this.Let(), new Object[]{this.If(), this.ElseIf(), this.Else(), this.For(), this.InvokeString(), this.InvokeStart()}));
    }

    Rule InvokeString() {
        return this.Sequence(this.StringLiteral(), ParboiledTrees.InvokeString.of(), new Object[0]);
    }

    Rule InvokeEnd() {
        return this.Sequence(this.AccessExpression(), ParboiledTrees.InvokeEnd.of(), new Object[0]);
    }

    Rule InvokeStart() {
        return this.Sequence(ParboiledTrees.Invoke.builder(), this.AccessExpression(), new Object[]{ParboiledTrees.Invoke.access(), this.Optional(this.Expression(), ParboiledTrees.Invoke.invoke(), new Object[0]), ParboiledTrees.Invoke.build()});
    }

    Rule DirectiveEnd() {
        return this.ClosingDirective(this.FirstOf(this.IfEnd(), this.LetEnd(), new Object[]{this.ForEnd(), this.InvokeEnd()}));
    }

    Rule IfEnd() {
        return this.Sequence(this.IF, ParboiledTrees.IfEnd.of(), new Object[0]);
    }

    Rule LetEnd() {
        return this.Sequence(this.LET, ParboiledTrees.LetEnd.of(), new Object[0]);
    }

    Rule ForEnd() {
        return this.Sequence(this.FOR, ParboiledTrees.ForEnd.of(), new Object[0]);
    }

    Rule Directive() {
        return this.FirstOf(this.DirectiveEnd(), this.DirectiveStart(), new Object[0]);
    }

    Rule OpeningDirective(Rule directive) {
        return this.Sequence("[", directive, new Object[]{"]"});
    }

    Rule ClosingDirective(Rule directive) {
        return this.Sequence("[/", directive, new Object[]{"]"});
    }

    Rule Parens(Rule expression) {
        return this.Sequence(this.Literal("("), expression, new Object[]{this.Literal(")")});
    }

    Rule AccessExpression() {
        return this.Sequence(ParboiledTrees.AccessExpression.builder(), this.Identifier(), new Object[]{ParboiledTrees.AccessExpression.addPath(), this.ZeroOrMore(this.Sequence(this.DOT, this.Identifier(), new Object[]{ParboiledTrees.AccessExpression.addPath()})), ParboiledTrees.AccessExpression.build()});
    }

    Rule GeneratorDeclaration() {
        return this.FirstOf(this.TransformGenerator(), this.AssignGenerator(), new Object[]{this.IterationGenerator()});
    }

    Rule IterationGenerator() {
        return this.Sequence(ParboiledTrees.IterationGenerator.builder(), this.ValueDeclaration(), new Object[]{ParboiledTrees.IterationGenerator.declaration(), this.IN, this.Expression(), ParboiledTrees.IterationGenerator.from(), this.Optional(this.IF, this.Expression(), new Object[]{ParboiledTrees.IterationGenerator.condition()}), ParboiledTrees.IterationGenerator.build()});
    }

    Rule AssignGenerator() {
        return this.Sequence(ParboiledTrees.AssignGenerator.builder(), this.ValueDeclaration(), new Object[]{ParboiledTrees.AssignGenerator.declaration(), this.ASSIGN, this.Expression(), ParboiledTrees.AssignGenerator.from(), ParboiledTrees.AssignGenerator.build()});
    }

    Rule TransformGenerator() {
        return this.Sequence(ParboiledTrees.TransformGenerator.builder(), this.ValueDeclaration(), new Object[]{ParboiledTrees.TransformGenerator.declaration(), this.ASSIGN, this.Expression(), ParboiledTrees.TransformGenerator.transform(), this.FOR, this.ValueDeclaration(), ParboiledTrees.TransformGenerator.varDeclaration(), this.IN, this.Expression(), ParboiledTrees.TransformGenerator.from(), this.Optional(this.IF, this.Expression(), new Object[]{ParboiledTrees.TransformGenerator.condition()}), ParboiledTrees.TransformGenerator.build()});
    }

    @DontLabel
    Rule DisambiguatedExpression() {
        return this.FirstOf(this.Parens(this.ApplyExpression()), this.ForIterationAccessExpression(), new Object[]{this.AccessExpression(), this.StringLiteral()});
    }

    Rule ForIterationAccessExpression() {
        return this.Sequence(this.FOR, this.DOT, new Object[]{this.AccessExpression(), ParboiledTrees.ForIterationAccessExpression.of()});
    }

    Rule Expression() {
        return this.FirstOf(this.Parens(this.ApplyExpression()), this.ApplyExpression(), new Object[0]);
    }

    Rule ApplyExpression() {
        return this.Sequence(ParboiledTrees.ApplyExpression.builder(), this.OneOrMore(this.DisambiguatedExpression(), ParboiledTrees.ApplyExpression.addParams(), new Object[0]), new Object[]{ParboiledTrees.ApplyExpression.build()});
    }

    Rule If() {
        return this.Sequence(this.IF, ParboiledTrees.If.builder(), new Object[]{this.Expression(), ParboiledTrees.If.condition(), ParboiledTrees.If.build()});
    }

    Rule ElseIf() {
        return this.Sequence(this.ELSE, this.IF, new Object[]{ParboiledTrees.ElseIf.builder(), this.Expression(), ParboiledTrees.ElseIf.condition(), ParboiledTrees.ElseIf.build()});
    }

    Rule Else() {
        return this.Sequence(this.ELSE, ParboiledTrees.Else.of(), new Object[0]);
    }

    Rule For() {
        return this.FirstOf(this.Sequence(this.FOR, this.DOT, new Object[]{ParboiledTrees.Invoke.builder(), this.AccessExpression(), ParboiledTrees.ForIterationAccessExpression.of(), ParboiledTrees.Invoke.access(), ParboiledTrees.Invoke.build()}), this.Sequence(this.FOR, ParboiledTrees.For.builder(), new Object[]{this.ForDeclaration(), ParboiledTrees.For.build()}), new Object[0]);
    }

    Rule ForDeclaration() {
        return this.Sequence(this.GeneratorDeclaration(), ParboiledTrees.For.addDeclaration(), new Object[]{this.ZeroOrMore(this.Sequence(this.COMMA, this.GeneratorDeclaration(), new Object[]{ParboiledTrees.For.addDeclaration()}))});
    }

    Rule Let() {
        return this.Sequence(this.LET, ParboiledTrees.Let.builder(), new Object[]{this.InvokableDeclaration(), ParboiledTrees.Let.declaration(), ParboiledTrees.Let.build()});
    }

    Rule ValueDeclaration() {
        return this.Sequence(ParboiledTrees.ValueDeclaration.builder(), this.Optional(this.Type(), ParboiledTrees.ValueDeclaration.type(), new Object[0]), new Object[]{this.Name(), ParboiledTrees.ValueDeclaration.name(), ParboiledTrees.ValueDeclaration.build()});
    }

    Rule InvokableDeclaration() {
        return this.Sequence(ParboiledTrees.InvokableDeclaration.builder(), this.Name(), new Object[]{ParboiledTrees.InvokableDeclaration.name(), this.ZeroOrMore(this.ParameterDeclaration()), ParboiledTrees.InvokableDeclaration.build()});
    }

    Rule ParameterDeclaration() {
        return this.Sequence(ParboiledTrees.Parameter.builder(), this.Type(), new Object[]{ParboiledTrees.Parameter.type(), this.Name(), ParboiledTrees.Parameter.name(), ParboiledTrees.Parameter.build(), ParboiledTrees.InvokableDeclaration.addParameters()});
    }

    Rule Template() {
        return this.Sequence(this.TEMPLATE, this.Optional(this.PUBLIC, ParboiledTrees.Template.isPublic(true), new Object[0]), new Object[]{this.InvokableDeclaration(), ParboiledTrees.Template.declaration()});
    }

    Rule Name() {
        return this.Identifier();
    }

    Rule Type() {
        return this.Sequence(ParboiledTrees.TypeDeclaration.builder(), this.TypeIdentifer(), new Object[]{ParboiledTrees.TypeDeclaration.type(), this.Optional(this.Ellipsis(), ParboiledTrees.TypeDeclaration.kind(Trees.TypeDeclaration.Kind.ITERABLE), new Object[0]), ParboiledTrees.TypeDeclaration.build()});
    }

    @MemoMismatches
    @SuppressNode
    Rule Keyword() {
        return this.Sequence(this.FirstOf(KEYWORD_IN, KEYWORD_FOR, new Object[]{KEYWORD_LET, KEYWORD_IF, KEYWORD_ELSE, KEYWORD_TEMPLATE, KEYWORD_PUBLIC}), this.TestNot(this.LetterOrDigit()), new Object[0]);
    }

    @DontLabel
    @SuppressSubnodes
    Rule Literal(String string) {
        return this.Sequence(this.String(string), this.Spacing(), new Object[0]);
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule Identifier() {
        return this.Sequence(this.TestNot(this.Keyword()), this.Sequence(this.Sequence(this.IdentifierStartLetter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]), ParboiledTrees.Identifier.of(), new Object[0]), new Object[]{this.Spacing()});
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule StringLiteral() {
        return this.Sequence("'", this.ZeroOrMore(this.NoneOf("'")), new Object[]{ParboiledTrees.StringLiteral.of(), "'", this.Spacing()});
    }

    @SuppressSubnodes
    @MemoMismatches
    Rule TypeIdentifer() {
        return this.Sequence(this.TestNot(this.Keyword()), this.Sequence(this.Sequence(this.TypeStartLetter(), this.ZeroOrMore(this.LetterOrDigit()), new Object[0]), ParboiledTrees.TypeIdentifier.of(), new Object[0]), new Object[]{this.Spacing()});
    }

    @SuppressSubnodes
    Rule Newline() {
        return this.FirstOf("\n", "\n\r", new Object[0]);
    }

    @SuppressSubnodes
    Rule TextFragment() {
        return this.ZeroOrMore(this.NoneOf("[]\n\r"));
    }

    @SuppressSubnodes
    Rule Ellipsis() {
        return this.Sequence(this.ELLIPSIS, this.Spacing(), new Object[0]);
    }

    Rule IdentifierStartLetter() {
        return this.FirstOf(this.CharRange('a', 'z'), Character.valueOf('_'), new Object[0]);
    }

    Rule TypeStartLetter() {
        return this.CharRange('A', 'Z');
    }

    @MemoMismatches
    Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{Character.valueOf('_'), Character.valueOf('$')});
    }

    @MemoMismatches
    Rule LetterOrDigit() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[]{this.CharRange('0', '9'), Character.valueOf('_'), Character.valueOf('$')});
    }

    @SuppressNode
    Rule Spacing() {
        return this.ZeroOrMore(this.AnyOf(" \n\r\f\t"));
    }
}

