/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.immutables.generator.Generator;
import org.immutables.generator.processor.Balancing;
import org.immutables.generator.processor.GeneratedTypes;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Inliner;
import org.immutables.generator.processor.Parser;
import org.immutables.generator.processor.Spacing;
import org.immutables.generator.processor.SwissArmyKnife;
import org.immutables.generator.processor.TemplateWriter;
import org.immutables.generator.processor.TypeResolver;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public final class Processor
extends AbstractProcessor {
    private final Parser parser = (Parser)Parboiled.createParser(Parser.class, (Object[])new Object[0]);

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Generator.Template.class.getCanonicalName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (!round.processingOver() && !round.errorRaised()) {
            this.processTemplates(round.getElementsAnnotatedWith(Generator.Template.class));
        }
        return true;
    }

    private void processTemplates(Set<? extends Element> templates) {
        for (TypeElement templateType : ElementFilter.typesIn(templates)) {
            try {
                this.generateTemplateType(templateType);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage() + "\n\n" + Throwables.getStackTraceAsString((Throwable)ex), templateType);
            }
        }
    }

    private void generateTemplateType(TypeElement templateType) throws IOException, Exception {
        SwissArmyKnife knife = new SwissArmyKnife(this.processingEnv, templateType);
        String string = this.readTemplateResource(templateType, knife);
        ImmutableTrees.Unit unit = this.parseUnit(string);
        ImmutableTrees.Unit resolved = this.transformUnit(knife, unit);
        TemplateWriter writingTransformer = new TemplateWriter(knife, templateType, GeneratedTypes.getSimpleName(templateType));
        CharSequence template = writingTransformer.toCharSequence(resolved);
        JavaFileObject templateFile = knife.environment.getFiler().createSourceFile(GeneratedTypes.getQualifiedName(knife.elements, templateType), templateType);
        try (Writer writer = templateFile.openWriter();){
            writer.append(template);
        }
    }

    private String readTemplateResource(TypeElement templateType, SwissArmyKnife knife) throws IOException {
        PackageElement packageElement = knife.elements.getPackageOf(templateType);
        return this.getTemplateText(knife.environment.getFiler(), templateType, packageElement);
    }

    private String getTemplateText(Filer filer, TypeElement templateType, PackageElement packageElement) throws IOException {
        String relativeName = templateType.getSimpleName() + ".generator";
        Name packageName = packageElement.getQualifiedName();
        ArrayList suppressed = Lists.newArrayList();
        try {
            return filer.getResource(StandardLocation.SOURCE_PATH, packageName, relativeName).getCharContent(true).toString();
        }
        catch (Exception cannotGetFromSourcePath) {
            suppressed.add(cannotGetFromSourcePath);
            try {
                return filer.getResource(StandardLocation.CLASS_OUTPUT, packageName, relativeName).getCharContent(true).toString();
            }
            catch (Exception cannotGetFromOutputPath) {
                suppressed.add(cannotGetFromOutputPath);
                try {
                    return filer.getResource(StandardLocation.CLASS_PATH, "", packageName.toString().replace('.', '/') + '/' + relativeName).getCharContent(true).toString();
                }
                catch (IOException cannotGetFromClasspath) {
                    for (Exception e : suppressed) {
                        cannotGetFromClasspath.addSuppressed(e);
                    }
                    throw cannotGetFromClasspath;
                }
            }
        }
    }

    private ImmutableTrees.Unit parseUnit(String templateText) throws Exception {
        ParsingResult result = new ReportingParseRunner(this.parser.Unit()).run(templateText);
        if (result.hasErrors()) {
            String errors = ErrorUtils.printParseErrors((List)result.parseErrors);
            throw new Exception(errors);
        }
        return (ImmutableTrees.Unit)Iterables.getOnlyElement((Iterable)result.valueStack);
    }

    private ImmutableTrees.Unit transformUnit(SwissArmyKnife knife, ImmutableTrees.Unit unit) {
        ImmutableTrees.Unit trimmed = Spacing.normalize(unit);
        ImmutableTrees.Unit balanced = Balancing.balance(trimmed);
        ImmutableTrees.Unit optimized = Inliner.optimize(balanced);
        ImmutableTrees.Unit resolved = new TypeResolver(knife).resolve(optimized);
        return resolved;
    }
}

