/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import java.util.List;
import org.immutables.generator.StringLiterals;

public class Trees {
    private Trees() {
    }

    public static abstract class TextLine
    implements TemplatePart,
    Synthetic {
        public abstract TextFragment fragment();

        public boolean isBlank() {
            return this.fragment().isWhitespace();
        }

        public boolean isEmpty() {
            return this.fragment().value().isEmpty();
        }

        public boolean newline() {
            return false;
        }

        public String toString() {
            return StringLiterals.toLiteral((String)(this.fragment().value() + (this.newline() ? "\n" : "")));
        }
    }

    public static interface TextBlock
    extends TemplatePart {
        public List<TextPart> parts();
    }

    public static abstract class TextFragment
    implements TextPart {
        public abstract String value();

        public String toString() {
            return StringLiterals.toLiteral((String)this.value());
        }

        public boolean isWhitespace() {
            return CharMatcher.WHITESPACE.matchesAllOf((CharSequence)this.value());
        }
    }

    public static abstract class Newline
    implements TextPart {
        public String toString() {
            return StringLiterals.toLiteral((String)"\n");
        }
    }

    public static abstract class StringLiteral
    implements Expression {
        public abstract String value();

        public String toString() {
            return StringLiterals.toLiteral((String)this.value());
        }
    }

    public static interface TextPart {
    }

    public static interface TemplateEnd
    extends DirectiveEnd,
    Synthetic {
    }

    public static interface Else
    extends Otherwise {
    }

    public static interface Conditional {
        public Expression condition();
    }

    public static interface ElseIf
    extends Otherwise,
    Conditional {
    }

    public static interface Otherwise
    extends DirectiveStart {
    }

    public static interface If
    extends Conditional,
    DirectiveStart {
    }

    public static interface For
    extends DirectiveStart {
        public List<GeneratorDeclaration> declaration();
    }

    public static interface TransformGenerator
    extends GeneratorValueDeclaration {
        public Expression transform();

        public ValueDeclaration varDeclaration();

        public Optional<Expression> condition();
    }

    public static interface IterationGenerator
    extends GeneratorValueDeclaration {
        public Optional<Expression> condition();
    }

    public static interface AssignGenerator
    extends GeneratorValueDeclaration {
    }

    public static interface GeneratorValueDeclaration
    extends GeneratorDeclaration {
        public ValueDeclaration declaration();

        public Expression from();
    }

    public static interface GeneratorDeclaration {
    }

    public static interface ApplyExpression
    extends Expression {
        public List<Expression> params();
    }

    public static interface AccessExpression
    extends Expression {
        public List<Identifier> path();
    }

    public static interface Expression {
    }

    public static abstract class Template
    implements Directive,
    Block,
    UnitPart,
    InvokableStatement {
        public boolean isPublic() {
            return false;
        }
    }

    public static interface Synthetic {
    }

    public static interface TemplatePart {
    }

    public static interface Unit {
        public List<UnitPart> parts();
    }

    public static interface UnitPart {
    }

    public static interface Let
    extends DirectiveStart,
    InvokableStatement {
    }

    public static interface Directive
    extends TemplatePart {
    }

    public static interface Invoke
    extends InvokeDeclaration,
    DirectiveStart {
    }

    public static interface InvokeDeclaration {
        public AccessExpression access();

        public Optional<ApplyExpression> invoke();
    }

    public static interface InvokeString
    extends DirectiveStart {
        public StringLiteral literal();
    }

    public static interface InvokeEnd
    extends DirectiveEnd {
        public AccessExpression access();
    }

    public static interface IfEnd
    extends DirectiveEnd {
    }

    public static interface ForEnd
    extends DirectiveEnd {
    }

    public static interface LetEnd
    extends DirectiveEnd {
    }

    public static interface DirectiveEnd
    extends Directive {
    }

    public static interface DirectiveStart
    extends Directive {
    }

    public static interface InvokeStatement
    extends Block,
    Synthetic {
        public Expression access();

        public List<Expression> params();
    }

    public static interface LetStatement
    extends Block,
    InvokableStatement,
    Synthetic {
    }

    public static interface ForIterationAccessExpression
    extends AccessExpression {
        public AccessExpression access();
    }

    public static abstract class ForStatement
    implements Block,
    Synthetic {
        public boolean useForAccess() {
            return true;
        }

        public boolean useDelimit() {
            return true;
        }

        public abstract List<GeneratorDeclaration> declaration();
    }

    public static interface IfStatement
    extends TemplatePart,
    Synthetic {
        public ConditionalBlock then();

        public List<ConditionalBlock> otherwiseIf();

        public Optional<Block> otherwise();
    }

    public static interface ConditionalBlock
    extends Conditional,
    Block,
    Synthetic {
    }

    public static interface Comment
    extends UnitPart,
    TemplatePart {
    }

    public static interface Block
    extends TemplatePart {
        public List<TemplatePart> parts();
    }

    public static interface InvokableStatement {
        public InvokableDeclaration declaration();
    }

    public static interface Named {
        public Identifier name();
    }

    public static interface Parameter
    extends Named,
    Typed {
    }

    public static interface Typed {
        public TypeReference type();
    }

    public static interface ValueDeclaration
    extends Named {
        public Optional<TypeReference> type();

        public Optional<TypeReference> containedType();

        public ValueDeclaration withType(TypeReference var1);

        public ValueDeclaration withContainedType(TypeReference var1);
    }

    public static interface InvokableDeclaration
    extends Named {
        public List<Parameter> parameters();
    }

    public static abstract class BoundAccessExpression
    implements AccessExpression,
    Synthetic {
        public abstract List<Object> accessor();

        public String toString() {
            return this.accessor().toString();
        }
    }

    public static abstract class ResolvedType
    implements TypeReference,
    Synthetic {
        public abstract Object type();

        public String toString() {
            return this.type().toString();
        }
    }

    public static abstract class TypeDeclaration
    implements TypeReference {
        public abstract TypeIdentifier type();

        public Kind kind() {
            return Kind.SCALAR;
        }

        public static enum Kind {
            SCALAR,
            ITERABLE;

        }
    }

    public static interface TypeReference {
    }

    public static abstract class TypeIdentifier {
        public abstract String value();

        public String toString() {
            return "`" + this.value() + "`";
        }
    }

    public static abstract class Identifier {
        public abstract String value();

        public String toString() {
            return "`" + this.value() + "`";
        }
    }
}

