/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;

public final class ExtensionLoader {
    private static final Splitter RESOURCE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();

    private ExtensionLoader() {
    }

    public static ImmutableSet<String> findExtensions(String resource) {
        ArrayList annotations = Lists.newArrayList();
        ClassLoader classLoader = ExtensionLoader.class.getClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(resource);
            while (resources.hasMoreElements()) {
                URL nextElement = resources.nextElement();
                String lines = Resources.toString((URL)nextElement, (Charset)StandardCharsets.UTF_8);
                annotations.addAll(RESOURCE_SPLITTER.splitToList((CharSequence)lines));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FluentIterable.from((Iterable)annotations).toSet();
    }
}

