/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generator.processor.Trees;

@ParametersAreNonnullByDefault
public final class ImmutableTrees {
    private ImmutableTrees() {
    }

    @Immutable
    public static final class ValueDeclaration
    implements Trees.ValueDeclaration {
        private final Optional<Trees.TypeReference> type;
        private final Optional<Trees.TypeReference> containedType;
        private final Trees.Identifier name;

        private ValueDeclaration(Optional<Trees.TypeReference> type, Optional<Trees.TypeReference> containedType, Trees.Identifier name) {
            this.type = type;
            this.containedType = containedType;
            this.name = name;
        }

        @Override
        public Optional<Trees.TypeReference> type() {
            return this.type;
        }

        @Override
        public Optional<Trees.TypeReference> containedType() {
            return this.containedType;
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        @Override
        public final ValueDeclaration withType(Trees.TypeReference value) {
            Optional newValue = Optional.of((Object)value);
            if (this.type.isPresent() && this.type.get() == value) {
                return this;
            }
            return new ValueDeclaration((Optional<Trees.TypeReference>)newValue, this.containedType, this.name);
        }

        public final ValueDeclaration withType(Optional<? extends Trees.TypeReference> optional) {
            Optional<? extends Trees.TypeReference> value = optional;
            if (!this.type.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.type.isPresent() && value.isPresent() && this.type.get() == value.get()) {
                return this;
            }
            return new ValueDeclaration(value, this.containedType, this.name);
        }

        @Override
        public final ValueDeclaration withContainedType(Trees.TypeReference value) {
            Optional newValue = Optional.of((Object)value);
            if (this.containedType.isPresent() && this.containedType.get() == value) {
                return this;
            }
            return new ValueDeclaration(this.type, (Optional<Trees.TypeReference>)newValue, this.name);
        }

        public final ValueDeclaration withContainedType(Optional<? extends Trees.TypeReference> optional) {
            Optional<? extends Trees.TypeReference> value = optional;
            if (!this.containedType.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.containedType.isPresent() && value.isPresent() && this.containedType.get() == value.get()) {
                return this;
            }
            return new ValueDeclaration(this.type, value, this.name);
        }

        public final ValueDeclaration withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value, (Object)"name");
            return new ValueDeclaration(this.type, this.containedType, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ValueDeclaration && this.equalTo((ValueDeclaration)another);
        }

        private boolean equalTo(ValueDeclaration another) {
            return this.type.equals(another.type) && this.containedType.equals(another.containedType) && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.containedType.hashCode();
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ValueDeclaration").omitNullValues().add("type", this.type.orNull()).add("containedType", this.containedType.orNull()).add("name", (Object)this.name).toString();
        }

        public static ValueDeclaration copyOf(Trees.ValueDeclaration instance) {
            if (instance instanceof ValueDeclaration) {
                return (ValueDeclaration)instance;
            }
            return ValueDeclaration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            private Optional<Trees.TypeReference> type = Optional.absent();
            private Optional<Trees.TypeReference> containedType = Optional.absent();
            @Nullable
            private Trees.Identifier name;

            private Builder() {
            }

            public final Builder from(Trees.ValueDeclaration instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Named instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Trees.Named instance;
                if (object instanceof Trees.ValueDeclaration) {
                    Optional<Trees.TypeReference> containedTypeOptional;
                    instance = (Trees.ValueDeclaration)object;
                    Optional<Trees.TypeReference> typeOptional = instance.type();
                    if (typeOptional.isPresent()) {
                        this.type(typeOptional);
                    }
                    if ((containedTypeOptional = instance.containedType()).isPresent()) {
                        this.containedType(containedTypeOptional);
                    }
                }
                if (object instanceof Trees.Named) {
                    instance = (Trees.Named)object;
                    this.name(instance.name());
                }
            }

            public final Builder type(Trees.TypeReference type) {
                this.type = Optional.of((Object)type);
                return this;
            }

            public final Builder type(Optional<? extends Trees.TypeReference> type) {
                this.type = type;
                return this;
            }

            public final Builder containedType(Trees.TypeReference containedType) {
                this.containedType = Optional.of((Object)containedType);
                return this;
            }

            public final Builder containedType(Optional<? extends Trees.TypeReference> containedType) {
                this.containedType = containedType;
                return this;
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name, (Object)"name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ValueDeclaration build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ValueDeclaration(this.type, this.containedType, this.name);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build ValueDeclaration, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class Template
    extends Trees.Template {
        private final boolean isPublic;
        private final ImmutableList<Trees.TemplatePart> parts;
        private final Trees.InvokableDeclaration declaration;

        private Template(Builder builder) {
            this.parts = builder.parts.build();
            this.declaration = builder.declaration;
            this.isPublic = builder.isPublicIsSet() ? builder.isPublic : super.isPublic();
        }

        private Template(boolean isPublic, ImmutableList<Trees.TemplatePart> parts, Trees.InvokableDeclaration declaration) {
            this.isPublic = isPublic;
            this.parts = parts;
            this.declaration = declaration;
        }

        @Override
        public boolean isPublic() {
            return this.isPublic;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public final Template withIsPublic(boolean value) {
            if (this.isPublic == value) {
                return this;
            }
            return new Template(value, this.parts, this.declaration);
        }

        public final Template withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Template(this.isPublic, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration);
        }

        public final Template withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Template(this.isPublic, (ImmutableList<Trees.TemplatePart>)newValue, this.declaration);
        }

        public final Template withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new Template(this.isPublic, this.parts, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Template && this.equalTo((Template)another);
        }

        private boolean equalTo(Template another) {
            return this.isPublic == another.isPublic && this.parts.equals(another.parts) && this.declaration.equals(another.declaration);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Booleans.hashCode((boolean)this.isPublic);
            h += (h << 5) + this.parts.hashCode();
            h += (h << 5) + this.declaration.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Template").omitNullValues().add("isPublic", this.isPublic).add("parts", this.parts).add("declaration", (Object)this.declaration).toString();
        }

        public static Template copyOf(Trees.Template instance) {
            if (instance instanceof Template) {
                return (Template)instance;
            }
            return Template.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private static final long OPT_BIT_IS_PUBLIC = 1L;
            private long initBits = 1L;
            private long optBits;
            private boolean isPublic;
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Template instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.InvokableStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof Trees.Block) {
                    instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
                if (object instanceof Trees.Template) {
                    instance = (Trees.Template)object;
                    this.isPublic(((Trees.Template)instance).isPublic());
                }
                if (object instanceof Trees.InvokableStatement) {
                    instance = (Trees.InvokableStatement)object;
                    this.declaration(instance.declaration());
                }
            }

            public final Builder isPublic(boolean isPublic) {
                this.isPublic = isPublic;
                this.optBits |= 1L;
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Template build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Template(this);
            }

            private boolean isPublicIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                return "Cannot build Template, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class LetStatement
    implements Trees.LetStatement {
        private final ImmutableList<Trees.TemplatePart> parts;
        private final Trees.InvokableDeclaration declaration;

        private LetStatement(ImmutableList<Trees.TemplatePart> parts, Trees.InvokableDeclaration declaration) {
            this.parts = parts;
            this.declaration = declaration;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public final LetStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new LetStatement((ImmutableList<Trees.TemplatePart>)newValue, this.declaration);
        }

        public final LetStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new LetStatement((ImmutableList<Trees.TemplatePart>)newValue, this.declaration);
        }

        public final LetStatement withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new LetStatement(this.parts, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof LetStatement && this.equalTo((LetStatement)another);
        }

        private boolean equalTo(LetStatement another) {
            return this.parts.equals(another.parts) && this.declaration.equals(another.declaration);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.parts.hashCode();
            h += (h << 5) + this.declaration.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"LetStatement").omitNullValues().add("parts", this.parts).add("declaration", (Object)this.declaration).toString();
        }

        public static LetStatement copyOf(Trees.LetStatement instance) {
            if (instance instanceof LetStatement) {
                return (LetStatement)instance;
            }
            return LetStatement.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private long initBits = 1L;
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.InvokableStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.LetStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof Trees.Block) {
                    instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
                if (object instanceof Trees.InvokableStatement) {
                    instance = (Trees.InvokableStatement)object;
                    this.declaration(instance.declaration());
                }
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public LetStatement build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new LetStatement(this.parts.build(), this.declaration);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                return "Cannot build LetStatement, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class ConditionalBlock
    implements Trees.ConditionalBlock {
        private final Trees.Expression condition;
        private final ImmutableList<Trees.TemplatePart> parts;

        private ConditionalBlock(Trees.Expression condition, ImmutableList<Trees.TemplatePart> parts) {
            this.condition = condition;
            this.parts = parts;
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public final ConditionalBlock withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"condition");
            return new ConditionalBlock(newValue, this.parts);
        }

        public final ConditionalBlock withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ConditionalBlock(this.condition, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public final ConditionalBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ConditionalBlock(this.condition, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ConditionalBlock && this.equalTo((ConditionalBlock)another);
        }

        private boolean equalTo(ConditionalBlock another) {
            return this.condition.equals(another.condition) && this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ConditionalBlock").omitNullValues().add("condition", (Object)this.condition).add("parts", this.parts).toString();
        }

        public static ConditionalBlock copyOf(Trees.ConditionalBlock instance) {
            if (instance instanceof ConditionalBlock) {
                return (ConditionalBlock)instance;
            }
            return ConditionalBlock.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.Expression condition;
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.Conditional instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.ConditionalBlock instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof Trees.Conditional) {
                    instance = (Trees.Conditional)object;
                    this.condition(instance.condition());
                }
                if (object instanceof Trees.Block) {
                    instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition, (Object)"condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public ConditionalBlock build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ConditionalBlock(this.condition, this.parts.build());
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                return "Cannot build ConditionalBlock, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class ApplyExpression
    implements Trees.ApplyExpression {
        private final ImmutableList<Trees.Expression> params;

        private ApplyExpression(ImmutableList<Trees.Expression> params) {
            this.params = params;
        }

        public ImmutableList<Trees.Expression> params() {
            return this.params;
        }

        public final ApplyExpression withParams(Trees.Expression ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ApplyExpression((ImmutableList<Trees.Expression>)newValue);
        }

        public final ApplyExpression withParams(Iterable<? extends Trees.Expression> elements) {
            if (this.params == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ApplyExpression((ImmutableList<Trees.Expression>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ApplyExpression && this.equalTo((ApplyExpression)another);
        }

        private boolean equalTo(ApplyExpression another) {
            return this.params.equals(another.params);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.params.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ApplyExpression").omitNullValues().add("params", this.params).toString();
        }

        public static ApplyExpression copyOf(Trees.ApplyExpression instance) {
            if (instance instanceof ApplyExpression) {
                return (ApplyExpression)instance;
            }
            return ApplyExpression.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.Expression> params = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.ApplyExpression instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.addAllParams(instance.params());
                return this;
            }

            public final Builder addParams(Trees.Expression element) {
                this.params.add((Object)element);
                return this;
            }

            public final Builder addParams(Trees.Expression ... elements) {
                this.params.add((Object[])elements);
                return this;
            }

            public final Builder params(Iterable<? extends Trees.Expression> elements) {
                this.params = ImmutableList.builder();
                return this.addAllParams(elements);
            }

            public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
                this.params.addAll(elements);
                return this;
            }

            public ApplyExpression build() {
                return new ApplyExpression(this.params.build());
            }
        }
    }

    @Immutable
    public static final class InvokeString
    implements Trees.InvokeString {
        private final Trees.StringLiteral literal;

        private InvokeString(Trees.StringLiteral literal) {
            this.literal = (Trees.StringLiteral)Preconditions.checkNotNull((Object)literal, (Object)"literal");
        }

        private InvokeString(InvokeString original, Trees.StringLiteral literal) {
            this.literal = literal;
        }

        @Override
        public Trees.StringLiteral literal() {
            return this.literal;
        }

        public final InvokeString withLiteral(Trees.StringLiteral value) {
            if (this.literal == value) {
                return this;
            }
            Trees.StringLiteral newValue = (Trees.StringLiteral)Preconditions.checkNotNull((Object)value, (Object)"literal");
            return new InvokeString(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof InvokeString && this.equalTo((InvokeString)another);
        }

        private boolean equalTo(InvokeString another) {
            return this.literal.equals(another.literal);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.literal.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeString").omitNullValues().add("literal", (Object)this.literal).toString();
        }

        public static InvokeString of(Trees.StringLiteral literal) {
            return new InvokeString(literal);
        }

        public static InvokeString copyOf(Trees.InvokeString instance) {
            if (instance instanceof InvokeString) {
                return (InvokeString)instance;
            }
            return InvokeString.of(instance.literal());
        }
    }

    @Immutable
    public static final class IfStatement
    implements Trees.IfStatement {
        private final Trees.ConditionalBlock then;
        private final ImmutableList<Trees.ConditionalBlock> otherwiseIf;
        private final Optional<Trees.Block> otherwise;

        private IfStatement(Trees.ConditionalBlock then, ImmutableList<Trees.ConditionalBlock> otherwiseIf, Optional<Trees.Block> otherwise) {
            this.then = then;
            this.otherwiseIf = otherwiseIf;
            this.otherwise = otherwise;
        }

        @Override
        public Trees.ConditionalBlock then() {
            return this.then;
        }

        public ImmutableList<Trees.ConditionalBlock> otherwiseIf() {
            return this.otherwiseIf;
        }

        @Override
        public Optional<Trees.Block> otherwise() {
            return this.otherwise;
        }

        public final IfStatement withThen(Trees.ConditionalBlock value) {
            if (this.then == value) {
                return this;
            }
            Trees.ConditionalBlock newValue = (Trees.ConditionalBlock)Preconditions.checkNotNull((Object)value, (Object)"then");
            return new IfStatement(newValue, this.otherwiseIf, this.otherwise);
        }

        public final IfStatement withOtherwiseIf(Trees.ConditionalBlock ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new IfStatement(this.then, (ImmutableList<Trees.ConditionalBlock>)newValue, this.otherwise);
        }

        public final IfStatement withOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
            if (this.otherwiseIf == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new IfStatement(this.then, (ImmutableList<Trees.ConditionalBlock>)newValue, this.otherwise);
        }

        public final IfStatement withOtherwise(Trees.Block value) {
            Optional newValue = Optional.of((Object)value);
            if (this.otherwise.isPresent() && this.otherwise.get() == value) {
                return this;
            }
            return new IfStatement(this.then, this.otherwiseIf, (Optional<Trees.Block>)newValue);
        }

        public final IfStatement withOtherwise(Optional<? extends Trees.Block> optional) {
            Optional<? extends Trees.Block> value = optional;
            if (!this.otherwise.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.otherwise.isPresent() && value.isPresent() && this.otherwise.get() == value.get()) {
                return this;
            }
            return new IfStatement(this.then, this.otherwiseIf, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IfStatement && this.equalTo((IfStatement)another);
        }

        private boolean equalTo(IfStatement another) {
            return this.then.equals(another.then) && this.otherwiseIf.equals(another.otherwiseIf) && this.otherwise.equals(another.otherwise);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.then.hashCode();
            h += (h << 5) + this.otherwiseIf.hashCode();
            h += (h << 5) + this.otherwise.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IfStatement").omitNullValues().add("then", (Object)this.then).add("otherwiseIf", this.otherwiseIf).add("otherwise", this.otherwise.orNull()).toString();
        }

        public static IfStatement copyOf(Trees.IfStatement instance) {
            if (instance instanceof IfStatement) {
                return (IfStatement)instance;
            }
            return IfStatement.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_THEN = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.ConditionalBlock then;
            private ImmutableList.Builder<Trees.ConditionalBlock> otherwiseIf = ImmutableList.builder();
            private Optional<Trees.Block> otherwise = Optional.absent();

            private Builder() {
            }

            public final Builder from(Trees.IfStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.then(instance.then());
                this.addAllOtherwiseIf(instance.otherwiseIf());
                Optional<Trees.Block> otherwiseOptional = instance.otherwise();
                if (otherwiseOptional.isPresent()) {
                    this.otherwise(otherwiseOptional);
                }
                return this;
            }

            public final Builder then(Trees.ConditionalBlock then) {
                this.then = (Trees.ConditionalBlock)Preconditions.checkNotNull((Object)then, (Object)"then");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addOtherwiseIf(Trees.ConditionalBlock element) {
                this.otherwiseIf.add((Object)element);
                return this;
            }

            public final Builder addOtherwiseIf(Trees.ConditionalBlock ... elements) {
                this.otherwiseIf.add((Object[])elements);
                return this;
            }

            public final Builder otherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
                this.otherwiseIf = ImmutableList.builder();
                return this.addAllOtherwiseIf(elements);
            }

            public final Builder addAllOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
                this.otherwiseIf.addAll(elements);
                return this;
            }

            public final Builder otherwise(Trees.Block otherwise) {
                this.otherwise = Optional.of((Object)otherwise);
                return this;
            }

            public final Builder otherwise(Optional<? extends Trees.Block> otherwise) {
                this.otherwise = otherwise;
                return this;
            }

            public IfStatement build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IfStatement(this.then, this.otherwiseIf.build(), this.otherwise);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("then");
                }
                return "Cannot build IfStatement, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class Newline
    extends Trees.Newline {
        private static final Newline INSTANCE = new Newline();

        private Newline() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return -1911993872;
        }

        public static Newline of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class TextLine
    extends Trees.TextLine {
        private final Trees.TextFragment fragment;
        private final boolean newline;

        private TextLine(Builder builder) {
            this.fragment = builder.fragment;
            this.newline = builder.newlineIsSet() ? builder.newline : super.newline();
        }

        private TextLine(Trees.TextFragment fragment, boolean newline) {
            this.fragment = fragment;
            this.newline = newline;
        }

        @Override
        public Trees.TextFragment fragment() {
            return this.fragment;
        }

        @Override
        public boolean newline() {
            return this.newline;
        }

        public final TextLine withFragment(Trees.TextFragment value) {
            if (this.fragment == value) {
                return this;
            }
            Trees.TextFragment newValue = (Trees.TextFragment)Preconditions.checkNotNull((Object)value, (Object)"fragment");
            return new TextLine(newValue, this.newline);
        }

        public final TextLine withNewline(boolean value) {
            if (this.newline == value) {
                return this;
            }
            return new TextLine(this.fragment, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TextLine && this.equalTo((TextLine)another);
        }

        private boolean equalTo(TextLine another) {
            return this.fragment.equals(another.fragment) && this.newline == another.newline;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.fragment.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.newline);
            return h;
        }

        public static TextLine copyOf(Trees.TextLine instance) {
            if (instance instanceof TextLine) {
                return (TextLine)instance;
            }
            return TextLine.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_FRAGMENT = 1L;
            private static final long OPT_BIT_NEWLINE = 1L;
            private long initBits = 1L;
            private long optBits;
            @Nullable
            private Trees.TextFragment fragment;
            private boolean newline;

            private Builder() {
            }

            public final Builder from(Trees.TextLine instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.fragment(instance.fragment());
                this.newline(instance.newline());
                return this;
            }

            public final Builder fragment(Trees.TextFragment fragment) {
                this.fragment = (Trees.TextFragment)Preconditions.checkNotNull((Object)fragment, (Object)"fragment");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder newline(boolean newline) {
                this.newline = newline;
                this.optBits |= 1L;
                return this;
            }

            public TextLine build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TextLine(this);
            }

            private boolean newlineIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("fragment");
                }
                return "Cannot build TextLine, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class SimpleAccessExpression
    implements Trees.SimpleAccessExpression {
        private final ImmutableList<Trees.Identifier> path;

        private SimpleAccessExpression(ImmutableList<Trees.Identifier> path) {
            this.path = path;
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public final SimpleAccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new SimpleAccessExpression((ImmutableList<Trees.Identifier>)newValue);
        }

        public final SimpleAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new SimpleAccessExpression((ImmutableList<Trees.Identifier>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SimpleAccessExpression && this.equalTo((SimpleAccessExpression)another);
        }

        private boolean equalTo(SimpleAccessExpression another) {
            return this.path.equals(another.path);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.path.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"SimpleAccessExpression").omitNullValues().add("path", this.path).toString();
        }

        public static SimpleAccessExpression copyOf(Trees.SimpleAccessExpression instance) {
            if (instance instanceof SimpleAccessExpression) {
                return (SimpleAccessExpression)instance;
            }
            return SimpleAccessExpression.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.Identifier> path = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.AccessExpression instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.SimpleAccessExpression instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.AccessExpression) {
                    Trees.AccessExpression instance = (Trees.AccessExpression)object;
                    this.addAllPath(instance.path());
                }
            }

            public final Builder addPath(Trees.Identifier element) {
                this.path.add((Object)element);
                return this;
            }

            public final Builder addPath(Trees.Identifier ... elements) {
                this.path.add((Object[])elements);
                return this;
            }

            public final Builder path(Iterable<? extends Trees.Identifier> elements) {
                this.path = ImmutableList.builder();
                return this.addAllPath(elements);
            }

            public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
                this.path.addAll(elements);
                return this;
            }

            public SimpleAccessExpression build() {
                return new SimpleAccessExpression(this.path.build());
            }
        }
    }

    @Immutable
    public static final class BoundAccessExpression
    extends Trees.BoundAccessExpression {
        private final ImmutableList<Object> accessor;
        private final ImmutableList<Trees.Identifier> path;

        private BoundAccessExpression(ImmutableList<Object> accessor, ImmutableList<Trees.Identifier> path) {
            this.accessor = accessor;
            this.path = path;
        }

        public ImmutableList<Object> accessor() {
            return this.accessor;
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public final BoundAccessExpression withAccessor(Object ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new BoundAccessExpression((ImmutableList<Object>)newValue, this.path);
        }

        public final BoundAccessExpression withAccessor(Iterable<? extends Object> elements) {
            if (this.accessor == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new BoundAccessExpression((ImmutableList<Object>)newValue, this.path);
        }

        public final BoundAccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new BoundAccessExpression(this.accessor, (ImmutableList<Trees.Identifier>)newValue);
        }

        public final BoundAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new BoundAccessExpression(this.accessor, (ImmutableList<Trees.Identifier>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BoundAccessExpression && this.equalTo((BoundAccessExpression)another);
        }

        private boolean equalTo(BoundAccessExpression another) {
            return this.accessor.equals(another.accessor) && this.path.equals(another.path);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.accessor.hashCode();
            h += (h << 5) + this.path.hashCode();
            return h;
        }

        public static BoundAccessExpression copyOf(Trees.BoundAccessExpression instance) {
            if (instance instanceof BoundAccessExpression) {
                return (BoundAccessExpression)instance;
            }
            return BoundAccessExpression.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Object> accessor = ImmutableList.builder();
            private ImmutableList.Builder<Trees.Identifier> path = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.BoundAccessExpression instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.AccessExpression instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Trees.AccessExpression instance;
                if (object instanceof Trees.BoundAccessExpression) {
                    instance = (Trees.BoundAccessExpression)object;
                    this.addAllAccessor(((Trees.BoundAccessExpression)instance).accessor());
                }
                if (object instanceof Trees.AccessExpression) {
                    instance = (Trees.AccessExpression)object;
                    this.addAllPath(instance.path());
                }
            }

            public final Builder addAccessor(Object element) {
                this.accessor.add(element);
                return this;
            }

            public final Builder addAccessor(Object ... elements) {
                this.accessor.add(elements);
                return this;
            }

            public final Builder accessor(Iterable<? extends Object> elements) {
                this.accessor = ImmutableList.builder();
                return this.addAllAccessor(elements);
            }

            public final Builder addAllAccessor(Iterable<? extends Object> elements) {
                this.accessor.addAll(elements);
                return this;
            }

            public final Builder addPath(Trees.Identifier element) {
                this.path.add((Object)element);
                return this;
            }

            public final Builder addPath(Trees.Identifier ... elements) {
                this.path.add((Object[])elements);
                return this;
            }

            public final Builder path(Iterable<? extends Trees.Identifier> elements) {
                this.path = ImmutableList.builder();
                return this.addAllPath(elements);
            }

            public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
                this.path.addAll(elements);
                return this;
            }

            public BoundAccessExpression build() {
                return new BoundAccessExpression(this.accessor.build(), this.path.build());
            }
        }
    }

    @Immutable
    public static final class ResolvedType
    extends Trees.ResolvedType {
        private final Object type;

        private ResolvedType(Object type) {
            this.type = Preconditions.checkNotNull((Object)type, (Object)"type");
        }

        private ResolvedType(ResolvedType original, Object type) {
            this.type = type;
        }

        @Override
        public Object type() {
            return this.type;
        }

        public final ResolvedType withType(Object value) {
            if (this.type == value) {
                return this;
            }
            Object newValue = Preconditions.checkNotNull((Object)value, (Object)"type");
            return new ResolvedType(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ResolvedType && this.equalTo((ResolvedType)another);
        }

        private boolean equalTo(ResolvedType another) {
            return this.type.equals(another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            return h;
        }

        public static ResolvedType of(Object type) {
            return new ResolvedType(type);
        }

        public static ResolvedType copyOf(Trees.ResolvedType instance) {
            if (instance instanceof ResolvedType) {
                return (ResolvedType)instance;
            }
            return ResolvedType.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private long initBits = 1L;
            @Nullable
            private Object type;

            private Builder() {
            }

            public final Builder from(Trees.ResolvedType instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.type(instance.type());
                return this;
            }

            public final Builder type(Object type) {
                this.type = Preconditions.checkNotNull((Object)type, (Object)"type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ResolvedType build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ResolvedType(null, this.type);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build ResolvedType, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class TransformGenerator
    implements Trees.TransformGenerator {
        private final Trees.Expression transform;
        private final Trees.ValueDeclaration varDeclaration;
        private final Optional<Trees.Expression> condition;
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private TransformGenerator(Trees.Expression transform, Trees.ValueDeclaration varDeclaration, Optional<Trees.Expression> condition, Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.transform = transform;
            this.varDeclaration = varDeclaration;
            this.condition = condition;
            this.declaration = declaration;
            this.from = from;
        }

        @Override
        public Trees.Expression transform() {
            return this.transform;
        }

        @Override
        public Trees.ValueDeclaration varDeclaration() {
            return this.varDeclaration;
        }

        @Override
        public Optional<Trees.Expression> condition() {
            return this.condition;
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public final TransformGenerator withTransform(Trees.Expression value) {
            if (this.transform == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"transform");
            return new TransformGenerator(newValue, this.varDeclaration, this.condition, this.declaration, this.from);
        }

        public final TransformGenerator withVarDeclaration(Trees.ValueDeclaration value) {
            if (this.varDeclaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value, (Object)"varDeclaration");
            return new TransformGenerator(this.transform, newValue, this.condition, this.declaration, this.from);
        }

        public final TransformGenerator withCondition(Trees.Expression value) {
            Optional newValue = Optional.of((Object)value);
            if (this.condition.isPresent() && this.condition.get() == value) {
                return this;
            }
            return new TransformGenerator(this.transform, this.varDeclaration, (Optional<Trees.Expression>)newValue, this.declaration, this.from);
        }

        public final TransformGenerator withCondition(Optional<? extends Trees.Expression> optional) {
            Optional<? extends Trees.Expression> value = optional;
            if (!this.condition.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.condition.isPresent() && value.isPresent() && this.condition.get() == value.get()) {
                return this;
            }
            return new TransformGenerator(this.transform, this.varDeclaration, value, this.declaration, this.from);
        }

        public final TransformGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new TransformGenerator(this.transform, this.varDeclaration, this.condition, newValue, this.from);
        }

        public final TransformGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"from");
            return new TransformGenerator(this.transform, this.varDeclaration, this.condition, this.declaration, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TransformGenerator && this.equalTo((TransformGenerator)another);
        }

        private boolean equalTo(TransformGenerator another) {
            return this.transform.equals(another.transform) && this.varDeclaration.equals(another.varDeclaration) && this.condition.equals(another.condition) && this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.transform.hashCode();
            h += (h << 5) + this.varDeclaration.hashCode();
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.from.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TransformGenerator").omitNullValues().add("transform", (Object)this.transform).add("varDeclaration", (Object)this.varDeclaration).add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static TransformGenerator copyOf(Trees.TransformGenerator instance) {
            if (instance instanceof TransformGenerator) {
                return (TransformGenerator)instance;
            }
            return TransformGenerator.builder().transform(instance.transform()).varDeclaration(instance.varDeclaration()).condition(instance.condition()).declaration(instance.declaration()).from(instance.from()).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TRANSFORM = 1L;
            private static final long INIT_BIT_VAR_DECLARATION = 2L;
            private static final long INIT_BIT_DECLARATION = 4L;
            private static final long INIT_BIT_FROM = 8L;
            private long initBits = 15L;
            @Nullable
            private Trees.Expression transform;
            @Nullable
            private Trees.ValueDeclaration varDeclaration;
            private Optional<Trees.Expression> condition = Optional.absent();
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            public final Builder transform(Trees.Expression transform) {
                this.transform = (Trees.Expression)Preconditions.checkNotNull((Object)transform, (Object)"transform");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder varDeclaration(Trees.ValueDeclaration varDeclaration) {
                this.varDeclaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)varDeclaration, (Object)"varDeclaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = Optional.of((Object)condition);
                return this;
            }

            public final Builder condition(Optional<? extends Trees.Expression> condition) {
                this.condition = condition;
                return this;
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from, (Object)"from");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public TransformGenerator build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TransformGenerator(this.transform, this.varDeclaration, this.condition, this.declaration, this.from);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("transform");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("varDeclaration");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("declaration");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("from");
                }
                return "Cannot build TransformGenerator, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class InvokableDeclaration
    implements Trees.InvokableDeclaration {
        private final ImmutableList<Trees.Parameter> parameters;
        private final Trees.Identifier name;

        private InvokableDeclaration(ImmutableList<Trees.Parameter> parameters, Trees.Identifier name) {
            this.parameters = parameters;
            this.name = name;
        }

        public ImmutableList<Trees.Parameter> parameters() {
            return this.parameters;
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        public final InvokableDeclaration withParameters(Trees.Parameter ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new InvokableDeclaration((ImmutableList<Trees.Parameter>)newValue, this.name);
        }

        public final InvokableDeclaration withParameters(Iterable<? extends Trees.Parameter> elements) {
            if (this.parameters == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new InvokableDeclaration((ImmutableList<Trees.Parameter>)newValue, this.name);
        }

        public final InvokableDeclaration withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value, (Object)"name");
            return new InvokableDeclaration(this.parameters, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof InvokableDeclaration && this.equalTo((InvokableDeclaration)another);
        }

        private boolean equalTo(InvokableDeclaration another) {
            return this.parameters.equals(another.parameters) && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.parameters.hashCode();
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokableDeclaration").omitNullValues().add("parameters", this.parameters).add("name", (Object)this.name).toString();
        }

        public static InvokableDeclaration copyOf(Trees.InvokableDeclaration instance) {
            if (instance instanceof InvokableDeclaration) {
                return (InvokableDeclaration)instance;
            }
            return InvokableDeclaration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            private ImmutableList.Builder<Trees.Parameter> parameters = ImmutableList.builder();
            @Nullable
            private Trees.Identifier name;

            private Builder() {
            }

            public final Builder from(Trees.InvokableDeclaration instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Named instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Trees.Named instance;
                if (object instanceof Trees.InvokableDeclaration) {
                    instance = (Trees.InvokableDeclaration)object;
                    this.addAllParameters(instance.parameters());
                }
                if (object instanceof Trees.Named) {
                    instance = (Trees.Named)object;
                    this.name(instance.name());
                }
            }

            public final Builder addParameters(Trees.Parameter element) {
                this.parameters.add((Object)element);
                return this;
            }

            public final Builder addParameters(Trees.Parameter ... elements) {
                this.parameters.add((Object[])elements);
                return this;
            }

            public final Builder parameters(Iterable<? extends Trees.Parameter> elements) {
                this.parameters = ImmutableList.builder();
                return this.addAllParameters(elements);
            }

            public final Builder addAllParameters(Iterable<? extends Trees.Parameter> elements) {
                this.parameters.addAll(elements);
                return this;
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name, (Object)"name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public InvokableDeclaration build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new InvokableDeclaration(this.parameters.build(), this.name);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build InvokableDeclaration, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class Comment
    implements Trees.Comment {
        private static final Comment INSTANCE = new Comment();

        private Comment() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return 1487449787;
        }

        public String toString() {
            return "Comment{}";
        }

        public static Comment of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class TextFragment
    extends Trees.TextFragment {
        private final String value;

        private TextFragment(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        private TextFragment(TextFragment original, String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final TextFragment withValue(String value) {
            if (this.value.equals(value)) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return new TextFragment(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TextFragment && this.equalTo((TextFragment)another);
        }

        private boolean equalTo(TextFragment another) {
            return this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public static TextFragment of(String value) {
            return new TextFragment(value);
        }

        public static TextFragment copyOf(Trees.TextFragment instance) {
            if (instance instanceof TextFragment) {
                return (TextFragment)instance;
            }
            return TextFragment.of(instance.value());
        }
    }

    @Immutable
    public static final class TextBlock
    implements Trees.TextBlock {
        private final ImmutableList<Trees.TextPart> parts;

        private TextBlock(ImmutableList<Trees.TextPart> parts) {
            this.parts = parts;
        }

        public ImmutableList<Trees.TextPart> parts() {
            return this.parts;
        }

        public final TextBlock withParts(Trees.TextPart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new TextBlock((ImmutableList<Trees.TextPart>)newValue);
        }

        public final TextBlock withParts(Iterable<? extends Trees.TextPart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new TextBlock((ImmutableList<Trees.TextPart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TextBlock && this.equalTo((TextBlock)another);
        }

        private boolean equalTo(TextBlock another) {
            return this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TextBlock").omitNullValues().add("parts", this.parts).toString();
        }

        public static TextBlock copyOf(Trees.TextBlock instance) {
            if (instance instanceof TextBlock) {
                return (TextBlock)instance;
            }
            return TextBlock.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.TextPart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.TextBlock instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.addAllParts(instance.parts());
                return this;
            }

            public final Builder addParts(Trees.TextPart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TextPart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TextPart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TextPart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public TextBlock build() {
                return new TextBlock(this.parts.build());
            }
        }
    }

    @Immutable
    public static final class IfEnd
    implements Trees.IfEnd {
        private static final IfEnd INSTANCE = new IfEnd();

        private IfEnd() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return 2000076314;
        }

        public String toString() {
            return "IfEnd{}";
        }

        public static IfEnd of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class Else
    implements Trees.Else {
        private static final Else INSTANCE = new Else();

        private Else() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return -1598161349;
        }

        public String toString() {
            return "Else{}";
        }

        public static Else of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class SimpleBlock
    implements Trees.SimpleBlock {
        private final ImmutableList<Trees.TemplatePart> parts;

        private SimpleBlock(ImmutableList<Trees.TemplatePart> parts) {
            this.parts = parts;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public final SimpleBlock withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new SimpleBlock((ImmutableList<Trees.TemplatePart>)newValue);
        }

        public final SimpleBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new SimpleBlock((ImmutableList<Trees.TemplatePart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof SimpleBlock && this.equalTo((SimpleBlock)another);
        }

        private boolean equalTo(SimpleBlock another) {
            return this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"SimpleBlock").omitNullValues().add("parts", this.parts).toString();
        }

        public static SimpleBlock copyOf(Trees.SimpleBlock instance) {
            if (instance instanceof SimpleBlock) {
                return (SimpleBlock)instance;
            }
            return SimpleBlock.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.SimpleBlock instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.Block) {
                    Trees.Block instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public SimpleBlock build() {
                return new SimpleBlock(this.parts.build());
            }
        }
    }

    @Immutable
    public static final class TemplateEnd
    implements Trees.TemplateEnd {
        private static final TemplateEnd INSTANCE = new TemplateEnd();

        private TemplateEnd() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return 1299747805;
        }

        public String toString() {
            return "TemplateEnd{}";
        }

        public static TemplateEnd of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class Unit
    implements Trees.Unit {
        private final ImmutableList<Trees.UnitPart> parts;

        private Unit(ImmutableList<Trees.UnitPart> parts) {
            this.parts = parts;
        }

        public ImmutableList<Trees.UnitPart> parts() {
            return this.parts;
        }

        public final Unit withParts(Trees.UnitPart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Unit((ImmutableList<Trees.UnitPart>)newValue);
        }

        public final Unit withParts(Iterable<? extends Trees.UnitPart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Unit((ImmutableList<Trees.UnitPart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Unit && this.equalTo((Unit)another);
        }

        private boolean equalTo(Unit another) {
            return this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Unit").omitNullValues().add("parts", this.parts).toString();
        }

        public static Unit copyOf(Trees.Unit instance) {
            if (instance instanceof Unit) {
                return (Unit)instance;
            }
            return Unit.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.UnitPart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.Unit instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.addAllParts(instance.parts());
                return this;
            }

            public final Builder addParts(Trees.UnitPart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.UnitPart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.UnitPart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.UnitPart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public Unit build() {
                return new Unit(this.parts.build());
            }
        }
    }

    @Immutable
    public static final class StringLiteral
    extends Trees.StringLiteral {
        private final String value;

        private StringLiteral(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        private StringLiteral(StringLiteral original, String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final StringLiteral withValue(String value) {
            if (this.value.equals(value)) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return new StringLiteral(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof StringLiteral && this.equalTo((StringLiteral)another);
        }

        private boolean equalTo(StringLiteral another) {
            return this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public static StringLiteral of(String value) {
            return new StringLiteral(value);
        }

        public static StringLiteral copyOf(Trees.StringLiteral instance) {
            if (instance instanceof StringLiteral) {
                return (StringLiteral)instance;
            }
            return StringLiteral.of(instance.value());
        }
    }

    @Immutable
    public static final class ForStatement
    extends Trees.ForStatement {
        private final boolean useForAccess;
        private final boolean useDelimit;
        private final ImmutableList<Trees.GeneratorDeclaration> declaration;
        private final ImmutableList<Trees.TemplatePart> parts;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ForStatement(Builder builder) {
            this.declaration = builder.declaration.build();
            this.parts = builder.parts.build();
            if (builder.useForAccessIsSet()) {
                this.initShim.useForAccess(builder.useForAccess);
            }
            if (builder.useDelimitIsSet()) {
                this.initShim.useDelimit(builder.useDelimit);
            }
            this.useForAccess = this.initShim.useForAccess();
            this.useDelimit = this.initShim.useDelimit();
            this.initShim = null;
        }

        private ForStatement(boolean useForAccess, boolean useDelimit, ImmutableList<Trees.GeneratorDeclaration> declaration, ImmutableList<Trees.TemplatePart> parts) {
            this.useForAccess = useForAccess;
            this.useDelimit = useDelimit;
            this.declaration = declaration;
            this.parts = parts;
            this.initShim = null;
        }

        @Override
        public boolean useForAccess() {
            InitShim shim = this.initShim;
            return shim != null ? shim.useForAccess() : this.useForAccess;
        }

        @Override
        public boolean useDelimit() {
            InitShim shim = this.initShim;
            return shim != null ? shim.useDelimit() : this.useDelimit;
        }

        public ImmutableList<Trees.GeneratorDeclaration> declaration() {
            return this.declaration;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public final ForStatement withUseForAccess(boolean value) {
            if (this.useForAccess == value) {
                return this;
            }
            return new ForStatement(value, this.useDelimit, this.declaration, this.parts);
        }

        public final ForStatement withUseDelimit(boolean value) {
            if (this.useDelimit == value) {
                return this;
            }
            return new ForStatement(this.useForAccess, value, this.declaration, this.parts);
        }

        public final ForStatement withDeclaration(Trees.GeneratorDeclaration ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ForStatement(this.useForAccess, this.useDelimit, (ImmutableList<Trees.GeneratorDeclaration>)newValue, this.parts);
        }

        public final ForStatement withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
            if (this.declaration == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ForStatement(this.useForAccess, this.useDelimit, (ImmutableList<Trees.GeneratorDeclaration>)newValue, this.parts);
        }

        public final ForStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ForStatement(this.useForAccess, this.useDelimit, this.declaration, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public final ForStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ForStatement(this.useForAccess, this.useDelimit, this.declaration, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ForStatement && this.equalTo((ForStatement)another);
        }

        private boolean equalTo(ForStatement another) {
            return this.useForAccess == another.useForAccess && this.useDelimit == another.useDelimit && this.declaration.equals(another.declaration) && this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Booleans.hashCode((boolean)this.useForAccess);
            h += (h << 5) + Booleans.hashCode((boolean)this.useDelimit);
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ForStatement").omitNullValues().add("useForAccess", this.useForAccess).add("useDelimit", this.useDelimit).add("declaration", this.declaration).add("parts", this.parts).toString();
        }

        public static ForStatement copyOf(Trees.ForStatement instance) {
            if (instance instanceof ForStatement) {
                return (ForStatement)instance;
            }
            return ForStatement.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_USE_FOR_ACCESS = 1L;
            private static final long OPT_BIT_USE_DELIMIT = 2L;
            private long optBits;
            private boolean useForAccess;
            private boolean useDelimit;
            private ImmutableList.Builder<Trees.GeneratorDeclaration> declaration = ImmutableList.builder();
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.ForStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Trees.Block instance;
                if (object instanceof Trees.ForStatement) {
                    instance = (Trees.ForStatement)object;
                    this.useForAccess(((Trees.ForStatement)instance).useForAccess());
                    this.addAllDeclaration(((Trees.ForStatement)instance).declaration());
                    this.useDelimit(((Trees.ForStatement)instance).useDelimit());
                }
                if (object instanceof Trees.Block) {
                    instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
            }

            public final Builder useForAccess(boolean useForAccess) {
                this.useForAccess = useForAccess;
                this.optBits |= 1L;
                return this;
            }

            public final Builder useDelimit(boolean useDelimit) {
                this.useDelimit = useDelimit;
                this.optBits |= 2L;
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
                this.declaration.add((Object)element);
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration ... elements) {
                this.declaration.add((Object[])elements);
                return this;
            }

            public final Builder declaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declaration = ImmutableList.builder();
                return this.addAllDeclaration(elements);
            }

            public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declaration.addAll(elements);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public ForStatement build() {
                return new ForStatement(this);
            }

            private boolean useForAccessIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean useDelimitIsSet() {
                return (this.optBits & 2L) != 0L;
            }
        }

        private final class InitShim {
            private boolean useForAccess;
            private int useForAccessBuildStage;
            private boolean useDelimit;
            private int useDelimitBuildStage;

            private InitShim() {
            }

            boolean useForAccess() {
                if (this.useForAccessBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.useForAccessBuildStage == 0) {
                    this.useForAccessBuildStage = -1;
                    this.useForAccess = ForStatement.super.useForAccess();
                    this.useForAccessBuildStage = 1;
                }
                return this.useForAccess;
            }

            void useForAccess(boolean useForAccess) {
                this.useForAccess = useForAccess;
                this.useForAccessBuildStage = 1;
            }

            boolean useDelimit() {
                if (this.useDelimitBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.useDelimitBuildStage == 0) {
                    this.useDelimitBuildStage = -1;
                    this.useDelimit = ForStatement.super.useDelimit();
                    this.useDelimitBuildStage = 1;
                }
                return this.useDelimit;
            }

            void useDelimit(boolean useDelimit) {
                this.useDelimit = useDelimit;
                this.useDelimitBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList attributes = Lists.newArrayList();
                if (this.useForAccessBuildStage == -1) {
                    attributes.add("useForAccess");
                }
                if (this.useDelimitBuildStage == -1) {
                    attributes.add("useDelimit");
                }
                return "Cannot build ForStatement, attribute initializers form cycle" + attributes;
            }
        }
    }

    @Immutable
    public static final class Parameter
    implements Trees.Parameter {
        private final Trees.Identifier name;
        private final Trees.TypeReference type;

        private Parameter(Trees.Identifier name, Trees.TypeReference type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public Trees.Identifier name() {
            return this.name;
        }

        @Override
        public Trees.TypeReference type() {
            return this.type;
        }

        public final Parameter withName(Trees.Identifier value) {
            if (this.name == value) {
                return this;
            }
            Trees.Identifier newValue = (Trees.Identifier)Preconditions.checkNotNull((Object)value, (Object)"name");
            return new Parameter(newValue, this.type);
        }

        public final Parameter withType(Trees.TypeReference value) {
            if (this.type == value) {
                return this;
            }
            Trees.TypeReference newValue = (Trees.TypeReference)Preconditions.checkNotNull((Object)value, (Object)"type");
            return new Parameter(this.name, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Parameter && this.equalTo((Parameter)another);
        }

        private boolean equalTo(Parameter another) {
            return this.name.equals(another.name) && this.type.equals(another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.type.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Parameter").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).toString();
        }

        public static Parameter copyOf(Trees.Parameter instance) {
            if (instance instanceof Parameter) {
                return (Parameter)instance;
            }
            return Parameter.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_TYPE = 2L;
            private long initBits = 3L;
            @Nullable
            private Trees.Identifier name;
            @Nullable
            private Trees.TypeReference type;

            private Builder() {
            }

            public final Builder from(Trees.Typed instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Named instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Parameter instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof Trees.Typed) {
                    instance = (Trees.Typed)object;
                    this.type(instance.type());
                }
                if (object instanceof Trees.Named) {
                    instance = (Trees.Named)object;
                    this.name(instance.name());
                }
            }

            public final Builder name(Trees.Identifier name) {
                this.name = (Trees.Identifier)Preconditions.checkNotNull((Object)name, (Object)"name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder type(Trees.TypeReference type) {
                this.type = (Trees.TypeReference)Preconditions.checkNotNull((Object)type, (Object)"type");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public Parameter build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Parameter(this.name, this.type);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build Parameter, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class IterationGenerator
    implements Trees.IterationGenerator {
        private final Optional<Trees.Expression> condition;
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private IterationGenerator(Optional<Trees.Expression> condition, Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.condition = condition;
            this.declaration = declaration;
            this.from = from;
        }

        @Override
        public Optional<Trees.Expression> condition() {
            return this.condition;
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public final IterationGenerator withCondition(Trees.Expression value) {
            Optional newValue = Optional.of((Object)value);
            if (this.condition.isPresent() && this.condition.get() == value) {
                return this;
            }
            return new IterationGenerator((Optional<Trees.Expression>)newValue, this.declaration, this.from);
        }

        public final IterationGenerator withCondition(Optional<? extends Trees.Expression> optional) {
            Optional<? extends Trees.Expression> value = optional;
            if (!this.condition.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.condition.isPresent() && value.isPresent() && this.condition.get() == value.get()) {
                return this;
            }
            return new IterationGenerator(value, this.declaration, this.from);
        }

        public final IterationGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new IterationGenerator(this.condition, newValue, this.from);
        }

        public final IterationGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"from");
            return new IterationGenerator(this.condition, this.declaration, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof IterationGenerator && this.equalTo((IterationGenerator)another);
        }

        private boolean equalTo(IterationGenerator another) {
            return this.condition.equals(another.condition) && this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.from.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"IterationGenerator").omitNullValues().add("condition", this.condition.orNull()).add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static IterationGenerator copyOf(Trees.IterationGenerator instance) {
            if (instance instanceof IterationGenerator) {
                return (IterationGenerator)instance;
            }
            return IterationGenerator.builder().condition(instance.condition()).declaration(instance.declaration()).from(instance.from()).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private static final long INIT_BIT_FROM = 2L;
            private long initBits = 3L;
            private Optional<Trees.Expression> condition = Optional.absent();
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = Optional.of((Object)condition);
                return this;
            }

            public final Builder condition(Optional<? extends Trees.Expression> condition) {
                this.condition = condition;
                return this;
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from, (Object)"from");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public IterationGenerator build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new IterationGenerator(this.condition, this.declaration, this.from);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("from");
                }
                return "Cannot build IterationGenerator, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class InvokeEnd
    implements Trees.InvokeEnd {
        private final Trees.AccessExpression access;

        private InvokeEnd(Trees.AccessExpression access) {
            this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access, (Object)"access");
        }

        private InvokeEnd(InvokeEnd original, Trees.AccessExpression access) {
            this.access = access;
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        public final InvokeEnd withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value, (Object)"access");
            return new InvokeEnd(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof InvokeEnd && this.equalTo((InvokeEnd)another);
        }

        private boolean equalTo(InvokeEnd another) {
            return this.access.equals(another.access);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.access.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeEnd").omitNullValues().add("access", (Object)this.access).toString();
        }

        public static InvokeEnd of(Trees.AccessExpression access) {
            return new InvokeEnd(access);
        }

        public static InvokeEnd copyOf(Trees.InvokeEnd instance) {
            if (instance instanceof InvokeEnd) {
                return (InvokeEnd)instance;
            }
            return InvokeEnd.of(instance.access());
        }
    }

    @Immutable
    public static final class TypeDeclaration
    extends Trees.TypeDeclaration {
        private final Trees.TypeIdentifier type;
        private final Trees.TypeDeclaration.Kind kind;

        private TypeDeclaration(Builder builder) {
            this.type = builder.type;
            this.kind = builder.kind != null ? builder.kind : (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)super.kind()), (Object)"kind"));
        }

        private TypeDeclaration(Trees.TypeIdentifier type, Trees.TypeDeclaration.Kind kind) {
            this.type = type;
            this.kind = kind;
        }

        @Override
        public Trees.TypeIdentifier type() {
            return this.type;
        }

        @Override
        public Trees.TypeDeclaration.Kind kind() {
            return this.kind;
        }

        public final TypeDeclaration withType(Trees.TypeIdentifier value) {
            if (this.type == value) {
                return this;
            }
            Trees.TypeIdentifier newValue = (Trees.TypeIdentifier)Preconditions.checkNotNull((Object)value, (Object)"type");
            return new TypeDeclaration(newValue, this.kind);
        }

        public final TypeDeclaration withKind(Trees.TypeDeclaration.Kind value) {
            if (this.kind == value) {
                return this;
            }
            Trees.TypeDeclaration.Kind newValue = (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"kind"));
            return new TypeDeclaration(this.type, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TypeDeclaration && this.equalTo((TypeDeclaration)another);
        }

        private boolean equalTo(TypeDeclaration another) {
            return this.type.equals(another.type) && this.kind.equals((Object)another.kind);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.kind.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"TypeDeclaration").omitNullValues().add("type", (Object)this.type).add("kind", (Object)this.kind).toString();
        }

        public static TypeDeclaration copyOf(Trees.TypeDeclaration instance) {
            if (instance instanceof TypeDeclaration) {
                return (TypeDeclaration)instance;
            }
            return TypeDeclaration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.TypeIdentifier type;
            @Nullable
            private Trees.TypeDeclaration.Kind kind;

            private Builder() {
            }

            public final Builder from(Trees.TypeDeclaration instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.type(instance.type());
                this.kind(instance.kind());
                return this;
            }

            public final Builder type(Trees.TypeIdentifier type) {
                this.type = (Trees.TypeIdentifier)Preconditions.checkNotNull((Object)type, (Object)"type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder kind(Trees.TypeDeclaration.Kind kind) {
                this.kind = (Trees.TypeDeclaration.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (Object)"kind"));
                return this;
            }

            public TypeDeclaration build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new TypeDeclaration(this);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build TypeDeclaration, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class ForEnd
    implements Trees.ForEnd {
        private static final ForEnd INSTANCE = new ForEnd();

        private ForEnd() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return 1796548500;
        }

        public String toString() {
            return "ForEnd{}";
        }

        public static ForEnd of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class InvokeStatement
    implements Trees.InvokeStatement {
        private final Trees.Expression access;
        private final ImmutableList<Trees.Expression> params;
        private final ImmutableList<Trees.TemplatePart> parts;

        private InvokeStatement(Trees.Expression access, ImmutableList<Trees.Expression> params, ImmutableList<Trees.TemplatePart> parts) {
            this.access = access;
            this.params = params;
            this.parts = parts;
        }

        @Override
        public Trees.Expression access() {
            return this.access;
        }

        public ImmutableList<Trees.Expression> params() {
            return this.params;
        }

        public ImmutableList<Trees.TemplatePart> parts() {
            return this.parts;
        }

        public final InvokeStatement withAccess(Trees.Expression value) {
            if (this.access == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"access");
            return new InvokeStatement(newValue, this.params, this.parts);
        }

        public final InvokeStatement withParams(Trees.Expression ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new InvokeStatement(this.access, (ImmutableList<Trees.Expression>)newValue, this.parts);
        }

        public final InvokeStatement withParams(Iterable<? extends Trees.Expression> elements) {
            if (this.params == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new InvokeStatement(this.access, (ImmutableList<Trees.Expression>)newValue, this.parts);
        }

        public final InvokeStatement withParts(Trees.TemplatePart ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new InvokeStatement(this.access, this.params, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public final InvokeStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
            if (this.parts == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new InvokeStatement(this.access, this.params, (ImmutableList<Trees.TemplatePart>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof InvokeStatement && this.equalTo((InvokeStatement)another);
        }

        private boolean equalTo(InvokeStatement another) {
            return this.access.equals(another.access) && this.params.equals(another.params) && this.parts.equals(another.parts);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.access.hashCode();
            h += (h << 5) + this.params.hashCode();
            h += (h << 5) + this.parts.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InvokeStatement").omitNullValues().add("access", (Object)this.access).add("params", this.params).add("parts", this.parts).toString();
        }

        public static InvokeStatement copyOf(Trees.InvokeStatement instance) {
            if (instance instanceof InvokeStatement) {
                return (InvokeStatement)instance;
            }
            return InvokeStatement.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ACCESS = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.Expression access;
            private ImmutableList.Builder<Trees.Expression> params = ImmutableList.builder();
            private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.InvokeStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Block instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Trees.Block instance;
                if (object instanceof Trees.InvokeStatement) {
                    instance = (Trees.InvokeStatement)object;
                    this.addAllParams(instance.params());
                    this.access(instance.access());
                }
                if (object instanceof Trees.Block) {
                    instance = (Trees.Block)object;
                    this.addAllParts(instance.parts());
                }
            }

            public final Builder access(Trees.Expression access) {
                this.access = (Trees.Expression)Preconditions.checkNotNull((Object)access, (Object)"access");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder addParams(Trees.Expression element) {
                this.params.add((Object)element);
                return this;
            }

            public final Builder addParams(Trees.Expression ... elements) {
                this.params.add((Object[])elements);
                return this;
            }

            public final Builder params(Iterable<? extends Trees.Expression> elements) {
                this.params = ImmutableList.builder();
                return this.addAllParams(elements);
            }

            public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
                this.params.addAll(elements);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart element) {
                this.parts.add((Object)element);
                return this;
            }

            public final Builder addParts(Trees.TemplatePart ... elements) {
                this.parts.add((Object[])elements);
                return this;
            }

            public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts = ImmutableList.builder();
                return this.addAllParts(elements);
            }

            public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
                this.parts.addAll(elements);
                return this;
            }

            public InvokeStatement build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new InvokeStatement(this.access, this.params.build(), this.parts.build());
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("access");
                }
                return "Cannot build InvokeStatement, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class Invoke
    implements Trees.Invoke {
        private final Trees.AccessExpression access;
        private final Optional<Trees.ApplyExpression> invoke;

        private Invoke(Trees.AccessExpression access, Optional<Trees.ApplyExpression> invoke) {
            this.access = access;
            this.invoke = invoke;
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        @Override
        public Optional<Trees.ApplyExpression> invoke() {
            return this.invoke;
        }

        public final Invoke withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value, (Object)"access");
            return new Invoke(newValue, this.invoke);
        }

        public final Invoke withInvoke(Trees.ApplyExpression value) {
            Optional newValue = Optional.of((Object)value);
            if (this.invoke.isPresent() && this.invoke.get() == value) {
                return this;
            }
            return new Invoke(this.access, (Optional<Trees.ApplyExpression>)newValue);
        }

        public final Invoke withInvoke(Optional<? extends Trees.ApplyExpression> optional) {
            Optional<? extends Trees.ApplyExpression> value = optional;
            if (!this.invoke.isPresent() && !value.isPresent()) {
                return this;
            }
            if (this.invoke.isPresent() && value.isPresent() && this.invoke.get() == value.get()) {
                return this;
            }
            return new Invoke(this.access, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Invoke && this.equalTo((Invoke)another);
        }

        private boolean equalTo(Invoke another) {
            return this.access.equals(another.access) && this.invoke.equals(another.invoke);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.access.hashCode();
            h += (h << 5) + this.invoke.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Invoke").omitNullValues().add("access", (Object)this.access).add("invoke", this.invoke.orNull()).toString();
        }

        public static Invoke copyOf(Trees.Invoke instance) {
            if (instance instanceof Invoke) {
                return (Invoke)instance;
            }
            return Invoke.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ACCESS = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.AccessExpression access;
            private Optional<Trees.ApplyExpression> invoke = Optional.absent();

            private Builder() {
            }

            public final Builder from(Trees.InvokeDeclaration instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Invoke instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.InvokeDeclaration) {
                    Trees.InvokeDeclaration instance = (Trees.InvokeDeclaration)object;
                    Optional<Trees.ApplyExpression> invokeOptional = instance.invoke();
                    if (invokeOptional.isPresent()) {
                        this.invoke(invokeOptional);
                    }
                    this.access(instance.access());
                }
            }

            public final Builder access(Trees.AccessExpression access) {
                this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access, (Object)"access");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder invoke(Trees.ApplyExpression invoke) {
                this.invoke = Optional.of((Object)invoke);
                return this;
            }

            public final Builder invoke(Optional<? extends Trees.ApplyExpression> invoke) {
                this.invoke = invoke;
                return this;
            }

            public Invoke build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Invoke(this.access, this.invoke);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("access");
                }
                return "Cannot build Invoke, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class LetEnd
    implements Trees.LetEnd {
        private static final LetEnd INSTANCE = new LetEnd();

        private LetEnd() {
        }

        public boolean equals(@Nullable Object another) {
            return this == another;
        }

        public int hashCode() {
            return 1959147778;
        }

        public String toString() {
            return "LetEnd{}";
        }

        public static LetEnd of() {
            return INSTANCE;
        }
    }

    @Immutable
    public static final class AssignGenerator
    implements Trees.AssignGenerator {
        private final Trees.ValueDeclaration declaration;
        private final Trees.Expression from;

        private AssignGenerator(Trees.ValueDeclaration declaration, Trees.Expression from) {
            this.declaration = declaration;
            this.from = from;
        }

        @Override
        public Trees.ValueDeclaration declaration() {
            return this.declaration;
        }

        @Override
        public Trees.Expression from() {
            return this.from;
        }

        public final AssignGenerator withDeclaration(Trees.ValueDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.ValueDeclaration newValue = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new AssignGenerator(newValue, this.from);
        }

        public final AssignGenerator withFrom(Trees.Expression value) {
            if (this.from == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"from");
            return new AssignGenerator(this.declaration, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AssignGenerator && this.equalTo((AssignGenerator)another);
        }

        private boolean equalTo(AssignGenerator another) {
            return this.declaration.equals(another.declaration) && this.from.equals(another.from);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.declaration.hashCode();
            h += (h << 5) + this.from.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AssignGenerator").omitNullValues().add("declaration", (Object)this.declaration).add("from", (Object)this.from).toString();
        }

        public static AssignGenerator copyOf(Trees.AssignGenerator instance) {
            if (instance instanceof AssignGenerator) {
                return (AssignGenerator)instance;
            }
            return AssignGenerator.builder().declaration(instance.declaration()).from(instance.from()).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private static final long INIT_BIT_FROM = 2L;
            private long initBits = 3L;
            @Nullable
            private Trees.ValueDeclaration declaration;
            @Nullable
            private Trees.Expression from;

            private Builder() {
            }

            public final Builder declaration(Trees.ValueDeclaration declaration) {
                this.declaration = (Trees.ValueDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder from(Trees.Expression from) {
                this.from = (Trees.Expression)Preconditions.checkNotNull((Object)from, (Object)"from");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public AssignGenerator build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new AssignGenerator(this.declaration, this.from);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("from");
                }
                return "Cannot build AssignGenerator, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class For
    implements Trees.For {
        private final ImmutableList<Trees.GeneratorDeclaration> declaration;

        private For(ImmutableList<Trees.GeneratorDeclaration> declaration) {
            this.declaration = declaration;
        }

        public ImmutableList<Trees.GeneratorDeclaration> declaration() {
            return this.declaration;
        }

        public final For withDeclaration(Trees.GeneratorDeclaration ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new For((ImmutableList<Trees.GeneratorDeclaration>)newValue);
        }

        public final For withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
            if (this.declaration == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new For((ImmutableList<Trees.GeneratorDeclaration>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof For && this.equalTo((For)another);
        }

        private boolean equalTo(For another) {
            return this.declaration.equals(another.declaration);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.declaration.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"For").omitNullValues().add("declaration", this.declaration).toString();
        }

        public static For copyOf(Trees.For instance) {
            if (instance instanceof For) {
                return (For)instance;
            }
            return For.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private ImmutableList.Builder<Trees.GeneratorDeclaration> declaration = ImmutableList.builder();

            private Builder() {
            }

            public final Builder from(Trees.For instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.addAllDeclaration(instance.declaration());
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
                this.declaration.add((Object)element);
                return this;
            }

            public final Builder addDeclaration(Trees.GeneratorDeclaration ... elements) {
                this.declaration.add((Object[])elements);
                return this;
            }

            public final Builder declaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declaration = ImmutableList.builder();
                return this.addAllDeclaration(elements);
            }

            public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
                this.declaration.addAll(elements);
                return this;
            }

            public For build() {
                return new For(this.declaration.build());
            }
        }
    }

    @Immutable
    public static final class Identifier
    extends Trees.Identifier {
        private final String value;

        private Identifier(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        private Identifier(Identifier original, String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final Identifier withValue(String value) {
            if (this.value.equals(value)) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return new Identifier(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Identifier && this.equalTo((Identifier)another);
        }

        private boolean equalTo(Identifier another) {
            return this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public static Identifier of(String value) {
            return new Identifier(value);
        }

        public static Identifier copyOf(Trees.Identifier instance) {
            if (instance instanceof Identifier) {
                return (Identifier)instance;
            }
            return Identifier.of(instance.value());
        }
    }

    @Immutable
    public static final class Let
    implements Trees.Let {
        private final Trees.InvokableDeclaration declaration;

        private Let(Trees.InvokableDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public Trees.InvokableDeclaration declaration() {
            return this.declaration;
        }

        public final Let withDeclaration(Trees.InvokableDeclaration value) {
            if (this.declaration == value) {
                return this;
            }
            Trees.InvokableDeclaration newValue = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)value, (Object)"declaration");
            return new Let(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Let && this.equalTo((Let)another);
        }

        private boolean equalTo(Let another) {
            return this.declaration.equals(another.declaration);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.declaration.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Let").omitNullValues().add("declaration", (Object)this.declaration).toString();
        }

        public static Let copyOf(Trees.Let instance) {
            if (instance instanceof Let) {
                return (Let)instance;
            }
            return Let.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_DECLARATION = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.InvokableDeclaration declaration;

            private Builder() {
            }

            public final Builder from(Trees.InvokableStatement instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.Let instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.InvokableStatement) {
                    Trees.InvokableStatement instance = (Trees.InvokableStatement)object;
                    this.declaration(instance.declaration());
                }
            }

            public final Builder declaration(Trees.InvokableDeclaration declaration) {
                this.declaration = (Trees.InvokableDeclaration)Preconditions.checkNotNull((Object)declaration, (Object)"declaration");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Let build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Let(this.declaration);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("declaration");
                }
                return "Cannot build Let, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class TypeIdentifier
    extends Trees.TypeIdentifier {
        private final String value;

        private TypeIdentifier(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        private TypeIdentifier(TypeIdentifier original, String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final TypeIdentifier withValue(String value) {
            if (this.value.equals(value)) {
                return this;
            }
            String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return new TypeIdentifier(this, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TypeIdentifier && this.equalTo((TypeIdentifier)another);
        }

        private boolean equalTo(TypeIdentifier another) {
            return this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public static TypeIdentifier of(String value) {
            return new TypeIdentifier(value);
        }

        public static TypeIdentifier copyOf(Trees.TypeIdentifier instance) {
            if (instance instanceof TypeIdentifier) {
                return (TypeIdentifier)instance;
            }
            return TypeIdentifier.of(instance.value());
        }
    }

    @Immutable
    public static final class If
    implements Trees.If {
        private final Trees.Expression condition;

        private If(Trees.Expression condition) {
            this.condition = condition;
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public final If withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"condition");
            return new If(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof If && this.equalTo((If)another);
        }

        private boolean equalTo(If another) {
            return this.condition.equals(another.condition);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"If").omitNullValues().add("condition", (Object)this.condition).toString();
        }

        public static If copyOf(Trees.If instance) {
            if (instance instanceof If) {
                return (If)instance;
            }
            return If.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.Expression condition;

            private Builder() {
            }

            public final Builder from(Trees.Conditional instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.If instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.Conditional) {
                    Trees.Conditional instance = (Trees.Conditional)object;
                    this.condition(instance.condition());
                }
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition, (Object)"condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public If build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new If(this.condition);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                return "Cannot build If, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class ForIterationAccessExpression
    implements Trees.ForIterationAccessExpression {
        private final Trees.AccessExpression access;
        private final ImmutableList<Trees.Identifier> path;

        private ForIterationAccessExpression(Trees.AccessExpression access) {
            this.access = (Trees.AccessExpression)Preconditions.checkNotNull((Object)access, (Object)"access");
            this.path = ImmutableList.of();
        }

        private ForIterationAccessExpression(Trees.AccessExpression access, ImmutableList<Trees.Identifier> path) {
            this.access = access;
            this.path = path;
        }

        @Override
        public Trees.AccessExpression access() {
            return this.access;
        }

        public ImmutableList<Trees.Identifier> path() {
            return this.path;
        }

        public final ForIterationAccessExpression withAccess(Trees.AccessExpression value) {
            if (this.access == value) {
                return this;
            }
            Trees.AccessExpression newValue = (Trees.AccessExpression)Preconditions.checkNotNull((Object)value, (Object)"access");
            return new ForIterationAccessExpression(newValue, this.path);
        }

        public final ForIterationAccessExpression withPath(Trees.Identifier ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new ForIterationAccessExpression(this.access, (ImmutableList<Trees.Identifier>)newValue);
        }

        public final ForIterationAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
            if (this.path == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new ForIterationAccessExpression(this.access, (ImmutableList<Trees.Identifier>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ForIterationAccessExpression && this.equalTo((ForIterationAccessExpression)another);
        }

        private boolean equalTo(ForIterationAccessExpression another) {
            return this.access.equals(another.access) && this.path.equals(another.path);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.access.hashCode();
            h += (h << 5) + this.path.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ForIterationAccessExpression").omitNullValues().add("access", (Object)this.access).add("path", this.path).toString();
        }

        public static ForIterationAccessExpression of(Trees.AccessExpression access) {
            return new ForIterationAccessExpression(access);
        }

        public static ForIterationAccessExpression copyOf(Trees.ForIterationAccessExpression instance) {
            if (instance instanceof ForIterationAccessExpression) {
                return (ForIterationAccessExpression)instance;
            }
            return ForIterationAccessExpression.of(instance.access()).withPath(instance.path());
        }
    }

    @Immutable
    public static final class ElseIf
    implements Trees.ElseIf {
        private final Trees.Expression condition;

        private ElseIf(Trees.Expression condition) {
            this.condition = condition;
        }

        @Override
        public Trees.Expression condition() {
            return this.condition;
        }

        public final ElseIf withCondition(Trees.Expression value) {
            if (this.condition == value) {
                return this;
            }
            Trees.Expression newValue = (Trees.Expression)Preconditions.checkNotNull((Object)value, (Object)"condition");
            return new ElseIf(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ElseIf && this.equalTo((ElseIf)another);
        }

        private boolean equalTo(ElseIf another) {
            return this.condition.equals(another.condition);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.condition.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ElseIf").omitNullValues().add("condition", (Object)this.condition).toString();
        }

        public static ElseIf copyOf(Trees.ElseIf instance) {
            if (instance instanceof ElseIf) {
                return (ElseIf)instance;
            }
            return ElseIf.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_CONDITION = 1L;
            private long initBits = 1L;
            @Nullable
            private Trees.Expression condition;

            private Builder() {
            }

            public final Builder from(Trees.Conditional instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            public final Builder from(Trees.ElseIf instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                if (object instanceof Trees.Conditional) {
                    Trees.Conditional instance = (Trees.Conditional)object;
                    this.condition(instance.condition());
                }
            }

            public final Builder condition(Trees.Expression condition) {
                this.condition = (Trees.Expression)Preconditions.checkNotNull((Object)condition, (Object)"condition");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public ElseIf build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ElseIf(this.condition);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("condition");
                }
                return "Cannot build ElseIf, some of required attributes are not set " + attributes;
            }
        }
    }
}

