/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.immutables.generator.AnnotationMirrors;
import org.immutables.generator.Generator;
import org.immutables.generator.Templates;
import org.immutables.generator.processor.Introspection;

public final class Imports
extends Introspection {
    private final TypeMirror importType;

    public Imports(ProcessingEnvironment environment) {
        super(environment);
        this.importType = this.elements.getTypeElement(Generator.Import.class.getCanonicalName()).asType();
    }

    public final ImmutableMap<String, TypeMirror> importsIn(TypeElement type) {
        HashMap collected = Maps.newHashMap();
        this.collectSimpleUsages(type, collected);
        this.collectBuiltins(collected);
        this.collectPackage(type, collected);
        this.collectImports(type, collected);
        this.collectTypedefs(type, collected);
        return ImmutableMap.copyOf((Map)collected);
    }

    private void collectBuiltins(Map<String, TypeMirror> collected) {
        for (TypeKind kind : TypeKind.values()) {
            if (!kind.isPrimitive()) continue;
            TypeElement boxedClass = this.types.boxedClass(this.types.getPrimitiveType(kind));
            collected.put(boxedClass.getSimpleName().toString(), boxedClass.asType());
        }
        TypeElement typeElement = this.elements.getTypeElement(String.class.getCanonicalName());
        collected.put(typeElement.getSimpleName().toString(), typeElement.asType());
        typeElement = this.elements.getTypeElement(Templates.Invokable.class.getCanonicalName());
        collected.put(typeElement.getSimpleName().toString(), typeElement.asType());
    }

    private void collectPackage(TypeElement type, Map<String, TypeMirror> collected) {
        for (TypeElement samePackageType : ElementFilter.typesIn(this.elements.getPackageOf(type).getEnclosedElements())) {
            this.collectIfSimpleType(samePackageType.asType(), collected);
        }
    }

    private void collectTypedefs(TypeElement type, Map<String, TypeMirror> collected) {
        for (VariableElement field : ElementFilter.fieldsIn(this.elements.getAllMembers(type))) {
            if (field.getAnnotation(Generator.Typedef.class) == null) continue;
            collected.put(field.getSimpleName().toString(), field.asType());
        }
    }

    private void collectSimpleUsages(TypeElement type, Map<String, TypeMirror> collected) {
        for (ExecutableElement method : ElementFilter.methodsIn(this.elements.getAllMembers(type))) {
            if (!this.shouldConsideredAsTypeUsage(method)) continue;
            this.collectIfSimpleType(method.getReturnType(), collected);
            for (VariableElement variableElement : method.getParameters()) {
                this.collectIfSimpleType(variableElement.asType(), collected);
            }
        }
    }

    private boolean shouldConsideredAsTypeUsage(ExecutableElement method) {
        return method.getTypeParameters().isEmpty() && !method.getModifiers().contains((Object)Modifier.PRIVATE) && !method.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void collectIfSimpleType(TypeMirror type, Map<String, TypeMirror> collected) {
        DeclaredType declared;
        if (type.getKind() == TypeKind.DECLARED && (declared = (DeclaredType)type).getTypeArguments().isEmpty()) {
            collected.put(declared.asElement().getSimpleName().toString(), declared);
        }
    }

    private void collectImports(TypeElement type, Map<String, TypeMirror> collected) {
        for (TypeMirror typeMirror : this.extractImports(type)) {
            collected.put(this.toSimpleName(typeMirror), typeMirror);
        }
    }

    private ImmutableList<TypeMirror> extractImports(TypeElement type) {
        ImmutableList.Builder importedTypes = ImmutableList.builder();
        TypeElement t = type;
        while (t != null) {
            importedTypes.addAll((Iterable)this.extractDeclaredImports(t).reverse());
            importedTypes.addAll((Iterable)this.extractDeclaredImports(this.elements.getPackageOf(type)).reverse());
            t = (TypeElement)this.types.asElement(t.getSuperclass());
        }
        return importedTypes.build().reverse();
    }

    private ImmutableList<TypeMirror> extractDeclaredImports(Element element) {
        return AnnotationMirrors.getTypesFromMirrors(this.types, this.importType, "value", element.getAnnotationMirrors());
    }
}

