/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

final class Inliner {
    private final Map<Trees.Identifier, InlinedStatementCreator> inlinables = Maps.newHashMap();

    private Inliner() {
    }

    public static ImmutableTrees.Unit optimize(ImmutableTrees.Unit unit) {
        return new Inliner().inline(unit);
    }

    private ImmutableTrees.Unit inline(ImmutableTrees.Unit unit) {
        new Finder().toUnit(unit);
        return new Weaver().toUnit(unit);
    }

    final class Weaver
    extends TreesTransformer {
        Weaver() {
        }

        @Override
        protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeStatement value) {
            InlinedStatementCreator creator = this.tryGetInlinable(value);
            if (creator != null) {
                return creator.inlined((List<Trees.Expression>)value.params(), (Iterable<? extends Trees.TemplatePart>)value.parts());
            }
            return value;
        }

        @Nullable
        private InlinedStatementCreator tryGetInlinable(ImmutableTrees.InvokeStatement invoke) {
            ImmutableTrees.SimpleAccessExpression ref;
            Trees.Expression access = invoke.access();
            if (access instanceof ImmutableTrees.SimpleAccessExpression && (ref = (ImmutableTrees.SimpleAccessExpression)access).path().size() == 1) {
                Trees.Identifier identifier = (Trees.Identifier)ref.path().get(0);
                return (InlinedStatementCreator)Inliner.this.inlinables.get(identifier);
            }
            return null;
        }
    }

    final class Finder
    extends TreesTransformer {
        private boolean inlinable;

        Finder() {
        }

        @Override
        public ImmutableTrees.Template toTemplate(ImmutableTrees.Template value) {
            if (value.isPublic()) {
                return value;
            }
            this.inlinable = true;
            this.asTemplatePartsElements(value, (List<Trees.TemplatePart>)value.parts());
            if (this.inlinable) {
                Inliner.this.inlinables.put(value.declaration().name(), new InlinedStatementCreator(value));
            }
            return value;
        }

        @Override
        public ImmutableTrees.InvokableDeclaration toInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
            this.inlinable = false;
            return value;
        }

        @Override
        public ImmutableTrees.ValueDeclaration toValueDeclaration(ImmutableTrees.ValueDeclaration value) {
            this.inlinable = false;
            return value;
        }

        @Override
        public ImmutableTrees.TextLine toTextLine(ImmutableTrees.TextLine value) {
            if (value.newline()) {
                this.inlinable = false;
            }
            return value;
        }
    }

    private static class InlinedStatementCreator
    extends TreesTransformer {
        private final ImmutableTrees.Template inlinable;
        private final int uniqueSuffix;
        private final Set<Trees.Identifier> remapped = Sets.newHashSet();

        InlinedStatementCreator(ImmutableTrees.Template inlinable) {
            this.uniqueSuffix = System.identityHashCode(inlinable);
            this.inlinable = inlinable;
            for (Trees.Parameter p : inlinable.declaration().parameters()) {
                this.remapped.add(p.name());
            }
        }

        ImmutableTrees.ForStatement inlined(List<Trees.Expression> params, Iterable<? extends Trees.TemplatePart> bodyParts) {
            ImmutableTrees.ForStatement.Builder builder = ImmutableTrees.ForStatement.builder().useForAccess(false).useDelimit(false);
            Iterator<Trees.Parameter> formals = this.inlinable.declaration().parameters().iterator();
            for (Trees.Expression argument : params) {
                Trees.Parameter formal = formals.next();
                builder.addDeclaration((Trees.GeneratorDeclaration)ImmutableTrees.AssignGenerator.builder().declaration(this.declarationFor(formal)).from(argument).build());
            }
            this.addBodyIfNecessary(builder, params, bodyParts);
            builder.addAllParts(this.asTemplatePartsElements(this.inlinable, (List<Trees.TemplatePart>)this.inlinable.parts()));
            return builder.build();
        }

        private ImmutableTrees.ValueDeclaration declarationFor(Trees.Parameter formalParameter) {
            return ImmutableTrees.ValueDeclaration.builder().type(formalParameter.type()).name(this.remappedIdentifier(formalParameter.name())).build();
        }

        private void addBodyIfNecessary(ImmutableTrees.ForStatement.Builder builder, List<Trees.Expression> params, Iterable<? extends Trees.TemplatePart> bodyParts) {
            if (Iterables.isEmpty(bodyParts)) {
                return;
            }
            Preconditions.checkState((this.inlinable.declaration().parameters().size() == params.size() + 1 ? 1 : 0) != 0);
            Trees.Parameter lastParameter = (Trees.Parameter)Iterables.getLast(this.inlinable.declaration().parameters());
            ImmutableTrees.LetStatement.Builder letBuilder = ImmutableTrees.LetStatement.builder().addAllParts(bodyParts).declaration(ImmutableTrees.InvokableDeclaration.builder().name(this.remappedIdentifier(lastParameter.name())).build());
            this.remapped.add(lastParameter.name());
            builder.addParts((Trees.TemplatePart)letBuilder.build());
        }

        @Override
        public ImmutableTrees.SimpleAccessExpression toSimpleAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
            final Trees.Identifier topAccessIdentifier = (Trees.Identifier)value.path().get(0);
            if (this.remapped.contains(topAccessIdentifier)) {
                return new TreesTransformer(){

                    @Override
                    public ImmutableTrees.Identifier toIdentifier(ImmutableTrees.Identifier value) {
                        return topAccessIdentifier == value ? InlinedStatementCreator.this.remappedIdentifier(value) : value;
                    }
                }.toSimpleAccessExpression(value);
            }
            return value;
        }

        protected ImmutableTrees.Identifier remappedIdentifier(Trees.Identifier value) {
            return ImmutableTrees.Identifier.of(value.value() + "_" + this.inlinable.declaration().name().value() + "_" + this.uniqueSuffix);
        }
    }
}

