/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Preconditions;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class Introspection {
    protected final ProcessingEnvironment environment;
    protected final Elements elements;
    protected final Types types;
    protected final boolean inEclipseCompiler;

    Introspection(ProcessingEnvironment environment) {
        this.environment = environment;
        this.elements = environment.getElementUtils();
        this.types = environment.getTypeUtils();
        this.inEclipseCompiler = environment.getClass().getName().startsWith("org.eclipse.jdt");
    }

    protected String toSimpleName(TypeMirror typeMirror) {
        return ((Element)Preconditions.checkNotNull((Object)this.types.asElement(typeMirror), (Object)"not declared type")).getSimpleName().toString();
    }

    protected String toName(TypeMirror typeMirror) {
        return ((TypeElement)Preconditions.checkNotNull((Object)this.types.asElement(typeMirror), (Object)"not declared type")).getQualifiedName().toString();
    }
}

