/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.Trees;

@ParametersAreNonnullByDefault
public abstract class TreesTransformer {
    protected TreesTransformer() {
    }

    public ImmutableTrees.ElseIf toElseIf(ImmutableTrees.ElseIf value) {
        return value.withCondition(this.asElseIfCondition(value, value.condition()));
    }

    protected Trees.Expression asElseIfCondition(ImmutableTrees.ElseIf value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ForIterationAccessExpression toForIterationAccessExpression(ImmutableTrees.ForIterationAccessExpression value) {
        return value.withAccess(this.asForIterationAccessExpressionAccess(value, value.access())).withPath(this.asForIterationAccessExpressionPathElements(value, (List<Trees.Identifier>)value.path()));
    }

    protected Trees.AccessExpression asForIterationAccessExpressionAccess(ImmutableTrees.ForIterationAccessExpression value, Trees.AccessExpression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.Identifier> asForIterationAccessExpressionPathElements(ImmutableTrees.ForIterationAccessExpression value, List<Trees.Identifier> elements) {
        ArrayList<Trees.Identifier> changedElements = new ArrayList<Trees.Identifier>(elements.size());
        boolean haveChanged = false;
        for (Trees.Identifier original : elements) {
            Trees.Identifier changed = this.asForIterationAccessExpressionPath(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Identifier asForIterationAccessExpressionPath(ImmutableTrees.ForIterationAccessExpression value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.If toIf(ImmutableTrees.If value) {
        return value.withCondition(this.asIfCondition(value, value.condition()));
    }

    protected Trees.Expression asIfCondition(ImmutableTrees.If value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.TypeIdentifier toTypeIdentifier(ImmutableTrees.TypeIdentifier value) {
        return value.withValue(this.asTypeIdentifierValue(value, value.value()));
    }

    protected String asTypeIdentifierValue(ImmutableTrees.TypeIdentifier value, String attribute) {
        return attribute;
    }

    public ImmutableTrees.Let toLet(ImmutableTrees.Let value) {
        return value.withDeclaration(this.asLetDeclaration(value, value.declaration()));
    }

    protected Trees.InvokableDeclaration asLetDeclaration(ImmutableTrees.Let value, Trees.InvokableDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
            return this.asInvokableDeclaration((ImmutableTrees.InvokableDeclaration)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.Identifier toIdentifier(ImmutableTrees.Identifier value) {
        return value.withValue(this.asIdentifierValue(value, value.value()));
    }

    protected String asIdentifierValue(ImmutableTrees.Identifier value, String attribute) {
        return attribute;
    }

    public ImmutableTrees.For toFor(ImmutableTrees.For value) {
        return value.withDeclaration(this.asForDeclarationElements(value, (List<Trees.GeneratorDeclaration>)value.declaration()));
    }

    protected Iterable<Trees.GeneratorDeclaration> asForDeclarationElements(ImmutableTrees.For value, List<Trees.GeneratorDeclaration> elements) {
        ArrayList<Trees.GeneratorDeclaration> changedElements = new ArrayList<Trees.GeneratorDeclaration>(elements.size());
        boolean haveChanged = false;
        for (Trees.GeneratorDeclaration original : elements) {
            Trees.GeneratorDeclaration changed = this.asForDeclaration(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.GeneratorDeclaration asForDeclaration(ImmutableTrees.For value, Trees.GeneratorDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.AssignGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.AssignGenerator)attribute);
        }
        if (attribute instanceof ImmutableTrees.IterationGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.IterationGenerator)attribute);
        }
        if (attribute instanceof ImmutableTrees.TransformGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.TransformGenerator)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.AssignGenerator toAssignGenerator(ImmutableTrees.AssignGenerator value) {
        return value.withDeclaration(this.asAssignGeneratorDeclaration(value, value.declaration())).withFrom(this.asAssignGeneratorFrom(value, value.from()));
    }

    protected Trees.ValueDeclaration asAssignGeneratorDeclaration(ImmutableTrees.AssignGenerator value, Trees.ValueDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.ValueDeclaration) {
            return this.asValueDeclaration((ImmutableTrees.ValueDeclaration)attribute);
        }
        return attribute;
    }

    protected Trees.Expression asAssignGeneratorFrom(ImmutableTrees.AssignGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.LetEnd toLetEnd(ImmutableTrees.LetEnd value) {
        return value;
    }

    public ImmutableTrees.Invoke toInvoke(ImmutableTrees.Invoke value) {
        return value.withAccess(this.asInvokeAccess(value, value.access())).withInvoke(this.asInvokeInvokeOptional(value, value.invoke()));
    }

    protected Trees.AccessExpression asInvokeAccess(ImmutableTrees.Invoke value, Trees.AccessExpression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        return attribute;
    }

    protected Optional<Trees.ApplyExpression> asInvokeInvokeOptional(ImmutableTrees.Invoke value, Optional<Trees.ApplyExpression> optional) {
        if (optional.isPresent()) {
            Trees.ApplyExpression original = (Trees.ApplyExpression)optional.get();
            Trees.ApplyExpression changed = this.asInvokeInvoke(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.ApplyExpression asInvokeInvoke(ImmutableTrees.Invoke value, Trees.ApplyExpression attribute) {
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asApplyExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.InvokeStatement toInvokeStatement(ImmutableTrees.InvokeStatement value) {
        return value.withAccess(this.asInvokeStatementAccess(value, value.access())).withParams(this.asInvokeStatementParamsElements(value, (List<Trees.Expression>)value.params())).withParts(this.asInvokeStatementPartsElements(value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Trees.Expression asInvokeStatementAccess(ImmutableTrees.InvokeStatement value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.Expression> asInvokeStatementParamsElements(ImmutableTrees.InvokeStatement value, List<Trees.Expression> elements) {
        ArrayList<Trees.Expression> changedElements = new ArrayList<Trees.Expression>(elements.size());
        boolean haveChanged = false;
        for (Trees.Expression original : elements) {
            Trees.Expression changed = this.asInvokeStatementParams(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Expression asInvokeStatementParams(ImmutableTrees.InvokeStatement value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.TemplatePart> asInvokeStatementPartsElements(ImmutableTrees.InvokeStatement value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asInvokeStatementParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asInvokeStatementParts(ImmutableTrees.InvokeStatement value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ForEnd toForEnd(ImmutableTrees.ForEnd value) {
        return value;
    }

    public ImmutableTrees.TypeDeclaration toTypeDeclaration(ImmutableTrees.TypeDeclaration value) {
        return value.withType(this.asTypeDeclarationType(value, value.type())).withKind(this.asTypeDeclarationKind(value, value.kind()));
    }

    protected Trees.TypeIdentifier asTypeDeclarationType(ImmutableTrees.TypeDeclaration value, Trees.TypeIdentifier attribute) {
        if (attribute instanceof ImmutableTrees.TypeIdentifier) {
            return this.asTypeIdentifier((ImmutableTrees.TypeIdentifier)attribute);
        }
        return attribute;
    }

    protected Trees.TypeDeclaration.Kind asTypeDeclarationKind(ImmutableTrees.TypeDeclaration value, Trees.TypeDeclaration.Kind attribute) {
        return attribute;
    }

    public ImmutableTrees.InvokeEnd toInvokeEnd(ImmutableTrees.InvokeEnd value) {
        return value.withAccess(this.asInvokeEndAccess(value, value.access()));
    }

    protected Trees.AccessExpression asInvokeEndAccess(ImmutableTrees.InvokeEnd value, Trees.AccessExpression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asAccessExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.IterationGenerator toIterationGenerator(ImmutableTrees.IterationGenerator value) {
        return value.withCondition(this.asIterationGeneratorConditionOptional(value, value.condition())).withDeclaration(this.asIterationGeneratorDeclaration(value, value.declaration())).withFrom(this.asIterationGeneratorFrom(value, value.from()));
    }

    protected Optional<Trees.Expression> asIterationGeneratorConditionOptional(ImmutableTrees.IterationGenerator value, Optional<Trees.Expression> optional) {
        if (optional.isPresent()) {
            Trees.Expression original = (Trees.Expression)optional.get();
            Trees.Expression changed = this.asIterationGeneratorCondition(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.Expression asIterationGeneratorCondition(ImmutableTrees.IterationGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Trees.ValueDeclaration asIterationGeneratorDeclaration(ImmutableTrees.IterationGenerator value, Trees.ValueDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.ValueDeclaration) {
            return this.asValueDeclaration((ImmutableTrees.ValueDeclaration)attribute);
        }
        return attribute;
    }

    protected Trees.Expression asIterationGeneratorFrom(ImmutableTrees.IterationGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.Parameter toParameter(ImmutableTrees.Parameter value) {
        return value.withName(this.asParameterName(value, value.name())).withType(this.asParameterType(value, value.type()));
    }

    protected Trees.Identifier asParameterName(ImmutableTrees.Parameter value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    protected Trees.TypeReference asParameterType(ImmutableTrees.Parameter value, Trees.TypeReference attribute) {
        if (attribute instanceof ImmutableTrees.TypeDeclaration) {
            return this.asTypeReference((ImmutableTrees.TypeDeclaration)attribute);
        }
        if (attribute instanceof ImmutableTrees.ResolvedType) {
            return this.asTypeReference((ImmutableTrees.ResolvedType)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ForStatement toForStatement(ImmutableTrees.ForStatement value) {
        return value.withUseForAccess(this.asForStatementUseForAccess(value, value.useForAccess())).withUseDelimit(this.asForStatementUseDelimit(value, value.useDelimit())).withDeclaration(this.asForStatementDeclarationElements(value, (List<Trees.GeneratorDeclaration>)value.declaration())).withParts(this.asForStatementPartsElements(value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected boolean asForStatementUseForAccess(ImmutableTrees.ForStatement value, boolean attribute) {
        return attribute;
    }

    protected boolean asForStatementUseDelimit(ImmutableTrees.ForStatement value, boolean attribute) {
        return attribute;
    }

    protected Iterable<Trees.GeneratorDeclaration> asForStatementDeclarationElements(ImmutableTrees.ForStatement value, List<Trees.GeneratorDeclaration> elements) {
        ArrayList<Trees.GeneratorDeclaration> changedElements = new ArrayList<Trees.GeneratorDeclaration>(elements.size());
        boolean haveChanged = false;
        for (Trees.GeneratorDeclaration original : elements) {
            Trees.GeneratorDeclaration changed = this.asForStatementDeclaration(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.GeneratorDeclaration asForStatementDeclaration(ImmutableTrees.ForStatement value, Trees.GeneratorDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.AssignGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.AssignGenerator)attribute);
        }
        if (attribute instanceof ImmutableTrees.IterationGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.IterationGenerator)attribute);
        }
        if (attribute instanceof ImmutableTrees.TransformGenerator) {
            return this.asGeneratorDeclaration((ImmutableTrees.TransformGenerator)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.TemplatePart> asForStatementPartsElements(ImmutableTrees.ForStatement value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asForStatementParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asForStatementParts(ImmutableTrees.ForStatement value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.StringLiteral toStringLiteral(ImmutableTrees.StringLiteral value) {
        return value.withValue(this.asStringLiteralValue(value, value.value()));
    }

    protected String asStringLiteralValue(ImmutableTrees.StringLiteral value, String attribute) {
        return attribute;
    }

    public ImmutableTrees.Unit toUnit(ImmutableTrees.Unit value) {
        return value.withParts(this.asUnitPartsElements(value, (List<Trees.UnitPart>)value.parts()));
    }

    protected Iterable<Trees.UnitPart> asUnitPartsElements(ImmutableTrees.Unit value, List<Trees.UnitPart> elements) {
        ArrayList<Trees.UnitPart> changedElements = new ArrayList<Trees.UnitPart>(elements.size());
        boolean haveChanged = false;
        for (Trees.UnitPart original : elements) {
            Trees.UnitPart changed = this.asUnitParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.UnitPart asUnitParts(ImmutableTrees.Unit value, Trees.UnitPart attribute) {
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asUnitPart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asUnitPart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.TemplateEnd toTemplateEnd(ImmutableTrees.TemplateEnd value) {
        return value;
    }

    public ImmutableTrees.SimpleBlock toSimpleBlock(ImmutableTrees.SimpleBlock value) {
        return value.withParts(this.asSimpleBlockPartsElements(value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Iterable<Trees.TemplatePart> asSimpleBlockPartsElements(ImmutableTrees.SimpleBlock value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asSimpleBlockParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asSimpleBlockParts(ImmutableTrees.SimpleBlock value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.Else toElse(ImmutableTrees.Else value) {
        return value;
    }

    public ImmutableTrees.IfEnd toIfEnd(ImmutableTrees.IfEnd value) {
        return value;
    }

    public ImmutableTrees.TextBlock toTextBlock(ImmutableTrees.TextBlock value) {
        return value.withParts(this.asTextBlockPartsElements(value, (List<Trees.TextPart>)value.parts()));
    }

    protected Iterable<Trees.TextPart> asTextBlockPartsElements(ImmutableTrees.TextBlock value, List<Trees.TextPart> elements) {
        ArrayList<Trees.TextPart> changedElements = new ArrayList<Trees.TextPart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TextPart original : elements) {
            Trees.TextPart changed = this.asTextBlockParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TextPart asTextBlockParts(ImmutableTrees.TextBlock value, Trees.TextPart attribute) {
        if (attribute instanceof ImmutableTrees.TextFragment) {
            return this.asTextPart((ImmutableTrees.TextFragment)attribute);
        }
        if (attribute instanceof ImmutableTrees.Newline) {
            return this.asTextPart((ImmutableTrees.Newline)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.TextFragment toTextFragment(ImmutableTrees.TextFragment value) {
        return value.withValue(this.asTextFragmentValue(value, value.value()));
    }

    protected String asTextFragmentValue(ImmutableTrees.TextFragment value, String attribute) {
        return attribute;
    }

    public ImmutableTrees.Comment toComment(ImmutableTrees.Comment value) {
        return value;
    }

    public ImmutableTrees.InvokableDeclaration toInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
        return value.withParameters(this.asInvokableDeclarationParametersElements(value, (List<Trees.Parameter>)value.parameters())).withName(this.asInvokableDeclarationName(value, value.name()));
    }

    protected Iterable<Trees.Parameter> asInvokableDeclarationParametersElements(ImmutableTrees.InvokableDeclaration value, List<Trees.Parameter> elements) {
        ArrayList<Trees.Parameter> changedElements = new ArrayList<Trees.Parameter>(elements.size());
        boolean haveChanged = false;
        for (Trees.Parameter original : elements) {
            Trees.Parameter changed = this.asInvokableDeclarationParameters(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Parameter asInvokableDeclarationParameters(ImmutableTrees.InvokableDeclaration value, Trees.Parameter attribute) {
        if (attribute instanceof ImmutableTrees.Parameter) {
            return this.asParameter((ImmutableTrees.Parameter)attribute);
        }
        return attribute;
    }

    protected Trees.Identifier asInvokableDeclarationName(ImmutableTrees.InvokableDeclaration value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.TransformGenerator toTransformGenerator(ImmutableTrees.TransformGenerator value) {
        return value.withTransform(this.asTransformGeneratorTransform(value, value.transform())).withVarDeclaration(this.asTransformGeneratorVarDeclaration(value, value.varDeclaration())).withCondition(this.asTransformGeneratorConditionOptional(value, value.condition())).withDeclaration(this.asTransformGeneratorDeclaration(value, value.declaration())).withFrom(this.asTransformGeneratorFrom(value, value.from()));
    }

    protected Trees.Expression asTransformGeneratorTransform(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Trees.ValueDeclaration asTransformGeneratorVarDeclaration(ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.ValueDeclaration) {
            return this.asValueDeclaration((ImmutableTrees.ValueDeclaration)attribute);
        }
        return attribute;
    }

    protected Optional<Trees.Expression> asTransformGeneratorConditionOptional(ImmutableTrees.TransformGenerator value, Optional<Trees.Expression> optional) {
        if (optional.isPresent()) {
            Trees.Expression original = (Trees.Expression)optional.get();
            Trees.Expression changed = this.asTransformGeneratorCondition(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.Expression asTransformGeneratorCondition(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Trees.ValueDeclaration asTransformGeneratorDeclaration(ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.ValueDeclaration) {
            return this.asValueDeclaration((ImmutableTrees.ValueDeclaration)attribute);
        }
        return attribute;
    }

    protected Trees.Expression asTransformGeneratorFrom(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ResolvedType toResolvedType(ImmutableTrees.ResolvedType value) {
        return value.withType(this.asResolvedTypeType(value, value.type()));
    }

    protected Object asResolvedTypeType(ImmutableTrees.ResolvedType value, Object attribute) {
        return attribute;
    }

    public ImmutableTrees.BoundAccessExpression toBoundAccessExpression(ImmutableTrees.BoundAccessExpression value) {
        return value.withAccessor(this.asBoundAccessExpressionAccessorElements(value, (List<Object>)value.accessor())).withPath(this.asBoundAccessExpressionPathElements(value, (List<Trees.Identifier>)value.path()));
    }

    protected Iterable<Object> asBoundAccessExpressionAccessorElements(ImmutableTrees.BoundAccessExpression value, List<Object> elements) {
        ArrayList<Object> changedElements = new ArrayList<Object>(elements.size());
        boolean haveChanged = false;
        for (Object original : elements) {
            Object changed = this.asBoundAccessExpressionAccessor(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Object asBoundAccessExpressionAccessor(ImmutableTrees.BoundAccessExpression value, Object attribute) {
        return attribute;
    }

    protected Iterable<Trees.Identifier> asBoundAccessExpressionPathElements(ImmutableTrees.BoundAccessExpression value, List<Trees.Identifier> elements) {
        ArrayList<Trees.Identifier> changedElements = new ArrayList<Trees.Identifier>(elements.size());
        boolean haveChanged = false;
        for (Trees.Identifier original : elements) {
            Trees.Identifier changed = this.asBoundAccessExpressionPath(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Identifier asBoundAccessExpressionPath(ImmutableTrees.BoundAccessExpression value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.SimpleAccessExpression toSimpleAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
        return value.withPath(this.asSimpleAccessExpressionPathElements(value, (List<Trees.Identifier>)value.path()));
    }

    protected Iterable<Trees.Identifier> asSimpleAccessExpressionPathElements(ImmutableTrees.SimpleAccessExpression value, List<Trees.Identifier> elements) {
        ArrayList<Trees.Identifier> changedElements = new ArrayList<Trees.Identifier>(elements.size());
        boolean haveChanged = false;
        for (Trees.Identifier original : elements) {
            Trees.Identifier changed = this.asSimpleAccessExpressionPath(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Identifier asSimpleAccessExpressionPath(ImmutableTrees.SimpleAccessExpression value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.TextLine toTextLine(ImmutableTrees.TextLine value) {
        return value.withFragment(this.asTextLineFragment(value, value.fragment())).withNewline(this.asTextLineNewline(value, value.newline()));
    }

    protected Trees.TextFragment asTextLineFragment(ImmutableTrees.TextLine value, Trees.TextFragment attribute) {
        if (attribute instanceof ImmutableTrees.TextFragment) {
            return this.asTextFragment((ImmutableTrees.TextFragment)attribute);
        }
        return attribute;
    }

    protected boolean asTextLineNewline(ImmutableTrees.TextLine value, boolean attribute) {
        return attribute;
    }

    public ImmutableTrees.Newline toNewline(ImmutableTrees.Newline value) {
        return value;
    }

    public ImmutableTrees.IfStatement toIfStatement(ImmutableTrees.IfStatement value) {
        return value.withThen(this.asIfStatementThen(value, value.then())).withOtherwiseIf(this.asIfStatementOtherwiseIfElements(value, (List<Trees.ConditionalBlock>)value.otherwiseIf())).withOtherwise(this.asIfStatementOtherwiseOptional(value, value.otherwise()));
    }

    protected Trees.ConditionalBlock asIfStatementThen(ImmutableTrees.IfStatement value, Trees.ConditionalBlock attribute) {
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asConditionalBlock((ImmutableTrees.ConditionalBlock)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.ConditionalBlock> asIfStatementOtherwiseIfElements(ImmutableTrees.IfStatement value, List<Trees.ConditionalBlock> elements) {
        ArrayList<Trees.ConditionalBlock> changedElements = new ArrayList<Trees.ConditionalBlock>(elements.size());
        boolean haveChanged = false;
        for (Trees.ConditionalBlock original : elements) {
            Trees.ConditionalBlock changed = this.asIfStatementOtherwiseIf(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.ConditionalBlock asIfStatementOtherwiseIf(ImmutableTrees.IfStatement value, Trees.ConditionalBlock attribute) {
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asConditionalBlock((ImmutableTrees.ConditionalBlock)attribute);
        }
        return attribute;
    }

    protected Optional<Trees.Block> asIfStatementOtherwiseOptional(ImmutableTrees.IfStatement value, Optional<Trees.Block> optional) {
        if (optional.isPresent()) {
            Trees.Block original = (Trees.Block)optional.get();
            Trees.Block changed = this.asIfStatementOtherwise(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.Block asIfStatementOtherwise(ImmutableTrees.IfStatement value, Trees.Block attribute) {
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asBlock((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asBlock((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asBlock((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asBlock((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asBlock((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asBlock((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.InvokeString toInvokeString(ImmutableTrees.InvokeString value) {
        return value.withLiteral(this.asInvokeStringLiteral(value, value.literal()));
    }

    protected Trees.StringLiteral asInvokeStringLiteral(ImmutableTrees.InvokeString value, Trees.StringLiteral attribute) {
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asStringLiteral((ImmutableTrees.StringLiteral)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ApplyExpression toApplyExpression(ImmutableTrees.ApplyExpression value) {
        return value.withParams(this.asApplyExpressionParamsElements(value, (List<Trees.Expression>)value.params()));
    }

    protected Iterable<Trees.Expression> asApplyExpressionParamsElements(ImmutableTrees.ApplyExpression value, List<Trees.Expression> elements) {
        ArrayList<Trees.Expression> changedElements = new ArrayList<Trees.Expression>(elements.size());
        boolean haveChanged = false;
        for (Trees.Expression original : elements) {
            Trees.Expression changed = this.asApplyExpressionParams(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.Expression asApplyExpressionParams(ImmutableTrees.ApplyExpression value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ConditionalBlock toConditionalBlock(ImmutableTrees.ConditionalBlock value) {
        return value.withCondition(this.asConditionalBlockCondition(value, value.condition())).withParts(this.asConditionalBlockPartsElements(value, (List<Trees.TemplatePart>)value.parts()));
    }

    protected Trees.Expression asConditionalBlockCondition(ImmutableTrees.ConditionalBlock value, Trees.Expression attribute) {
        if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
            return this.asExpression((ImmutableTrees.ForIterationAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.StringLiteral) {
            return this.asExpression((ImmutableTrees.StringLiteral)attribute);
        }
        if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
            return this.asExpression((ImmutableTrees.BoundAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
            return this.asExpression((ImmutableTrees.SimpleAccessExpression)attribute);
        }
        if (attribute instanceof ImmutableTrees.ApplyExpression) {
            return this.asExpression((ImmutableTrees.ApplyExpression)attribute);
        }
        return attribute;
    }

    protected Iterable<Trees.TemplatePart> asConditionalBlockPartsElements(ImmutableTrees.ConditionalBlock value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asConditionalBlockParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asConditionalBlockParts(ImmutableTrees.ConditionalBlock value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.LetStatement toLetStatement(ImmutableTrees.LetStatement value) {
        return value.withParts(this.asLetStatementPartsElements(value, (List<Trees.TemplatePart>)value.parts())).withDeclaration(this.asLetStatementDeclaration(value, value.declaration()));
    }

    protected Iterable<Trees.TemplatePart> asLetStatementPartsElements(ImmutableTrees.LetStatement value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asLetStatementParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asLetStatementParts(ImmutableTrees.LetStatement value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    protected Trees.InvokableDeclaration asLetStatementDeclaration(ImmutableTrees.LetStatement value, Trees.InvokableDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
            return this.asInvokableDeclaration((ImmutableTrees.InvokableDeclaration)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.Template toTemplate(ImmutableTrees.Template value) {
        return value.withIsPublic(this.asTemplateIsPublic(value, value.isPublic())).withParts(this.asTemplatePartsElements(value, (List<Trees.TemplatePart>)value.parts())).withDeclaration(this.asTemplateDeclaration(value, value.declaration()));
    }

    protected boolean asTemplateIsPublic(ImmutableTrees.Template value, boolean attribute) {
        return attribute;
    }

    protected Iterable<Trees.TemplatePart> asTemplatePartsElements(ImmutableTrees.Template value, List<Trees.TemplatePart> elements) {
        ArrayList<Trees.TemplatePart> changedElements = new ArrayList<Trees.TemplatePart>(elements.size());
        boolean haveChanged = false;
        for (Trees.TemplatePart original : elements) {
            Trees.TemplatePart changed = this.asTemplateParts(value, original);
            if (changed != original) {
                haveChanged = true;
            }
            changedElements.add(changed);
        }
        return haveChanged ? changedElements : elements;
    }

    protected Trees.TemplatePart asTemplateParts(ImmutableTrees.Template value, Trees.TemplatePart attribute) {
        if (attribute instanceof ImmutableTrees.ElseIf) {
            return this.asTemplatePart((ImmutableTrees.ElseIf)attribute);
        }
        if (attribute instanceof ImmutableTrees.If) {
            return this.asTemplatePart((ImmutableTrees.If)attribute);
        }
        if (attribute instanceof ImmutableTrees.Let) {
            return this.asTemplatePart((ImmutableTrees.Let)attribute);
        }
        if (attribute instanceof ImmutableTrees.For) {
            return this.asTemplatePart((ImmutableTrees.For)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetEnd) {
            return this.asTemplatePart((ImmutableTrees.LetEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.Invoke) {
            return this.asTemplatePart((ImmutableTrees.Invoke)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeStatement) {
            return this.asTemplatePart((ImmutableTrees.InvokeStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForEnd) {
            return this.asTemplatePart((ImmutableTrees.ForEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeEnd) {
            return this.asTemplatePart((ImmutableTrees.InvokeEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.ForStatement) {
            return this.asTemplatePart((ImmutableTrees.ForStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.TemplateEnd) {
            return this.asTemplatePart((ImmutableTrees.TemplateEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.SimpleBlock) {
            return this.asTemplatePart((ImmutableTrees.SimpleBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Else) {
            return this.asTemplatePart((ImmutableTrees.Else)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfEnd) {
            return this.asTemplatePart((ImmutableTrees.IfEnd)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextBlock) {
            return this.asTemplatePart((ImmutableTrees.TextBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.Comment) {
            return this.asTemplatePart((ImmutableTrees.Comment)attribute);
        }
        if (attribute instanceof ImmutableTrees.TextLine) {
            return this.asTemplatePart((ImmutableTrees.TextLine)attribute);
        }
        if (attribute instanceof ImmutableTrees.IfStatement) {
            return this.asTemplatePart((ImmutableTrees.IfStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.InvokeString) {
            return this.asTemplatePart((ImmutableTrees.InvokeString)attribute);
        }
        if (attribute instanceof ImmutableTrees.ConditionalBlock) {
            return this.asTemplatePart((ImmutableTrees.ConditionalBlock)attribute);
        }
        if (attribute instanceof ImmutableTrees.LetStatement) {
            return this.asTemplatePart((ImmutableTrees.LetStatement)attribute);
        }
        if (attribute instanceof ImmutableTrees.Template) {
            return this.asTemplatePart((ImmutableTrees.Template)attribute);
        }
        return attribute;
    }

    protected Trees.InvokableDeclaration asTemplateDeclaration(ImmutableTrees.Template value, Trees.InvokableDeclaration attribute) {
        if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
            return this.asInvokableDeclaration((ImmutableTrees.InvokableDeclaration)attribute);
        }
        return attribute;
    }

    public ImmutableTrees.ValueDeclaration toValueDeclaration(ImmutableTrees.ValueDeclaration value) {
        return value.withType(this.asValueDeclarationTypeOptional(value, value.type())).withContainedType(this.asValueDeclarationContainedTypeOptional(value, value.containedType())).withName(this.asValueDeclarationName(value, value.name()));
    }

    protected Optional<Trees.TypeReference> asValueDeclarationTypeOptional(ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
        if (optional.isPresent()) {
            Trees.TypeReference original = (Trees.TypeReference)optional.get();
            Trees.TypeReference changed = this.asValueDeclarationType(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.TypeReference asValueDeclarationType(ImmutableTrees.ValueDeclaration value, Trees.TypeReference attribute) {
        if (attribute instanceof ImmutableTrees.TypeDeclaration) {
            return this.asTypeReference((ImmutableTrees.TypeDeclaration)attribute);
        }
        if (attribute instanceof ImmutableTrees.ResolvedType) {
            return this.asTypeReference((ImmutableTrees.ResolvedType)attribute);
        }
        return attribute;
    }

    protected Optional<Trees.TypeReference> asValueDeclarationContainedTypeOptional(ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
        if (optional.isPresent()) {
            Trees.TypeReference original = (Trees.TypeReference)optional.get();
            Trees.TypeReference changed = this.asValueDeclarationContainedType(value, original);
            return changed != original ? Optional.of((Object)changed) : optional;
        }
        return Optional.absent();
    }

    protected Trees.TypeReference asValueDeclarationContainedType(ImmutableTrees.ValueDeclaration value, Trees.TypeReference attribute) {
        if (attribute instanceof ImmutableTrees.TypeDeclaration) {
            return this.asTypeReference((ImmutableTrees.TypeDeclaration)attribute);
        }
        if (attribute instanceof ImmutableTrees.ResolvedType) {
            return this.asTypeReference((ImmutableTrees.ResolvedType)attribute);
        }
        return attribute;
    }

    protected Trees.Identifier asValueDeclarationName(ImmutableTrees.ValueDeclaration value, Trees.Identifier attribute) {
        if (attribute instanceof ImmutableTrees.Identifier) {
            return this.asIdentifier((ImmutableTrees.Identifier)attribute);
        }
        return attribute;
    }

    protected Trees.TypeIdentifier asTypeIdentifier(ImmutableTrees.TypeIdentifier value) {
        return this.toTypeIdentifier(value);
    }

    protected Trees.StringLiteral asStringLiteral(ImmutableTrees.StringLiteral value) {
        return this.toStringLiteral(value);
    }

    protected Trees.TextPart asTextPart(ImmutableTrees.TextFragment value) {
        return this.toTextFragment(value);
    }

    protected Trees.TextPart asTextPart(ImmutableTrees.Newline value) {
        return this.toNewline(value);
    }

    protected Trees.ApplyExpression asApplyExpression(ImmutableTrees.ApplyExpression value) {
        return this.toApplyExpression(value);
    }

    protected Trees.Identifier asIdentifier(ImmutableTrees.Identifier value) {
        return this.toIdentifier(value);
    }

    protected Trees.Expression asExpression(ImmutableTrees.StringLiteral value) {
        return this.toStringLiteral(value);
    }

    protected Trees.Expression asExpression(ImmutableTrees.BoundAccessExpression value) {
        return this.toBoundAccessExpression(value);
    }

    protected Trees.Expression asExpression(ImmutableTrees.SimpleAccessExpression value) {
        return this.toSimpleAccessExpression(value);
    }

    protected Trees.Expression asExpression(ImmutableTrees.ApplyExpression value) {
        return this.toApplyExpression(value);
    }

    protected Trees.Expression asExpression(ImmutableTrees.ForIterationAccessExpression value) {
        return this.toForIterationAccessExpression(value);
    }

    protected Trees.ConditionalBlock asConditionalBlock(ImmutableTrees.ConditionalBlock value) {
        return this.toConditionalBlock(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ForEnd value) {
        return this.toForEnd(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TextBlock value) {
        return this.toTextBlock(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.LetEnd value) {
        return this.toLetEnd(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TemplateEnd value) {
        return this.toTemplateEnd(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Else value) {
        return this.toElse(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.SimpleBlock value) {
        return this.toSimpleBlock(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeString value) {
        return this.toInvokeString(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ConditionalBlock value) {
        return this.toConditionalBlock(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.IfEnd value) {
        return this.toIfEnd(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Template value) {
        return this.toTemplate(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ElseIf value) {
        return this.toElseIf(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Invoke value) {
        return this.toInvoke(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeStatement value) {
        return this.toInvokeStatement(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ForStatement value) {
        return this.toForStatement(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Comment value) {
        return this.toComment(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.If value) {
        return this.toIf(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.IfStatement value) {
        return this.toIfStatement(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Let value) {
        return this.toLet(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.For value) {
        return this.toFor(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TextLine value) {
        return this.toTextLine(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeEnd value) {
        return this.toInvokeEnd(value);
    }

    protected Trees.TemplatePart asTemplatePart(ImmutableTrees.LetStatement value) {
        return this.toLetStatement(value);
    }

    protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.TransformGenerator value) {
        return this.toTransformGenerator(value);
    }

    protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.AssignGenerator value) {
        return this.toAssignGenerator(value);
    }

    protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.IterationGenerator value) {
        return this.toIterationGenerator(value);
    }

    protected Trees.TextFragment asTextFragment(ImmutableTrees.TextFragment value) {
        return this.toTextFragment(value);
    }

    protected Trees.ValueDeclaration asValueDeclaration(ImmutableTrees.ValueDeclaration value) {
        return this.toValueDeclaration(value);
    }

    protected Trees.TypeReference asTypeReference(ImmutableTrees.ResolvedType value) {
        return this.toResolvedType(value);
    }

    protected Trees.TypeReference asTypeReference(ImmutableTrees.TypeDeclaration value) {
        return this.toTypeDeclaration(value);
    }

    protected Trees.Parameter asParameter(ImmutableTrees.Parameter value) {
        return this.toParameter(value);
    }

    protected Trees.UnitPart asUnitPart(ImmutableTrees.Template value) {
        return this.toTemplate(value);
    }

    protected Trees.UnitPart asUnitPart(ImmutableTrees.Comment value) {
        return this.toComment(value);
    }

    protected Trees.InvokableDeclaration asInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
        return this.toInvokableDeclaration(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.InvokeStatement value) {
        return this.toInvokeStatement(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.ConditionalBlock value) {
        return this.toConditionalBlock(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.ForStatement value) {
        return this.toForStatement(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.Template value) {
        return this.toTemplate(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.SimpleBlock value) {
        return this.toSimpleBlock(value);
    }

    protected Trees.Block asBlock(ImmutableTrees.LetStatement value) {
        return this.toLetStatement(value);
    }

    protected Trees.AccessExpression asAccessExpression(ImmutableTrees.BoundAccessExpression value) {
        return this.toBoundAccessExpression(value);
    }

    protected Trees.AccessExpression asAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
        return this.toSimpleAccessExpression(value);
    }

    protected Trees.AccessExpression asAccessExpression(ImmutableTrees.ForIterationAccessExpression value) {
        return this.toForIterationAccessExpression(value);
    }
}

