/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator.processor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.immutables.generator.processor.Accessors;
import org.immutables.generator.processor.ImmutableTrees;
import org.immutables.generator.processor.SwissArmyKnife;
import org.immutables.generator.processor.Trees;
import org.immutables.generator.processor.TreesTransformer;

public final class TypeResolver {
    static final String ITERATION_ACCESS_VARIABLE = "for";
    private final SwissArmyKnife knife;

    public TypeResolver(SwissArmyKnife knife) {
        this.knife = knife;
    }

    public ImmutableTrees.Unit resolve(ImmutableTrees.Unit unit) {
        return new Transformer(new Scope()).toUnit(new ForIterationAccessTransformer().toUnit(unit));
    }

    public static ImmutableList<Accessors.BoundAccess> asBoundAccess(Iterable<?> iterable) {
        for (Object object : iterable) {
            Preconditions.checkArgument((boolean)(object instanceof Accessors.BoundAccess));
        }
        return FluentIterable.from(iterable).filter(Accessors.BoundAccess.class).toList();
    }

    private static final class Transformer
    extends TreesTransformer {
        private final Scope scope;

        public Transformer(Scope scope) {
            this.scope = scope;
        }

        @Override
        public ImmutableTrees.Unit toUnit(ImmutableTrees.Unit unit) {
            for (ImmutableTrees.Template template : Iterables.filter(unit.parts(), ImmutableTrees.Template.class)) {
                this.scope.declareInvokable(template.declaration().name());
            }
            return super.toUnit(unit);
        }

        @Override
        public ImmutableTrees.AssignGenerator toAssignGenerator(ImmutableTrees.AssignGenerator value) {
            ImmutableTrees.AssignGenerator generator = super.toAssignGenerator(value);
            return generator.withDeclaration(this.scope.inferType(generator.declaration(), generator.from(), InferencePurpose.ASSIGN));
        }

        @Override
        protected Trees.TemplatePart asTemplatePart(ImmutableTrees.LetStatement statement) {
            this.scope.declareInvokable(statement.declaration().name());
            return super.asTemplatePart(statement);
        }

        @Override
        public ImmutableTrees.IterationGenerator toIterationGenerator(ImmutableTrees.IterationGenerator value) {
            ImmutableTrees.IterationGenerator generator = super.toIterationGenerator(value);
            return generator.withDeclaration(this.scope.inferType(generator.declaration(), generator.from(), InferencePurpose.ITERATE)).withCondition(this.asIterationGeneratorConditionAfterDeclaration(generator, generator.condition()));
        }

        @Override
        public ImmutableTrees.TransformGenerator toTransformGenerator(ImmutableTrees.TransformGenerator value) {
            ImmutableTrees.TransformGenerator generator = super.toTransformGenerator(value);
            generator = generator.withVarDeclaration(this.scope.inferType(generator.varDeclaration(), generator.from(), InferencePurpose.ITERATE)).withCondition(this.asTransformGeneratorConditionAfterDeclaration(generator, generator.condition())).withTransform(this.asTransformGeneratorTransformAfterDeclaration(generator, generator.transform()));
            return generator.withDeclaration(this.scope.inferType(generator.declaration(), generator.transform(), InferencePurpose.COLLECT));
        }

        private Optional<Trees.Expression> asIterationGeneratorConditionAfterDeclaration(ImmutableTrees.IterationGenerator generator, Optional<Trees.Expression> condition) {
            if (condition.isPresent()) {
                return Optional.of((Object)super.asIterationGeneratorCondition(generator, (Trees.Expression)condition.get()));
            }
            return Optional.absent();
        }

        private Optional<Trees.Expression> asTransformGeneratorConditionAfterDeclaration(ImmutableTrees.TransformGenerator generator, Optional<Trees.Expression> condition) {
            if (condition.isPresent()) {
                return Optional.of((Object)super.asTransformGeneratorCondition(generator, (Trees.Expression)condition.get()));
            }
            return Optional.absent();
        }

        private Trees.Expression asTransformGeneratorTransformAfterDeclaration(ImmutableTrees.TransformGenerator generator, Trees.Expression condition) {
            return super.asTransformGeneratorTransform(generator, condition);
        }

        @Override
        protected Trees.Expression asIterationGeneratorCondition(ImmutableTrees.IterationGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        protected Trees.Expression asTransformGeneratorCondition(ImmutableTrees.TransformGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        protected Trees.Expression asTransformGeneratorTransform(ImmutableTrees.TransformGenerator value, Trees.Expression element) {
            return this.simplifyExpression(element);
        }

        @Override
        public ImmutableTrees.Parameter toParameter(ImmutableTrees.Parameter parameter) {
            return parameter.withType(this.scope.declare((Trees.TypeDeclaration)parameter.type(), parameter.name()));
        }

        @Override
        public ImmutableTrees.Template toTemplate(ImmutableTrees.Template template) {
            try {
                Scope nestedScope = this.scope.nest();
                Transformer nested = new Transformer(nestedScope);
                return template.withDeclaration(nested.asTemplateDeclaration(template, template.declaration())).withParts(nested.asTemplatePartsElements(template, (List<Trees.TemplatePart>)template.parts()));
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("In template " + template.declaration().name() + ": " + ex.getMessage(), ex);
            }
        }

        @Override
        public ImmutableTrees.LetStatement toLetStatement(ImmutableTrees.LetStatement statement) {
            Transformer nested = new Transformer(this.scope.nest());
            return statement.withDeclaration(nested.asLetStatementDeclaration(statement, statement.declaration())).withParts(nested.asLetStatementPartsElements(statement, (List<Trees.TemplatePart>)statement.parts()));
        }

        @Override
        public ImmutableTrees.ForStatement toForStatement(ImmutableTrees.ForStatement statement) {
            Scope nestedScope = this.scope.nest();
            nestedScope.declareForIterationAccess(ImmutableTrees.Identifier.of(TypeResolver.ITERATION_ACCESS_VARIABLE));
            Transformer nested = new Transformer(nestedScope);
            return statement.withDeclaration(nested.asForStatementDeclarationElements(statement, (List<Trees.GeneratorDeclaration>)statement.declaration())).withParts(nested.asForStatementPartsElements(statement, (List<Trees.TemplatePart>)statement.parts()));
        }

        @Override
        protected Iterable<Trees.TemplatePart> asForStatementPartsElements(ImmutableTrees.ForStatement value, List<Trees.TemplatePart> collection) {
            return super.asForStatementPartsElements(value, collection);
        }

        @Override
        protected Trees.AccessExpression asAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
            return this.scope.resolveAccess(value);
        }

        @Override
        protected Trees.Expression asExpression(ImmutableTrees.ApplyExpression value) {
            return this.simplifyExpression(super.asExpression(value));
        }

        @Override
        protected Trees.Expression asExpression(ImmutableTrees.SimpleAccessExpression value) {
            return this.scope.resolveAccess(value);
        }

        private Trees.Expression simplifyExpression(Trees.Expression expression) {
            ImmutableList<Trees.Expression> params;
            if (expression instanceof ImmutableTrees.ApplyExpression && (params = ((ImmutableTrees.ApplyExpression)expression).params()).size() == 1) {
                return (Trees.Expression)params.get(0);
            }
            return expression;
        }
    }

    private static final class ForIterationAccessTransformer
    extends TreesTransformer {
        private ForIterationAccessTransformer() {
        }

        @Override
        protected Trees.Expression asExpression(ImmutableTrees.ForIterationAccessExpression expression) {
            return ImmutableTrees.SimpleAccessExpression.builder().addPath((Trees.Identifier)ImmutableTrees.Identifier.of(TypeResolver.ITERATION_ACCESS_VARIABLE)).addAllPath(expression.access().path()).build();
        }
    }

    private class Scope {
        final Map<String, TypeMirror> locals = Maps.newLinkedHashMap();

        private Scope() {
        }

        Scope nest() {
            Scope nested = new Scope();
            nested.locals.putAll(this.locals);
            return nested;
        }

        Trees.TypeReference declare(Trees.TypeDeclaration type, Trees.Identifier name) {
            if (this.isDeclared(name)) {
                throw new TypingException(String.format("Redeclaration of local %s", name));
            }
            return this.declare(this.resolve(type), name);
        }

        Trees.TypeReference declareInvokable(Trees.Identifier name) {
            return this.declare(((TypeResolver)TypeResolver.this).knife.accessors.invokableType, name);
        }

        Trees.TypeReference declareForIterationAccess(Trees.Identifier name) {
            return this.declare(((TypeResolver)TypeResolver.this).knife.accessors.iterationType, name);
        }

        boolean isDeclared(Trees.Identifier name) {
            return this.locals.containsKey(name.value());
        }

        Trees.TypeReference declare(TypeMirror type, Trees.Identifier name) {
            this.locals.put(name.value(), type);
            return ImmutableTrees.ResolvedType.of(type);
        }

        TypeMirror resolve(Trees.TypeDeclaration type) {
            TypeMirror resolved = (TypeMirror)((TypeResolver)TypeResolver.this).knife.imports.get((Object)type.type().value());
            if (resolved == null) {
                throw new TypingException(String.format("Could not resolve %s simple type", type));
            }
            if (type.kind() == Trees.TypeDeclaration.Kind.ITERABLE) {
                resolved = this.makeIterableTypeOf(resolved);
            }
            return resolved;
        }

        DeclaredType makeIterableTypeOf(TypeMirror resolved) {
            return ((TypeResolver)TypeResolver.this).knife.types.getDeclaredType(((TypeResolver)TypeResolver.this).knife.accessors.iterableElement, resolved);
        }

        ImmutableTrees.BoundAccessExpression resolveAccess(Trees.AccessExpression expression) {
            if (expression instanceof ImmutableTrees.BoundAccessExpression) {
                return (ImmutableTrees.BoundAccessExpression)expression;
            }
            try {
                ImmutableTrees.BoundAccessExpression.Builder builder = ImmutableTrees.BoundAccessExpression.builder().addAllPath(expression.path());
                Accessors.BoundAccess accessor = null;
                for (Trees.Identifier identifier : expression.path()) {
                    accessor = this.bindAccess(accessor, identifier.value());
                    builder.addAccessor((Object)accessor);
                }
                return builder.build();
            }
            catch (Exception ex) {
                RuntimeException exception = new RuntimeException("Path " + expression.path() + ": " + ex.getMessage());
                exception.setStackTrace(ex.getStackTrace());
                throw exception;
            }
        }

        Accessors.BoundAccess bindAccess(@Nullable Accessors.BoundAccess previous, String name) {
            return previous != null ? ((TypeResolver)TypeResolver.this).knife.binder.bind(previous.type, name) : ((TypeResolver)TypeResolver.this).knife.binder.bindLocalOrThis(((TypeResolver)TypeResolver.this).knife.type.asType(), name, this.locals);
        }

        Trees.ValueDeclaration inferType(Trees.ValueDeclaration declaration, Trees.Expression expression, InferencePurpose inferenceKind) {
            if (expression instanceof ImmutableTrees.BoundAccessExpression) {
                ImmutableTrees.BoundAccessExpression scopeBoundAccess = (ImmutableTrees.BoundAccessExpression)expression;
                Accessors.BoundAccess lastAccess = (Accessors.BoundAccess)Iterables.getLast(TypeResolver.asBoundAccess(scopeBoundAccess.accessor()));
                if (inferenceKind == InferencePurpose.ITERATE && !lastAccess.isContainer()) {
                    throw new TypingException(String.format("Not iterable type '%s'%n\tin expression '%s'", lastAccess.type, scopeBoundAccess.path()));
                }
                if (declaration.type().isPresent()) {
                    return declaration.withType(this.resolveDeclared((Trees.TypeReference)declaration.type().get(), declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(this.resolveType((Trees.TypeReference)declaration.type().get(), false)));
                }
                if (inferenceKind == InferencePurpose.ITERATE) {
                    TypeMirror resolved = lastAccess.containedType;
                    return declaration.withType(this.declare(resolved, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(resolved));
                }
                if (inferenceKind == InferencePurpose.COLLECT) {
                    TypeMirror resolved = ((TypeResolver)TypeResolver.this).knife.accessors.wrapIterable(lastAccess.type);
                    return declaration.withType(this.declare(resolved, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(lastAccess.type));
                }
                return declaration.withType(this.declare(lastAccess.type, declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(lastAccess.type));
            }
            if (declaration.type().isPresent()) {
                return declaration.withType(this.resolveDeclared((Trees.TypeReference)declaration.type().get(), declaration.name())).withContainedType(ImmutableTrees.ResolvedType.of(this.resolveType((Trees.TypeReference)declaration.type().get(), false)));
            }
            throw new TypingException(String.format("Value should be typed %s%n\texpression '%s'", declaration.name(), expression));
        }

        private Trees.TypeReference resolveDeclared(Trees.TypeReference typeReference, Trees.Identifier name) {
            return this.declare(this.resolveType(typeReference, true), name);
        }

        private TypeMirror resolveType(Trees.TypeReference typeReference, boolean wrapIterable) {
            Preconditions.checkState((boolean)(typeReference instanceof ImmutableTrees.TypeDeclaration));
            ImmutableTrees.TypeDeclaration typeDeclaration = (ImmutableTrees.TypeDeclaration)typeReference;
            Trees.TypeIdentifier type = typeDeclaration.type();
            TypeMirror resolved = (TypeMirror)((TypeResolver)TypeResolver.this).knife.imports.get((Object)type.value());
            if (resolved == null) {
                throw new TypingException(String.format("Could not resolve declared type '%s'", typeDeclaration));
            }
            if (wrapIterable && typeDeclaration.kind() == Trees.TypeDeclaration.Kind.ITERABLE) {
                resolved = ((TypeResolver)TypeResolver.this).knife.accessors.wrapIterable(resolved);
            }
            return resolved;
        }
    }

    private static enum InferencePurpose {
        ASSIGN,
        ITERATE,
        COLLECT;

    }

    public static class TypingException
    extends RuntimeException {
        TypingException(String message) {
            super(message);
        }
    }
}

