/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.immutables.generator.Generator;
import org.immutables.generator.StaticEnvironment;
import org.immutables.generator.Templates;

public abstract class AbstractGenerator
extends AbstractProcessor {
    protected abstract void process();

    protected final ProcessingEnvironment processing() {
        return StaticEnvironment.processing();
    }

    protected final RoundEnvironment round() {
        return StaticEnvironment.round();
    }

    protected final Set<TypeElement> annotations() {
        return StaticEnvironment.annotations();
    }

    protected final void invoke(Templates.Invokable invokable) {
        Preconditions.checkArgument((invokable.arity() == 0 ? 1 : 0) != 0, (Object)"Entry template fragment should not have parameters");
        invokable.invoke(Templates.Invokation.initial(), new Object[0]);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SupportedSourceVersion sourceVersion = this.getClass().getAnnotation(SupportedSourceVersion.class);
        if (sourceVersion != null) {
            return sourceVersion.value();
        }
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Generator.SupportedAnnotations annotations = this.getClass().getAnnotation(Generator.SupportedAnnotations.class);
        if (annotations != null) {
            HashSet annotationNames = Sets.newHashSet();
            for (Class<? extends Annotation> c : annotations.value()) {
                annotationNames.add(c.getCanonicalName());
            }
            return ImmutableSet.copyOf((Collection)annotationNames);
        }
        return super.getSupportedAnnotationTypes();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        try {
            StaticEnvironment.init(annotations, round, this.processingEnv);
            if (!round.processingOver() && !round.errorRaised()) {
                this.process();
            }
            StaticEnvironment.shutdown();
        }
        catch (Exception ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getName() + " threw " + Throwables.getStackTraceAsString((Throwable)ex));
        }
        return false;
    }
}

