/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.Escaper;
import java.util.Map;

public final class StringLiterals {
    private static final Escaper ESCAPER = new ArrayBasedCharEscaper((Map)ImmutableMap.builder().put((Object)Character.valueOf('\b'), (Object)"\\b").put((Object)Character.valueOf('\"'), (Object)"\\\"").put((Object)Character.valueOf('\''), (Object)"\\'").put((Object)Character.valueOf('\\'), (Object)"\\\\").put((Object)Character.valueOf('\f'), (Object)"\\f").put((Object)Character.valueOf('\n'), (Object)"\\n").put((Object)Character.valueOf('\r'), (Object)"\\r").put((Object)Character.valueOf('\t'), (Object)"\\t").build(), ' ', '~'){
        final char[] hex = "0123456789abcdef".toCharArray();

        protected char[] escapeUnsafe(char c) {
            char[] result = new char[6];
            result[0] = 92;
            result[1] = 117;
            result[5] = this.hex[c & 0xF];
            c = (char)(c >>> 4);
            result[4] = this.hex[c & 0xF];
            c = (char)(c >>> 4);
            result[3] = this.hex[c & 0xF];
            c = (char)(c >>> 4);
            result[2] = this.hex[c & 0xF];
            return result;
        }
    };

    private StringLiterals() {
    }

    public static Escaper escaper() {
        return ESCAPER;
    }

    public static String toLiteral(char character) {
        return "'" + StringLiterals.escaper().escape("" + character) + "'";
    }

    public static String toLiteral(String string) {
        return "\"" + StringLiterals.escaper().escape(string) + "\"";
    }
}

