/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@NotThreadSafe
public final class TypeHierarchyCollector {
    private final List<DeclaredType> extendedClasses = Lists.newArrayList();
    private final Set<DeclaredType> implementedInterfaces = Sets.newLinkedHashSet();

    public void collectFrom(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.collectHierarchyMirrors(this.toDeclaredType(typeMirror), this.extendedClasses, this.implementedInterfaces);
        }
    }

    private DeclaredType toDeclaredType(TypeMirror typeMirror) {
        Preconditions.checkArgument((typeMirror.getKind() == TypeKind.DECLARED ? 1 : 0) != 0);
        return (DeclaredType)typeMirror;
    }

    public ImmutableList<DeclaredType> extendedClasses() {
        return ImmutableList.copyOf(this.extendedClasses);
    }

    public ImmutableSet<DeclaredType> implementedInterfaces() {
        return ImmutableSet.copyOf(this.implementedInterfaces);
    }

    public ImmutableList<String> extendedClassNames() {
        return FluentIterable.from(this.extendedClasses).transform((Function)ToNameOfTypeElement.FUNCTION).toList();
    }

    public ImmutableSet<String> implementedInterfaceNames() {
        return FluentIterable.from(this.implementedInterfaces).transform((Function)ToNameOfTypeElement.FUNCTION).toSet();
    }

    private void collectHierarchyMirrors(DeclaredType topClass, List<DeclaredType> extendedClasses, Set<DeclaredType> implementedInterfaces) {
        if (topClass.getKind() != TypeKind.DECLARED || topClass.toString().equals(Object.class.getName())) {
            return;
        }
        this.collectInterfacesMirrors(topClass, implementedInterfaces);
        TypeElement e = this.toTypeElement(topClass);
        TypeMirror superclassMirror = e.getSuperclass();
        if (superclassMirror.getKind() != TypeKind.NONE) {
            DeclaredType superclass = this.toDeclaredType(superclassMirror);
            extendedClasses.add(superclass);
            this.collectHierarchyMirrors(superclass, extendedClasses, implementedInterfaces);
        }
        for (TypeMirror typeMirror : e.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            this.collectInterfacesMirrors(this.toDeclaredType(typeMirror), implementedInterfaces);
        }
    }

    private void collectInterfacesMirrors(DeclaredType topClass, Set<DeclaredType> implementedInterfaces) {
        TypeElement e = this.toTypeElement(topClass);
        if (e.getKind().isInterface()) {
            implementedInterfaces.add(topClass);
            for (TypeMirror typeMirror : e.getInterfaces()) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                this.collectInterfacesMirrors(this.toDeclaredType(typeMirror), implementedInterfaces);
            }
        }
    }

    private TypeElement toTypeElement(DeclaredType input) {
        return ToDeclaredTypeElement.FUNCTION.apply(input);
    }

    private static enum ToNameOfTypeElement implements Function<DeclaredType, String>
    {
        FUNCTION;


        public String apply(DeclaredType input) {
            return ToDeclaredTypeElement.FUNCTION.apply(input).getQualifiedName().toString();
        }
    }

    private static enum ToDeclaredTypeElement implements Function<DeclaredType, TypeElement>
    {
        FUNCTION;


        public TypeElement apply(DeclaredType input) {
            return (TypeElement)input.asElement();
        }
    }
}

