/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository.internal;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.bson.AbstractBsonReader;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.mongo.repository.internal.BsonReader;
import org.immutables.mongo.repository.internal.BsonWriter;

public final class BsonEncoding {
    private BsonEncoding() {
    }

    public static <T> CodecRegistry registryFor(final Class<T> type, final TypeAdapter<T> adapter) {
        return new CodecRegistry(){

            public <X> Codec<X> get(Class<X> clazz) {
                if (type.isAssignableFrom(clazz)) {
                    return BsonEncoding.codecFor(type, adapter);
                }
                throw new CodecConfigurationException(String.format("Type %s not supported by this registry", type.getName()));
            }
        };
    }

    public static <T> Codec<T> codecFor(final Class<T> type, final TypeAdapter<T> adapter) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(adapter, (Object)"adapter");
        return new Codec<T>(){
            final Decoder<T> decoder;
            final Encoder<T> encoder;
            {
                this.decoder = BsonEncoding.decoderFor(type, adapter);
                this.encoder = BsonEncoding.encoderFor(type, adapter);
            }

            public T decode(org.bson.BsonReader reader, DecoderContext context) {
                return this.decoder.decode(reader, context);
            }

            public void encode(org.bson.BsonWriter writer, T value, EncoderContext context) {
                this.encoder.encode(writer, value, context);
            }

            public Class<T> getEncoderClass() {
                return this.encoder.getEncoderClass();
            }
        };
    }

    public static <T> Decoder<T> decoderFor(final Class<T> type, final TypeAdapter<T> adapter) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(adapter, (Object)"adapter");
        return new Decoder<T>(){

            public T decode(org.bson.BsonReader reader, DecoderContext decoderContext) {
                if (!(reader instanceof AbstractBsonReader)) {
                    throw new UnsupportedOperationException(String.format("Only readers of type %s supported. Yours is %s", AbstractBsonReader.class.getName(), reader.getClass().getName()));
                }
                try {
                    return adapter.read((JsonReader)new BsonReader((AbstractBsonReader)reader));
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Couldn't encode %s", type), e);
                }
            }
        };
    }

    public static <T> Encoder<T> encoderFor(final Class<T> type, final TypeAdapter<T> adapter) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(adapter, (Object)"adapter");
        return new Encoder<T>(){

            public void encode(org.bson.BsonWriter writer, T value, EncoderContext encoderContext) {
                try {
                    adapter.write((JsonWriter)new BsonWriter(writer), value);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Couldn't write value of class %s: %s", type.getName(), value), e);
                }
            }

            public Class<T> getEncoderClass() {
                return type;
            }
        };
    }
}

