/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository.internal;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.bson.types.Decimal128;

@NotThreadSafe
public class BsonReader
extends JsonReader {
    private static final Reader UNREADABLE_READER = new Reader(){

        @Override
        public int read(char[] buffer, int offset, int count) throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private final AbstractBsonReader delegate;

    BsonReader(AbstractBsonReader delegate) {
        super(UNREADABLE_READER);
        this.delegate = (AbstractBsonReader)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    private void advance() {
        this.delegate.readBsonType();
    }

    public void beginArray() throws IOException {
        this.delegate.readStartArray();
    }

    public void endArray() throws IOException {
        this.delegate.readEndArray();
    }

    public void beginObject() throws IOException {
        this.delegate.readStartDocument();
    }

    public void endObject() throws IOException {
        this.delegate.readEndDocument();
    }

    public boolean hasNext() throws IOException {
        if (!this.hasMoreElements()) {
            return false;
        }
        this.advance();
        return this.hasMoreElements();
    }

    private boolean hasMoreElements() {
        switch (this.state()) {
            case END_OF_DOCUMENT: 
            case END_OF_ARRAY: 
            case DONE: {
                return false;
            }
        }
        return true;
    }

    public JsonToken peek() throws IOException {
        switch (this.state()) {
            case INITIAL: 
            case SCOPE_DOCUMENT: 
            case TYPE: {
                this.advance();
                return BsonReader.toGsonToken(this.delegate.getCurrentBsonType());
            }
            case NAME: {
                return JsonToken.NAME;
            }
            case END_OF_DOCUMENT: {
                return JsonToken.END_OBJECT;
            }
            case END_OF_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case DONE: {
                return JsonToken.END_DOCUMENT;
            }
            case VALUE: {
                return BsonReader.toGsonToken(this.delegate.getCurrentBsonType());
            }
        }
        throw new IllegalStateException("Unexpected state: " + this.state() + " currentType:" + this.delegate.getCurrentBsonType());
    }

    private AbstractBsonReader.State state() {
        return this.delegate.getState();
    }

    private static JsonToken toGsonToken(BsonType type) {
        switch (type) {
            case END_OF_DOCUMENT: {
                return JsonToken.END_DOCUMENT;
            }
            case DOCUMENT: {
                return JsonToken.BEGIN_OBJECT;
            }
            case ARRAY: {
                return JsonToken.BEGIN_ARRAY;
            }
            case BOOLEAN: {
                return JsonToken.BOOLEAN;
            }
            case STRING: 
            case SYMBOL: 
            case OBJECT_ID: 
            case BINARY: 
            case REGULAR_EXPRESSION: {
                return JsonToken.STRING;
            }
            case DATE_TIME: 
            case DOUBLE: 
            case INT32: 
            case INT64: 
            case TIMESTAMP: 
            case DECIMAL128: {
                return JsonToken.NUMBER;
            }
            case NULL: {
                return JsonToken.NULL;
            }
        }
        return JsonToken.NULL;
    }

    public String nextName() throws IOException {
        return this.delegate.readName();
    }

    public String nextString() throws IOException {
        return this.scalarToString();
    }

    private String scalarToString() {
        switch (this.delegate.getCurrentBsonType()) {
            case STRING: {
                return this.delegate.readString();
            }
            case SYMBOL: {
                return this.delegate.readSymbol();
            }
            case INT32: {
                return Integer.toString(this.delegate.readInt32());
            }
            case INT64: {
                return Long.toString(this.delegate.readInt64());
            }
            case DOUBLE: {
                return Double.toString(this.delegate.readDouble());
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().toString();
            }
        }
        throw new IllegalStateException("Unknown scalar type to be converted to string: " + this.delegate.getCurrentBsonType());
    }

    public boolean nextBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public void nextNull() throws IOException {
        this.delegate.readNull();
    }

    public double nextDouble() throws IOException {
        switch (this.delegate.getCurrentBsonType()) {
            case INT32: {
                return this.delegate.readInt32();
            }
            case INT64: {
                return this.delegate.readInt64();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().doubleValue();
            }
        }
        return this.delegate.readDouble();
    }

    public long nextLong() throws IOException {
        switch (this.delegate.getCurrentBsonType()) {
            case DOUBLE: {
                return (long)this.delegate.readDouble();
            }
            case INT32: {
                return this.delegate.readInt32();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().longValueExact();
            }
        }
        return this.delegate.readInt64();
    }

    public int nextInt() throws IOException {
        switch (this.delegate.getCurrentBsonType()) {
            case DOUBLE: {
                return (int)this.delegate.readDouble();
            }
            case INT64: {
                return (int)this.delegate.readInt64();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().intValueExact();
            }
        }
        return this.delegate.readInt32();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void skipValue() throws IOException {
        this.delegate.skipValue();
    }

    public Pattern nextPattern() {
        return Pattern.compile(this.delegate.readRegularExpression().getPattern());
    }

    public long nextTimeInstant() {
        return this.delegate.readDateTime();
    }

    public Decimal128 nextDecimal() {
        return this.delegate.readDecimal128();
    }

    public byte[] nextObjectId() {
        return this.delegate.readObjectId().toByteArray();
    }

    public byte[] nextBinary() {
        return this.delegate.readBinaryData().getData();
    }
}

