/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Constraints {
    private static final CharMatcher NON_LITERAL_REGEX_CHARACTERS = CharMatcher.anyOf((CharSequence)"\\^$[]().*+").precomputed();
    private static final Constraint NIL = new Constraint(){

        @Override
        public final <V extends ConstraintVisitor<V>> V accept(V visitor) {
            return visitor;
        }

        @Override
        public boolean isNil() {
            return true;
        }
    };

    private Constraints() {
    }

    public static Constraint nilConstraint() {
        return NIL;
    }

    public static Pattern prefixPatternOf(String prefix) {
        Preconditions.checkArgument((boolean)NON_LITERAL_REGEX_CHARACTERS.matchesNoneOf((CharSequence)prefix), (String)"Prefix [%s] should be literal, otherwise use constructed regex Pattern", (Object[])new Object[]{prefix});
        return Pattern.compile("^" + prefix);
    }

    private static abstract class ConsConstraint
    extends Constraint {
        final Constraint tail;
        final String name;
        final boolean negate;
        @Nullable
        final Object value;

        ConsConstraint(Constraint tail, String name, boolean negate, @Nullable Object value) {
            this.tail = (Constraint)Preconditions.checkNotNull((Object)tail);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.value = value;
            this.negate = negate;
        }

        @Override
        public final <V extends ConstraintVisitor<V>> V accept(V visitor) {
            return this.dispatch(this.tail.accept(visitor));
        }

        abstract <V extends ConstraintVisitor<V>> V dispatch(V var1);
    }

    public static abstract class Constraint
    implements ConstraintVisitor<Constraint>,
    ConstraintHost {
        public boolean isNil() {
            return false;
        }

        @Override
        public Constraint in(String name, boolean negate, Iterable<?> values) {
            return new InConstraint(this, name, negate, values);
        }

        @Override
        public Constraint equal(String name, boolean negate, @Nullable Object value) {
            return new EqualToConstraint(this, name, negate, value);
        }

        @Override
        public Constraint range(String name, boolean negate, Range<?> range) {
            return new RangeConstraint(this, name, negate, range);
        }

        @Override
        public Constraint size(String name, boolean negate, int size) {
            return new SizeConstraint(this, name, negate, size);
        }

        @Override
        public Constraint present(String name, boolean negate) {
            return new PresenseConstraint(this, name, negate);
        }

        @Override
        public Constraint match(String name, boolean negate, Pattern pattern) {
            return new PatternConstraint(this, name, negate, pattern);
        }

        @Override
        public Constraint disjunction() {
            return new DisjunctionConstraint(this);
        }

        @Override
        public Constraint nested(String name, ConstraintHost constraints) {
            return new NestedConstraint(this, name, constraints);
        }
    }

    private static final class DisjunctionConstraint
    extends Constraint {
        private final Constraint tail;

        DisjunctionConstraint(Constraint tail) {
            this.tail = tail;
        }

        @Override
        public <V extends ConstraintVisitor<V>> V accept(V visitor) {
            return this.tail.accept(visitor).disjunction();
        }
    }

    private static final class NestedConstraint
    extends ConsConstraint {
        NestedConstraint(Constraint tail, String name, ConstraintHost value) {
            super(tail, name, false, value);
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.nested(this.name, (ConstraintHost)this.value);
        }
    }

    private static final class PresenseConstraint
    extends ConsConstraint {
        PresenseConstraint(Constraint tail, String name, boolean negate) {
            super(tail, name, negate, null);
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.present(this.name, this.negate);
        }
    }

    private static final class SizeConstraint
    extends ConsConstraint {
        SizeConstraint(Constraint tail, String name, boolean negate, int value) {
            super(tail, name, negate, value);
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.size(this.name, this.negate, (Integer)this.value);
        }
    }

    private static final class RangeConstraint
    extends ConsConstraint {
        RangeConstraint(Constraint tail, String name, boolean negate, Range<?> value) {
            super(tail, name, negate, Preconditions.checkNotNull(value));
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.range(this.name, this.negate, (Range)this.value);
        }
    }

    private static final class EqualToConstraint
    extends ConsConstraint {
        EqualToConstraint(Constraint tail, String name, boolean negate, Object value) {
            super(tail, name, negate, value);
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.equal(this.name, this.negate, this.value);
        }
    }

    private static final class InConstraint
    extends ConsConstraint {
        InConstraint(Constraint tail, String name, boolean negate, Iterable<?> value) {
            super(tail, name, negate, ImmutableSet.copyOf(value));
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.in(this.name, this.negate, (Iterable)this.value);
        }
    }

    private static final class PatternConstraint
    extends ConsConstraint {
        PatternConstraint(Constraint tail, String name, boolean negate, Pattern pattern) {
            super(tail, name, negate, Preconditions.checkNotNull((Object)pattern));
        }

        @Override
        <V extends ConstraintVisitor<V>> V dispatch(V visitor) {
            return visitor.match(this.name, this.negate, (Pattern)this.value);
        }
    }

    public static interface ConstraintVisitor<V extends ConstraintVisitor<V>> {
        public V in(String var1, boolean var2, Iterable<?> var3);

        public V equal(String var1, boolean var2, @Nullable Object var3);

        public V range(String var1, boolean var2, Range<?> var3);

        public V size(String var1, boolean var2, int var3);

        public V present(String var1, boolean var2);

        public V match(String var1, boolean var2, Pattern var3);

        public V nested(String var1, ConstraintHost var2);

        public V disjunction();
    }

    public static interface ConstraintHost {
        public <V extends ConstraintVisitor<V>> V accept(V var1);
    }
}

