/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository.internal;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.gson.TypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.immutables.mongo.repository.internal.BsonEncoding;
import org.immutables.mongo.repository.internal.Constraints;

public final class Support {
    private Support() {
    }

    public static Bson convertToBson(Constraints.ConstraintHost fields) {
        if (fields instanceof JsonQuery) {
            return Document.parse((String)((JsonQuery)fields).value);
        }
        return fields.accept(new ConstraintBuilder("")).asDocument();
    }

    public static String stringify(Constraints.ConstraintHost constraints) {
        if (constraints instanceof JsonQuery) {
            return ((JsonQuery)constraints).value;
        }
        return Support.convertToBson(constraints).toString();
    }

    public static Constraints.ConstraintHost jsonQuery(String query) {
        return new JsonQuery(query);
    }

    public static <T> Object writable(TypeAdapter<T> adapter, T value) {
        return new Adapted<T>(adapter, value);
    }

    public static Object writable(Object value) {
        return value;
    }

    public static <T extends Comparable<? super T>> Range<Comparable<Object>> writable(TypeAdapter<T> adapter, Range<T> range) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return Range.range((Comparable)((Comparable)Support.writable(adapter, range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)Support.writable(adapter, range.upperEndpoint())), (BoundType)range.upperBoundType());
        }
        if (range.hasLowerBound()) {
            return Range.downTo((Comparable)((Comparable)Support.writable(adapter, range.lowerEndpoint())), (BoundType)range.lowerBoundType());
        }
        if (range.hasUpperBound()) {
            return Range.upTo((Comparable)((Comparable)Support.writable(adapter, range.upperEndpoint())), (BoundType)range.upperBoundType());
        }
        throw new AssertionError();
    }

    public static <T extends Comparable<? super T>> Range<Comparable<Object>> writable(Range<T> range) {
        return (Range)Support.writable(range);
    }

    public static Object unwrapBsonable(Object value) {
        if (value instanceof Document) {
            for (Map.Entry entry : ((Document)value).entrySet()) {
                entry.setValue(Support.unwrapBsonable(entry.getValue()));
            }
            return value;
        }
        if (value instanceof Iterable) {
            return ImmutableList.copyOf(Support.unwrapBsonableIterable((Iterable)value));
        }
        if (value instanceof Constraints.ConstraintHost) {
            return Support.convertToBson((Constraints.ConstraintHost)value);
        }
        if (value == null || value instanceof Number || value instanceof Boolean || value instanceof String) {
            return value;
        }
        if (value instanceof Adapted) {
            return ((Adapted)value).toBson();
        }
        return String.valueOf(value);
    }

    static Iterable<?> unwrapBsonableIterable(Iterable<?> values) {
        return Iterables.transform(values, (Function)new Function<Object, Object>(){

            public Object apply(Object input) {
                return Support.unwrapBsonable(input);
            }
        });
    }

    public static Object emptyBsonObject() {
        return new Document();
    }

    public static Object bsonObjectAttribute(String name, Object value) {
        return new Document(name, value);
    }

    static final class Adapted<T>
    implements Comparable<Adapted<T>> {
        final T value;
        final TypeAdapter<T> adapter;

        Adapted(TypeAdapter<T> adapter, T value) {
            this.adapter = adapter;
            this.value = value;
        }

        BsonValue toBson() {
            Encoder<?> encoder = BsonEncoding.encoderFor(this.value.getClass(), this.adapter);
            BsonDocument bson = new BsonDocument();
            BsonDocumentWriter writer = new BsonDocumentWriter(bson);
            writer.writeStartDocument();
            writer.writeName("$");
            encoder.encode((BsonWriter)writer, this.value, EncoderContext.builder().build());
            writer.writeEndDocument();
            writer.flush();
            return bson.get((Object)"$");
        }

        @Override
        public int compareTo(Adapted<T> o) {
            return ((Comparable)this.value).compareTo(o.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue(this.value).toString();
        }
    }

    private static class JsonQuery
    implements Constraints.ConstraintHost {
        private final String value;

        JsonQuery(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        public String toString() {
            return this.value;
        }

        @Override
        public <V extends Constraints.ConstraintVisitor<V>> V accept(V visitor) {
            throw new UnsupportedOperationException("Satisfied ConstraintSupport.ConstraintHost only for technical reasons and don't implements accept");
        }
    }

    @NotThreadSafe
    public static class ConstraintBuilder
    implements Constraints.ConstraintVisitor<ConstraintBuilder> {
        private final String keyPrefix;
        private Document constraints;
        private List<Document> disjunction;
        private static final String[][] comparisonOperators = new String[][]{{"$lt", "$lte"}, {"$gt", "$gte"}};

        ConstraintBuilder(String keyPrefix) {
            this(keyPrefix, new Document());
        }

        private ConstraintBuilder(String keyPrefix, Document constraints) {
            this.keyPrefix = keyPrefix;
            this.constraints = constraints;
        }

        private ConstraintBuilder newBuilderForKey(String key) {
            return new ConstraintBuilder(this.keyPrefix + "." + key);
        }

        private void addContraint(String name, Object constraint) {
            String path = this.keyPrefix.concat(name);
            Object existingConstraint = this.constraints.get((Object)path);
            if (existingConstraint != null) {
                this.constraints.put(path, this.mergeConstraints(path, constraint, existingConstraint));
            } else {
                this.constraints.put(path, constraint);
            }
        }

        @Override
        public ConstraintBuilder in(String name, boolean negate, Iterable<?> values) {
            this.addContraint(name, new Document(negate ? "$nin" : "$in", (Object)ImmutableSet.copyOf(Support.unwrapBsonableIterable(values))));
            return this;
        }

        @Override
        public ConstraintBuilder equal(String name, boolean negate, @Nullable Object value) {
            this.addContraint(name, negate ? new Document("$ne", Support.unwrapBsonable(value)) : Support.unwrapBsonable(value));
            return this;
        }

        @Override
        public ConstraintBuilder range(String name, boolean negate, Range<?> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                if (range.lowerEndpoint().equals(range.upperEndpoint()) && !range.isEmpty()) {
                    this.equal(name, negate, range.lowerEndpoint());
                } else {
                    Document rangeObject = new Document().append(this.boundToOperator(true, false, range.lowerBoundType()), Support.unwrapBsonable(range.lowerEndpoint())).append(this.boundToOperator(false, false, range.upperBoundType()), Support.unwrapBsonable(range.upperEndpoint()));
                    this.addContraint(name, this.negateConstraint(negate, rangeObject));
                }
            } else if (range.hasLowerBound()) {
                Document rangeObject = new Document(this.boundToOperator(true, negate, range.lowerBoundType()), Support.unwrapBsonable(range.lowerEndpoint()));
                this.addContraint(name, rangeObject);
            } else if (range.hasUpperBound()) {
                Document rangeObject = new Document(this.boundToOperator(false, negate, range.upperBoundType()), Support.unwrapBsonable(range.upperEndpoint()));
                this.addContraint(name, rangeObject);
            }
            return this;
        }

        private String boundToOperator(boolean lower, boolean negate, BoundType lowerBoundType) {
            boolean closedBound = lowerBoundType == BoundType.CLOSED;
            return comparisonOperators[lower ^ negate ? 1 : 0][closedBound ^ negate ? 1 : 0];
        }

        private Object negateConstraint(boolean negate, Object constraint) {
            return negate ? new Document("$not", constraint) : constraint;
        }

        public Document asDocument() {
            if (this.disjunction != null) {
                return new Document("$or", this.disjunction);
            }
            return this.constraints;
        }

        @Override
        public ConstraintBuilder size(String name, boolean negate, int size) {
            this.addContraint(name, this.negateConstraint(negate, new Document("$size", (Object)size)));
            return this;
        }

        @Override
        public ConstraintBuilder present(String name, boolean negate) {
            this.addContraint(name, new Document("$exists", (Object)(!negate ? 1 : 0)));
            return this;
        }

        @Override
        public ConstraintBuilder match(String name, boolean negate, Pattern pattern) {
            this.addContraint(name, this.negateConstraint(negate, pattern));
            return this;
        }

        @Override
        public ConstraintBuilder nested(String name, Constraints.ConstraintHost nestedConstraints) {
            this.constraints.putAll((Map)nestedConstraints.accept(this.newBuilderForKey(name)).asDocument());
            return this;
        }

        @Override
        public ConstraintBuilder disjunction() {
            if (this.disjunction == null) {
                this.disjunction = new ArrayList<Document>(4);
                this.disjunction.add(this.constraints);
            }
            this.constraints = new Document();
            this.disjunction.add(this.constraints);
            return this;
        }

        private Object mergeConstraints(String path, Object constraint, Object existingConstraint) {
            Preconditions.checkState((boolean)false, (String)"Cannot add another contraint on '%s': %s. Existing: %s", (Object[])new Object[]{path, constraint, existingConstraint});
            return constraint;
        }
    }
}

