/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.types;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.immutables.mongo.repository.internal.BsonReader;
import org.immutables.mongo.repository.internal.BsonWriter;
import org.immutables.mongo.types.Binary;
import org.immutables.mongo.types.Id;
import org.immutables.mongo.types.TimeInstant;

public final class TypeAdapters
implements TypeAdapterFactory {
    private static final TypeToken<Id> ID_TYPE_TOKEN = TypeToken.get(Id.class);
    private static final TypeToken<TimeInstant> TIME_INSTANT_TYPE_TOKEN = TypeToken.get(TimeInstant.class);
    private static final TypeToken<Binary> BINARY_TYPE_TOKEN = TypeToken.get(Binary.class);
    private static final TypeToken<Pattern> PATTERN_TYPE_TOKEN = TypeToken.get(Pattern.class);
    private static final TypeToken<Decimal128> DECIMAL128_TYPE_TOKEN = TypeToken.get(Decimal128.class);
    private static final TypeAdapter<TimeInstant> WRAPPED_TIME_INSTANT_ADAPTER = new TypeAdapter<TimeInstant>(){

        public void write(JsonWriter out, TimeInstant value) throws IOException {
            if (out instanceof BsonWriter) {
                TIME_INSTANT_ADAPTER.write(out, (Object)value.value());
            } else {
                out.value(value.toString());
            }
        }

        public TimeInstant read(JsonReader in) throws IOException {
            return TimeInstant.of((Long)TIME_INSTANT_ADAPTER.read(in));
        }

        public String toString() {
            return "TypeAdapters.(TimeInstant)";
        }
    };
    private static final TypeAdapter<Id> WRAPPED_ID_ADAPTER = new TypeAdapter<Id>(){

        public void write(JsonWriter out, Id value) throws IOException {
            if (out instanceof BsonWriter) {
                OBJECT_ID_ADAPTER.write(out, (Object)value.value());
            } else {
                out.value(value.toString());
            }
        }

        public Id read(JsonReader in) throws IOException {
            return Id.from((byte[])OBJECT_ID_ADAPTER.read(in));
        }

        public String toString() {
            return "TypeAdapters.(Id)";
        }
    };
    private static final TypeAdapter<Binary> WRAPPED_BINARY_ADAPTER = new TypeAdapter<Binary>(){

        public void write(JsonWriter out, Binary value) throws IOException {
            if (out instanceof BsonWriter) {
                BINARY_ADAPTER.write(out, (Object)value.value());
            } else {
                out.value(value.toString());
            }
        }

        public Binary read(JsonReader in) throws IOException {
            return Binary.create((byte[])BINARY_ADAPTER.read(in));
        }

        public String toString() {
            return "TypeAdapters.(Binary)";
        }
    };
    private static final TypeAdapter<Pattern> PATTERN_ADAPTER = new TypeAdapter<Pattern>(){

        public void write(JsonWriter out, Pattern value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else if (out instanceof BsonWriter) {
                ((BsonWriter)out).value(value);
            } else {
                out.value(value.toString());
            }
        }

        public Pattern read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in instanceof BsonReader) {
                return ((BsonReader)in).nextPattern();
            }
            return Pattern.compile(in.nextString());
        }

        public String toString() {
            return "TypeAdapters.(Pattern)";
        }
    };
    private static final TypeAdapter<Decimal128> DECIMAL128_ADAPTER = new TypeAdapter<Decimal128>(){

        public void write(JsonWriter out, Decimal128 value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else if (out instanceof BsonWriter) {
                ((BsonWriter)out).value(value);
            } else {
                out.value(value.toString());
            }
        }

        public Decimal128 read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in instanceof BsonReader) {
                return ((BsonReader)in).nextDecimal();
            }
            return Decimal128.parse((String)in.nextString());
        }

        public String toString() {
            return "TypeAdapters.(Decimal128)";
        }
    };
    private static final TypeAdapter<BigDecimal> DECIMAL_ADAPTER = new TypeAdapter<BigDecimal>(){

        public void write(JsonWriter out, BigDecimal value) throws IOException {
            Preconditions.checkArgument((boolean)(out instanceof BsonWriter), (Object)"Should be BsonWriter, not some other JsonWriter");
            Preconditions.checkNotNull((Object)value, (Object)"Value could not be null, delegate to #nullSafe() adapter if needed");
            ((BsonWriter)out).value(value);
        }

        public BigDecimal read(JsonReader in) throws IOException {
            Preconditions.checkArgument((boolean)(in instanceof BsonReader), (Object)"Should be BsonReader, not some other JsonReader");
            return ((BsonReader)in).nextDecimal().bigDecimalValue();
        }

        public String toString() {
            return "TypeAdapters.decimalAdapter()";
        }
    };
    private static final TypeAdapter<Long> TIME_INSTANT_ADAPTER = new TypeAdapter<Long>(){

        public void write(JsonWriter out, Long value) throws IOException {
            Preconditions.checkArgument((boolean)(out instanceof BsonWriter), (Object)"Should be BsonWriter, not some other JsonWriter");
            Preconditions.checkNotNull((Object)value, (Object)"Value could not be null, delegate to #nullSafe() adapter if needed");
            ((BsonWriter)out).valueTimeInstant(value);
        }

        public Long read(JsonReader in) throws IOException {
            Preconditions.checkArgument((boolean)(in instanceof BsonReader), (Object)"Should be BsonReader, not some other JsonReader");
            return ((BsonReader)in).nextTimeInstant();
        }

        public String toString() {
            return "TypeAdapters.timeInstantAdapter()";
        }
    };
    private static final TypeAdapter<byte[]> OBJECT_ID_ADAPTER = new TypeAdapter<byte[]>(){

        public void write(JsonWriter out, byte[] value) throws IOException {
            Preconditions.checkArgument((boolean)(out instanceof BsonWriter), (Object)"Should be BsonWriter, not some other JsonWriter");
            Preconditions.checkNotNull((Object)value, (Object)"Value could not be null, delegate to #nullSafe() adapter if needed");
            ((BsonWriter)out).valueObjectId(value);
        }

        public byte[] read(JsonReader in) throws IOException {
            Preconditions.checkArgument((boolean)(in instanceof BsonReader), (Object)"Should be BsonReader, not some other JsonReader");
            return ((BsonReader)in).nextObjectId();
        }

        public String toString() {
            return "TypeAdapters.objectIdAdapter()";
        }
    };
    private static final TypeAdapter<byte[]> BINARY_ADAPTER = new TypeAdapter<byte[]>(){

        public void write(JsonWriter out, byte[] value) throws IOException {
            Preconditions.checkArgument((boolean)(out instanceof BsonWriter), (Object)"Should be BsonWriter, not some other JsonWriter");
            Preconditions.checkNotNull((Object)value, (Object)"Value could not be null, delegate to #nullSafe() adapter if needed");
            ((BsonWriter)out).valueBinary(value);
        }

        public byte[] read(JsonReader in) throws IOException {
            Preconditions.checkArgument((boolean)(in instanceof BsonReader), (Object)"Should be BsonReader, not some other JsonReader");
            return ((BsonReader)in).nextBinary();
        }

        public String toString() {
            return "TypeAdapters.binaryAdapter()";
        }
    };

    @Nullable
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ID_TYPE_TOKEN.equals(type)) {
            return WRAPPED_ID_ADAPTER;
        }
        if (TIME_INSTANT_TYPE_TOKEN.equals(type)) {
            return WRAPPED_TIME_INSTANT_ADAPTER;
        }
        if (BINARY_TYPE_TOKEN.equals(type)) {
            return WRAPPED_BINARY_ADAPTER;
        }
        if (PATTERN_TYPE_TOKEN.equals(type)) {
            return PATTERN_ADAPTER;
        }
        if (DECIMAL128_TYPE_TOKEN.equals(type)) {
            return DECIMAL128_ADAPTER;
        }
        return null;
    }

    public static TypeAdapter<Long> timeInstantAdapter() {
        return TIME_INSTANT_ADAPTER;
    }

    public static TypeAdapter<byte[]> objectIdAdapter() {
        return OBJECT_ID_ADAPTER;
    }

    public static TypeAdapter<byte[]> binaryAdapter() {
        return BINARY_ADAPTER;
    }

    public static TypeAdapter<BigDecimal> decimalAdapter() {
        return DECIMAL_ADAPTER;
    }
}

