/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.ordinal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import org.immutables.check.Checkers;
import org.immutables.ordinal.Domain;
import org.immutables.ordinal.ImmutableOrdinalSet;
import org.immutables.ordinal.Ord;
import org.immutables.ordinal.OrdinalValue;
import org.junit.Test;

public class OrdinalSetTest {
    Domain da = new Domain();
    Domain db = new Domain();
    Ord a0 = this.da.get(0);
    Ord a1 = this.da.get(1);
    Ord b0 = this.db.get(0);
    Ord b1 = this.db.get(1);

    @Test
    public void emptySet() {
        Checkers.check((boolean)ImmutableOrdinalSet.of().isEmpty());
        Checkers.check((Object)ImmutableOrdinalSet.of().size()).is((Object)0);
        Checkers.check((Iterable)ImmutableOrdinalSet.of()).same((Object)ImmutableOrdinalSet.of());
        Checkers.check((Iterable)ImmutableOrdinalSet.of()).asString().notEmpty();
    }

    @Test
    public void builder() {
        Checkers.check((Iterable)ImmutableOrdinalSet.builder().add((OrdinalValue)this.a0).addAll((Iterable)ImmutableList.of((Object)this.a1)).build()).is((Object)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[]{this.a1}));
    }

    @Test
    public void singletonSet() {
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).isEmpty() ? 1 : 0) != 0);
        Checkers.check((Object)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).size()).is((Object)1);
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])).asString().notEmpty();
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])).isOf((Object[])new Ord[]{this.a0});
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])).has((Object)this.a0);
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).contains((Object)this.a0));
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).contains((Object)this.a1) ? 1 : 0) != 0);
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])).not((Object)ImmutableOrdinalSet.of((OrdinalValue)this.da.get(4), (OrdinalValue[])new Ord[0]));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).containsAll((Collection)ImmutableSet.of((Object)this.a0)));
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0])).not().hasAll((Iterable)ImmutableSet.of((Object)this.da.get(5)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void differentDomainInRegularSet() {
        ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[]{this.b0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void duplicateInRegularSet() {
        ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[]{this.a0});
    }

    @Test
    public void copyOfIterable() {
        ImmutableOrdinalSet s1 = ImmutableOrdinalSet.of((OrdinalValue)this.a1, (OrdinalValue[])new Ord[0]);
        Checkers.check((Iterable)ImmutableOrdinalSet.copyOf((Iterable)s1)).same((Object)s1);
        Checkers.check((Iterable)ImmutableOrdinalSet.copyOf(Arrays.asList(new Ord[0]))).same((Object)ImmutableOrdinalSet.of());
        Checkers.check((Iterable)ImmutableOrdinalSet.copyOf(Arrays.asList(this.b0))).isOf((Object[])new Ord[]{this.b0});
        Checkers.check((Iterable)ImmutableOrdinalSet.copyOf(Arrays.asList(this.a0, this.a1))).isOf((Object[])new Ord[]{this.a0, this.a1});
    }

    @Test
    public void regularSetBasic() {
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[]{this.a1}).isEmpty() ? 1 : 0) != 0);
        Checkers.check((Object)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).size()).is((Object)2);
    }

    @Test
    public void incrementCountersSmall() {
        int[] counters = new int[this.da.length()];
        ImmutableOrdinalSet.of((OrdinalValue)this.a1, (OrdinalValue[])new Ord[0]).incrementCounters(counters);
        ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[0]).incrementCounters(counters);
        ImmutableOrdinalSet.of((OrdinalValue)this.a1, (OrdinalValue[])new Ord[0]).incrementCounters(counters);
        ImmutableOrdinalSet.of().incrementCounters(counters);
        Checkers.check((int[])counters).isOf((Object[])new Integer[]{1, 2});
    }

    @Test
    public void incrementCountersLarge() {
        Domain dc = new Domain();
        Ord[] cs = new Ord[120];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = dc.get(i);
        }
        int[] counters = new int[dc.length()];
        ImmutableOrdinalSet.of((OrdinalValue)cs[62], (OrdinalValue[])new Ord[]{cs[119], cs[98]}).incrementCounters(counters);
        ImmutableOrdinalSet.of((OrdinalValue)cs[119], (OrdinalValue[])new Ord[]{cs[1]}).incrementCounters(counters);
        Checkers.check((int[])new int[]{counters[0], counters[1], counters[62], counters[98], counters[119]}).isOf((Object[])new Integer[]{0, 1, 1, 1, 2});
    }

    @Test
    public void setContains() {
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[0])));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAny((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[0])));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b1, (OrdinalValue[])new Ord[0]).containsAny((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAny((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})));
        Checkers.check((!ImmutableOrdinalSet.of().containsAny((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})) ? 1 : 0) != 0);
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.a0, (OrdinalValue[])new Ord[]{this.a1})) ? 1 : 0) != 0);
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.db.get(120), (OrdinalValue[])new Ord[]{this.db.get(130)})) ? 1 : 0) != 0);
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.db.get(30), (OrdinalValue[])new Ord[]{this.db.get(70)}).containsAll((Collection)ImmutableOrdinalSet.of((OrdinalValue)this.db.get(30), (OrdinalValue[])new Ord[]{this.db.get(60)})) ? 1 : 0) != 0);
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})).hasAll((Object[])new Ord[]{this.b0});
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})).not().hasAll((Object[])new Ord[]{this.a0, this.a1});
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})).not().hasAll((Object[])new Ord[]{this.b0, this.a1});
        Checkers.check((Iterable)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1})).not().has((Object)this.a1);
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableSet.of()));
        Checkers.check((boolean)ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableSet.of((Object)this.b0, (Object)this.b1)));
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).contains((Object)this.a1) ? 1 : 0) != 0);
        Checkers.check((!ImmutableOrdinalSet.of((OrdinalValue)this.b0, (OrdinalValue[])new Ord[]{this.b1}).containsAll((Collection)ImmutableSet.of((Object)this.a1, (Object)this.a0)) ? 1 : 0) != 0);
    }
}

